/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class LinkTab
extends Tab {
    Link link1;
    Group linkGroup;
    static final int LINK_FOREGROUND_COLOR = 3;
    Color linkForegroundColor;

    LinkTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.linkGroup = new Group((Composite)this.exampleGroup, 0);
        this.linkGroup.setLayout((Layout)new GridLayout());
        this.linkGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.linkGroup.setText("Link");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.link1 = new Link((Composite)this.linkGroup, style);
        this.link1.setText(ControlExample.getResourceString("LinkText"));
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    @Override
    void createColorAndFontGroup() {
        super.createColorAndFontGroup();
        TableItem item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Link_Foreground_Color"));
        this.shell.addDisposeListener(event -> {
            if (this.linkForegroundColor != null) {
                this.linkForegroundColor.dispose();
            }
            this.linkForegroundColor = null;
        });
    }

    @Override
    void changeFontOrColor(int index) {
        switch (index) {
            case 3: {
                Color oldColor = this.linkForegroundColor;
                if (oldColor == null) {
                    oldColor = this.link1.getLinkForeground();
                }
                this.colorDialog.setRGB(oldColor.getRGB());
                RGB rgb = this.colorDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = this.linkForegroundColor;
                this.linkForegroundColor = new Color((Device)this.display, rgb);
                this.setLinkForeground();
                if (oldColor == null) break;
                oldColor.dispose();
                break;
            }
            default: {
                super.changeFontOrColor(index);
            }
        }
    }

    void setLinkForeground() {
        TableItem item;
        Image oldImage;
        Color color;
        if (!this.instance.startup) {
            this.link1.setLinkForeground(this.linkForegroundColor);
        }
        if ((color = this.linkForegroundColor) == null) {
            color = this.link1.getLinkForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(3)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    @Override
    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Color oldColor = this.linkForegroundColor;
        this.linkForegroundColor = null;
        this.setLinkForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setLinkForeground();
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.link1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Text", "ToolTipText"};
    }

    @Override
    String getTabText() {
        return "Link";
    }
}

