/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.RangeTab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

class ProgressBarTab
extends RangeTab {
    ProgressBar progressBar1;
    Group progressBarGroup;
    Button smoothButton;
    Button indeterminateButton;

    ProgressBarTab(ControlExample instance) {
        super(instance);
    }

    @Override
    void createExampleGroup() {
        super.createExampleGroup();
        this.progressBarGroup = new Group((Composite)this.exampleGroup, 0);
        this.progressBarGroup.setLayout((Layout)new GridLayout());
        this.progressBarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.progressBarGroup.setText("ProgressBar");
    }

    @Override
    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.smoothButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.indeterminateButton.getSelection()) {
            style |= 2;
        }
        this.progressBar1 = new ProgressBar((Composite)this.progressBarGroup, style);
    }

    @Override
    void createStyleGroup() {
        super.createStyleGroup();
        this.smoothButton = new Button((Composite)this.styleGroup, 32);
        this.smoothButton.setText("SWT.SMOOTH");
        this.indeterminateButton = new Button((Composite)this.styleGroup, 32);
        this.indeterminateButton.setText("SWT.INDETERMINATE");
    }

    @Override
    Widget[] getExampleWidgets() {
        return new Widget[]{this.progressBar1};
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Selection", "State", "ToolTipText"};
    }

    @Override
    String getShortTabText() {
        return "PB";
    }

    @Override
    String getTabText() {
        return "ProgressBar";
    }

    @Override
    void setExampleWidgetState() {
        super.setExampleWidgetState();
        if (this.indeterminateButton.getSelection()) {
            this.selectionSpinner.setEnabled(false);
            this.minimumSpinner.setEnabled(false);
            this.maximumSpinner.setEnabled(false);
        } else {
            this.selectionSpinner.setEnabled(true);
            this.minimumSpinner.setEnabled(true);
            this.maximumSpinner.setEnabled(true);
        }
        this.smoothButton.setSelection((this.progressBar1.getStyle() & 0x10000) != 0);
        this.indeterminateButton.setSelection((this.progressBar1.getStyle() & 2) != 0);
    }

    @Override
    int getDefaultMaximum() {
        return this.progressBar1.getMaximum();
    }

    @Override
    int getDefaultMinimum() {
        return this.progressBar1.getMinimum();
    }

    @Override
    int getDefaultSelection() {
        return this.progressBar1.getSelection();
    }

    @Override
    void setWidgetMaximum() {
        this.progressBar1.setMaximum(this.maximumSpinner.getSelection());
        this.updateSpinners();
    }

    @Override
    void setWidgetMinimum() {
        this.progressBar1.setMinimum(this.minimumSpinner.getSelection());
        this.updateSpinners();
    }

    @Override
    void setWidgetSelection() {
        this.progressBar1.setSelection(this.selectionSpinner.getSelection());
        this.updateSpinners();
    }

    void updateSpinners() {
        this.updateSpinner(this.minimumSpinner, this.progressBar1.getMinimum());
        this.updateSpinner(this.selectionSpinner, this.progressBar1.getSelection());
        this.updateSpinner(this.maximumSpinner, this.progressBar1.getMaximum());
    }

    void updateSpinner(Spinner spinner, int selection) {
        if (spinner.getSelection() != selection) {
            spinner.setSelection(selection);
        }
    }
}

