/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class ShellTab
extends Tab {
    Button noParentButton;
    Button parentButton;
    Button noTrimButton;
    Button closeButton;
    Button titleButton;
    Button minButton;
    Button maxButton;
    Button borderButton;
    Button resizeButton;
    Button onTopButton;
    Button toolButton;
    Button sheetButton;
    Button shellTrimButton;
    Button dialogTrimButton;
    Button noMoveButton;
    Button createButton;
    Button closeAllButton;
    Button modelessButton;
    Button primaryModalButton;
    Button applicationModalButton;
    Button systemModalButton;
    Button imageButton;
    Group parentStyleGroup;
    Group modalStyleGroup;
    int shellCount = 0;
    Shell[] shells = new Shell[4];

    ShellTab(ControlExample instance) {
        super(instance);
    }

    void closeAllShells() {
        int i = 0;
        while (i < this.shellCount) {
            if (this.shells[i] != null & !this.shells[i].isDisposed()) {
                this.shells[i].dispose();
                this.shells[i] = null;
            }
            ++i;
        }
        this.shellCount = 0;
    }

    public void createButtonSelected(SelectionEvent event) {
        if (this.shellCount >= this.shells.length) {
            Shell[] newShells = new Shell[this.shells.length + 4];
            System.arraycopy(this.shells, 0, newShells, 0, this.shells.length);
            this.shells = newShells;
        }
        int style = 0;
        if (this.noTrimButton.getSelection()) {
            style |= 8;
        }
        if (this.noMoveButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.closeButton.getSelection()) {
            style |= 0x40;
        }
        if (this.titleButton.getSelection()) {
            style |= 0x20;
        }
        if (this.minButton.getSelection()) {
            style |= 0x80;
        }
        if (this.maxButton.getSelection()) {
            style |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.resizeButton.getSelection()) {
            style |= 0x10;
        }
        if (this.onTopButton.getSelection()) {
            style |= 0x4000;
        }
        if (this.toolButton.getSelection()) {
            style |= 4;
        }
        if (this.sheetButton.getSelection()) {
            style |= 0x10000000;
        }
        if (this.modelessButton.getSelection()) {
            style |= 0;
        }
        if (this.primaryModalButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.applicationModalButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.systemModalButton.getSelection()) {
            style |= 0x20000;
        }
        this.shells[this.shellCount] = this.noParentButton.getSelection() ? new Shell(style) : new Shell(this.shell, style);
        Shell currentShell = this.shells[this.shellCount];
        currentShell.setBackgroundMode(1);
        Button button = new Button((Composite)currentShell, 32);
        button.setBounds(20, 20, 120, 30);
        button.setText(ControlExample.getResourceString("FullScreen"));
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> currentShell.setFullScreen(button.getSelection())));
        Button close = new Button((Composite)currentShell, 8);
        close.setBounds(160, 20, 120, 30);
        close.setText(ControlExample.getResourceString("Close"));
        close.addListener(13, event1 -> currentShell.dispose());
        currentShell.setSize(300, 100);
        currentShell.setText(String.valueOf(ControlExample.getResourceString("Title")) + this.shellCount);
        if (this.imageButton.getSelection()) {
            currentShell.setImage(this.instance.images[2]);
        }
        if (this.backgroundImageButton.getSelection()) {
            currentShell.setBackgroundImage(this.instance.images[3]);
        }
        this.hookListeners((Widget)currentShell);
        currentShell.open();
        ++this.shellCount;
    }

    @Override
    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 3));
        this.styleGroup.setText(ControlExample.getResourceString("Decoration_Styles"));
        this.modalStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.modalStyleGroup.setLayout((Layout)new GridLayout());
        this.modalStyleGroup.setLayoutData((Object)new GridData(272));
        this.modalStyleGroup.setText(ControlExample.getResourceString("Modal_Styles"));
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
        this.parentStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.parentStyleGroup.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(256);
        this.parentStyleGroup.setLayoutData((Object)gridData);
        this.parentStyleGroup.setText(ControlExample.getResourceString("Parent"));
    }

    @Override
    void createControlWidgets() {
        this.noParentButton = new Button((Composite)this.parentStyleGroup, 16);
        this.noParentButton.setText(ControlExample.getResourceString("No_Parent"));
        this.parentButton = new Button((Composite)this.parentStyleGroup, 16);
        this.parentButton.setText(ControlExample.getResourceString("Parent"));
        this.noTrimButton = new Button((Composite)this.styleGroup, 32);
        this.noTrimButton.setText("SWT.NO_TRIM");
        this.noMoveButton = new Button((Composite)this.styleGroup, 32);
        this.noMoveButton.setText("SWT.NO_MOVE");
        this.closeButton = new Button((Composite)this.styleGroup, 32);
        this.closeButton.setText("SWT.CLOSE");
        this.titleButton = new Button((Composite)this.styleGroup, 32);
        this.titleButton.setText("SWT.TITLE");
        this.minButton = new Button((Composite)this.styleGroup, 32);
        this.minButton.setText("SWT.MIN");
        this.maxButton = new Button((Composite)this.styleGroup, 32);
        this.maxButton.setText("SWT.MAX");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.resizeButton = new Button((Composite)this.styleGroup, 32);
        this.resizeButton.setText("SWT.RESIZE");
        this.onTopButton = new Button((Composite)this.styleGroup, 32);
        this.onTopButton.setText("SWT.ON_TOP");
        this.toolButton = new Button((Composite)this.styleGroup, 32);
        this.toolButton.setText("SWT.TOOL");
        this.sheetButton = new Button((Composite)this.styleGroup, 32);
        this.sheetButton.setText("SWT.SHEET");
        Label separator = new Label((Composite)this.styleGroup, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.shellTrimButton = new Button((Composite)this.styleGroup, 32);
        this.shellTrimButton.setText("SWT.SHELL_TRIM");
        this.dialogTrimButton = new Button((Composite)this.styleGroup, 32);
        this.dialogTrimButton.setText("SWT.DIALOG_TRIM");
        this.modelessButton = new Button((Composite)this.modalStyleGroup, 16);
        this.modelessButton.setText("SWT.MODELESS");
        this.primaryModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.primaryModalButton.setText("SWT.PRIMARY_MODAL");
        this.applicationModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.applicationModalButton.setText("SWT.APPLICATION_MODAL");
        this.systemModalButton = new Button((Composite)this.modalStyleGroup, 16);
        this.systemModalButton.setText("SWT.SYSTEM_MODAL");
        this.imageButton = new Button((Composite)this.otherGroup, 32);
        this.imageButton.setText(ControlExample.getResourceString("Image"));
        this.backgroundImageButton = new Button((Composite)this.otherGroup, 32);
        this.backgroundImageButton.setText(ControlExample.getResourceString("BackgroundImage"));
        this.createSetGetGroup();
        this.createButton = new Button((Composite)this.controlGroup, 0);
        GridData gridData = new GridData(128);
        this.createButton.setLayoutData((Object)gridData);
        this.createButton.setText(ControlExample.getResourceString("Create_Shell"));
        this.closeAllButton = new Button((Composite)this.controlGroup, 0);
        gridData = new GridData(32);
        this.closeAllButton.setText(ControlExample.getResourceString("Close_All_Shells"));
        this.closeAllButton.setLayoutData((Object)gridData);
        this.createButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.createButtonSelected((SelectionEvent)e)));
        this.closeAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.closeAllShells()));
        SelectionListener decorationButtonListener = SelectionListener.widgetSelectedAdapter(event -> this.decorationButtonSelected((SelectionEvent)event));
        this.noTrimButton.addSelectionListener(decorationButtonListener);
        this.noMoveButton.addSelectionListener(decorationButtonListener);
        this.closeButton.addSelectionListener(decorationButtonListener);
        this.titleButton.addSelectionListener(decorationButtonListener);
        this.minButton.addSelectionListener(decorationButtonListener);
        this.maxButton.addSelectionListener(decorationButtonListener);
        this.borderButton.addSelectionListener(decorationButtonListener);
        this.resizeButton.addSelectionListener(decorationButtonListener);
        this.dialogTrimButton.addSelectionListener(decorationButtonListener);
        this.shellTrimButton.addSelectionListener(decorationButtonListener);
        this.applicationModalButton.addSelectionListener(decorationButtonListener);
        this.systemModalButton.addSelectionListener(decorationButtonListener);
        this.noParentButton.setSelection(true);
        this.modelessButton.setSelection(true);
    }

    public void decorationButtonSelected(SelectionEvent event) {
        Button widget = (Button)event.widget;
        if (widget == this.applicationModalButton || widget == this.systemModalButton) {
            if (widget.getSelection()) {
                this.closeButton.setSelection(true);
                this.noTrimButton.setSelection(false);
            }
            return;
        }
        if (widget == this.closeButton && (this.applicationModalButton.getSelection() || this.systemModalButton.getSelection())) {
            this.closeButton.setSelection(true);
        }
        if (widget.getSelection()) {
            if (widget == this.noTrimButton) {
                if (this.applicationModalButton.getSelection() || this.systemModalButton.getSelection()) {
                    this.noTrimButton.setSelection(false);
                    return;
                }
                this.closeButton.setSelection(false);
                this.titleButton.setSelection(false);
                this.minButton.setSelection(false);
                this.maxButton.setSelection(false);
                this.borderButton.setSelection(false);
                this.resizeButton.setSelection(false);
            } else {
                this.noTrimButton.setSelection(false);
            }
        }
        if (widget == this.dialogTrimButton || widget == this.shellTrimButton) {
            if (widget.getSelection() && widget == this.dialogTrimButton) {
                this.shellTrimButton.setSelection(false);
            } else {
                this.dialogTrimButton.setSelection(false);
            }
            this.closeButton.setSelection(widget.getSelection());
            this.titleButton.setSelection(widget.getSelection());
            this.minButton.setSelection(widget == this.shellTrimButton && widget.getSelection());
            this.maxButton.setSelection(widget == this.shellTrimButton && widget.getSelection());
            this.borderButton.setSelection(widget == this.dialogTrimButton && widget.getSelection());
            this.resizeButton.setSelection(widget == this.shellTrimButton && widget.getSelection());
        } else {
            boolean title = this.titleButton.getSelection();
            boolean close = this.closeButton.getSelection();
            boolean min = this.minButton.getSelection();
            boolean max = this.maxButton.getSelection();
            boolean border = this.borderButton.getSelection();
            boolean resize = this.resizeButton.getSelection();
            this.dialogTrimButton.setSelection(title && close && border && !min && !max && !resize);
            this.shellTrimButton.setSelection(title && close && min && max && resize && !border);
        }
    }

    @Override
    String getTabText() {
        return "Shell";
    }

    @Override
    String[] getMethodNames() {
        return new String[]{"Alpha", "Bounds", "MinimumSize", "Modified", "Text"};
    }

    @Override
    Widget[] getExampleWidgets() {
        return this.shellCount == 0 ? new Widget[]{} : this.shells;
    }
}

