/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

abstract class Tab {
    Shell shell;
    Display display;
    Button borderButton;
    Button enabledButton;
    Button visibleButton;
    Button backgroundImageButton;
    Button popupMenuButton;
    Button preferredButton;
    Button tooSmallButton;
    Button smallButton;
    Button largeButton;
    Button rectangleButton;
    Button fillHButton;
    Button fillVButton;
    Composite tabFolderPage;
    Group exampleGroup;
    Group controlGroup;
    Group listenersGroup;
    Group otherGroup;
    Group sizeGroup;
    Group styleGroup;
    Group colorGroup;
    Group backgroundModeGroup;
    final ControlExample instance;
    static final int TOO_SMALL_SIZE = 10;
    static final int RETANGLE_SIZE_WIDTH = 140;
    static final int RETANGLE_SIZE_HEIGHT = 30;
    static final int SMALL_SIZE = 50;
    static final int LARGE_SIZE = 100;
    static final boolean RTL_SUPPORT_ENABLE = "win32".equals(SWT.getPlatform()) || "gtk".equals(SWT.getPlatform());
    Group orientationGroup;
    Button rtlButton;
    Button ltrButton;
    Button defaultOrietationButton;
    Group directionGroup;
    Button rtlDirectionButton;
    Button ltrDirectionButton;
    Button autoDirectionButton;
    Button defaultDirectionButton;
    static final int IMAGE_SIZE = 12;
    static final int FOREGROUND_COLOR = 0;
    static final int BACKGROUND_COLOR = 1;
    static final int FONT = 2;
    Table colorAndFontTable;
    ColorDialog colorDialog;
    FontDialog fontDialog;
    Color foregroundColor;
    Color backgroundColor;
    Font font;
    Combo backgroundModeCombo;
    Button backgroundModeImageButton;
    Button backgroundModeColorButton;
    boolean samplePopup = false;
    Combo nameCombo;
    Label returnTypeLabel;
    Button getButton;
    Button setButton;
    Text setText;
    Text getText;
    Shell setGetDialog;
    Text eventConsole;
    boolean logging = false;
    boolean untypedEvents = false;
    boolean[] eventsFilter;
    int setFieldsMask = 0;
    Event setFieldsEvent = new Event();
    boolean ignore = false;
    static final int DOIT = 256;
    static final int DETAIL = 512;
    static final int TEXT = 1024;
    static final int X = 2048;
    static final int Y = 4096;
    static final int WIDTH = 8192;
    static final int HEIGHT = 16384;
    static final int DETAIL_IME = 0;
    static final int DETAIL_ERASE_ITEM = 1;
    static final int DETAIL_TRAVERSE = 2;
    final EventInfo[] EVENT_INFO = new EventInfo[]{new EventInfo("Activate", 26, 0, 0, new Event()), new EventInfo("Arm", 30, 0, 0, new Event()), new EventInfo("Close", 21, 256, 0, new Event()), new EventInfo("Collapse", 18, 0, 0, new Event()), new EventInfo("Deactivate", 27, 0, 0, new Event()), new EventInfo("DefaultSelection", 14, 0, 0, new Event()), new EventInfo("Deiconify", 20, 0, 0, new Event()), new EventInfo("Dispose", 12, 0, 0, new Event()), new EventInfo("DragDetect", 29, 0, 0, new Event()), new EventInfo("EraseItem", 40, 513, 0, new Event()), new EventInfo("Expand", 17, 0, 0, new Event()), new EventInfo("FocusIn", 15, 0, 0, new Event()), new EventInfo("FocusOut", 16, 0, 0, new Event()), new EventInfo("HardKeyDown", 33, 0, 0, new Event()), new EventInfo("HardKeyUp", 34, 0, 0, new Event()), new EventInfo("Help", 28, 0, 0, new Event()), new EventInfo("Hide", 23, 0, 0, new Event()), new EventInfo("Iconify", 19, 0, 0, new Event()), new EventInfo("KeyDown", 1, 256, 0, new Event()), new EventInfo("KeyUp", 2, 256, 0, new Event()), new EventInfo("MeasureItem", 41, 0, 0, new Event()), new EventInfo("MenuDetect", 35, 6400, 0, new Event()), new EventInfo("Modify", 24, 0, 0, new Event()), new EventInfo("MouseDoubleClick", 8, 0, 0, new Event()), new EventInfo("MouseDown", 3, 0, 0, new Event()), new EventInfo("MouseEnter", 6, 0, 0, new Event()), new EventInfo("MouseExit", 7, 0, 0, new Event()), new EventInfo("MouseHorizontalWheel", 38, 0, 0, new Event()), new EventInfo("MouseHover", 32, 0, 0, new Event()), new EventInfo("MouseMove", 5, 0, 0, new Event()), new EventInfo("MouseUp", 4, 0, 0, new Event()), new EventInfo("MouseVerticalWheel", 37, 0, 0, new Event()), new EventInfo("Move", 10, 0, 0, new Event()), new EventInfo("Paint", 9, 0, 0, new Event()), new EventInfo("PaintItem", 42, 0, 0, new Event()), new EventInfo("Resize", 11, 0, 0, new Event()), new EventInfo("Selection", 13, 6400, 0, new Event()), new EventInfo("SetData", 36, 0, 0, new Event()), new EventInfo("Show", 22, 0, 0, new Event()), new EventInfo("Traverse", 31, 770, 0, new Event()), new EventInfo("Verify", 25, 1280, 0, new Event()), new EventInfo("ImeComposition", 43, 1792, 0, new Event())};
    static final String[][] DETAIL_CONSTANTS = new String[][]{{"SWT.COMPOSITION_CHANGED", "SWT.COMPOSITION_OFFSET", "SWT.COMPOSITION_SELECTION"}, {"SWT.SELECTED", "SWT.FOCUSED", "SWT.BACKGROUND", "SWT.FOREGROUND", "SWT.HOT"}, {"SWT.TRAVERSE_NONE", "SWT.TRAVERSE_ESCAPE", "SWT.TRAVERSE_RETURN", "SWT.TRAVERSE_TAB_PREVIOUS", "SWT.TRAVERSE_TAB_NEXT", "SWT.TRAVERSE_ARROW_PREVIOUS", "SWT.TRAVERSE_ARROW_NEXT", "SWT.TRAVERSE_MNEMONIC", "SWT.TRAVERSE_PAGE_PREVIOUS", "SWT.TRAVERSE_PAGE_NEXT"}};
    static final Object[] DETAIL_VALUES = new Object[]{"SWT.COMPOSITION_CHANGED", 1, "SWT.COMPOSITION_OFFSET", 2, "SWT.COMPOSITION_SELECTION", 3, "SWT.SELECTED", 2, "SWT.FOCUSED", 4, "SWT.BACKGROUND", 8, "SWT.FOREGROUND", 16, "SWT.HOT", 32, "SWT.TRAVERSE_NONE", 0, "SWT.TRAVERSE_ESCAPE", 2, "SWT.TRAVERSE_RETURN", 4, "SWT.TRAVERSE_TAB_PREVIOUS", 8, "SWT.TRAVERSE_TAB_NEXT", 16, "SWT.TRAVERSE_ARROW_PREVIOUS", 32, "SWT.TRAVERSE_ARROW_NEXT", 64, "SWT.TRAVERSE_MNEMONIC", 128, "SWT.TRAVERSE_PAGE_PREVIOUS", 256, "SWT.TRAVERSE_PAGE_NEXT", 512};

    Tab(ControlExample instance) {
        this.instance = instance;
    }

    void createControlGroup() {
        Control[] children;
        this.controlGroup = new Group(this.tabFolderPage, 0);
        this.controlGroup.setLayout((Layout)new GridLayout(2, true));
        this.controlGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.createStyleGroup();
        this.createOtherGroup();
        this.createSetGetGroup();
        this.createSizeGroup();
        this.createColorAndFontGroup();
        if (this.rtlSupport()) {
            this.createOrientationGroup();
            this.createDirectionGroup();
        }
        this.createBackgroundModeGroup();
        SelectionListener selectionListener = SelectionListener.widgetSelectedAdapter(event -> {
            if ((event.widget.getStyle() & 0x10) != 0 && !((Button)event.widget).getSelection()) {
                return;
            }
            if (!this.handleTextDirection(event.widget)) {
                this.recreateExampleWidgets();
                if (this.rtlSupport()) {
                    this.ltrDirectionButton.setSelection(false);
                    this.rtlDirectionButton.setSelection(false);
                    this.autoDirectionButton.setSelection(false);
                    this.defaultDirectionButton.setSelection(true);
                }
            }
        });
        Control[] controlArray = children = this.styleGroup.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Button) {
                Button button = (Button)child;
                button.addSelectionListener(selectionListener);
            } else if (child instanceof Composite) {
                Control[] grandchildren;
                Composite composite = (Composite)child;
                Control[] controlArray2 = grandchildren = composite.getChildren();
                int n3 = grandchildren.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control grandchild = controlArray2[n4];
                    if (grandchild instanceof Button) {
                        Button button = (Button)grandchild;
                        button.addSelectionListener(selectionListener);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (this.rtlSupport()) {
            this.rtlButton.addSelectionListener(selectionListener);
            this.ltrButton.addSelectionListener(selectionListener);
            this.defaultOrietationButton.addSelectionListener(selectionListener);
            this.rtlDirectionButton.addSelectionListener(selectionListener);
            this.ltrDirectionButton.addSelectionListener(selectionListener);
            this.autoDirectionButton.addSelectionListener(selectionListener);
            this.defaultDirectionButton.addSelectionListener(selectionListener);
        }
    }

    void createSetGetGroup() {
        String[] methodNames = this.getMethodNames();
        if (methodNames != null) {
            Button setGetButton = new Button((Composite)this.otherGroup, 8);
            setGetButton.setText(ControlExample.getResourceString("Set_Get"));
            setGetButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            setGetButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                if (this.getExampleWidgets().length > 0) {
                    if (this.setGetDialog == null) {
                        this.setGetDialog = this.createSetGetDialog(methodNames);
                    }
                    Point pt = setGetButton.getLocation();
                    pt = this.display.map((Control)setGetButton.getParent(), null, pt);
                    this.setGetDialog.setLocation(pt.x, pt.y);
                    this.setGetDialog.open();
                }
            }));
        }
    }

    void createControlWidgets() {
    }

    void createColorAndFontGroup() {
        this.colorGroup = new Group((Composite)this.controlGroup, 0);
        this.colorGroup.setLayout((Layout)new GridLayout(2, true));
        this.colorGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.colorGroup.setText(ControlExample.getResourceString("Colors"));
        this.colorAndFontTable = new Table((Composite)this.colorGroup, 2560);
        this.colorAndFontTable.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        TableItem item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Foreground_Color"));
        this.colorAndFontTable.setSelection(0);
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Background_Color"));
        item = new TableItem(this.colorAndFontTable, 0);
        item.setText(ControlExample.getResourceString("Font"));
        Button changeButton = new Button((Composite)this.colorGroup, 8);
        changeButton.setText(ControlExample.getResourceString("Change"));
        changeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Button defaultsButton = new Button((Composite)this.colorGroup, 8);
        defaultsButton.setText(ControlExample.getResourceString("Defaults"));
        defaultsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.colorDialog = new ColorDialog(this.shell);
        this.fontDialog = new FontDialog(this.shell);
        this.colorAndFontTable.addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(event -> this.changeFontOrColor(this.colorAndFontTable.getSelectionIndex())));
        changeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.changeFontOrColor(this.colorAndFontTable.getSelectionIndex())));
        defaultsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.resetColorsAndFonts()));
        this.shell.addDisposeListener(event -> {
            if (this.foregroundColor != null) {
                this.foregroundColor.dispose();
            }
            if (this.backgroundColor != null) {
                this.backgroundColor.dispose();
            }
            if (this.font != null) {
                this.font.dispose();
            }
            this.foregroundColor = null;
            this.backgroundColor = null;
            this.font = null;
            if (this.colorAndFontTable != null && !this.colorAndFontTable.isDisposed()) {
                TableItem[] items;
                TableItem[] tableItemArray = items = this.colorAndFontTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem currentItem = tableItemArray[n2];
                    Image image = currentItem.getImage();
                    if (image != null) {
                        image.dispose();
                    }
                    ++n2;
                }
            }
        });
    }

    void changeFontOrColor(int index) {
        switch (index) {
            case 0: {
                RGB rgb;
                Control[] controls;
                Color oldColor = this.foregroundColor;
                if (oldColor == null && (controls = this.getExampleControls()).length > 0) {
                    oldColor = controls[0].getForeground();
                }
                if (oldColor != null) {
                    this.colorDialog.setRGB(oldColor.getRGB());
                }
                if ((rgb = this.colorDialog.open()) == null) {
                    return;
                }
                oldColor = this.foregroundColor;
                this.foregroundColor = new Color((Device)this.display, rgb);
                this.setExampleWidgetForeground();
                if (oldColor == null) break;
                oldColor.dispose();
                break;
            }
            case 1: {
                RGB rgb;
                Control[] controls;
                Color oldColor = this.backgroundColor;
                if (oldColor == null && (controls = this.getExampleControls()).length > 0) {
                    oldColor = controls[0].getBackground();
                }
                if (oldColor != null) {
                    this.colorDialog.setRGB(oldColor.getRGB());
                }
                if ((rgb = this.colorDialog.open()) == null) {
                    return;
                }
                oldColor = this.backgroundColor;
                this.backgroundColor = new Color((Device)this.display, rgb);
                this.setExampleWidgetBackground();
                if (oldColor == null) break;
                oldColor.dispose();
                break;
            }
            case 2: {
                FontData fontData;
                Control[] controls;
                Font oldFont = this.font;
                if (oldFont == null && (controls = this.getExampleControls()).length > 0) {
                    oldFont = controls[0].getFont();
                }
                if (oldFont != null) {
                    this.fontDialog.setFontList(oldFont.getFontData());
                }
                if ((fontData = this.fontDialog.open()) == null) {
                    return;
                }
                oldFont = this.font;
                this.font = new Font((Device)this.display, fontData);
                this.setExampleWidgetFont();
                this.setExampleWidgetSize();
                if (oldFont == null) break;
                oldFont.dispose();
            }
        }
    }

    void createOtherGroup() {
        this.otherGroup = new Group((Composite)this.controlGroup, 0);
        this.otherGroup.setLayout((Layout)new GridLayout());
        this.otherGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.otherGroup.setText(ControlExample.getResourceString("Other"));
        this.enabledButton = new Button((Composite)this.otherGroup, 32);
        this.enabledButton.setText(ControlExample.getResourceString("Enabled"));
        this.visibleButton = new Button((Composite)this.otherGroup, 32);
        this.visibleButton.setText(ControlExample.getResourceString("Visible"));
        this.backgroundImageButton = new Button((Composite)this.otherGroup, 32);
        this.backgroundImageButton.setText(ControlExample.getResourceString("BackgroundImage"));
        this.popupMenuButton = new Button((Composite)this.otherGroup, 32);
        this.popupMenuButton.setText(ControlExample.getResourceString("PopupMenu"));
        this.enabledButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setExampleWidgetEnabled()));
        this.visibleButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setExampleWidgetVisibility()));
        this.backgroundImageButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setExampleWidgetBackgroundImage()));
        this.popupMenuButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setExampleWidgetPopupMenu()));
        this.enabledButton.setSelection(true);
        this.visibleButton.setSelection(true);
        this.backgroundImageButton.setSelection(false);
        this.popupMenuButton.setSelection(false);
    }

    void createBackgroundModeGroup() {
        this.backgroundModeGroup = new Group((Composite)this.controlGroup, 0);
        this.backgroundModeGroup.setLayout((Layout)new GridLayout());
        this.backgroundModeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.backgroundModeGroup.setText(ControlExample.getResourceString("Background_Mode"));
        this.backgroundModeCombo = new Combo((Composite)this.backgroundModeGroup, 8);
        this.backgroundModeCombo.setItems(new String[]{"SWT.INHERIT_NONE", "SWT.INHERIT_DEFAULT", "SWT.INHERIT_FORCE"});
        this.backgroundModeImageButton = new Button((Composite)this.backgroundModeGroup, 32);
        this.backgroundModeImageButton.setText(ControlExample.getResourceString("BackgroundImage"));
        this.backgroundModeColorButton = new Button((Composite)this.backgroundModeGroup, 32);
        this.backgroundModeColorButton.setText(ControlExample.getResourceString("BackgroundColor"));
        this.backgroundModeCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setExampleGroupBackgroundMode()));
        this.backgroundModeImageButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setExampleGroupBackgroundImage()));
        this.backgroundModeColorButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setExampleGroupBackgroundColor()));
        this.backgroundModeCombo.setText(this.backgroundModeCombo.getItem(0));
        this.backgroundModeImageButton.setSelection(false);
        this.backgroundModeColorButton.setSelection(false);
    }

    void createEditEventDialog(Shell parent, int x, int y, int index) {
        Shell dialog = new Shell(parent, 67696);
        dialog.setLayout((Layout)new GridLayout());
        dialog.setText(ControlExample.getResourceString("Edit_Event"));
        Label label = new Label((Composite)dialog, 0);
        label.setText(ControlExample.getResourceString("Edit_Event_Fields", this.EVENT_INFO[index].name));
        Group group = new Group((Composite)dialog, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        int fields = this.EVENT_INFO[index].settableFields;
        int eventType = this.EVENT_INFO[index].type;
        this.setFieldsMask = this.EVENT_INFO[index].setFields;
        this.setFieldsEvent = this.EVENT_INFO[index].event;
        if ((fields & 0x100) != 0) {
            new Label((Composite)group, 0).setText("doit");
            Combo doitCombo = new Combo((Composite)group, 8);
            doitCombo.setItems(new String[]{"", "true", "false"});
            if ((this.setFieldsMask & 0x100) != 0) {
                doitCombo.setText(Boolean.toString(this.setFieldsEvent.doit));
            }
            doitCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            doitCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                String newValue = doitCombo.getText();
                if (newValue.length() == 0) {
                    this.setFieldsMask &= 0xFFFFFEFF;
                } else {
                    this.setFieldsEvent.type = eventType;
                    this.setFieldsEvent.doit = newValue.equals("true");
                    this.setFieldsMask |= 0x100;
                }
            }));
        }
        if ((fields & 0x200) != 0) {
            new Label((Composite)group, 0).setText("detail");
            int detailType = fields & 0xFF;
            Combo detailCombo = new Combo((Composite)group, 8);
            detailCombo.setItems(DETAIL_CONSTANTS[detailType]);
            detailCombo.add("", 0);
            detailCombo.setVisibleItemCount(detailCombo.getItemCount());
            if ((this.setFieldsMask & 0x200) != 0) {
                detailCombo.setText(DETAIL_CONSTANTS[detailType][this.setFieldsEvent.detail]);
            }
            detailCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            detailCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                String newValue = detailCombo.getText();
                if (newValue.length() == 0) {
                    this.setFieldsMask &= 0xFFFFFDFF;
                } else {
                    this.setFieldsEvent.type = eventType;
                    int i = 0;
                    while (i < DETAIL_VALUES.length) {
                        if (newValue.equals(DETAIL_VALUES[i])) {
                            this.setFieldsEvent.detail = (Integer)DETAIL_VALUES[i + 1];
                            break;
                        }
                        i += 2;
                    }
                    this.setFieldsMask |= 0x200;
                }
            }));
        }
        if ((fields & 0x400) != 0) {
            new Label((Composite)group, 0).setText("text");
            Text textText = new Text((Composite)group, 2048);
            if ((this.setFieldsMask & 0x400) != 0) {
                textText.setText(this.setFieldsEvent.text);
            }
            textText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            textText.addModifyListener(e -> {
                String newValue = textText.getText();
                if (newValue.length() == 0) {
                    this.setFieldsMask &= 0xFFFFFBFF;
                } else {
                    this.setFieldsEvent.type = eventType;
                    this.setFieldsEvent.text = newValue;
                    this.setFieldsMask |= 0x400;
                }
            });
        }
        if ((fields & 0x800) != 0) {
            new Label((Composite)group, 0).setText("x");
            Text xText = new Text((Composite)group, 2048);
            if ((this.setFieldsMask & 0x800) != 0) {
                xText.setText(Integer.toString(this.setFieldsEvent.x));
            }
            xText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            xText.addModifyListener(e -> {
                String newValue = xText.getText();
                try {
                    int newIntValue = Integer.parseInt(newValue);
                    this.setFieldsEvent.type = eventType;
                    this.setFieldsEvent.x = newIntValue;
                    this.setFieldsMask |= 0x800;
                }
                catch (NumberFormatException numberFormatException) {
                    this.setFieldsMask &= 0xFFFFF7FF;
                }
            });
        }
        if ((fields & 0x1000) != 0) {
            new Label((Composite)group, 0).setText("y");
            Text yText = new Text((Composite)group, 2048);
            if ((this.setFieldsMask & 0x1000) != 0) {
                yText.setText(Integer.toString(this.setFieldsEvent.y));
            }
            yText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            yText.addModifyListener(e -> {
                String newValue = yText.getText();
                try {
                    int newIntValue = Integer.parseInt(newValue);
                    this.setFieldsEvent.type = eventType;
                    this.setFieldsEvent.y = newIntValue;
                    this.setFieldsMask |= 0x1000;
                }
                catch (NumberFormatException numberFormatException) {
                    this.setFieldsMask &= 0xFFFFEFFF;
                }
            });
        }
        if ((fields & 0x2000) != 0) {
            new Label((Composite)group, 0).setText("width");
            Text widthText = new Text((Composite)group, 2048);
            if ((this.setFieldsMask & 0x2000) != 0) {
                widthText.setText(Integer.toString(this.setFieldsEvent.width));
            }
            widthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            widthText.addModifyListener(e -> {
                String newValue = widthText.getText();
                try {
                    int newIntValue = Integer.parseInt(newValue);
                    this.setFieldsEvent.type = eventType;
                    this.setFieldsEvent.width = newIntValue;
                    this.setFieldsMask |= 0x2000;
                }
                catch (NumberFormatException numberFormatException) {
                    this.setFieldsMask &= 0xFFFFDFFF;
                }
            });
        }
        if ((fields & 0x4000) != 0) {
            new Label((Composite)group, 0).setText("height");
            Text heightText = new Text((Composite)group, 2048);
            if ((this.setFieldsMask & 0x4000) != 0) {
                heightText.setText(Integer.toString(this.setFieldsEvent.height));
            }
            heightText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            heightText.addModifyListener(e -> {
                String newValue = heightText.getText();
                try {
                    int newIntValue = Integer.parseInt(newValue);
                    this.setFieldsEvent.type = eventType;
                    this.setFieldsEvent.height = newIntValue;
                    this.setFieldsMask |= 0x4000;
                }
                catch (NumberFormatException numberFormatException) {
                    this.setFieldsMask &= 0xFFFFBFFF;
                }
            });
        }
        Button ok = new Button((Composite)dialog, 8);
        ok.setText(ControlExample.getResourceString("OK"));
        GridData data = new GridData(70, -1);
        data.horizontalAlignment = 131072;
        ok.setLayoutData((Object)data);
        ok.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.EVENT_INFO[n].setFields = this.setFieldsMask;
            this.EVENT_INFO[n].event = this.setFieldsEvent;
            dialog.dispose();
        }));
        dialog.setDefaultButton(ok);
        dialog.pack();
        dialog.setLocation(x, y);
        dialog.open();
    }

    void createEventConsolePopup() {
        Menu popup = new Menu((Decorations)this.shell, 8);
        this.eventConsole.setMenu(popup);
        MenuItem cut = new MenuItem(popup, 8);
        cut.setText(ControlExample.getResourceString("MenuItem_Cut"));
        cut.addListener(13, event -> this.eventConsole.cut());
        MenuItem copy = new MenuItem(popup, 8);
        copy.setText(ControlExample.getResourceString("MenuItem_Copy"));
        copy.addListener(13, event -> this.eventConsole.copy());
        MenuItem paste = new MenuItem(popup, 8);
        paste.setText(ControlExample.getResourceString("MenuItem_Paste"));
        paste.addListener(13, event -> this.eventConsole.paste());
        new MenuItem(popup, 2);
        MenuItem selectAll = new MenuItem(popup, 8);
        selectAll.setText(ControlExample.getResourceString("MenuItem_SelectAll"));
        selectAll.addListener(13, event -> this.eventConsole.selectAll());
    }

    void createExampleGroup() {
        this.exampleGroup = new Group(this.tabFolderPage, 0);
        this.exampleGroup.setLayout((Layout)new GridLayout());
        this.exampleGroup.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    void createExampleWidgets() {
    }

    void createListenerSelectionDialog() {
        final Shell dialog = new Shell(this.shell, 67696);
        dialog.setText(ControlExample.getResourceString("Select_Listeners"));
        dialog.setLayout((Layout)new GridLayout(2, false));
        final Table table = new Table((Composite)dialog, 2592);
        GridData data = new GridData(1808);
        data.verticalSpan = 3;
        table.setLayoutData((Object)data);
        int i = 0;
        while (i < this.EVENT_INFO.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(this.EVENT_INFO[i].name);
            item.setChecked(this.eventsFilter[i]);
            ++i;
        }
        String[] customNames = this.getCustomEventNames();
        int i2 = 0;
        while (i2 < customNames.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(customNames[i2]);
            item.setChecked(this.eventsFilter[this.EVENT_INFO.length + i2]);
            ++i2;
        }
        Button selectAll = new Button((Composite)dialog, 8);
        selectAll.setText(ControlExample.getResourceString("Select_All"));
        selectAll.setLayoutData((Object)new GridData(256));
        selectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < this.EVENT_INFO.length) {
                items[i].setChecked(true);
                ++i;
            }
            i = 0;
            while (i < customNames.length) {
                items[this.EVENT_INFO.length + i].setChecked(true);
                ++i;
            }
        }));
        Button deselectAll = new Button((Composite)dialog, 8);
        deselectAll.setText(ControlExample.getResourceString("Deselect_All"));
        deselectAll.setLayoutData((Object)new GridData(256));
        deselectAll.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < this.EVENT_INFO.length) {
                items[i].setChecked(false);
                ++i;
            }
            i = 0;
            while (i < customNames.length) {
                items[this.EVENT_INFO.length + i].setChecked(false);
                ++i;
            }
        }));
        final Button editEvent = new Button((Composite)dialog, 8);
        editEvent.setText(ControlExample.getResourceString("Edit_Event"));
        editEvent.setLayoutData((Object)new GridData(258));
        editEvent.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Point pt = editEvent.getLocation();
            pt = e.display.map((Control)editEvent, null, pt);
            int index = table.getSelectionIndex();
            if (this.getExampleWidgets().length > 0 && index != -1) {
                this.createEditEventDialog(dialog, pt.x, pt.y, index);
            }
        }));
        editEvent.setEnabled(false);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int fields = 0;
                int index = table.getSelectionIndex();
                if (index != -1 && index < Tab.this.EVENT_INFO.length) {
                    fields = Tab.this.EVENT_INFO[index].settableFields;
                }
                editEvent.setEnabled(fields != 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (editEvent.getEnabled()) {
                    Point pt = editEvent.getLocation();
                    pt = e.display.map((Control)editEvent, null, pt);
                    int index = table.getSelectionIndex();
                    if (Tab.this.getExampleWidgets().length > 0 && index != -1 && index < Tab.this.EVENT_INFO.length) {
                        Tab.this.createEditEventDialog(dialog, pt.x, pt.y, index);
                    }
                }
            }
        });
        new Label((Composite)dialog, 0);
        Button ok = new Button((Composite)dialog, 8);
        ok.setText(ControlExample.getResourceString("OK"));
        dialog.setDefaultButton(ok);
        ok.setLayoutData((Object)new GridData(256));
        ok.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            TableItem[] items = table.getItems();
            int i = 0;
            while (i < this.EVENT_INFO.length) {
                this.eventsFilter[i] = items[i].getChecked();
                ++i;
            }
            i = 0;
            while (i < customNames.length) {
                this.eventsFilter[this.EVENT_INFO.length + i] = items[this.EVENT_INFO.length + i].getChecked();
                ++i;
            }
            dialog.dispose();
        }));
        dialog.pack();
        Rectangle bounds = dialog.getBounds();
        Rectangle trim = dialog.computeTrim(0, 0, 0, 0);
        Rectangle clientArea = this.display.getClientArea();
        if (bounds.height > clientArea.height) {
            dialog.setSize(bounds.width, clientArea.height - trim.height);
        }
        dialog.setLocation(bounds.x, clientArea.y);
        dialog.open();
        while (!dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    void createListenersGroup() {
        this.listenersGroup = new Group(this.tabFolderPage, 0);
        this.listenersGroup.setLayout((Layout)new GridLayout(4, false));
        this.listenersGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.listenersGroup.setText(ControlExample.getResourceString("Listeners"));
        Button listenersButton = new Button((Composite)this.listenersGroup, 8);
        listenersButton.setText(ControlExample.getResourceString("Select_Listeners"));
        listenersButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.createListenerSelectionDialog();
            this.recreateExampleWidgets();
        }));
        Button untypedEventsCheckbox = new Button((Composite)this.listenersGroup, 32);
        untypedEventsCheckbox.setText(ControlExample.getResourceString("UntypedEvents"));
        untypedEventsCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.untypedEvents = untypedEventsCheckbox.getSelection();
        }));
        Button listenCheckbox = new Button((Composite)this.listenersGroup, 32);
        listenCheckbox.setText(ControlExample.getResourceString("Listen"));
        listenCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.logging = listenCheckbox.getSelection();
            this.recreateExampleWidgets();
        }));
        Button clearButton = new Button((Composite)this.listenersGroup, 8);
        clearButton.setText(ControlExample.getResourceString("Clear"));
        clearButton.setLayoutData((Object)new GridData(128));
        clearButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.eventConsole.setText("")));
        int customEventCount = this.getCustomEventNames().length;
        this.eventsFilter = new boolean[this.EVENT_INFO.length + customEventCount];
        int i = 0;
        while (i < this.EVENT_INFO.length + customEventCount) {
            this.eventsFilter[i] = true;
            ++i;
        }
        this.eventConsole = new Text((Composite)this.listenersGroup, 2818);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        data.heightHint = 80;
        this.eventConsole.setLayoutData((Object)data);
        this.createEventConsolePopup();
        this.eventConsole.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.keyCode == 65 || e.keyCode == 97) && (e.stateMask & SWT.MOD1) != 0) {
                    Tab.this.eventConsole.selectAll();
                    e.doit = false;
                }
            }
        });
    }

    String[] getMethodNames() {
        return null;
    }

    Shell createSetGetDialog(String[] methodNames) {
        Shell dialog = new Shell(this.shell, 2160);
        dialog.setLayout((Layout)new GridLayout(2, false));
        dialog.setText(String.valueOf(this.getTabText()) + " " + ControlExample.getResourceString("Set_Get"));
        this.nameCombo = new Combo((Composite)dialog, 8);
        this.nameCombo.setItems(methodNames);
        this.nameCombo.setText(methodNames[0]);
        this.nameCombo.setVisibleItemCount(methodNames.length);
        this.nameCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.nameCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.resetLabels()));
        this.returnTypeLabel = new Label((Composite)dialog, 0);
        this.returnTypeLabel.setLayoutData((Object)new GridData(4, 1, false, false));
        this.setButton = new Button((Composite)dialog, 8);
        this.setButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.setButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setValue();
            this.setText.selectAll();
            this.setText.setFocus();
        }));
        this.setText = new Text((Composite)dialog, 2052);
        this.setText.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.getButton = new Button((Composite)dialog, 8);
        this.getButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.getButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getValue()));
        this.getText = new Text((Composite)dialog, 2826);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 240;
        data.heightHint = 200;
        this.getText.setLayoutData((Object)data);
        this.resetLabels();
        dialog.setDefaultButton(this.setButton);
        dialog.pack();
        dialog.addDisposeListener(e -> {
            Shell shell = this.setGetDialog = null;
        });
        return dialog;
    }

    void resetLabels() {
        String methodRoot = this.nameCombo.getText();
        this.returnTypeLabel.setText(this.parameterInfo(methodRoot));
        this.setButton.setText(this.setMethodName(methodRoot));
        this.getButton.setText("get" + methodRoot);
        this.setText.setText("");
        this.getText.setText("");
        this.getValue();
        this.setText.setFocus();
    }

    String setMethodName(String methodRoot) {
        return "set" + methodRoot;
    }

    String parameterInfo(String methodRoot) {
        String typeName = null;
        Class<?> returnType = this.getReturnType(methodRoot);
        boolean isArray = returnType.isArray();
        typeName = isArray ? returnType.getComponentType().getName() : returnType.getName();
        String typeNameString = typeName;
        int index = typeName.lastIndexOf(46);
        if (index != -1 && index + 1 < typeName.length()) {
            typeNameString = typeName.substring(index + 1);
        }
        String info = ControlExample.getResourceString("Info_" + typeNameString + (isArray ? "A" : ""));
        if (isArray) {
            typeNameString = String.valueOf(typeNameString) + "[]";
        }
        return ControlExample.getResourceString("Parameter_Info", typeNameString, info);
    }

    void getValue() {
        String methodName = "get" + this.nameCombo.getText();
        this.getText.setText("");
        Widget[] widgets = this.getExampleWidgets();
        int i = 0;
        while (i < widgets.length) {
            block10: {
                try {
                    if (widgets[i] == null) break block10;
                    Method method = widgets[i].getClass().getMethod(methodName, new Class[0]);
                    Object result = method.invoke((Object)widgets[i], new Object[0]);
                    if (result == null) {
                        this.getText.append("null");
                    } else if (result.getClass().isArray()) {
                        int length = Array.getLength(result);
                        if (length == 0) {
                            this.getText.append(result.getClass().getComponentType() + "[0]");
                        }
                        int j = 0;
                        while (j < length) {
                            this.getText.append(String.valueOf(Array.get(result, j).toString()) + "\n");
                            ++j;
                        }
                    } else {
                        this.getText.append(result.toString());
                    }
                }
                catch (Exception e) {
                    this.getText.append(e.toString());
                }
                if (i + 1 < widgets.length) {
                    this.getText.append("\n\n");
                }
            }
            ++i;
        }
    }

    Class<?> getReturnType(String methodRoot) {
        Class<?> returnType = null;
        String methodName = "get" + methodRoot;
        Widget[] widgets = this.getExampleWidgets();
        try {
            Method method = widgets[0].getClass().getMethod(methodName, new Class[0]);
            returnType = method.getReturnType();
        }
        catch (Exception exception) {}
        return returnType;
    }

    void setValue() {
        Widget[] widgets;
        String methodRoot = this.nameCombo.getText();
        Class<?> returnType = this.getReturnType(methodRoot);
        String methodName = this.setMethodName(methodRoot);
        String value = this.setText.getText();
        Widget[] widgetArray = widgets = this.getExampleWidgets();
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            block27: {
                Widget widget = widgetArray[n2];
                try {
                    if (widget != null) {
                        int j;
                        String[] strings;
                        Method method = widget.getClass().getMethod(methodName, returnType);
                        String typeName = returnType.getName();
                        Object[] parameter = null;
                        if (value.equals("null")) {
                            parameter = new Object[1];
                        } else if (typeName.equals("int")) {
                            parameter = new Object[]{Integer.valueOf(value)};
                        } else if (typeName.equals("long")) {
                            parameter = new Object[]{new Long(value)};
                        } else if (typeName.equals("char")) {
                            parameter = new Object[]{value.length() == 1 ? new Character(value.charAt(0)) : new Character('\u0000')};
                        } else if (typeName.equals("boolean")) {
                            parameter = new Object[]{Boolean.valueOf(value)};
                        } else if (typeName.equals("java.lang.String")) {
                            parameter = new Object[]{value};
                        } else if (typeName.equals("org.eclipse.swt.graphics.Point")) {
                            String[] xy = this.split(value, ',');
                            parameter = new Object[]{new Point(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]))};
                        } else if (typeName.equals("org.eclipse.swt.graphics.Rectangle")) {
                            String[] xywh = this.split(value, ',');
                            parameter = new Object[]{new Rectangle(Integer.parseInt(xywh[0]), Integer.parseInt(xywh[1]), Integer.parseInt(xywh[2]), Integer.parseInt(xywh[3]))};
                        } else if (typeName.equals("[I")) {
                            strings = this.split(value, ',');
                            int[] ints = new int[strings.length];
                            j = 0;
                            while (j < strings.length) {
                                ints[j] = Integer.valueOf(strings[j]);
                                ++j;
                            }
                            parameter = new Object[]{ints};
                        } else if (typeName.equals("[C")) {
                            strings = this.split(value, ',');
                            char[] chars = new char[strings.length];
                            j = 0;
                            while (j < strings.length) {
                                chars[j] = strings[j].charAt(0);
                                ++j;
                            }
                            parameter = new Object[]{chars};
                        } else {
                            parameter = typeName.equals("[Ljava.lang.String;") ? new Object[]{this.split(value, ',')} : this.parameterForType(typeName, value, widget);
                        }
                        method.invoke((Object)widget, parameter);
                    }
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    String message = e.getMessage();
                    this.getText.setText(e.toString());
                    if (cause != null) {
                        this.getText.append(", cause=\n" + cause.toString());
                    }
                    if (message == null) break block27;
                    this.getText.append(", message=\n" + message);
                }
            }
            ++n2;
        }
    }

    Object[] parameterForType(String typeName, String value, Widget widget) {
        return new Object[]{value};
    }

    void createOrientationGroup() {
        this.orientationGroup = new Group((Composite)this.controlGroup, 0);
        this.orientationGroup.setLayout((Layout)new GridLayout());
        this.orientationGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.orientationGroup.setText(ControlExample.getResourceString("Orientation"));
        this.defaultOrietationButton = new Button((Composite)this.orientationGroup, 16);
        this.defaultOrietationButton.setText(ControlExample.getResourceString("Default"));
        this.defaultOrietationButton.setSelection(true);
        this.ltrButton = new Button((Composite)this.orientationGroup, 16);
        this.ltrButton.setText("SWT.LEFT_TO_RIGHT");
        this.rtlButton = new Button((Composite)this.orientationGroup, 16);
        this.rtlButton.setText("SWT.RIGHT_TO_LEFT");
    }

    void createDirectionGroup() {
        this.directionGroup = new Group((Composite)this.controlGroup, 0);
        this.directionGroup.setLayout((Layout)new GridLayout());
        this.directionGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.directionGroup.setText(ControlExample.getResourceString("Text_Direction"));
        this.defaultDirectionButton = new Button((Composite)this.directionGroup, 16);
        this.defaultDirectionButton.setText(ControlExample.getResourceString("Default"));
        this.defaultDirectionButton.setSelection(true);
        this.ltrDirectionButton = new Button((Composite)this.directionGroup, 16);
        this.ltrDirectionButton.setText("SWT.LEFT_TO_RIGHT");
        this.rtlDirectionButton = new Button((Composite)this.directionGroup, 16);
        this.rtlDirectionButton.setText("SWT.RIGHT_TO_LEFT");
        this.autoDirectionButton = new Button((Composite)this.directionGroup, 16);
        this.autoDirectionButton.setText("AUTO direction");
    }

    void createSizeGroup() {
        this.sizeGroup = new Group((Composite)this.controlGroup, 0);
        this.sizeGroup.setLayout((Layout)new GridLayout());
        this.sizeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.sizeGroup.setText(ControlExample.getResourceString("Size"));
        this.preferredButton = new Button((Composite)this.sizeGroup, 16);
        this.preferredButton.setText(ControlExample.getResourceString("Preferred"));
        this.tooSmallButton = new Button((Composite)this.sizeGroup, 16);
        this.tooSmallButton.setText("10 X 10");
        this.smallButton = new Button((Composite)this.sizeGroup, 16);
        this.smallButton.setText("50 X 50");
        this.largeButton = new Button((Composite)this.sizeGroup, 16);
        this.largeButton.setText("100 X 100");
        this.rectangleButton = new Button((Composite)this.sizeGroup, 16);
        this.rectangleButton.setText("140 X 30");
        this.fillHButton = new Button((Composite)this.sizeGroup, 32);
        this.fillHButton.setText(ControlExample.getResourceString("Fill_X"));
        this.fillVButton = new Button((Composite)this.sizeGroup, 32);
        this.fillVButton.setText(ControlExample.getResourceString("Fill_Y"));
        SelectionListener selectionListener = SelectionListener.widgetSelectedAdapter(event -> this.setExampleWidgetSize());
        this.preferredButton.addSelectionListener(selectionListener);
        this.tooSmallButton.addSelectionListener(selectionListener);
        this.smallButton.addSelectionListener(selectionListener);
        this.largeButton.addSelectionListener(selectionListener);
        this.rectangleButton.addSelectionListener(selectionListener);
        this.fillHButton.addSelectionListener(selectionListener);
        this.fillVButton.addSelectionListener(selectionListener);
        this.preferredButton.setSelection(true);
    }

    void createStyleGroup() {
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.styleGroup.setText(ControlExample.getResourceString("Styles"));
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        this.shell = tabFolder.getShell();
        this.display = this.shell.getDisplay();
        this.tabFolderPage = new Composite((Composite)tabFolder, 0);
        this.tabFolderPage.setLayout((Layout)new GridLayout(2, false));
        this.createExampleGroup();
        this.createControlGroup();
        this.createListenersGroup();
        this.createExampleWidgets();
        this.hookExampleWidgetListeners();
        this.createControlWidgets();
        this.setExampleWidgetState();
        return this.tabFolderPage;
    }

    void setExampleWidgetPopupMenu() {
        Control[] controls;
        Control[] controlArray = controls = this.getExampleControls();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.addListener(35, event -> {
                Menu menu = control.getMenu();
                if (menu != null && this.samplePopup) {
                    menu.dispose();
                    menu = null;
                }
                if (menu == null && this.popupMenuButton.getSelection()) {
                    menu = new Menu((Decorations)this.shell, 8 | control.getStyle() & 0x6000000);
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText("Sample popup menu item");
                    this.specialPopupMenuItems(menu, event);
                    control.setMenu(menu);
                    this.samplePopup = true;
                }
            });
            ++n2;
        }
    }

    protected void specialPopupMenuItems(Menu menu, Event event) {
    }

    void disposeExampleWidgets() {
        Widget[] widgets;
        Widget[] widgetArray = widgets = this.getExampleWidgets();
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            widget.dispose();
            ++n2;
        }
    }

    Image colorImage(Color color) {
        Image image = new Image((Device)this.display, 12, 12);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        Rectangle bounds = image.getBounds();
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.setBackground(this.display.getSystemColor(2));
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        gc.dispose();
        return image;
    }

    Image fontImage(Font font) {
        Image image = new Image((Device)this.display, 12, 12);
        GC gc = new GC((Drawable)image);
        Rectangle bounds = image.getBounds();
        gc.setBackground(this.display.getSystemColor(1));
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.setBackground(this.display.getSystemColor(2));
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        FontData[] data = font.getFontData();
        int style = data[0].getStyle();
        switch (style) {
            case 0: {
                gc.drawLine(3, 3, 3, 8);
                gc.drawLine(4, 3, 7, 8);
                gc.drawLine(8, 3, 8, 8);
                break;
            }
            case 1: {
                gc.drawLine(3, 2, 3, 9);
                gc.drawLine(4, 2, 4, 9);
                gc.drawLine(5, 2, 7, 2);
                gc.drawLine(5, 3, 8, 3);
                gc.drawLine(5, 5, 7, 5);
                gc.drawLine(5, 6, 7, 6);
                gc.drawLine(5, 8, 8, 8);
                gc.drawLine(5, 9, 7, 9);
                gc.drawLine(7, 4, 8, 4);
                gc.drawLine(7, 7, 8, 7);
                break;
            }
            case 2: {
                gc.drawLine(6, 2, 8, 2);
                gc.drawLine(7, 3, 4, 8);
                gc.drawLine(3, 9, 5, 9);
                break;
            }
            case 3: {
                gc.drawLine(5, 2, 8, 2);
                gc.drawLine(5, 3, 8, 3);
                gc.drawLine(6, 4, 4, 7);
                gc.drawLine(7, 4, 5, 7);
                gc.drawLine(3, 8, 6, 8);
                gc.drawLine(3, 9, 6, 9);
            }
        }
        gc.dispose();
        return image;
    }

    String[] getCustomEventNames() {
        return new String[0];
    }

    int getDefaultStyle() {
        if (this.ltrButton != null && this.ltrButton.getSelection()) {
            return 0x2000000;
        }
        if (this.rtlButton != null && this.rtlButton.getSelection()) {
            return 0x4000000;
        }
        return 0;
    }

    Widget[] getExampleWidgets() {
        return new Widget[0];
    }

    Control[] getExampleControls() {
        Widget[] widgets = this.getExampleWidgets();
        Control[] controls = new Control[]{};
        Widget[] widgetArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (widget instanceof Control) {
                Control[] newControls = new Control[controls.length + 1];
                System.arraycopy(controls, 0, newControls, 0, controls.length);
                controls = newControls;
                controls[controls.length - 1] = (Control)widget;
            }
            ++n2;
        }
        return controls;
    }

    Item[] getExampleWidgetItems() {
        return new Item[0];
    }

    String getShortTabText() {
        return this.getTabText();
    }

    String getTabText() {
        return "";
    }

    boolean handleTextDirection(Widget widget) {
        if (!this.rtlSupport()) {
            return false;
        }
        int textDirection = 0;
        if (this.ltrDirectionButton.equals(widget)) {
            textDirection = 0x2000000;
        } else if (this.rtlDirectionButton.equals(widget)) {
            textDirection = 0x4000000;
        } else if (this.autoDirectionButton.equals(widget)) {
            textDirection = 0x6000000;
        } else if (!this.defaultDirectionButton.equals(widget)) {
            return false;
        }
        Control[] children = this.getExampleControls();
        if (children.length > 0) {
            if (textDirection == 0) {
                textDirection = children[0].getOrientation();
            }
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setTextDirection(textDirection);
                ++n2;
            }
        }
        return true;
    }

    void hookExampleWidgetListeners() {
        if (this.logging) {
            Item[] exampleItems;
            Widget[] widgets;
            Widget[] widgetArray = widgets = this.getExampleWidgets();
            int n = widgets.length;
            int n2 = 0;
            while (n2 < n) {
                Widget widget = widgetArray[n2];
                this.hookListeners(widget);
                ++n2;
            }
            Item[] itemArray = exampleItems = this.getExampleWidgetItems();
            int n3 = exampleItems.length;
            n = 0;
            while (n < n3) {
                Item exampleItem = itemArray[n];
                this.hookListeners((Widget)exampleItem);
                ++n;
            }
            String[] customNames = this.getCustomEventNames();
            int i = 0;
            while (i < customNames.length) {
                if (this.eventsFilter[this.EVENT_INFO.length + i]) {
                    this.hookCustomListener(customNames[i]);
                }
                ++i;
            }
        }
    }

    void hookCustomListener(String eventName) {
    }

    void hookListeners(Widget widget) {
        if (this.logging) {
            Listener listener = event -> this.log(event);
            int i = 0;
            while (i < this.EVENT_INFO.length) {
                if (this.eventsFilter[i]) {
                    widget.addListener(this.EVENT_INFO[i].type, listener);
                }
                ++i;
            }
        }
    }

    void log(Event event) {
        int i = 0;
        while (i < this.EVENT_INFO.length) {
            if (this.EVENT_INFO[i].type == event.type) break;
            ++i;
        }
        String toString = String.valueOf(this.EVENT_INFO[i].name) + " [" + event.type + "]: ";
        if (!this.untypedEvents) {
            switch (event.type) {
                case 1: 
                case 2: {
                    toString = String.valueOf(toString) + new KeyEvent(event).toString();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 32: 
                case 37: {
                    toString = String.valueOf(toString) + new MouseEvent(event).toString();
                    break;
                }
                case 9: {
                    toString = String.valueOf(toString) + new PaintEvent(event).toString();
                    break;
                }
                case 10: 
                case 11: {
                    toString = String.valueOf(toString) + new ControlEvent(event).toString();
                    break;
                }
                case 12: {
                    toString = String.valueOf(toString) + new DisposeEvent(event).toString();
                    break;
                }
                case 13: 
                case 14: {
                    toString = String.valueOf(toString) + new SelectionEvent(event).toString();
                    break;
                }
                case 15: 
                case 16: {
                    toString = String.valueOf(toString) + new FocusEvent(event).toString();
                    break;
                }
                case 17: 
                case 18: {
                    toString = String.valueOf(toString) + new TreeEvent(event).toString();
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 26: 
                case 27: {
                    toString = String.valueOf(toString) + new ShellEvent(event).toString();
                    break;
                }
                case 22: 
                case 23: {
                    toString = String.valueOf(toString) + (event.widget instanceof Menu ? new MenuEvent(event).toString() : event.toString());
                    break;
                }
                case 24: {
                    toString = String.valueOf(toString) + new ModifyEvent(event).toString();
                    break;
                }
                case 25: {
                    toString = String.valueOf(toString) + new VerifyEvent(event).toString();
                    break;
                }
                case 28: {
                    toString = String.valueOf(toString) + new HelpEvent(event).toString();
                    break;
                }
                case 30: {
                    toString = String.valueOf(toString) + new ArmEvent(event).toString();
                    break;
                }
                case 31: {
                    toString = String.valueOf(toString) + new TraverseEvent(event).toString();
                    break;
                }
                default: {
                    toString = String.valueOf(toString) + event.toString();
                    break;
                }
            }
        } else {
            toString = String.valueOf(toString) + event.toString();
        }
        this.log(toString);
        int mask = this.EVENT_INFO[i].setFields;
        if (!this.ignore && mask != 0) {
            Event setFieldsEvent = this.EVENT_INFO[i].event;
            if ((mask & 0x100) != 0) {
                event.doit = setFieldsEvent.doit;
            }
            if ((mask & 0x200) != 0) {
                event.detail = setFieldsEvent.detail;
            }
            if ((mask & 0x400) != 0) {
                event.text = setFieldsEvent.text;
            }
            if ((mask & 0x800) != 0) {
                event.x = setFieldsEvent.x;
            }
            if ((mask & 0x1000) != 0) {
                event.y = setFieldsEvent.y;
            }
            if ((mask & 0x2000) != 0) {
                event.width = setFieldsEvent.width;
            }
            if ((mask & 0x4000) != 0) {
                event.height = setFieldsEvent.height;
            }
            this.eventConsole.append(ControlExample.getResourceString("Returning"));
            this.ignore = true;
            this.log(event);
            this.ignore = false;
        }
    }

    void log(String string) {
        if (!this.eventConsole.isDisposed()) {
            this.eventConsole.append(string);
            this.eventConsole.append("\n");
        }
    }

    void log(String eventName, TypedEvent event) {
        this.log(String.valueOf(eventName) + ": " + event.toString());
    }

    void recreateExampleWidgets() {
        this.disposeExampleWidgets();
        this.createExampleWidgets();
        this.hookExampleWidgetListeners();
        this.setExampleWidgetState();
    }

    void resetColorsAndFonts() {
        Color oldColor = this.foregroundColor;
        this.foregroundColor = null;
        this.setExampleWidgetForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldColor = this.backgroundColor;
        this.backgroundColor = null;
        this.setExampleWidgetBackground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        Font oldFont = this.font;
        this.font = null;
        this.setExampleWidgetFont();
        this.setExampleWidgetSize();
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    boolean rtlSupport() {
        return RTL_SUPPORT_ENABLE;
    }

    void setExampleGroupBackgroundColor() {
        if (this.backgroundModeGroup == null) {
            return;
        }
        this.exampleGroup.setBackground(this.backgroundModeColorButton.getSelection() ? this.display.getSystemColor(9) : null);
    }

    void setExampleGroupBackgroundImage() {
        if (this.backgroundModeGroup == null) {
            return;
        }
        this.exampleGroup.setBackgroundImage(this.backgroundModeImageButton.getSelection() ? this.instance.images[4] : null);
    }

    void setExampleGroupBackgroundMode() {
        if (this.backgroundModeGroup == null) {
            return;
        }
        String modeString = this.backgroundModeCombo.getText();
        int mode = 0;
        if (modeString.equals("SWT.INHERIT_DEFAULT")) {
            mode = 1;
        }
        if (modeString.equals("SWT.INHERIT_FORCE")) {
            mode = 2;
        }
        this.exampleGroup.setBackgroundMode(mode);
    }

    void setExampleWidgetBackground() {
        TableItem item;
        Image oldImage;
        if (this.colorAndFontTable == null) {
            return;
        }
        Control[] controls = this.getExampleControls();
        if (!this.instance.startup) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setBackground(this.backgroundColor);
                ++n2;
            }
        }
        Color color = this.backgroundColor;
        if (controls.length == 0) {
            return;
        }
        if (color == null) {
            color = controls[0].getBackground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(1)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setExampleWidgetEnabled() {
        Control[] controls;
        Control[] controlArray = controls = this.getExampleControls();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(this.enabledButton.getSelection());
            ++n2;
        }
    }

    void setExampleWidgetFont() {
        TableItem item;
        Image oldImage;
        if (this.colorAndFontTable == null) {
            return;
        }
        Control[] controls = this.getExampleControls();
        if (!this.instance.startup) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setFont(this.font);
                ++n2;
            }
        }
        Font ft = this.font;
        if (controls.length == 0) {
            return;
        }
        if (ft == null) {
            ft = controls[0].getFont();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(2)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.fontImage(ft));
        item.setFont(ft);
        this.colorAndFontTable.layout();
    }

    void setExampleWidgetForeground() {
        TableItem item;
        Image oldImage;
        if (this.colorAndFontTable == null) {
            return;
        }
        Control[] controls = this.getExampleControls();
        if (!this.instance.startup) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setForeground(this.foregroundColor);
                ++n2;
            }
        }
        Color color = this.foregroundColor;
        if (controls.length == 0) {
            return;
        }
        if (color == null) {
            color = controls[0].getForeground();
        }
        if ((oldImage = (item = this.colorAndFontTable.getItem(0)).getImage()) != null) {
            oldImage.dispose();
        }
        item.setImage(this.colorImage(color));
    }

    void setExampleWidgetSize() {
        Control[] controls;
        int size = -1;
        if (this.preferredButton == null) {
            return;
        }
        if (this.preferredButton.getSelection()) {
            size = -1;
        }
        if (this.tooSmallButton.getSelection()) {
            size = 10;
        }
        if (this.smallButton.getSelection()) {
            size = 50;
        }
        if (this.largeButton.getSelection()) {
            size = 100;
        }
        Control[] controlArray = controls = this.getExampleControls();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            GridData gridData = new GridData(size, size);
            if (this.rectangleButton.getSelection()) {
                gridData = new GridData(140, 30);
            }
            gridData.grabExcessHorizontalSpace = this.fillHButton.getSelection();
            gridData.grabExcessVerticalSpace = this.fillVButton.getSelection();
            gridData.horizontalAlignment = this.fillHButton.getSelection() ? 4 : 16384;
            gridData.verticalAlignment = this.fillVButton.getSelection() ? 4 : 128;
            control.setLayoutData((Object)gridData);
            ++n2;
        }
        this.tabFolderPage.layout(controls);
    }

    void setExampleWidgetState() {
        this.setExampleWidgetBackground();
        this.setExampleWidgetForeground();
        this.setExampleWidgetFont();
        if (!this.instance.startup) {
            this.setExampleWidgetEnabled();
            this.setExampleWidgetVisibility();
            this.setExampleGroupBackgroundMode();
            this.setExampleGroupBackgroundColor();
            this.setExampleGroupBackgroundImage();
            this.setExampleWidgetBackgroundImage();
            this.setExampleWidgetPopupMenu();
            this.setExampleWidgetSize();
        }
    }

    void setExampleWidgetVisibility() {
        Control[] controls;
        Control[] controlArray = controls = this.getExampleControls();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setVisible(this.visibleButton.getSelection());
            ++n2;
        }
    }

    void setExampleWidgetBackgroundImage() {
        Control[] controls;
        if (this.backgroundImageButton != null && this.backgroundImageButton.isDisposed()) {
            return;
        }
        Control[] controlArray = controls = this.getExampleControls();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setBackgroundImage(this.backgroundImageButton.getSelection() ? this.instance.images[3] : null);
            ++n2;
        }
    }

    String[] split(String string, char ch) {
        String[] result = new String[]{};
        int start = 0;
        int length = string.length();
        while (start < length) {
            int end = string.indexOf(ch, start);
            if (end == -1) {
                end = length;
            }
            String substr = string.substring(start, end);
            String[] newResult = new String[result.length + 1];
            System.arraycopy(result, 0, newResult, 0, result.length);
            newResult[result.length] = substr;
            result = newResult;
            start = end + 1;
        }
        return result;
    }

    static class EventInfo {
        String name;
        int type;
        int settableFields;
        int setFields;
        Event event;

        EventInfo(String name, int type, int settableFields, int setFields, Event event) {
            this.name = name;
            this.type = type;
            this.settableFields = settableFields;
            this.setFields = setFields;
            this.event = event;
        }
    }
}

