/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.util.LinkedList;
import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Transform;

public class BallTab
extends AnimatedGraphicsTab {
    BallCollection[] bc = new BallCollection[5];

    @Override
    public void dispose() {
        this.bc[4] = null;
        this.bc[3] = null;
        this.bc[2] = null;
        this.bc[1] = null;
        this.bc[0] = null;
    }

    public BallTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Alpha");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Ball");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("BallDescription");
    }

    @Override
    public int getInitialAnimationTime() {
        return 10;
    }

    @Override
    public void next(int width, int height) {
        int i = 0;
        while (i < this.bc.length) {
            if (this.bc[i] == null) {
                return;
            }
            if (this.bc[i].prevx.size() == 0) {
                this.bc[i].prevx.addLast(new Float(this.bc[i].x));
                this.bc[i].prevy.addLast(new Float(this.bc[i].y));
            } else if (this.bc[i].prevx.size() == this.bc[i].capacity) {
                this.bc[i].prevx.removeFirst();
                this.bc[i].prevy.removeFirst();
            }
            this.bc[i].x += this.bc[i].incX;
            this.bc[i].y += this.bc[i].incY;
            float random = (float)Math.random();
            if (this.bc[i].x + (float)this.bc[i].ball_size > (float)width) {
                this.bc[i].x = width - this.bc[i].ball_size;
                this.bc[i].incX = random * (float)(-width) / 16.0f - 1.0f;
            }
            if (this.bc[i].x < 0.0f) {
                this.bc[i].x = 0.0f;
                this.bc[i].incX = random * (float)width / 16.0f + 1.0f;
            }
            if (this.bc[i].y + (float)this.bc[i].ball_size > (float)height) {
                this.bc[i].y = height - this.bc[i].ball_size - 2;
                this.bc[i].incY = random * (float)(-height) / 16.0f - 1.0f;
            }
            if (this.bc[i].y < 0.0f) {
                this.bc[i].y = 0.0f;
                this.bc[i].incY = random * (float)height / 16.0f + 1.0f;
            }
            this.bc[i].prevx.addLast(new Float(this.bc[i].x));
            this.bc[i].prevy.addLast(new Float(this.bc[i].y));
            ++i;
        }
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        if (this.bc[0] == null) {
            this.bc[0] = new BallCollection(0.0f, 0.0f, 5.0f, 5.0f, 20, 20, new Color[]{device.getSystemColor(5)});
            this.bc[1] = new BallCollection(50.0f, 300.0f, 10.0f, -5.0f, 50, 10, new Color[]{device.getSystemColor(9)});
            this.bc[2] = new BallCollection(250.0f, 100.0f, -5.0f, 8.0f, 25, 12, new Color[]{device.getSystemColor(3)});
            this.bc[3] = new BallCollection(150.0f, 400.0f, 5.0f, 8.0f, 35, 14, new Color[]{device.getSystemColor(2)});
            this.bc[4] = new BallCollection(100.0f, 250.0f, -5.0f, -18.0f, 100, 5, new Color[]{device.getSystemColor(11)});
        }
        BallCollection[] ballCollectionArray = this.bc;
        int n = this.bc.length;
        int n2 = 0;
        while (n2 < n) {
            BallCollection ballCollection = ballCollectionArray[n2];
            int i = 0;
            while (i < ballCollection.prevx.size()) {
                Transform transform = new Transform(device);
                transform.translate(ballCollection.prevx.get(ballCollection.prevx.size() - (i + 1)).floatValue(), ballCollection.prevy.get(ballCollection.prevy.size() - (i + 1)).floatValue());
                gc.setTransform(transform);
                transform.dispose();
                Path path = new Path(device);
                path.addArc(0.0f, 0.0f, (float)ballCollection.ball_size, (float)ballCollection.ball_size, 0.0f, 360.0f);
                gc.setAlpha(255 - i * (255 / ballCollection.capacity));
                gc.setBackground(ballCollection.colors[0]);
                gc.fillPath(path);
                gc.drawPath(path);
                path.dispose();
                ++i;
            }
            ++n2;
        }
    }

    static class BallCollection {
        float x;
        float y;
        float incX;
        float incY;
        int ball_size;
        int capacity;
        LinkedList<Float> prevx;
        LinkedList<Float> prevy;
        Color[] colors;

        public BallCollection(float x, float y, float incX, float incY, int ball_size, int capacity, Color[] colors) {
            this.x = x;
            this.y = y;
            this.incX = incX;
            this.incY = incY;
            this.ball_size = ball_size;
            this.capacity = capacity;
            this.prevx = new LinkedList();
            this.prevy = new LinkedList();
            this.colors = colors;
        }
    }
}

