/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class CardsTab
extends AnimatedGraphicsTab {
    float movClubX;
    float movClubY;
    float movDiamondX;
    float movDiamondY;
    float movHeart;
    float movSpade;
    float inc_club = 5.0f;
    float inc_diamond = 5.0f;
    float inc_hearts = 5.0f;
    float inc_spade = 5.0f;
    float scale;
    float scaleWidth;
    int rotationAngle = 0;
    float scaleArg = 0.0f;
    float heartScale = 0.5f;
    float spadeScale = 0.333f;
    int clubWidth;
    int diamondWidth;
    int heartWidth;
    int spadeHeight;
    Image ace_club;
    Image ace_spade;
    Image ace_diamond;
    Image ace_hearts;

    public CardsTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Transform");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Cards");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("CardsDescription");
    }

    @Override
    public void dispose() {
        if (this.ace_club != null) {
            this.ace_club.dispose();
            this.ace_club = null;
            this.ace_spade.dispose();
            this.ace_spade = null;
            this.ace_diamond.dispose();
            this.ace_diamond = null;
            this.ace_hearts.dispose();
            this.ace_hearts = null;
        }
    }

    @Override
    public void next(int width, int height) {
        this.rotationAngle = (this.rotationAngle + 10) % 360;
        this.scaleArg = (float)(this.scaleArg == 1.0f ? (double)this.scaleArg - 0.1 : (double)this.scaleArg + 0.1);
        this.scale = (float)Math.cos(this.scaleArg);
        this.movClubX += this.inc_club;
        this.movDiamondX += this.inc_diamond;
        this.movHeart += this.inc_hearts;
        this.movSpade += this.inc_spade;
        this.scaleWidth = (float)((double)(this.movClubY / (float)height) * 0.35 + 0.15);
        this.movClubY = (float)(2 * height / 5) * (float)Math.sin(0.01 * (double)this.movClubX - 90.0) + (float)(2 * height / 5);
        this.movDiamondY = (float)(2 * height / 5) * (float)Math.cos(0.01 * (double)this.movDiamondX) + (float)(2 * height / 5);
        if (this.movClubX + (float)this.clubWidth * this.scaleWidth > (float)width) {
            this.movClubX = (float)width - (float)this.clubWidth * this.scaleWidth;
            this.inc_club = -this.inc_club;
        }
        if (this.movClubX < 0.0f) {
            this.movClubX = 0.0f;
            this.inc_club = -this.inc_club;
        }
        if (this.movDiamondX + (float)this.diamondWidth * this.scaleWidth > (float)width) {
            this.movDiamondX = (float)width - (float)this.diamondWidth * this.scaleWidth;
            this.inc_diamond = -this.inc_diamond;
        }
        if (this.movDiamondX < 0.0f) {
            this.movDiamondX = 0.0f;
            this.inc_diamond = -this.inc_diamond;
        }
        if (this.movHeart + (float)this.heartWidth * this.heartScale > (float)width) {
            this.movHeart = (float)width - (float)this.heartWidth * this.heartScale;
            this.inc_hearts = -this.inc_hearts;
        }
        if (this.movHeart < 0.0f) {
            this.movHeart = 0.0f;
            this.inc_hearts = -this.inc_hearts;
        }
        if (this.movSpade + (float)this.spadeHeight * this.spadeScale > (float)height) {
            this.movSpade = (float)height - (float)this.spadeHeight * this.spadeScale;
            this.inc_spade = -this.inc_spade;
        }
        if (this.movSpade < 0.0f) {
            this.movSpade = 0.0f;
            this.inc_spade = -this.inc_spade;
        }
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        if (this.ace_club == null) {
            this.ace_club = GraphicsExample.loadImage(device, GraphicsExample.class, "ace_club.jpg");
            this.ace_spade = GraphicsExample.loadImage(device, GraphicsExample.class, "ace_spade.jpg");
            this.ace_diamond = GraphicsExample.loadImage(device, GraphicsExample.class, "ace_diamond.jpg");
            this.ace_hearts = GraphicsExample.loadImage(device, GraphicsExample.class, "ace_hearts.jpg");
        }
        this.clubWidth = this.ace_club.getBounds().width;
        this.diamondWidth = this.ace_diamond.getBounds().width;
        this.heartWidth = this.ace_hearts.getBounds().width;
        this.spadeHeight = this.ace_spade.getBounds().height;
        Transform transform = new Transform(device);
        transform.translate((float)((int)this.movClubX), (float)((int)this.movClubY));
        transform.scale(this.scaleWidth, this.scaleWidth);
        Rectangle rect = this.ace_club.getBounds();
        transform.translate((float)(rect.width / 2), (float)(rect.height / 2));
        transform.rotate((float)this.rotationAngle);
        transform.translate((float)(-rect.width / 2), (float)(-rect.height / 2));
        gc.setTransform(transform);
        transform.dispose();
        gc.drawImage(this.ace_club, 0, 0);
        transform = new Transform(device);
        transform.translate((float)((int)this.movDiamondX), (float)((int)this.movDiamondY));
        transform.scale(this.scaleWidth, this.scaleWidth);
        gc.setTransform(transform);
        transform.dispose();
        gc.drawImage(this.ace_diamond, 0, 0);
        transform = new Transform(device);
        transform.translate(this.movHeart, (float)(height / 2));
        transform.scale(this.heartScale, 0.5f * this.scale);
        gc.setTransform(transform);
        transform.dispose();
        gc.drawImage(this.ace_hearts, 0, 0);
        transform = new Transform(device);
        transform.translate(this.movSpade, this.movSpade);
        transform.scale(0.5f * this.scale, this.spadeScale);
        gc.setTransform(transform);
        transform.dispose();
        gc.drawImage(this.ace_spade, 0, 0);
    }
}

