/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;

public class CurvesTab
extends GraphicsTab {
    private Rectangle quadHndl = new Rectangle(200, 150, 5, 5);
    private Rectangle quadEndHndl = new Rectangle(400, 0, 5, 5);
    private Rectangle cubHndl1 = new Rectangle(133, -60, 5, 5);
    private Rectangle cubHndl2 = new Rectangle(266, 60, 5, 5);
    private Rectangle cubEndHndl = new Rectangle(400, 0, 5, 5);
    private float quadXPos;
    private float quadYPos;
    private float cubXPos;
    private float cubYPos;
    private float quadDiffX = 0.0f;
    private float quadDiffY = 0.0f;
    private float quadEndDiffX = 0.0f;
    private float quadEndDiffY = 0.0f;
    private float cubDiffX1 = 0.0f;
    private float cubDiffY1 = 0.0f;
    private float cubDiffX2 = 0.0f;
    private float cubDiffY2 = 0.0f;
    private float cubEndDiffX = 0.0f;
    private float cubEndDiffY = 0.0f;
    private boolean quadPtMoved;
    private boolean quadEndPtMoved;
    private boolean cubPt1Moved;
    private boolean cubPt2Moved;
    private boolean cubEndPtMoved;
    private MouseMoveListener mouseMoveListener;
    private MouseListener mouseListener;
    private Cursor cursor;
    private boolean hovering = false;
    private boolean mouseDown = false;

    public CurvesTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Curves");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Curves");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("CurvesDescription");
    }

    @Override
    public boolean getDoubleBuffered() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.mouseListener != null) {
            this.example.canvas.removeMouseListener(this.mouseListener);
        }
        if (this.mouseMoveListener != null) {
            this.example.canvas.removeMouseMoveListener(this.mouseMoveListener);
        }
        this.cursor = null;
    }

    private boolean isHovering(MouseEvent e) {
        Rectangle quad = new Rectangle(this.quadHndl.x + (int)this.quadXPos - 1, this.quadHndl.y + (int)this.quadYPos - 1, this.quadHndl.width + 2, this.quadHndl.height + 2);
        Rectangle quadEnd = new Rectangle(this.quadEndHndl.x + (int)this.quadXPos - 1, this.quadEndHndl.y + (int)this.quadYPos - 1, this.quadEndHndl.width + 2, this.quadEndHndl.height + 2);
        Rectangle cub1 = new Rectangle(this.cubHndl1.x + (int)this.cubXPos - 1, this.cubHndl1.y + (int)this.cubYPos - 1, this.cubHndl1.width + 2, this.cubHndl1.height + 2);
        Rectangle cub2 = new Rectangle(this.cubHndl2.x + (int)this.cubXPos - 1, this.cubHndl2.y + (int)this.cubYPos - 1, this.cubHndl2.width + 2, this.cubHndl2.height + 2);
        Rectangle cubEnd = new Rectangle(this.cubEndHndl.x + (int)this.cubXPos - 1, this.cubEndHndl.y + (int)this.cubYPos - 1, this.cubEndHndl.width + 2, this.cubEndHndl.height + 2);
        return quad.contains(e.x, e.y) || quadEnd.contains(e.x, e.y) || cub1.contains(e.x, e.y) || cub2.contains(e.x, e.y) || cubEnd.contains(e.x, e.y);
    }

    @Override
    public void createControlPanel(Composite parent) {
        if (this.cursor == null) {
            this.cursor = parent.getDisplay().getSystemCursor(21);
        }
        this.mouseMoveListener = e -> {
            if (this.hovering && this.mouseDown) {
                this.example.canvas.setCursor(this.cursor);
            } else if (this.isHovering(e)) {
                this.example.canvas.setCursor(this.cursor);
                this.hovering = true;
            } else {
                this.example.canvas.setCursor(null);
                this.hovering = false;
            }
            if (this.quadPtMoved) {
                this.quadDiffX = this.quadDiffX + (float)e.x - (float)((int)this.quadXPos) - (float)this.quadHndl.x;
                this.quadDiffY = this.quadDiffY + (float)e.y - (float)((int)this.quadYPos) - (float)this.quadHndl.y;
                this.quadHndl.x = e.x - (int)this.quadXPos;
                this.quadHndl.y = e.y - (int)this.quadYPos;
            } else if (this.quadEndPtMoved) {
                this.quadEndDiffX = this.quadEndDiffX + (float)e.x - (float)((int)this.quadXPos) - (float)this.quadEndHndl.x;
                this.quadEndDiffY = this.quadEndDiffY + (float)e.y - (float)((int)this.quadYPos) - (float)this.quadEndHndl.y;
                this.quadEndHndl.x = e.x - (int)this.quadXPos;
                this.quadEndHndl.y = e.y - (int)this.quadYPos;
            } else if (this.cubPt1Moved) {
                this.cubDiffX1 = this.cubDiffX1 + (float)e.x - (float)((int)this.cubXPos) - (float)this.cubHndl1.x;
                this.cubDiffY1 = this.cubDiffY1 + (float)e.y - (float)((int)this.cubYPos) - (float)this.cubHndl1.y;
                this.cubHndl1.x = e.x - (int)this.cubXPos;
                this.cubHndl1.y = e.y - (int)this.cubYPos;
            } else if (this.cubPt2Moved) {
                this.cubDiffX2 = this.cubDiffX2 + (float)e.x - (float)((int)this.cubXPos) - (float)this.cubHndl2.x;
                this.cubDiffY2 = this.cubDiffY2 + (float)e.y - (float)((int)this.cubYPos) - (float)this.cubHndl2.y;
                this.cubHndl2.x = e.x - (int)this.cubXPos;
                this.cubHndl2.y = e.y - (int)this.cubYPos;
            } else if (this.cubEndPtMoved) {
                this.cubEndDiffX = this.cubEndDiffX + (float)e.x - (float)((int)this.cubXPos) - (float)this.cubEndHndl.x;
                this.cubEndDiffY = this.cubEndDiffY + (float)e.y - (float)((int)this.cubYPos) - (float)this.cubEndHndl.y;
                this.cubEndHndl.x = e.x - (int)this.cubXPos;
                this.cubEndHndl.y = e.y - (int)this.cubYPos;
            }
            this.example.redraw();
        };
        this.mouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                Rectangle quad = new Rectangle(((CurvesTab)CurvesTab.this).quadHndl.x + (int)CurvesTab.this.quadXPos - 1, ((CurvesTab)CurvesTab.this).quadHndl.y + (int)CurvesTab.this.quadYPos - 1, ((CurvesTab)CurvesTab.this).quadHndl.width + 2, ((CurvesTab)CurvesTab.this).quadHndl.height + 2);
                Rectangle quadEnd = new Rectangle(((CurvesTab)CurvesTab.this).quadEndHndl.x + (int)CurvesTab.this.quadXPos - 1, ((CurvesTab)CurvesTab.this).quadEndHndl.y + (int)CurvesTab.this.quadYPos - 1, ((CurvesTab)CurvesTab.this).quadEndHndl.width + 2, ((CurvesTab)CurvesTab.this).quadEndHndl.height + 2);
                Rectangle cub1 = new Rectangle(((CurvesTab)CurvesTab.this).cubHndl1.x + (int)CurvesTab.this.cubXPos - 1, ((CurvesTab)CurvesTab.this).cubHndl1.y + (int)CurvesTab.this.cubYPos - 1, ((CurvesTab)CurvesTab.this).cubHndl1.width + 2, ((CurvesTab)CurvesTab.this).cubHndl1.height + 2);
                Rectangle cub2 = new Rectangle(((CurvesTab)CurvesTab.this).cubHndl2.x + (int)CurvesTab.this.cubXPos - 1, ((CurvesTab)CurvesTab.this).cubHndl2.y + (int)CurvesTab.this.cubYPos - 1, ((CurvesTab)CurvesTab.this).cubHndl2.width + 2, ((CurvesTab)CurvesTab.this).cubHndl2.height + 2);
                Rectangle cubEnd = new Rectangle(((CurvesTab)CurvesTab.this).cubEndHndl.x + (int)CurvesTab.this.cubXPos - 1, ((CurvesTab)CurvesTab.this).cubEndHndl.y + (int)CurvesTab.this.cubYPos - 1, ((CurvesTab)CurvesTab.this).cubEndHndl.width + 2, ((CurvesTab)CurvesTab.this).cubEndHndl.height + 2);
                if (quad.contains(e.x, e.y)) {
                    CurvesTab.this.quadPtMoved = true;
                    CurvesTab.this.mouseDown = true;
                } else if (quadEnd.contains(e.x, e.y)) {
                    CurvesTab.this.quadEndPtMoved = true;
                    CurvesTab.this.mouseDown = true;
                } else if (cub1.contains(e.x, e.y)) {
                    CurvesTab.this.cubPt1Moved = true;
                    CurvesTab.this.mouseDown = true;
                } else if (cub2.contains(e.x, e.y)) {
                    CurvesTab.this.cubPt2Moved = true;
                    CurvesTab.this.mouseDown = true;
                } else if (cubEnd.contains(e.x, e.y)) {
                    CurvesTab.this.cubEndPtMoved = true;
                    CurvesTab.this.mouseDown = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                CurvesTab.this.mouseDown = false;
                if (CurvesTab.this.isHovering(e)) {
                    CurvesTab.this.example.canvas.setCursor(CurvesTab.this.cursor);
                } else {
                    CurvesTab.this.example.canvas.setCursor(null);
                }
                if (CurvesTab.this.quadPtMoved) {
                    CurvesTab.this.quadPtMoved = false;
                }
                if (CurvesTab.this.quadEndPtMoved) {
                    CurvesTab.this.quadEndPtMoved = false;
                }
                if (CurvesTab.this.cubPt1Moved) {
                    CurvesTab.this.cubPt1Moved = false;
                }
                if (CurvesTab.this.cubPt2Moved) {
                    CurvesTab.this.cubPt2Moved = false;
                }
                if (CurvesTab.this.cubEndPtMoved) {
                    CurvesTab.this.cubEndPtMoved = false;
                }
                CurvesTab.this.example.redraw();
            }
        };
        this.example.canvas.addMouseMoveListener(this.mouseMoveListener);
        this.example.canvas.addMouseListener(this.mouseListener);
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Font font = new Font(device, CurvesTab.getPlatformFont(), 16, 2);
        gc.setFont(font);
        gc.setLineWidth(5);
        this.cubXPos = width / 5;
        this.cubYPos = height / 3;
        Transform transform = new Transform(device);
        transform.translate(this.cubXPos, this.cubYPos);
        gc.setTransform(transform);
        transform.dispose();
        gc.setForeground(device.getSystemColor(3));
        gc.drawString(GraphicsExample.getResourceString("Cubic"), 25, -70, true);
        Path path = new Path(device);
        path.cubicTo(133.0f + this.cubDiffX1, -60.0f + this.cubDiffY1, 266.0f + this.cubDiffX2, 60.0f + this.cubDiffY2, 400.0f + this.cubEndDiffX, 0.0f + this.cubEndDiffY);
        gc.drawPath(path);
        path.dispose();
        gc.setTransform(null);
        gc.setForeground(device.getSystemColor(10));
        gc.drawRectangle(this.cubHndl1.x + (int)this.cubXPos, this.cubHndl1.y + (int)this.cubYPos, this.cubHndl1.width, this.cubHndl1.height);
        gc.drawRectangle(this.cubHndl2.x + (int)this.cubXPos, this.cubHndl2.y + (int)this.cubYPos, this.cubHndl2.width, this.cubHndl2.height);
        gc.drawRectangle(this.cubEndHndl.x + (int)this.cubXPos, this.cubEndHndl.y + (int)this.cubYPos, this.cubEndHndl.width, this.cubEndHndl.height);
        this.quadXPos = width / 5;
        this.quadYPos = 2 * height / 3;
        transform = new Transform(device);
        transform.translate(this.quadXPos, this.quadYPos);
        gc.setTransform(transform);
        transform.dispose();
        gc.setForeground(device.getSystemColor(5));
        gc.drawString(GraphicsExample.getResourceString("Quadratic"), 0, -50, true);
        path = new Path(device);
        path.quadTo(200.0f + this.quadDiffX, 150.0f + this.quadDiffY, 400.0f + this.quadEndDiffX, 0.0f + this.quadEndDiffY);
        gc.drawPath(path);
        path.dispose();
        gc.setTransform(null);
        gc.setForeground(device.getSystemColor(15));
        gc.drawRectangle(this.quadHndl.x + (int)this.quadXPos, this.quadHndl.y + (int)this.quadYPos, this.quadHndl.width, this.quadHndl.height);
        gc.drawRectangle(this.quadEndHndl.x + (int)this.quadXPos, this.quadEndHndl.y + (int)this.quadYPos, this.quadEndHndl.width, this.quadEndHndl.height);
        font.dispose();
    }

    static String getPlatformFont() {
        if (SWT.getPlatform() == "win32") {
            return "Arial";
        }
        if (SWT.getPlatform() == "gtk") {
            return "Baekmuk Batang";
        }
        return "Verdana";
    }
}

