/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class GradientTab
extends GraphicsTab {
    ToolBar toolBar;
    ToolItem colorItem1;
    ToolItem colorItem2;
    Menu menu1;
    Menu menu2;
    GraphicsBackground colorGB1;
    GraphicsBackground colorGB2;

    public GradientTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public void dispose() {
        if (this.menu1 != null) {
            this.menu1.dispose();
            this.menu1 = null;
        }
        if (this.menu2 != null) {
            this.menu2.dispose();
            this.menu2 = null;
        }
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Gradient");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("GradImage");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("GradientImageDescription");
    }

    @Override
    public void createControlPanel(Composite parent) {
        Display display = parent.getDisplay();
        this.toolBar = new ToolBar(parent, 0x800000);
        ColorMenu colorMenu = new ColorMenu();
        this.menu1 = colorMenu.createMenu((Control)parent.getParent(), gb -> {
            this.colorGB1 = gb;
            this.colorItem1.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.colorGB1 = (GraphicsBackground)this.menu1.getItem(4).getData();
        this.colorItem1 = new ToolItem(this.toolBar, 8);
        this.colorItem1.setText(GraphicsExample.getResourceString("GradientTabItem1"));
        this.colorItem1.setImage(this.colorGB1.getThumbNail());
        this.colorItem1.addListener(13, event -> {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar toolBar = toolItem.getParent();
            Rectangle toolItemBounds = toolItem.getBounds();
            Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
            this.menu1.setLocation(point.x, point.y + toolItemBounds.height);
            this.menu1.setVisible(true);
        });
        this.menu2 = colorMenu.createMenu((Control)parent.getParent(), gb -> {
            this.colorGB2 = gb;
            this.colorItem2.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.colorGB2 = (GraphicsBackground)this.menu2.getItem(2).getData();
        this.colorItem2 = new ToolItem(this.toolBar, 8);
        this.colorItem2.setText(GraphicsExample.getResourceString("GradientTabItem2"));
        this.colorItem2.setImage(this.colorGB2.getThumbNail());
        this.colorItem2.addListener(13, event -> {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar toolBar = toolItem.getParent();
            Rectangle toolItemBounds = toolItem.getBounds();
            Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
            this.menu2.setLocation(point.x, point.y + toolItemBounds.height);
            this.menu2.setVisible(true);
        });
        ToolItem swapItem = new ToolItem(this.toolBar, 8);
        swapItem.setText(GraphicsExample.getResourceString("SwapColors"));
        swapItem.setImage(this.example.loadImage((Device)display, "swap.gif"));
        swapItem.addListener(13, event -> {
            GraphicsBackground tmp = this.colorGB1;
            this.colorGB1 = this.colorGB2;
            this.colorGB2 = tmp;
            this.colorItem1.setImage(this.colorGB1.getThumbNail());
            this.colorItem2.setImage(this.colorGB2.getThumbNail());
            this.example.redraw();
        });
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Image image = this.createImage(device, this.colorGB1.getBgColor1(), this.colorGB2.getBgColor1(), width, height);
        Pattern p = new Pattern(device, image);
        gc.setBackgroundPattern(p);
        gc.fillRectangle(0, 0, width, height);
        p.dispose();
        image.dispose();
    }

    Image createImage(Device device, Color color1, Color color2, int width, int height) {
        Image image = new Image(device, width / 2, height / 2);
        GC gc = new GC((Drawable)image);
        Rectangle rect = image.getBounds();
        Pattern pattern1 = new Pattern(device, (float)rect.x, (float)rect.y, (float)rect.width / 2.0f, (float)rect.height / 2.0f, color1, color2);
        gc.setBackgroundPattern(pattern1);
        Path path = new Path(device);
        path.addRectangle(0.0f, 0.0f, (float)width / 4.0f, (float)height / 4.0f);
        path.addRectangle((float)width / 4.0f, (float)height / 4.0f, (float)width / 4.0f, (float)height / 4.0f);
        gc.fillPath(path);
        path.dispose();
        Pattern pattern2 = new Pattern(device, (float)rect.width, 0.0f, (float)rect.width / 2.0f, (float)rect.height / 2.0f, color1, color2);
        gc.setBackgroundPattern(pattern2);
        path = new Path(device);
        path.addRectangle((float)width / 4.0f, 0.0f, (float)width / 4.0f, (float)height / 4.0f);
        path.addRectangle(0.0f, (float)height / 4.0f, (float)width / 4.0f, (float)height / 4.0f);
        gc.fillPath(path);
        path.dispose();
        gc.dispose();
        pattern1.dispose();
        pattern2.dispose();
        return image;
    }
}

