/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.examples.graphics.AlphaTab;
import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.BallTab;
import org.eclipse.swt.examples.graphics.BlackHoleTab;
import org.eclipse.swt.examples.graphics.CardsTab;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.CountDownTab;
import org.eclipse.swt.examples.graphics.CurvesSWTTab;
import org.eclipse.swt.examples.graphics.CurvesTab;
import org.eclipse.swt.examples.graphics.CustomAlphaTab;
import org.eclipse.swt.examples.graphics.CustomFontTab;
import org.eclipse.swt.examples.graphics.FontBounceTab;
import org.eclipse.swt.examples.graphics.GradientTab;
import org.eclipse.swt.examples.graphics.GraphicAntialiasTab;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.examples.graphics.ImageFlipTab;
import org.eclipse.swt.examples.graphics.ImageScaleTab;
import org.eclipse.swt.examples.graphics.ImageTransformTab;
import org.eclipse.swt.examples.graphics.InterpolationTab;
import org.eclipse.swt.examples.graphics.IntroTab;
import org.eclipse.swt.examples.graphics.LineCapTab;
import org.eclipse.swt.examples.graphics.LineJoinTab;
import org.eclipse.swt.examples.graphics.LineStyleTab;
import org.eclipse.swt.examples.graphics.LineTab;
import org.eclipse.swt.examples.graphics.MazeTab;
import org.eclipse.swt.examples.graphics.PathClippingAnimTab;
import org.eclipse.swt.examples.graphics.PathClippingTab;
import org.eclipse.swt.examples.graphics.PathTab;
import org.eclipse.swt.examples.graphics.RGBTab;
import org.eclipse.swt.examples.graphics.RegionClippingTab;
import org.eclipse.swt.examples.graphics.ShapesTab;
import org.eclipse.swt.examples.graphics.SpiralTab;
import org.eclipse.swt.examples.graphics.StarPolyTab;
import org.eclipse.swt.examples.graphics.TextAntialiasTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class GraphicsExample {
    Composite parent;
    GraphicsTab[] tabs;
    GraphicsTab tab;
    GraphicsBackground background;
    ToolBar toolBar;
    Tree tabList;
    Text tabDesc;
    Sash hSash;
    Sash vSash;
    Canvas canvas;
    Composite tabControlPanel;
    ToolItem backItem;
    ToolItem dbItem;
    Menu backMenu;
    List<Image> resources;
    List<GraphicsTab> tabs_in_order;
    boolean animate = true;
    static boolean advanceGraphics;
    static boolean advanceGraphicsInit;
    static final int MARGIN = 5;
    static final int SASH_SPACING = 1;
    static final int TIMER = 30;
    static final ResourceBundle RESOURCE_BUNDLE;

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle("examples_graphics");
    }

    public GraphicsExample() {
    }

    public GraphicsExample(Composite parent) {
        this.parent = parent;
        this.resources = new ArrayList<Image>();
        this.createControls(parent);
        this.setTab(this.tab);
        this.startAnimationTimer();
    }

    boolean checkAdvancedGraphics() {
        if (advanceGraphicsInit) {
            return advanceGraphics;
        }
        advanceGraphicsInit = true;
        Display display = this.parent.getDisplay();
        try {
            Path path = new Path((Device)display);
            path.dispose();
        }
        catch (SWTException sWTException) {
            Shell shell = display.getActiveShell();
            Shell newShell = null;
            if (shell == null) {
                shell = newShell = new Shell(display);
            }
            MessageBox dialog = new MessageBox(shell, 40);
            dialog.setText(RESOURCE_BUNDLE.getString("Warning"));
            dialog.setMessage(RESOURCE_BUNDLE.getString("LibNotFound"));
            dialog.open();
            if (newShell != null) {
                newShell.dispose();
            }
            return false;
        }
        advanceGraphics = true;
        return true;
    }

    void createControls(Composite parent) {
        this.tabs = this.createTabs();
        this.createToolBar(parent);
        this.createTabList(parent);
        this.hSash = new Sash(parent, 256);
        this.createTabDesc(parent);
        this.vSash = new Sash(parent, 512);
        this.createCanvas(parent);
        this.createControlPanel(parent);
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.toolBar.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment((Control)this.toolBar, 5);
        data.right = new FormAttachment((Control)this.vSash, -1);
        data.bottom = new FormAttachment((Control)this.hSash, -1);
        this.tabList.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        int offset = parent.getBounds().height - this.tabDesc.computeSize((int)-1, (int)(this.tabDesc.getLineHeight() * 10)).y;
        data.top = new FormAttachment(null, offset);
        data.right = new FormAttachment((Control)this.vSash, -1);
        this.hSash.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment((Control)this.hSash, 1);
        data.right = new FormAttachment((Control)this.vSash, -1);
        data.bottom = new FormAttachment(100, -5);
        this.tabDesc.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(null, this.tabList.computeSize((int)-1, (int)-1).x + 50);
        data.top = new FormAttachment((Control)this.toolBar, 5);
        data.bottom = new FormAttachment(100, -5);
        this.vSash.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.vSash, 1);
        data.top = new FormAttachment((Control)this.toolBar, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment((Control)this.tabControlPanel);
        this.canvas.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.vSash, 1);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.tabControlPanel.setLayoutData((Object)data);
        this.vSash.addListener(13, event -> {
            Rectangle rect = this.hSash.getParent().getClientArea();
            event.x = Math.min(Math.max(event.x, 60), rect.width - 60);
            if (event.detail != 1) {
                FormData data1 = (FormData)this.vSash.getLayoutData();
                data1.left.offset = event.x;
                this.vSash.requestLayout();
                this.animate = true;
            } else {
                this.animate = false;
            }
        });
        this.hSash.addListener(13, event -> {
            Rectangle rect = this.vSash.getParent().getClientArea();
            event.y = Math.min(Math.max(event.y, this.tabList.getLocation().y + 60), rect.height - 60);
            if (event.detail != 1) {
                FormData data1 = (FormData)this.hSash.getLayoutData();
                data1.top.offset = event.y;
                this.hSash.requestLayout();
            }
        });
    }

    void createCanvas(Composite parent) {
        int style = 262144;
        if (this.dbItem.getSelection()) {
            style |= 0x20000000;
        }
        this.canvas = new Canvas(parent, style);
        this.canvas.addListener(9, event -> {
            GC gc = event.gc;
            Rectangle rect = this.canvas.getClientArea();
            Device device = gc.getDevice();
            Pattern pattern = null;
            if (this.background.getBgColor1() != null) {
                if (this.background.getBgColor2() != null) {
                    pattern = new Pattern(device, 0.0f, 0.0f, (float)rect.width, (float)rect.height, this.background.getBgColor1(), this.background.getBgColor2());
                    gc.setBackgroundPattern(pattern);
                } else {
                    gc.setBackground(this.background.getBgColor1());
                }
            } else if (this.background.getBgImage() != null) {
                pattern = new Pattern(device, this.background.getBgImage());
                gc.setBackgroundPattern(pattern);
            }
            gc.fillRectangle(rect);
            GraphicsTab tab = this.getTab();
            if (tab != null) {
                tab.paint(gc, rect.width, rect.height);
            }
            if (pattern != null) {
                pattern.dispose();
            }
        });
    }

    void recreateCanvas() {
        if (this.dbItem.getSelection() == ((this.canvas.getStyle() & 0x20000000) != 0)) {
            return;
        }
        Object data = this.canvas.getLayoutData();
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        this.createCanvas(this.parent);
        this.canvas.setLayoutData(data);
        this.parent.layout(true, true);
    }

    void createControlPanel(Composite parent) {
        Group group = new Group(parent, 0);
        this.tabControlPanel = group;
        group.setText(GraphicsExample.getResourceString("Settings"));
        this.tabControlPanel.setLayout((Layout)new RowLayout());
    }

    void createToolBar(Composite parent) {
        Display display = parent.getDisplay();
        this.toolBar = new ToolBar(parent, 0x800000);
        ToolItem back = new ToolItem(this.toolBar, 8);
        back.setText(GraphicsExample.getResourceString("Back"));
        back.setImage(this.loadImage((Device)display, "back.gif"));
        back.addListener(13, event -> {
            int index = this.tabs_in_order.indexOf(this.tab) - 1;
            if (index < 0) {
                index = this.tabs_in_order.size() - 1;
            }
            this.setTab(this.tabs_in_order.get(index));
        });
        ToolItem next = new ToolItem(this.toolBar, 8);
        next.setText(GraphicsExample.getResourceString("Next"));
        next.setImage(this.loadImage((Device)display, "next.gif"));
        next.addListener(13, event -> {
            int index = (this.tabs_in_order.indexOf(this.tab) + 1) % this.tabs_in_order.size();
            this.setTab(this.tabs_in_order.get(index));
        });
        ColorMenu colorMenu = new ColorMenu();
        colorMenu.setColorItems(true);
        colorMenu.setPatternItems(this.checkAdvancedGraphics());
        colorMenu.setGradientItems(this.checkAdvancedGraphics());
        this.backMenu = colorMenu.createMenu((Control)parent, gb -> {
            this.background = gb;
            this.backItem.setImage(gb.getThumbNail());
            if (this.canvas != null) {
                this.canvas.redraw();
            }
        });
        this.background = (GraphicsBackground)this.backMenu.getItem(0).getData();
        this.backItem = new ToolItem(this.toolBar, 8);
        this.backItem.setText(GraphicsExample.getResourceString("Background"));
        this.backItem.setImage(this.background.getThumbNail());
        this.backItem.addListener(13, event -> {
            if (event.widget == this.backItem) {
                ToolItem toolItem = (ToolItem)event.widget;
                ToolBar toolBar = toolItem.getParent();
                Rectangle toolItemBounds = toolItem.getBounds();
                Point point = toolBar.toDisplay(new Point(toolItemBounds.x, toolItemBounds.y));
                this.backMenu.setLocation(point.x, point.y + toolItemBounds.height);
                this.backMenu.setVisible(true);
            }
        });
        this.dbItem = new ToolItem(this.toolBar, 32);
        this.dbItem.setText(GraphicsExample.getResourceString("DoubleBuffer"));
        this.dbItem.setImage(this.loadImage((Device)display, "db.gif"));
        this.dbItem.addListener(13, event -> this.setDoubleBuffered(this.dbItem.getSelection()));
    }

    static Image createThumbnail(Device device, String name) {
        Image image = new Image(device, name);
        Rectangle src = image.getBounds();
        Image result = null;
        if (src.width != 16 || src.height != 16) {
            result = new Image(device, 16, 16);
            GC gc = new GC((Drawable)result);
            Rectangle dest = result.getBounds();
            gc.drawImage(image, src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height);
            gc.dispose();
        }
        if (result != null) {
            image.dispose();
            return result;
        }
        return image;
    }

    static Image createImage(Device device, Color color1, Color color2, int width, int height) {
        Image image = new Image(device, width, height);
        GC gc = new GC((Drawable)image);
        Rectangle rect = image.getBounds();
        Pattern pattern = new Pattern(device, (float)rect.x, (float)rect.y, (float)(rect.width - 1), (float)(rect.height - 1), color1, color2);
        gc.setBackgroundPattern(pattern);
        gc.fillRectangle(rect);
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.dispose();
        pattern.dispose();
        return image;
    }

    static Image createImage(Device device, Color color) {
        Image image = new Image(device, 16, 16);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        Rectangle rect = image.getBounds();
        gc.fillRectangle(rect);
        if (color.equals((Object)device.getSystemColor(2))) {
            gc.setForeground(device.getSystemColor(1));
        }
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.dispose();
        return image;
    }

    void createTabList(Composite parent) {
        TreeItem[] items;
        this.tabList = new Tree(parent, 2820);
        Arrays.sort(this.tabs, (tab0, tab1) -> tab0.getText().compareTo(tab1.getText()));
        HashSet<String> set = new HashSet<String>();
        GraphicsTab[] graphicsTabArray = this.tabs;
        int n = this.tabs.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsTab tab = graphicsTabArray[n2];
            set.add(tab.getCategory());
            ++n2;
        }
        Object[] categories = new String[set.size()];
        set.toArray(categories);
        Arrays.sort(categories);
        Object[] objectArray = categories;
        int n3 = categories.length;
        n = 0;
        while (n < n3) {
            Object text = objectArray[n];
            TreeItem item = new TreeItem(this.tabList, 0);
            item.setText((String)text);
            ++n;
        }
        this.tabs_in_order = new ArrayList<GraphicsTab>();
        TreeItem[] treeItemArray = items = this.tabList.getItems();
        int n4 = items.length;
        n3 = 0;
        while (n3 < n4) {
            TreeItem item = treeItemArray[n3];
            GraphicsTab[] graphicsTabArray2 = this.tabs;
            int n5 = this.tabs.length;
            int n6 = 0;
            while (n6 < n5) {
                GraphicsTab tab = graphicsTabArray2[n6];
                if (item.getText().equals(tab.getCategory())) {
                    TreeItem item1 = new TreeItem(item, 0);
                    item1.setText(tab.getText());
                    item1.setData((Object)tab);
                    this.tabs_in_order.add(tab);
                }
                ++n6;
            }
            ++n3;
        }
        this.tabList.addListener(13, event -> {
            TreeItem item = (TreeItem)event.item;
            if (item != null) {
                GraphicsTab gt = (GraphicsTab)item.getData();
                if (gt == this.tab) {
                    return;
                }
                this.setTab((GraphicsTab)item.getData());
            }
        });
    }

    void createTabDesc(Composite parent) {
        this.tabDesc = new Text(parent, 2882);
        this.tabDesc.setEditable(false);
        this.tabDesc.setBackground(Display.getCurrent().getSystemColor(1));
    }

    GraphicsTab[] createTabs() {
        this.tab = new IntroTab(this);
        return new GraphicsTab[]{new LineTab(this), new StarPolyTab(this), this.tab, new BlackHoleTab(this), new AlphaTab(this), new BallTab(this), new CountDownTab(this), new CurvesSWTTab(this), new CurvesTab(this), new CustomFontTab(this), new FontBounceTab(this), new GradientTab(this), new ImageTransformTab(this), new ShapesTab(this), new MazeTab(this), new RGBTab(this), new SpiralTab(this), new CardsTab(this), new LineCapTab(this), new InterpolationTab(this), new PathClippingTab(this), new PathClippingAnimTab(this), new LineStyleTab(this), new LineJoinTab(this), new RegionClippingTab(this), new CustomAlphaTab(this), new TextAntialiasTab(this), new GraphicAntialiasTab(this), new ImageFlipTab(this), new ImageScaleTab(this), new PathTab(this)};
    }

    public void dispose() {
        if (this.tabs != null) {
            GraphicsTab[] graphicsTabArray = this.tabs;
            int n = this.tabs.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicsTab tab = graphicsTabArray[n2];
                tab.dispose();
                ++n2;
            }
        }
        this.tabs = null;
        if (this.resources != null) {
            for (Image image : this.resources) {
                if (image == null) continue;
                image.dispose();
            }
        }
        this.resources = null;
        if (this.backMenu != null) {
            this.backMenu.dispose();
            this.backMenu = null;
        }
    }

    TreeItem findItemByData(TreeItem[] items, Object data) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            if ((item = this.findItemByData(item.getItems(), data)) != null) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public GraphicsTab getTab() {
        return this.tab;
    }

    static String getResourceString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static Image loadImage(Device device, Class<GraphicsExample> clazz, String string) {
        Image image;
        block12: {
            InputStream stream = clazz.getResourceAsStream(string);
            if (stream == null) {
                return null;
            }
            image = null;
            try {
                try {
                    image = new Image(device, stream);
                }
                catch (SWTException sWTException) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return image;
    }

    Image loadImage(Device device, String name) {
        Image image = GraphicsExample.loadImage(device, GraphicsExample.class, name);
        if (image != null) {
            this.resources.add(image);
        }
        return image;
    }

    public Shell open(Display display) {
        Shell shell = new Shell(display);
        shell.setText(GraphicsExample.getResourceString("GraphicsExample"));
        GraphicsExample example = new GraphicsExample((Composite)shell);
        shell.addListener(21, event -> example.dispose());
        shell.open();
        return shell;
    }

    public void redraw() {
        this.canvas.redraw();
    }

    public void setDoubleBuffered(boolean doubleBuffered) {
        this.dbItem.setSelection(doubleBuffered);
        this.recreateCanvas();
    }

    public void setFocus() {
        this.tabList.setFocus();
    }

    public void setTab(GraphicsTab tab) {
        TreeItem item;
        TreeItem[] selection;
        Control[] children;
        Control[] controlArray = children = this.tabControlPanel.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (this.tab != null) {
            this.tab.dispose();
        }
        this.tab = tab;
        if (tab != null) {
            this.setDoubleBuffered(tab.getDoubleBuffered());
            tab.createControlPanel(this.tabControlPanel);
            this.tabDesc.setText(tab.getDescription());
        } else {
            this.tabDesc.setText("");
        }
        FormData data = (FormData)this.tabControlPanel.getLayoutData();
        children = this.tabControlPanel.getChildren();
        data.top = children.length != 0 ? null : new FormAttachment(100, -5);
        this.parent.layout(true, true);
        if (tab != null && ((selection = this.tabList.getSelection()).length == 0 || selection[0].getData() != tab) && (item = this.findItemByData(this.tabList.getItems(), tab)) != null) {
            this.tabList.setSelection(new TreeItem[]{item});
        }
        this.canvas.redraw();
    }

    void startAnimationTimer() {
        final Display display = this.parent.getDisplay();
        display.timerExec(30, new Runnable(){

            @Override
            public void run() {
                if (GraphicsExample.this.canvas.isDisposed()) {
                    return;
                }
                int timeout = 30;
                GraphicsTab tab = GraphicsExample.this.getTab();
                if (tab instanceof AnimatedGraphicsTab) {
                    AnimatedGraphicsTab animTab = (AnimatedGraphicsTab)tab;
                    if (GraphicsExample.this.animate && animTab.getAnimation()) {
                        Rectangle rect = GraphicsExample.this.canvas.getClientArea();
                        animTab.next(rect.width, rect.height);
                        GraphicsExample.this.canvas.redraw();
                        GraphicsExample.this.canvas.update();
                    }
                    timeout = animTab.getAnimationTime();
                }
                display.timerExec(timeout, (Runnable)this);
            }
        });
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new GraphicsExample().open(display);
        while (shell != null && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

