/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.AnimatedGraphicsTab;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class PathClippingAnimTab
extends AnimatedGraphicsTab {
    private Button colorButton;
    private GraphicsBackground background;
    private Menu menu;
    private int rectWidth = 300;
    private int rectHeight = 300;
    private int incWidth = 5;
    private int incHeight = 5;
    private boolean vertical = false;
    private int angle;

    public PathClippingAnimTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Clipping");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("AnimPathClipping");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("AnimPathClippingDesc");
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        super.createControlPanel(parent);
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), gb -> {
            this.background = gb;
            this.colorButton.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.background = (GraphicsBackground)this.menu.getItem(4).getData();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.background.getThumbNail());
        this.colorButton.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu.setLocation(point.x, point.y + bounds.height);
            this.menu.setVisible(true);
        });
    }

    @Override
    public void next(int width, int height) {
        this.angle = (this.angle + 5) % 360;
        if (this.vertical) {
            if (this.rectHeight <= 0) {
                this.incHeight = -this.incHeight;
            }
            if (this.rectHeight >= height) {
                this.incHeight = -this.incHeight;
                this.vertical = false;
            }
            this.rectHeight += this.incHeight;
        } else {
            if (this.rectWidth <= 0) {
                this.incWidth = -this.incWidth;
            }
            if (this.rectWidth >= width) {
                this.incWidth = -this.incWidth;
                this.vertical = true;
            }
            this.rectWidth += this.incWidth;
        }
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        Path path = new Path(device);
        path.moveTo((float)(width / 2), 0.0f);
        path.lineTo((float)(width / 2 + 100), 173.0f);
        path.lineTo((float)(width / 2 - 100), 173.0f);
        path.lineTo((float)(width / 2), 0.0f);
        Path path2 = new Path(device);
        path2.moveTo((float)(width / 2), (float)height);
        path2.lineTo((float)(width / 2 + 100), (float)(height - 173));
        path2.lineTo((float)(width / 2 - 100), (float)(height - 173));
        path2.lineTo((float)(width / 2), (float)height);
        Path path3 = new Path(device);
        path3.moveTo(0.0f, (float)(height / 2));
        path3.lineTo(173.0f, (float)(height / 2 - 100));
        path3.lineTo(173.0f, (float)(height / 2 + 100));
        path3.lineTo(0.0f, (float)(height / 2));
        Path path4 = new Path(device);
        path4.moveTo((float)width, (float)(height / 2));
        path4.lineTo((float)(width - 173), (float)(height / 2 - 100));
        path4.lineTo((float)(width - 173), (float)(height / 2 + 100));
        path4.lineTo((float)width, (float)(height / 2));
        Path path5 = new Path(device);
        path5.moveTo((float)((width - 200) / 2), (float)((height - 200) / 2));
        path5.addArc((float)((width - 200) / 2), (float)((height - 200) / 2), 200.0f, 200.0f, 0.0f, 360.0f);
        Path path6 = new Path(device);
        path6.addRectangle((float)((width - 40) / 2), 175.0f, 40.0f, (float)((height - 200) / 2 - 177));
        Path path7 = new Path(device);
        path7.addRectangle((float)((width - 40) / 2), (float)((height - 200) / 2 + 202), 40.0f, (float)(height - 175 - ((height - 200) / 2 + 202)));
        Path path8 = new Path(device);
        path8.addRectangle(175.0f, (float)((height - 40) / 2), (float)((width - 200) / 2 - 177), 40.0f);
        Path path9 = new Path(device);
        path9.addRectangle((float)((width - 200) / 2 + 202), (float)((height - 40) / 2), (float)(width - 175 - ((width - 200) / 2 + 202)), 40.0f);
        path.addPath(path2);
        path.addPath(path3);
        path.addPath(path4);
        path.addPath(path5);
        path.addPath(path6);
        path.addPath(path7);
        path.addPath(path8);
        path.addPath(path9);
        gc.setClipping(path);
        Pattern pattern = null;
        if (this.background.getBgColor1() != null) {
            gc.setBackground(this.background.getBgColor1());
        } else if (this.background.getBgImage() != null) {
            pattern = new Pattern(device, this.background.getBgImage());
            gc.setBackgroundPattern(pattern);
        }
        gc.setLineWidth(2);
        gc.fillRectangle((width - this.rectWidth) / 2, (height - this.rectHeight) / 2, this.rectWidth, this.rectHeight);
        gc.drawPath(path);
        if (pattern != null) {
            pattern.dispose();
        }
        path9.dispose();
        path8.dispose();
        path7.dispose();
        path6.dispose();
        path5.dispose();
        path4.dispose();
        path3.dispose();
        path2.dispose();
        path.dispose();
    }
}

