/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class PathClippingTab
extends GraphicsTab {
    private Combo clippingCb;
    private Button colorButton;
    private GraphicsBackground background;
    private Menu menu;

    public PathClippingTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Clipping");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("PathClipping");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("PathClippingDesc");
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Clipping"));
        this.clippingCb = new Combo(comp, 4);
        this.clippingCb.add(GraphicsExample.getResourceString("Circles"));
        this.clippingCb.add(GraphicsExample.getResourceString("Rectangle"));
        this.clippingCb.add(GraphicsExample.getResourceString("Oval"));
        this.clippingCb.add(GraphicsExample.getResourceString("Word"));
        this.clippingCb.add(GraphicsExample.getResourceString("Star"));
        this.clippingCb.add(GraphicsExample.getResourceString("Triangles"));
        this.clippingCb.add(GraphicsExample.getResourceString("Default"));
        this.clippingCb.select(0);
        this.clippingCb.addListener(13, event -> this.example.redraw());
        ColorMenu cm = new ColorMenu();
        cm.setPatternItems(this.example.checkAdvancedGraphics());
        this.menu = cm.createMenu((Control)parent.getParent(), gb -> {
            this.background = gb;
            this.colorButton.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.background = (GraphicsBackground)this.menu.getItem(4).getData();
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.background.getThumbNail());
        this.colorButton.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu.setLocation(point.x, point.y + bounds.height);
            this.menu.setVisible(true);
        });
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        int clipping = this.clippingCb.getSelectionIndex();
        switch (clipping) {
            case 0: {
                Path path = new Path(device);
                path.addArc((float)((width - width / 5) / 2), (float)((height - height / 5) / 2), (float)(width / 5), (float)(height / 5), 0.0f, 360.0f);
                path.addArc((float)(5 * (width - width / 8) / 12), (float)(4 * (height - height / 8) / 12), (float)(width / 8), (float)(height / 8), 0.0f, 360.0f);
                path.addArc((float)(7 * (width - width / 8) / 12), (float)(8 * (height - height / 8) / 12), (float)(width / 8), (float)(height / 8), 0.0f, 360.0f);
                path.addArc((float)(6 * (width - width / 12) / 12), (float)(3 * (height - height / 12) / 12), (float)(width / 12), (float)(height / 12), 0.0f, 360.0f);
                path.addArc((float)(6 * (width - width / 12) / 12), (float)(9 * (height - height / 12) / 12), (float)(width / 12), (float)(height / 12), 0.0f, 360.0f);
                path.addArc(11.5f * (float)(width - width / 18) / 20.0f, (float)(5 * (height - height / 18) / 18), (float)(width / 18), (float)(height / 18), 0.0f, 360.0f);
                path.addArc(8.5f * (float)(width - width / 18) / 20.0f, (float)(13 * (height - height / 18) / 18), (float)(width / 18), (float)(height / 18), 0.0f, 360.0f);
                gc.setClipping(path);
                path.dispose();
                break;
            }
            case 1: {
                Path path = new Path(device);
                path.addRectangle(100.0f, 100.0f, (float)(width - 200), (float)(height - 200));
                path.addRectangle(120.0f, 120.0f, (float)(width - 240), (float)(height - 240));
                path.addRectangle(140.0f, 140.0f, (float)(width - 280), (float)(height - 280));
                gc.setClipping(path);
                path.dispose();
                break;
            }
            case 2: {
                Path path = new Path(device);
                path.addArc(100.0f, 100.0f, (float)(width - 200), (float)(height - 200), 0.0f, 360.0f);
                path.addArc((float)((width - width / 5) / 2), (float)((height - height / 5) / 2), (float)(width / 5), (float)(height / 5), 0.0f, 360.0f);
                path.addArc((float)(5 * (width - width / 8) / 12), (float)(4 * (height - height / 8) / 12), (float)(width / 8), (float)(height / 8), 0.0f, 360.0f);
                path.addArc((float)(7 * (width - width / 8) / 12), (float)(8 * (height - height / 8) / 12), (float)(width / 8), (float)(height / 8), 0.0f, 360.0f);
                path.addArc((float)(6 * (width - width / 12) / 12), (float)(3 * (height - height / 12) / 12), (float)(width / 12), (float)(height / 12), 0.0f, 360.0f);
                path.addArc((float)(6 * (width - width / 12) / 12), (float)(9 * (height - height / 12) / 12), (float)(width / 12), (float)(height / 12), 0.0f, 360.0f);
                path.addArc(11.5f * (float)(width - width / 18) / 20.0f, (float)(5 * (height - height / 18) / 18), (float)(width / 18), (float)(height / 18), 0.0f, 360.0f);
                path.addArc(8.5f * (float)(width - width / 18) / 20.0f, (float)(13 * (height - height / 18) / 18), (float)(width / 18), (float)(height / 18), 0.0f, 360.0f);
                gc.setClipping(path);
                path.dispose();
                break;
            }
            case 3: {
                Path path = new Path(device);
                String text = GraphicsExample.getResourceString("SWT");
                Font font = new Font(device, "Times", 200, 0);
                gc.setFont(font);
                Point size = gc.stringExtent(text);
                path.addString(text, (float)((width - size.x) / 2), (float)((height - size.y) / 2), font);
                font.dispose();
                gc.setClipping(path);
                path.dispose();
                break;
            }
            case 4: {
                Path path = new Path(device);
                path.lineTo((float)(width / 2), 0.0f);
                path.lineTo((float)(5 * width / 8), (float)(height / 3));
                path.lineTo((float)width, (float)(height / 3));
                path.lineTo((float)(3 * width / 4), (float)(10 * height / 16));
                path.lineTo((float)(7 * width / 8), (float)height);
                path.lineTo((float)(width / 2), (float)(3 * height / 4));
                path.lineTo((float)(width / 8), (float)height);
                path.lineTo((float)(width / 4), (float)(10 * height / 16));
                path.lineTo(0.0f, (float)(height / 3));
                path.lineTo((float)(3 * width / 8), (float)(height / 3));
                path.lineTo((float)(width / 2), 0.0f);
                Path ovalPath = new Path(device);
                ovalPath.addArc(90.0f, 90.0f, (float)(width - 180), (float)(height - 180), 0.0f, 360.0f);
                path.addPath(ovalPath);
                gc.setClipping(path);
                ovalPath.dispose();
                path.dispose();
                break;
            }
            case 5: {
                Path path = new Path(device);
                path.addRectangle(0.0f, 0.0f, (float)width, (float)height);
                path.lineTo((float)(width / 4), 0.0f);
                path.lineTo((float)(width / 4), (float)(height / 2));
                path.lineTo(0.0f, (float)(height / 2));
                path.lineTo((float)(width / 4), 0.0f);
                Path path2 = new Path(device);
                path2.lineTo((float)(width / 2), 0.0f);
                path2.lineTo((float)(width / 4), (float)(height / 2));
                path2.lineTo((float)(3 * width / 4), (float)(height / 2));
                path2.lineTo((float)(width / 2), 0.0f);
                Path path3 = new Path(device);
                path3.lineTo((float)(3 * width / 4), 0.0f);
                path3.lineTo((float)(3 * width / 4), (float)(height / 2));
                path3.lineTo((float)width, (float)(height / 2));
                path3.lineTo((float)(3 * width / 4), 0.0f);
                Path path4 = new Path(device);
                path4.lineTo(0.0f, (float)height);
                path4.lineTo((float)(width / 4), (float)(height / 2));
                path4.lineTo((float)(width / 2), (float)height);
                path4.lineTo(0.0f, (float)height);
                Path path5 = new Path(device);
                path5.lineTo((float)(width / 2), (float)height);
                path5.lineTo((float)(3 * width / 4), (float)(height / 2));
                path5.lineTo((float)width, (float)height);
                path5.lineTo((float)(width / 2), (float)height);
                path.addPath(path2);
                path.addPath(path3);
                path.addPath(path4);
                path.addPath(path5);
                gc.setClipping(path);
                path5.dispose();
                path4.dispose();
                path3.dispose();
                path2.dispose();
                path.dispose();
                break;
            }
            case 6: {
                gc.setClipping(0, 0, width, height);
            }
        }
        Pattern pattern = null;
        if (this.background.getBgColor1() != null) {
            gc.setBackground(this.background.getBgColor1());
        } else if (this.background.getBgImage() != null) {
            pattern = new Pattern(device, this.background.getBgImage());
            gc.setBackgroundPattern(pattern);
        }
        gc.fillRectangle(0, 0, width, height);
        if (pattern != null) {
            pattern.dispose();
        }
    }
}

