/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RegionClippingTab
extends GraphicsTab {
    private Combo clippingCb;
    private Button colorButton1;
    private Button colorButton2;
    private Menu menu1;
    private Menu menu2;
    private GraphicsBackground colorGB1;
    private GraphicsBackground colorGB2;

    public RegionClippingTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Clipping");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("RegionClipping");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("RegionClippingDescription");
    }

    @Override
    public void dispose() {
        if (this.menu1 != null) {
            this.menu1.dispose();
            this.menu1 = null;
        }
        if (this.menu2 != null) {
            this.menu2.dispose();
            this.menu2 = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Clipping"));
        this.clippingCb = new Combo(comp, 4);
        this.clippingCb.add(GraphicsExample.getResourceString("Region1"));
        this.clippingCb.add(GraphicsExample.getResourceString("Region2"));
        this.clippingCb.add(GraphicsExample.getResourceString("Add"));
        this.clippingCb.add(GraphicsExample.getResourceString("Sub"));
        this.clippingCb.add(GraphicsExample.getResourceString("Inter"));
        this.clippingCb.select(0);
        this.clippingCb.addListener(13, event -> this.example.redraw());
        ColorMenu cm = new ColorMenu();
        this.menu1 = cm.createMenu((Control)parent.getParent(), gb -> {
            this.colorGB1 = gb;
            this.colorButton1.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.menu2 = cm.createMenu((Control)parent.getParent(), gb -> {
            this.colorGB2 = gb;
            this.colorButton2.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        this.colorGB1 = (GraphicsBackground)this.menu1.getItem(4).getData();
        this.colorGB2 = (GraphicsBackground)this.menu2.getItem(2).getData();
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.colorButton1 = new Button(comp, 8);
        this.colorButton1.setText(GraphicsExample.getResourceString("Color1"));
        this.colorButton1.setImage(this.colorGB1.getThumbNail());
        this.colorButton1.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu1.setLocation(point.x, point.y + bounds.height);
            this.menu1.setVisible(true);
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.colorButton2 = new Button(comp, 8);
        this.colorButton2.setText(GraphicsExample.getResourceString("Color2"));
        this.colorButton2.setImage(this.colorGB2.getThumbNail());
        this.colorButton2.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu2.setLocation(point.x, point.y + bounds.height);
            this.menu2.setVisible(true);
        });
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        int[] polygon1 = new int[]{10, height / 2, 9 * width / 16, 10, 9 * width / 16, height - 10};
        Region region1 = new Region(device);
        region1.add(polygon1);
        int[] polygon2 = new int[]{9 * width / 16, 10, 9 * width / 16, height / 8, 7 * width / 16, 2 * height / 8, 9 * width / 16, 3 * height / 8, 7 * width / 16, 4 * height / 8, 9 * width / 16, 5 * height / 8, 7 * width / 16, 6 * height / 8, 9 * width / 16, 7 * height / 8, 9 * width / 16, height - 10, width - 10, height / 2};
        Region region2 = new Region(device);
        region2.add(polygon2);
        gc.setAlpha(127);
        int clippingIndex = this.clippingCb.getSelectionIndex();
        switch (clippingIndex) {
            case 0: {
                gc.setClipping(region1);
                gc.setBackground(this.colorGB1.getBgColor1());
                gc.fillPolygon(polygon1);
                break;
            }
            case 1: {
                gc.setClipping(region2);
                gc.setBackground(this.colorGB2.getBgColor1());
                gc.fillPolygon(polygon2);
                break;
            }
            case 2: {
                region1.add(region2);
                break;
            }
            case 3: {
                region1.subtract(region2);
                break;
            }
            case 4: {
                region1.intersect(region2);
            }
        }
        if (clippingIndex > 1) {
            gc.setClipping(region1);
            gc.setBackground(this.colorGB1.getBgColor1());
            gc.fillPolygon(polygon1);
            gc.setBackground(this.colorGB2.getBgColor1());
            gc.fillPolygon(polygon2);
        }
        region1.dispose();
        region2.dispose();
    }
}

