/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.examples.graphics.ColorMenu;
import org.eclipse.swt.examples.graphics.GraphicsBackground;
import org.eclipse.swt.examples.graphics.GraphicsExample;
import org.eclipse.swt.examples.graphics.GraphicsTab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class TextAntialiasTab
extends GraphicsTab {
    Combo aliasCombo;
    static int[] aliasValues;
    Button colorButton;
    Menu menu;
    GraphicsBackground textColor;
    String text = GraphicsExample.getResourceString("SWT");

    static {
        int[] nArray = new int[3];
        nArray[1] = -1;
        nArray[2] = 1;
        aliasValues = nArray;
    }

    public TextAntialiasTab(GraphicsExample example) {
        super(example);
    }

    @Override
    public String getCategory() {
        return GraphicsExample.getResourceString("Antialiasing");
    }

    @Override
    public String getText() {
        return GraphicsExample.getResourceString("Text");
    }

    @Override
    public String getDescription() {
        return GraphicsExample.getResourceString("AntialiasingTextDesc");
    }

    @Override
    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    public void createControlPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        new Label(comp, 0x1000000).setText(GraphicsExample.getResourceString("Antialiasing"));
        this.aliasCombo = new Combo(comp, 4);
        this.aliasCombo.add("OFF");
        this.aliasCombo.add("DEFAULT");
        this.aliasCombo.add("ON");
        this.aliasCombo.select(0);
        this.aliasCombo.addListener(13, event -> this.example.redraw());
        ColorMenu cm = new ColorMenu();
        cm.setColorItems(true);
        this.menu = cm.createMenu((Control)parent.getParent(), gb -> {
            this.textColor = gb;
            this.colorButton.setImage(gb.getThumbNail());
            this.example.redraw();
        });
        comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.textColor = (GraphicsBackground)this.menu.getItem(1).getData();
        this.colorButton = new Button(comp, 8);
        this.colorButton.setText(GraphicsExample.getResourceString("Color"));
        this.colorButton.setImage(this.textColor.getThumbNail());
        this.colorButton.addListener(13, event -> {
            Button button = (Button)event.widget;
            Composite parent1 = button.getParent();
            Rectangle bounds = button.getBounds();
            Point point = parent1.toDisplay(new Point(bounds.x, bounds.y));
            this.menu.setLocation(point.x, point.y + bounds.height);
            this.menu.setVisible(true);
        });
    }

    @Override
    public void paint(GC gc, int width, int height) {
        if (!this.example.checkAdvancedGraphics()) {
            return;
        }
        Device device = gc.getDevice();
        if (this.textColor != null && this.textColor.getBgColor1() != null) {
            gc.setForeground(this.textColor.getBgColor1());
        }
        gc.setTextAntialias(aliasValues[this.aliasCombo.getSelectionIndex()]);
        Font font = new Font(device, TextAntialiasTab.getPlatformFontFace(0), 100, 0);
        gc.setFont(font);
        Point size = gc.stringExtent(this.text);
        gc.drawString(this.text, width / 4 - size.x / 2, height / 4 - size.y / 2, true);
        font.dispose();
        font = new Font(device, TextAntialiasTab.getPlatformFontFace(1), 100, 0);
        gc.setFont(font);
        size = gc.stringExtent(this.text);
        gc.drawString(this.text, width / 4 - size.x / 2, 3 * height / 4 - size.y / 2, true);
        font.dispose();
        font = new Font(device, TextAntialiasTab.getPlatformFontFace(2), 50, 0);
        gc.setFont(font);
        size = gc.stringExtent(this.text);
        gc.drawString(this.text, (width - size.x) / 2, 0, true);
        font.dispose();
        font = new Font(device, TextAntialiasTab.getPlatformFontFace(3), 100, 2);
        gc.setFont(font);
        size = gc.stringExtent(this.text);
        gc.drawString(this.text, (width - size.x) / 2, (height - size.y) / 2, true);
        font.dispose();
        font = new Font(device, TextAntialiasTab.getPlatformFontFace(4), 50, 0);
        gc.setFont(font);
        size = gc.stringExtent(this.text);
        gc.drawString(this.text, (width - size.x) / 2, height - size.y, true);
        font.dispose();
        font = new Font(device, TextAntialiasTab.getPlatformFontFace(5), 100, 0);
        gc.setFont(font);
        size = gc.stringExtent(this.text);
        gc.drawString(this.text, 3 * width / 4 - size.x / 2, height / 4 - size.y / 2, true);
        font.dispose();
        font = new Font(device, TextAntialiasTab.getPlatformFontFace(6), 100, 0);
        gc.setFont(font);
        size = gc.stringExtent(this.text);
        gc.drawString(this.text, 3 * width / 4 - size.x / 2, 3 * height / 4 - size.y / 2, true);
        font.dispose();
    }

    static String getPlatformFontFace(int index) {
        if (SWT.getPlatform() == "win32") {
            return (new String[]{"Bookman Old Style", "Century Gothic", "Comic Sans MS", "Impact", "Garamond", "Lucida Console", "Monotype Corsiva"})[index];
        }
        if (SWT.getPlatform() == "gtk") {
            return (new String[]{"Luxi Mono", "KacstTitleL", "Baekmuk Batang", "Baekmuk Headline", "KacstFarsi", "Baekmuk Gulim", "URW Chancery L"})[index];
        }
        return (new String[]{"Courier", "Verdana", "Verdana", "Verdana", "Verdana", "Verdana", "Verdana"})[index];
    }
}

