/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.hoverhelp;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class HoverHelp {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_hoverhelp");
    static final int hhiInformation = 0;
    static final int hhiWarning = 1;
    static final String[] imageLocations = new String[]{"information.gif", "warning.gif"};
    Image[] images;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new HoverHelp().open(display);
        while (shell != null && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        block5: {
            Class<HoverHelp> clazz = HoverHelp.class;
            try {
                if (this.images != null) break block5;
                this.images = new Image[imageLocations.length];
                int i = 0;
                while (i < imageLocations.length) {
                    InputStream stream = clazz.getResourceAsStream(imageLocations[i]);
                    ImageData source = new ImageData(stream);
                    ImageData mask = source.getTransparencyMask();
                    this.images[i] = new Image((Device)display, source, mask);
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                System.err.println(this.getResourceString("error.CouldNotLoadResources", new Object[]{ex.getMessage()}));
                return null;
            }
        }
        Shell shell = new Shell();
        this.createPartControl((Composite)shell);
        shell.addDisposeListener(e -> {
            if (this.images != null) {
                Image[] imageArray = this.images;
                int n = this.images.length;
                int n2 = 0;
                while (n2 < n) {
                    Image image = imageArray[n2];
                    if (image != null) {
                        image.dispose();
                    }
                    ++n2;
                }
                this.images = null;
            }
        });
        shell.pack();
        shell.open();
        return shell;
    }

    public String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(this.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public void createPartControl(Composite frame) {
        ToolTipHandler tooltip = new ToolTipHandler(frame.getShell());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        frame.setLayout((Layout)layout);
        String platform = SWT.getPlatform();
        String helpKey = "F1";
        if (platform.equals("gtk")) {
            helpKey = "Ctrl+F1";
        }
        if (platform.equals("cocoa")) {
            helpKey = "Help";
        }
        ToolBar bar = new ToolBar(frame, 2048);
        int i = 0;
        while (i < 5) {
            ToolItem item = new ToolItem(bar, 8);
            item.setText(this.getResourceString("ToolItem.text", new Object[]{i}));
            item.setData("TIP_TEXT", (Object)this.getResourceString("ToolItem.tooltip", new Object[]{item.getText(), helpKey}));
            item.setData("TIP_HELPTEXTHANDLER", widget -> {
                Item item1 = (Item)widget;
                return this.getResourceString("ToolItem.help", new Object[]{item1.getText()});
            });
            ++i;
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        bar.setLayoutData((Object)gridData);
        tooltip.activateHoverHelp((Control)bar);
        Table table = new Table(frame, 2048);
        int i2 = 0;
        while (i2 < 4) {
            TableItem item = new TableItem(table, 8);
            item.setText(this.getResourceString("Item", new Object[]{i2}));
            item.setData("TIP_IMAGE", (Object)this.images[0]);
            item.setText(this.getResourceString("TableItem.text", new Object[]{i2}));
            item.setData("TIP_TEXT", (Object)this.getResourceString("TableItem.tooltip", new Object[]{item.getText(), helpKey}));
            item.setData("TIP_HELPTEXTHANDLER", widget -> {
                Item item1 = (Item)widget;
                return this.getResourceString("TableItem.help", new Object[]{item1.getText()});
            });
            ++i2;
        }
        table.setLayoutData((Object)new GridData(16));
        tooltip.activateHoverHelp((Control)table);
        Tree tree = new Tree(frame, 2048);
        int i3 = 0;
        while (i3 < 4) {
            TreeItem item = new TreeItem(tree, 8);
            item.setText(this.getResourceString("Item", new Object[]{i3}));
            item.setData("TIP_IMAGE", (Object)this.images[1]);
            item.setText(this.getResourceString("TreeItem.text", new Object[]{i3}));
            item.setData("TIP_TEXT", (Object)this.getResourceString("TreeItem.tooltip", new Object[]{item.getText(), helpKey}));
            item.setData("TIP_HELPTEXTHANDLER", widget -> {
                Item item1 = (Item)widget;
                return this.getResourceString("TreeItem.help", new Object[]{item1.getText()});
            });
            ++i3;
        }
        tree.setLayoutData((Object)new GridData(16));
        tooltip.activateHoverHelp((Control)tree);
        Button button = new Button(frame, 8);
        button.setText(this.getResourceString("Hello.text"));
        button.setData("TIP_TEXT", (Object)this.getResourceString("Hello.tooltip"));
        tooltip.activateHoverHelp((Control)button);
    }

    protected static class ToolTipHandler {
        private Shell parentShell;
        private Shell tipShell;
        private Label tipLabelImage;
        private Label tipLabelText;
        private Widget tipWidget;
        private Point tipPosition;

        public ToolTipHandler(Shell parent) {
            Display display = parent.getDisplay();
            this.parentShell = parent;
            this.tipShell = new Shell(parent, 16388);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 2;
            this.tipShell.setLayout((Layout)gridLayout);
            this.tipShell.setBackground(display.getSystemColor(29));
            this.tipLabelImage = new Label((Composite)this.tipShell, 0);
            this.tipLabelImage.setForeground(display.getSystemColor(28));
            this.tipLabelImage.setBackground(display.getSystemColor(29));
            this.tipLabelImage.setLayoutData((Object)new GridData(772));
            this.tipLabelText = new Label((Composite)this.tipShell, 0);
            this.tipLabelText.setForeground(display.getSystemColor(28));
            this.tipLabelText.setBackground(display.getSystemColor(29));
            this.tipLabelText.setLayoutData((Object)new GridData(772));
        }

        public void activateHoverHelp(final Control control) {
            control.addMouseListener(MouseListener.mouseDownAdapter(e -> {
                if (this.tipShell.isVisible()) {
                    this.tipShell.setVisible(false);
                }
            }));
            control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    if (tipShell.isVisible()) {
                        tipShell.setVisible(false);
                    }
                    tipWidget = null;
                }

                public void mouseHover(MouseEvent event) {
                    ToolBar w;
                    Point pt = new Point(event.x, event.y);
                    Widget widget = event.widget;
                    if (widget instanceof ToolBar) {
                        w = (ToolBar)widget;
                        widget = w.getItem(pt);
                    }
                    if (widget instanceof Table) {
                        w = (Table)widget;
                        widget = w.getItem(pt);
                    }
                    if (widget instanceof Tree) {
                        w = (Tree)widget;
                        widget = w.getItem(pt);
                    }
                    if (widget == null) {
                        tipShell.setVisible(false);
                        tipWidget = null;
                        return;
                    }
                    if (widget == tipWidget) {
                        return;
                    }
                    tipWidget = widget;
                    tipPosition = control.toDisplay(pt);
                    String text = (String)widget.getData("TIP_TEXT");
                    Image image = (Image)widget.getData("TIP_IMAGE");
                    tipLabelText.setText(text != null ? text : "");
                    tipLabelImage.setImage(image);
                    tipShell.pack();
                    this.setHoverLocation(tipShell, tipPosition);
                    tipShell.setVisible(true);
                }
            });
            control.addHelpListener(event -> {
                if (this.tipWidget == null) {
                    return;
                }
                ToolTipHelpTextHandler handler = (ToolTipHelpTextHandler)this.tipWidget.getData("TIP_HELPTEXTHANDLER");
                if (handler == null) {
                    return;
                }
                String text = handler.getHelpText(this.tipWidget);
                if (text == null) {
                    return;
                }
                if (this.tipShell.isVisible()) {
                    this.tipShell.setVisible(false);
                    Shell helpShell = new Shell(this.parentShell, 1264);
                    helpShell.setLayout((Layout)new FillLayout());
                    Label label = new Label((Composite)helpShell, 0);
                    label.setText(text);
                    helpShell.pack();
                    this.setHoverLocation(helpShell, this.tipPosition);
                    helpShell.open();
                }
            });
        }

        private void setHoverLocation(Shell shell, Point position) {
            Rectangle displayBounds = shell.getDisplay().getBounds();
            Rectangle shellBounds = shell.getBounds();
            shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
            shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
            shell.setBounds(shellBounds);
        }
    }

    protected static interface ToolTipHelpTextHandler {
        public String getHelpText(Widget var1);
    }
}

