/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import java.util.Random;
import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.ContinuousPaintSession;
import org.eclipse.swt.examples.paint.PaintExample;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.PointFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class AirbrushTool
extends ContinuousPaintSession
implements PaintTool {
    private ToolSettings settings;
    private Random random = new Random();
    private int cachedRadiusSquared;
    private int cachedNumPoints;

    public AirbrushTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.setRetriggerTimer(10);
        this.set(toolSettings);
    }

    @Override
    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
        this.cachedRadiusSquared = this.settings.airbrushRadius * this.settings.airbrushRadius;
        this.cachedNumPoints = 314 * this.settings.airbrushIntensity * this.cachedRadiusSquared / 250000;
        if (this.cachedNumPoints == 0 && this.settings.airbrushIntensity != 0) {
            this.cachedNumPoints = 1;
        }
    }

    @Override
    public String getDisplayName() {
        return PaintExample.getResourceString("tool.Airbrush.label");
    }

    @Override
    protected void render(Point point) {
        ContainerFigure cfig = new ContainerFigure();
        int i = 0;
        while (i < this.cachedNumPoints) {
            int randY;
            int randX;
            while ((randX = (int)((this.random.nextDouble() - 0.5) * (double)this.settings.airbrushRadius * 2.0)) * randX + (randY = (int)((this.random.nextDouble() - 0.5) * (double)this.settings.airbrushRadius * 2.0)) * randY > this.cachedRadiusSquared) {
            }
            cfig.add(new PointFigure(this.settings.commonForegroundColor, point.x + randX, point.y + randY));
            ++i;
        }
        this.getPaintSurface().drawFigure(cfig);
    }
}

