/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Region;

public class ContainerFigure
extends Figure {
    private static final int INITIAL_ARRAY_SIZE = 16;
    Figure[] objectStack = null;
    int nextIndex = 0;

    public void add(Figure object) {
        if (this.objectStack == null) {
            this.objectStack = new Figure[16];
        } else if (this.objectStack.length <= this.nextIndex) {
            Figure[] newObjectStack = new Figure[this.objectStack.length * 2];
            System.arraycopy(this.objectStack, 0, newObjectStack, 0, this.objectStack.length);
            this.objectStack = newObjectStack;
        }
        this.objectStack[this.nextIndex] = object;
        ++this.nextIndex;
    }

    public boolean isEmpty() {
        return this.nextIndex == 0;
    }

    public void clear() {
        while (--this.nextIndex > 0) {
            this.objectStack[this.nextIndex] = null;
        }
        this.nextIndex = 0;
    }

    @Override
    public void draw(FigureDrawContext fdc) {
        int i = 0;
        while (i < this.nextIndex) {
            this.objectStack[i].draw(fdc);
            ++i;
        }
    }

    @Override
    public void addDamagedRegion(FigureDrawContext fdc, Region region) {
        int i = 0;
        while (i < this.nextIndex) {
            this.objectStack[i].addDamagedRegion(fdc, region);
            ++i;
        }
    }
}

