/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

public class EllipseFigure
extends Figure {
    private Color foregroundColor;
    private Color backgroundColor;
    private int lineStyle;
    private int x1;
    private int y1;
    private int x2;
    private int y2;

    public EllipseFigure(Color foregroundColor, Color backgroundColor, int lineStyle, int x1, int y1, int x2, int y2) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.lineStyle = lineStyle;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public void draw(FigureDrawContext fdc) {
        Rectangle r = fdc.toClientRectangle(this.x1, this.y1, this.x2, this.y2);
        fdc.gc.setForeground(this.foregroundColor);
        fdc.gc.setBackground(this.backgroundColor);
        fdc.gc.setLineStyle(this.lineStyle);
        fdc.gc.drawOval(r.x, r.y, r.width - 1, r.height - 1);
        fdc.gc.setLineStyle(1);
    }

    @Override
    public void addDamagedRegion(FigureDrawContext fdc, Region region) {
        region.add(fdc.toClientRectangle(this.x1, this.y1, this.x2, this.y2));
    }
}

