/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class StyledTextContentSpec
implements TextChangeListener {
    static String contentClassName;
    static int failCount;
    static int errorCount;
    Class<?> contentClass = null;
    StyledTextContent contentInstance = null;
    int verify = 0;
    Method currentMethod = null;
    boolean failed = false;
    StyledText widget = null;
    Shell shell = null;

    static {
        failCount = 0;
        errorCount = 0;
    }

    public void assertTrue(String message, boolean condition) {
        System.out.print("\t" + this.currentMethod.getName() + " " + message);
        if (!condition) {
            this.fail(message);
        } else {
            System.out.println(" passed");
        }
    }

    public void fail(String message) {
        this.failed = true;
        System.out.println(" FAILED: " + message);
        ++failCount;
    }

    public StyledTextContent getContentInstance() {
        this.contentInstance.setText("");
        this.widget.setContent(this.contentInstance);
        return this.contentInstance;
    }

    public static String getTestText() {
        return "This is the first line.\r\nThis is the second line.\r\nThis is the third line.\r\nThis is the fourth line.\r\nThis is the fifth line.\r\n\r\nThis is the first line again.\r\nThis is the second line again.\r\nThis is the third line again.\r\nThis is the fourth line again.\r\nThis is the fifth line again.\r\n\r\nThis is the first line once again.\r\nThis is the second line once again.\r\nThis is the third line once again.\r\nThis is the fourth line once again.\r\nThis is the fifth line once again.";
    }

    public static void main(String[] args) {
        StyledTextContentSpec spec = new StyledTextContentSpec();
        if (args.length <= 0) {
            MessageBox box = new MessageBox(Display.getDefault().getActiveShell(), 1);
            box.setMessage("Content class must be specified as an execution argument.");
            box.open();
            return;
        }
        contentClassName = args[0];
        spec.run();
        System.out.println();
        System.out.println(String.valueOf(failCount) + " TEST FAILURES.");
        System.out.println(String.valueOf(errorCount) + " UNEXPECTED ERRORS.");
    }

    public void run() {
        if (contentClassName.isEmpty()) {
            MessageBox box = new MessageBox(Display.getDefault().getActiveShell(), 1);
            box.setMessage("Content class must be specified as an execution argument.");
            box.open();
            return;
        }
        if (this.contentClass == null) {
            try {
                this.contentClass = Class.forName(contentClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                MessageBox box = new MessageBox(Display.getDefault().getActiveShell(), 1);
                box.setMessage("Content class:\n" + contentClassName + "\nnot found");
                box.open();
                return;
            }
        }
        try {
            this.contentInstance = (StyledTextContent)this.contentClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            MessageBox box = new MessageBox(Display.getDefault().getActiveShell(), 1);
            box.setMessage("Unable to access content class:\n" + contentClassName);
            box.open();
            return;
        }
        catch (InstantiationException instantiationException) {
            MessageBox box = new MessageBox(Display.getDefault().getActiveShell(), 1);
            box.setMessage("Unable to instantiate content class:\n" + contentClassName);
            box.open();
            return;
        }
        Class<?> clazz = this.getClass();
        Method[] methods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            this.setUp();
            this.currentMethod = methods[i];
            this.failed = false;
            try {
                if (this.currentMethod.getName().startsWith("test_")) {
                    System.out.println();
                    System.out.println(String.valueOf(this.currentMethod.getName()) + "...");
                    this.currentMethod.invoke((Object)this, new Object[0]);
                    if (!this.failed) {
                        System.out.println("PASSED.");
                    } else {
                        System.out.println("FAILED");
                    }
                }
            }
            catch (InvocationTargetException ex) {
                System.out.println("\t" + this.currentMethod.getName() + " ERROR ==> " + ex.getTargetException().toString());
                System.out.println("FAILED");
                ++errorCount;
            }
            catch (Exception ex) {
                System.out.println("\t" + this.currentMethod.getName() + " ERROR ==> " + ex.toString());
                System.out.println("FAILED");
                ++errorCount;
            }
            if (this.verify != 0) {
                this.verify = 0;
                this.contentInstance.removeTextChangeListener((TextChangeListener)this);
            }
            this.tearDown();
            ++i;
        }
    }

    public void textSet(TextChangedEvent event) {
    }

    public void textChanged(TextChangedEvent event) {
    }

    public void textChanging(TextChangingEvent event) {
        switch (this.verify) {
            case 1: {
                this.assertTrue(":1a:", event.replaceLineCount == 0);
                this.assertTrue(":1b:", event.newLineCount == 1);
                break;
            }
            case 2: {
                this.assertTrue(":2a:", event.replaceLineCount == 2);
                this.assertTrue(":2b:", event.newLineCount == 0);
                break;
            }
            case 3: {
                this.assertTrue(":3a:", event.replaceLineCount == 0);
                this.assertTrue(":3b:", event.newLineCount == 2);
                break;
            }
            case 4: {
                this.assertTrue(":4:", false);
                break;
            }
            case 5: {
                this.assertTrue(":5a:", event.replaceLineCount == 0);
                this.assertTrue(":5b:", event.newLineCount == 1);
                break;
            }
            case 6: {
                this.assertTrue(":6a:", event.replaceLineCount == 1);
                this.assertTrue(":6b:", event.newLineCount == 0);
                break;
            }
            case 8: {
                this.assertTrue(":8a:", event.replaceLineCount == 1);
                this.assertTrue(":8b:", event.newLineCount == 0);
                break;
            }
            case 9: {
                this.assertTrue(":9a:", event.replaceLineCount == 1);
                this.assertTrue(":9b:", event.newLineCount == 0);
                break;
            }
            case 10: {
                this.assertTrue(":10:", false);
                break;
            }
            case 11: {
                this.assertTrue(":11:", false);
                break;
            }
            case 12: {
                this.assertTrue(":12a:", event.replaceLineCount == 0);
                this.assertTrue(":12b:", event.newLineCount == 1);
                break;
            }
            case 13: {
                this.assertTrue(":13a:", event.replaceLineCount == 0);
                this.assertTrue(":13b:", event.newLineCount == 1);
                break;
            }
            case 14: {
                this.assertTrue(":14:", false);
                break;
            }
            case 15: {
                this.assertTrue(":15a:", event.replaceLineCount == 1);
                this.assertTrue(":15b:", event.newLineCount == 2);
                break;
            }
            case 16: {
                this.assertTrue(":16:", false);
                break;
            }
            case 17: {
                this.assertTrue(":17:", false);
                break;
            }
            case 18: {
                this.assertTrue(":18a:", event.replaceLineCount == 0);
                this.assertTrue(":18b:", event.newLineCount == 2);
                break;
            }
            case 19: {
                this.assertTrue(":19a:", event.replaceLineCount == 0);
                this.assertTrue(":19b:", event.newLineCount == 3);
                break;
            }
            case 20: {
                this.assertTrue(":20:", false);
            }
        }
    }

    public void test_Insert() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\r");
        content.replaceTextRange(0, 0, "test\n ");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":1a:", newText.equals("test\n This\nis a test\r"));
        this.assertTrue(":1b:", content.getLineCount() == 4);
        this.assertTrue(":1c:", content.getLine(0).equals("test"));
        this.assertTrue(":1d:", content.getLine(1).equals(" This"));
        this.assertTrue(":1e:", content.getLine(2).equals("is a test"));
        this.assertTrue(":1f:", content.getLine(3).isEmpty());
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 0, "*** ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":2a:", newText.equals("This\n*** is a test\r"));
        this.assertTrue(":2b:", content.getLineCount() == 3);
        this.assertTrue(":2c:", content.getLine(0).equals("This"));
        this.assertTrue(":2d:", content.getLine(1).equals("*** is a test"));
        this.assertTrue(":2e:", content.getLine(2).isEmpty());
        content.setText("Line 1\r\nLine 2");
        content.replaceTextRange(0, 0, "\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":3a:", newText.equals("\rLine 1\r\nLine 2"));
        this.assertTrue(":3b:", content.getLineCount() == 3);
        this.assertTrue(":3c:", content.getLine(0).isEmpty());
        this.assertTrue(":3d:", content.getLine(1).equals("Line 1"));
        this.assertTrue(":3e:", content.getLine(2).equals("Line 2"));
        content.replaceTextRange(9, 0, "\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":3f:", newText.equals("\rLine 1\r\n\rLine 2"));
        this.assertTrue(":3g:", content.getLineCount() == 4);
        this.assertTrue(":3h:", content.getLine(0).isEmpty());
        this.assertTrue(":3i:", content.getLine(1).equals("Line 1"));
        this.assertTrue(":3j:", content.getLine(2).isEmpty());
        this.assertTrue(":3k:", content.getLine(3).equals("Line 2"));
        content.setText("This\nis a test\r");
        content.replaceTextRange(0, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4a:", newText.equals("\nThis\nis a test\r"));
        this.assertTrue(":4b:", content.getLineCount() == 4);
        this.assertTrue(":4c:", content.getLine(0).isEmpty());
        this.assertTrue(":4d:", content.getLine(1).equals("This"));
        this.assertTrue(":4e:", content.getLine(2).equals("is a test"));
        this.assertTrue(":4f:", content.getLine(3).isEmpty());
        content.setText("This\nis a test\r");
        content.replaceTextRange(7, 0, "\r\nnewLine");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":5a:", newText.equals("This\nis\r\nnewLine a test\r"));
        this.assertTrue(":5b:", content.getLineCount() == 4);
        this.assertTrue(":5c:", content.getLine(0).equals("This"));
        this.assertTrue(":5d:", content.getLine(1).equals("is"));
        this.assertTrue(":5e:", content.getLine(2).equals("newLine a test"));
        this.assertTrue(":5f:", content.getLine(3).isEmpty());
        content.setText("");
        content.replaceTextRange(0, 0, "This\nis\r\nnewLine a test\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":6a:", newText.equals("This\nis\r\nnewLine a test\r"));
        this.assertTrue(":6b:", content.getLineCount() == 4);
        this.assertTrue(":6c:", content.getLine(0).equals("This"));
        this.assertTrue(":6d:", content.getLine(1).equals("is"));
        this.assertTrue(":6e:", content.getLine(2).equals("newLine a test"));
        this.assertTrue(":6f:", content.getLine(3).isEmpty());
        content.setText("This");
        content.replaceTextRange(4, 0, "\n ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":7a:", newText.equals("This\n "));
        this.assertTrue(":7b:", content.getLineCount() == 2);
        this.assertTrue(":7c:", content.getLine(0).equals("This"));
        this.assertTrue(":7d:", content.getLine(1).equals(" "));
        content.setText("This\n");
        content.replaceTextRange(5, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":7e:", newText.equals("This\n\n"));
        this.assertTrue(":7f:", content.getLineCount() == 3);
        this.assertTrue(":7g:", content.getLine(0).equals("This"));
        this.assertTrue(":7h:", content.getLine(1).isEmpty());
        this.assertTrue(":7i:", content.getLine(2).isEmpty());
        content.setText("This");
        content.replaceTextRange(0, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":8a:", newText.equals("\nThis"));
        this.assertTrue(":8b:", content.getLineCount() == 2);
        this.assertTrue(":8c:", content.getLine(0).isEmpty());
        this.assertTrue(":8d:", content.getLine(1).equals("This"));
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 0, "*** ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":9a:", newText.equals("This\n*** is a test\r"));
        this.assertTrue(":9b:", content.getLineCount() == 3);
        this.assertTrue(":9c:", content.getLine(0).equals("This"));
        this.assertTrue(":9d:", content.getLine(1).equals("*** is a test"));
        this.assertTrue(":9e:", content.getLine(2).isEmpty());
        content.setText("This\n");
        content.replaceTextRange(5, 0, "line");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":10a:", newText.equals("This\nline"));
        this.assertTrue(":10b:", content.getLineCount() == 2);
        this.assertTrue(":10c:", content.getLine(0).equals("This"));
        this.assertTrue(":10d:", content.getLine(1).equals("line"));
        this.assertTrue(":10e:", content.getLineAtOffset(8) == 1);
        this.assertTrue(":10f:", content.getLineAtOffset(9) == 1);
        content.setText("This\n");
        content.replaceTextRange(0, 0, "line\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":11a:", newText.equals("line\nThis\n"));
        this.assertTrue(":11b:", content.getLineCount() == 3);
        this.assertTrue(":11c:", content.getLine(0).equals("line"));
        this.assertTrue(":11d:", content.getLine(1).equals("This"));
        this.assertTrue(":11e:", content.getLineAtOffset(5) == 1);
        content.setText("Line 1\r\nLine 2\r\nLine 3");
        content.replaceTextRange(0, 0, "\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":12a:", newText.equals("\rLine 1\r\nLine 2\r\nLine 3"));
        this.assertTrue(":12b:", content.getLineCount() == 4);
        this.assertTrue(":12c:", content.getLine(0).isEmpty());
        this.assertTrue(":12d:", content.getLine(1).equals("Line 1"));
        this.assertTrue(":12e:", content.getLine(2).equals("Line 2"));
        this.assertTrue(":12f:", content.getLine(3).equals("Line 3"));
        content.setText("Line 1\nLine 2\nLine 3");
        content.replaceTextRange(7, 0, "Line1a\nLine1b\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":13a:", newText.equals("Line 1\nLine1a\nLine1b\nLine 2\nLine 3"));
        this.assertTrue(":13b:", content.getLineCount() == 5);
        this.assertTrue(":13c:", content.getLine(0).equals("Line 1"));
        this.assertTrue(":13d:", content.getLine(1).equals("Line1a"));
        this.assertTrue(":13e:", content.getLine(2).equals("Line1b"));
        this.assertTrue(":13f:", content.getLine(3).equals("Line 2"));
        this.assertTrue(":13g:", content.getLine(4).equals("Line 3"));
        content.setText("Line 1\nLine 2\nLine 3");
        content.replaceTextRange(11, 0, "l1a");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":14a:", newText.equals("Line 1\nLinel1a 2\nLine 3"));
        this.assertTrue(":14b:", content.getLineCount() == 3);
        this.assertTrue(":14c:", content.getLine(0).equals("Line 1"));
        this.assertTrue(":14d:", content.getLine(1).equals("Linel1a 2"));
        this.assertTrue(":14e:", content.getLine(2).equals("Line 3"));
        content.setText("Line 1\nLine 2 is a very long line that spans many words\nLine 3");
        content.replaceTextRange(19, 0, "very, very, ");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":15a:", newText.equals("Line 1\nLine 2 is a very, very, very long line that spans many words\nLine 3"));
        this.assertTrue(":15b:", content.getLineCount() == 3);
        this.assertTrue(":15c:", content.getLine(0).equals("Line 1"));
        this.assertTrue(":15d:", content.getLine(1).equals("Line 2 is a very, very, very long line that spans many words"));
        this.assertTrue(":15e:", content.getLine(2).equals("Line 3"));
    }

    public void test_Empty() {
        StyledTextContent content = this.getContentInstance();
        this.assertTrue(":1a:", content.getLineCount() == 1);
        this.assertTrue(":1b:", content.getLine(0).isEmpty());
        content.setText("test");
        content.replaceTextRange(0, 4, "");
        this.assertTrue(":2a:", content.getLineCount() == 1);
        this.assertTrue(":2b:", content.getLine(0).isEmpty());
    }

    public void test_Line_Conversion() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\rrepeat\nend\r");
        this.assertTrue(":1a:", content.getLineCount() == 5);
        this.assertTrue(":1b:", content.getLine(0).equals("This"));
        this.assertTrue(":1c:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":1d:", content.getLine(1).equals("is a test"));
        this.assertTrue(":1e:", content.getLineAtOffset(4) == 0);
        this.assertTrue(":1f:", content.getOffsetAtLine(1) == 5);
        this.assertTrue(":1g:", content.getLine(2).equals("repeat"));
        this.assertTrue(":1h:", content.getOffsetAtLine(2) == 15);
        this.assertTrue(":1i:", content.getLine(3).equals("end"));
        this.assertTrue(":1j:", content.getOffsetAtLine(3) == 22);
        this.assertTrue(":1k:", content.getLine(4).isEmpty());
        this.assertTrue(":1l:", content.getOffsetAtLine(4) == 26);
        content.setText("This\r\nis a test");
        this.assertTrue(":2a:", content.getLineCount() == 2);
        this.assertTrue(":2b:", content.getLine(1).equals("is a test"));
        this.assertTrue(":2c:", content.getLineAtOffset(4) == 0);
        this.assertTrue(":2d:", content.getLineAtOffset(5) == 0);
        content.setText("This\r\nis a test\r");
        this.assertTrue(":3a:", content.getLineCount() == 3);
        this.assertTrue(":3b:", content.getLine(1).equals("is a test"));
        this.assertTrue(":3c:", content.getLineAtOffset(15) == 1);
        content.setText("\r\n");
        this.assertTrue(":4a:", content.getLineCount() == 2);
        this.assertTrue(":4b:", content.getLine(0).isEmpty());
        this.assertTrue(":4c:", content.getLine(1).isEmpty());
        this.assertTrue(":4d:", content.getLineAtOffset(0) == 0);
        this.assertTrue(":4e:", content.getLineAtOffset(1) == 0);
        this.assertTrue(":4f:", content.getLineAtOffset(2) == 1);
        content.setText("\r\n\n\r\r\n");
        this.assertTrue(":5a:", content.getLineCount() == 5);
        this.assertTrue(":5b:", content.getLine(0).isEmpty());
        this.assertTrue(":5c:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":5d:", content.getLine(1).isEmpty());
        this.assertTrue(":5e:", content.getOffsetAtLine(1) == 2);
        this.assertTrue(":5f:", content.getLine(2).isEmpty());
        this.assertTrue(":5g:", content.getOffsetAtLine(2) == 3);
        this.assertTrue(":5h:", content.getLine(3).isEmpty());
        this.assertTrue(":5i:", content.getOffsetAtLine(3) == 4);
        this.assertTrue(":5j:", content.getLine(4).isEmpty());
        this.assertTrue(":5k:", content.getOffsetAtLine(4) == 6);
        content.setText("test\r\rtest2\r\r");
        this.assertTrue(":6a:", content.getLineCount() == 5);
        this.assertTrue(":6b:", content.getLine(0).equals("test"));
        this.assertTrue(":6c:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":6d:", content.getLine(1).isEmpty());
        this.assertTrue(":6e:", content.getOffsetAtLine(1) == 5);
        this.assertTrue(":6f:", content.getLine(2).equals("test2"));
        this.assertTrue(":6g:", content.getOffsetAtLine(2) == 6);
        this.assertTrue(":6h:", content.getLine(3).isEmpty());
        this.assertTrue(":6i:", content.getOffsetAtLine(3) == 12);
        this.assertTrue(":6j:", content.getLine(4).isEmpty());
        this.assertTrue(":6k:", content.getOffsetAtLine(4) == 13);
    }

    public void test_Offset_To_Line() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\rrepeat\nend\r");
        this.assertTrue(":1a:", content.getLineAtOffset(0) == 0);
        this.assertTrue(":1b:", content.getLineAtOffset(3) == 0);
        this.assertTrue(":1c:", content.getLineAtOffset(4) == 0);
        this.assertTrue(":1d:", content.getLineAtOffset(25) == 3);
        this.assertTrue(":1e:", content.getLineAtOffset(26) == 4);
        content.setText("This\r\nis a test");
        this.assertTrue(":2a:", content.getLineAtOffset(5) == 0);
        this.assertTrue(":2b:", content.getLineAtOffset(6) == 1);
        this.assertTrue(":2c:", content.getLineAtOffset(10) == 1);
        content.setText("\r\n");
        this.assertTrue(":3a:", content.getLineAtOffset(0) == 0);
        this.assertTrue(":3b:", content.getLineAtOffset(1) == 0);
        this.assertTrue(":3c:", content.getLineAtOffset(2) == 1);
        content.setText("\r\n\n\r\r\n");
        this.assertTrue(":4a:", content.getLineAtOffset(0) == 0);
        this.assertTrue(":4b:", content.getLineAtOffset(1) == 0);
        this.assertTrue(":4c:", content.getLineAtOffset(2) == 1);
        this.assertTrue(":4d:", content.getLineAtOffset(3) == 2);
        this.assertTrue(":4e:", content.getLineAtOffset(4) == 3);
        this.assertTrue(":4f:", content.getLineAtOffset(5) == 3);
        this.assertTrue(":4g:", content.getLineAtOffset(6) == 4);
        content.setText("\r\n\r\n");
        this.assertTrue(":5a:", content.getLineAtOffset(0) == 0);
        this.assertTrue(":5b:", content.getLineAtOffset(1) == 0);
        this.assertTrue(":5c:", content.getLineAtOffset(2) == 1);
        this.assertTrue(":5d:", content.getLineAtOffset(3) == 1);
        this.assertTrue(":5e:", content.getLineAtOffset(4) == 2);
        content.setText("\r\r\r\n\r\n");
        this.assertTrue(":6a:", content.getLineAtOffset(0) == 0);
        this.assertTrue(":6b:", content.getLineAtOffset(1) == 1);
        this.assertTrue(":6c:", content.getLineAtOffset(2) == 2);
        this.assertTrue(":6d:", content.getLineAtOffset(4) == 3);
        content.setText("");
        this.assertTrue(":7a:", content.getLineAtOffset(0) == 0);
        content = this.getContentInstance();
        this.assertTrue(":8a:", content.getLineAtOffset(0) == 0);
    }

    public void test_Line_To_Offset() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\rrepeat\nend\r");
        this.assertTrue(":1a:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":1b:", content.getOffsetAtLine(1) == 5);
        this.assertTrue(":1c:", content.getOffsetAtLine(2) == 15);
        this.assertTrue(":1d:", content.getOffsetAtLine(3) == 22);
        this.assertTrue(":1e:", content.getOffsetAtLine(4) == 26);
        content.setText("This\r\nis a test");
        this.assertTrue(":2a:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":2b:", content.getOffsetAtLine(1) == 6);
        content.setText("\r\n");
        this.assertTrue(":3a:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":3b:", content.getOffsetAtLine(1) == 2);
        content.setText("\r\n\n\r\r\n");
        this.assertTrue(":4a:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":4b:", content.getOffsetAtLine(1) == 2);
        this.assertTrue(":4c:", content.getOffsetAtLine(2) == 3);
        this.assertTrue(":4d:", content.getOffsetAtLine(3) == 4);
        this.assertTrue(":4e:", content.getOffsetAtLine(4) == 6);
        content.setText("\r\ntest\r\n");
        this.assertTrue(":5a:", content.getOffsetAtLine(0) == 0);
        this.assertTrue(":5b:", content.getOffsetAtLine(1) == 2);
        this.assertTrue(":5c:", content.getOffsetAtLine(2) == 8);
    }

    public void test_Delete() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\r");
        content.replaceTextRange(6, 2, "");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":1a:", newText.equals("This\nia test\r"));
        this.assertTrue(":1b:", content.getLine(0).equals("This"));
        this.assertTrue(":1c:", content.getLine(1).equals("ia test"));
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 9, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":2a:", newText.equals("This\n\r"));
        this.assertTrue(":2b:", content.getLineCount() == 3);
        this.assertTrue(":2c:", content.getLine(0).equals("This"));
        this.assertTrue(":2d:", content.getLine(1).isEmpty());
        this.assertTrue(":2e:", content.getLine(2).isEmpty());
        content.setText("This\nis a test\nline 3\nline 4");
        content.replaceTextRange(21, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":3a:", newText.equals("This\nis a test\nline 3"));
        this.assertTrue(":3b:", content.getLineCount() == 3);
        this.assertTrue(":3c:", content.getLine(0).equals("This"));
        this.assertTrue(":3d:", content.getLine(1).equals("is a test"));
        this.assertTrue(":3e:", content.getLine(2).equals("line 3"));
        content.setText("This\nis a test\nline 3\nline 4");
        content.replaceTextRange(0, 5, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4a:", newText.equals("is a test\nline 3\nline 4"));
        this.assertTrue(":4b:", content.getLineCount() == 3);
        this.assertTrue(":4c:", content.getLine(0).equals("is a test"));
        this.assertTrue(":4d:", content.getLine(1).equals("line 3"));
        this.assertTrue(":4e:", content.getLine(2).equals("line 4"));
        content.replaceTextRange(16, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4f:", newText.equals("is a test\nline 3"));
        this.assertTrue(":4g:", content.getLine(0).equals("is a test"));
        this.assertTrue(":4h:", content.getLine(1).equals("line 3"));
        content.replaceTextRange(9, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4i:", newText.equals("is a test"));
        this.assertTrue(":4j:", content.getLine(0).equals("is a test"));
        content.replaceTextRange(1, 8, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4k:", newText.equals("i"));
        this.assertTrue(":4l:", content.getLine(0).equals("i"));
        content.replaceTextRange(0, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4m:", newText.isEmpty());
        this.assertTrue(":4n:", content.getLine(0).isEmpty());
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 9, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":5a:", newText.equals("This\n\r"));
        this.assertTrue(":5b:", content.getLineCount() == 3);
        this.assertTrue(":5c:", content.getLine(0).equals("This"));
        this.assertTrue(":5d:", content.getLine(1).isEmpty());
        this.assertTrue(":5e:", content.getLine(2).isEmpty());
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        content.replaceTextRange(4, 8, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":6a:", newText.equals("L1\r\nL4\r\n"));
        this.assertTrue(":6b:", content.getLineCount() == 3);
        this.assertTrue(":6c:", content.getLine(0).equals("L1"));
        this.assertTrue(":6d:", content.getLine(1).equals("L4"));
        this.assertTrue(":6e:", content.getLine(2).isEmpty());
        content.setText("\nL1\r\nL2");
        content.replaceTextRange(0, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":7a:", newText.equals("L1\r\nL2"));
        this.assertTrue(":7b:", content.getLineCount() == 2);
        this.assertTrue(":7c:", content.getLine(0).equals("L1"));
        this.assertTrue(":7d:", content.getLine(1).equals("L2"));
        content.setText("\nL1\r\nL2\r\n");
        content.replaceTextRange(7, 2, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":8a:", newText.equals("\nL1\r\nL2"));
        this.assertTrue(":8b:", content.getLineCount() == 3);
        this.assertTrue(":8c:", content.getLine(0).isEmpty());
        this.assertTrue(":8d:", content.getLine(1).equals("L1"));
        this.assertTrue(":8e:", content.getLine(2).equals("L2"));
        content.setText("\nLine 1\nLine 2\n");
        content.replaceTextRange(0, 7, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":9a:", newText.equals("\nLine 2\n"));
        this.assertTrue(":9b:", content.getLineCount() == 3);
        this.assertTrue(":9c:", content.getLine(0).isEmpty());
        this.assertTrue(":9d:", content.getLine(1).equals("Line 2"));
        this.assertTrue(":9e:", content.getLine(2).isEmpty());
        content.setText("Line 1\nLine 2\n");
        content.replaceTextRange(6, 8, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":10a:", newText.equals("Line 1"));
        this.assertTrue(":10b:", content.getLineCount() == 1);
        this.assertTrue(":10c:", content.getLine(0).equals("Line 1"));
        content.setText("Line one is short\r\nLine 2 is a longer line\r\nLine 3\n");
        content.replaceTextRange(12, 17, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":11a:", newText.equals("Line one is a longer line\r\nLine 3\n"));
        this.assertTrue(":11b:", content.getLineCount() == 3);
        this.assertTrue(":11c:", content.getLine(0).equals("Line one is a longer line"));
        this.assertTrue(":11d:", content.getLine(1).equals("Line 3"));
        this.assertTrue(":11e:", content.getLine(2).isEmpty());
    }

    public void test_Replace() {
        StyledTextContent content = this.getContentInstance();
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 4, "a");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":1a:", newText.equals("This\na test\r"));
        this.assertTrue(":1b:", content.getLineCount() == 3);
        this.assertTrue(":1c:", content.getLine(0).equals("This"));
        this.assertTrue(":1d:", content.getLine(1).equals("a test"));
        this.assertTrue(":1e:", content.getLine(2).isEmpty());
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 2, "was");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":2a:", newText.equals("This\nwas a test\r"));
        this.assertTrue(":2b:", content.getLineCount() == 3);
        this.assertTrue(":2c:", content.getLine(0).equals("This"));
        this.assertTrue(":2d:", content.getLine(1).equals("was a test"));
        this.assertTrue(":2e:", content.getLine(2).isEmpty());
        content.setText("This is a test\r");
        content.replaceTextRange(5, 2, "was");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":3a:", newText.equals("This was a test\r"));
        this.assertTrue(":3b:", content.getLineCount() == 2);
        this.assertTrue(":3c:", content.getLine(0).equals("This was a test"));
        this.assertTrue(":3d:", content.getLineAtOffset(15) == 0);
        content.setText("Line 1\nLine 2\nLine 3");
        content.replaceTextRange(0, 7, "La\nLb\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4a:", newText.equals("La\nLb\nLine 2\nLine 3"));
        this.assertTrue(":4b:", content.getLine(0).equals("La"));
        this.assertTrue(":4c:", content.getLine(1).equals("Lb"));
        this.assertTrue(":4d:", content.getLine(2).equals("Line 2"));
        this.assertTrue(":4e:", content.getLine(3).equals("Line 3"));
        content.setText(StyledTextContentSpec.getTestText());
        newText = content.getTextRange(0, content.getCharCount());
        int start = content.getOffsetAtLine(6);
        int end = content.getOffsetAtLine(11);
        content.replaceTextRange(start, end - start, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":5a:", content.getLineCount() == 12);
        this.assertTrue(":5a:", content.getLine(5).isEmpty());
        this.assertTrue(":5a:", content.getLine(6).isEmpty());
        start = content.getOffsetAtLine(7);
        content.replaceTextRange(start, content.getCharCount() - start, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":5a:", content.getLineCount() == 8);
        this.assertTrue(":5a:", content.getLine(5).isEmpty());
        this.assertTrue(":5a:", content.getLine(6).isEmpty());
        this.assertTrue(":5a:", content.getLine(7).isEmpty());
    }

    public void test_Special_Cases() {
        StyledTextContent content = this.getContentInstance();
        this.assertTrue(":0a:", content.getLineCount() == 1);
        this.assertTrue(":0b:", content.getOffsetAtLine(0) == 0);
        content.setText("This is the input/output text component.");
        content.replaceTextRange(0, 0, "\n");
        this.assertTrue(":1a:", content.getLine(0).isEmpty());
        content.replaceTextRange(1, 0, "\n");
        this.assertTrue(":1b:", content.getLine(0).isEmpty());
        content.replaceTextRange(2, 0, "\n");
        this.assertTrue(":1c:", content.getLine(0).isEmpty());
        content.replaceTextRange(3, 0, "\n");
        this.assertTrue(":1d:", content.getLine(0).isEmpty());
        content.replaceTextRange(4, 0, "\n");
        this.assertTrue(":1e:", content.getLine(0).isEmpty());
        content.replaceTextRange(5, 0, "\n");
        this.assertTrue(":1f:", content.getLine(0).isEmpty());
        content.replaceTextRange(6, 0, "\n");
        this.assertTrue(":1g:", content.getLine(0).isEmpty());
        content.replaceTextRange(7, 0, "\n");
        this.assertTrue(":1h:", content.getLine(0).isEmpty());
        content.setText("This is the input/output text component.");
        content.replaceTextRange(0, 0, "\n");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":2a:", newText.equals("\nThis is the input/output text component."));
        this.assertTrue(":2b:", content.getLine(0).isEmpty());
        this.assertTrue(":2c:", content.getLine(1).equals("This is the input/output text component."));
        content.replaceTextRange(1, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":2d:", newText.equals("\n\nThis is the input/output text component."));
        this.assertTrue(":2e:", content.getLine(0).isEmpty());
        this.assertTrue(":2f:", content.getLine(1).isEmpty());
        this.assertTrue(":2g:", content.getLine(2).equals("This is the input/output text component."));
        content.replaceTextRange(2, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":3a:", newText.equals("\n\n\nThis is the input/output text component."));
        this.assertTrue(":3b:", content.getLine(0).isEmpty());
        this.assertTrue(":3c:", content.getLine(1).isEmpty());
        this.assertTrue(":3d:", content.getLine(2).isEmpty());
        this.assertTrue(":3e:", content.getLine(3).equals("This is the input/output text component."));
        content.replaceTextRange(3, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":3f:", newText.equals("\n\n\n\nThis is the input/output text component."));
        this.assertTrue(":3g:", content.getLine(0).isEmpty());
        this.assertTrue(":3h:", content.getLine(1).isEmpty());
        this.assertTrue(":3i:", content.getLine(2).isEmpty());
        this.assertTrue(":3j:", content.getLine(3).isEmpty());
        this.assertTrue(":3k:", content.getLine(4).equals("This is the input/output text component."));
        content.replaceTextRange(3, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4a:", newText.equals("\n\n\nThis is the input/output text component."));
        this.assertTrue(":4b:", content.getLine(0).isEmpty());
        this.assertTrue(":4c:", content.getLine(1).isEmpty());
        this.assertTrue(":4d:", content.getLine(2).isEmpty());
        this.assertTrue(":4e:", content.getLine(3).equals("This is the input/output text component."));
        content.replaceTextRange(2, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":4f:", newText.equals("\n\nThis is the input/output text component."));
        this.assertTrue(":4g:", content.getLine(0).isEmpty());
        this.assertTrue(":4h:", content.getLine(1).isEmpty());
        this.assertTrue(":4i:", content.getLine(2).equals("This is the input/output text component."));
        content.replaceTextRange(2, 0, "a");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":5a:", newText.equals("\n\naThis is the input/output text component."));
        this.assertTrue(":5b:", content.getLine(0).isEmpty());
        this.assertTrue(":5c:", content.getLine(1).isEmpty());
        this.assertTrue(":5d:", content.getLine(2).equals("aThis is the input/output text component."));
        content.setText("abc\r\ndef");
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":6a:", newText.equals("ac\r\ndef"));
        this.assertTrue(":6b:", content.getLineCount() == 2);
        this.assertTrue(":6c:", content.getLine(0).equals("ac"));
        this.assertTrue(":6d:", content.getLine(1).equals("def"));
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":6e:", newText.equals("a\r\ndef"));
        this.assertTrue(":6f:", content.getLineCount() == 2);
        this.assertTrue(":6g:", content.getLine(0).equals("a"));
        this.assertTrue(":6h:", content.getLine(1).equals("def"));
        content.replaceTextRange(1, 2, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":6i:", newText.equals("adef"));
        this.assertTrue(":6j:", content.getLineCount() == 1);
        this.assertTrue(":6k:", content.getLine(0).equals("adef"));
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":6l:", newText.equals("aef"));
        this.assertTrue(":6m:", content.getLineCount() == 1);
        this.assertTrue(":6n:", content.getLine(0).equals("aef"));
        content.replaceTextRange(1, 1, "");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":6o:", newText.equals("af"));
        this.assertTrue(":6p:", content.getLineCount() == 1);
        this.assertTrue(":6q:", content.getLine(0).equals("af"));
        content.setText("abc");
        content.replaceTextRange(0, 1, "1");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":7a:", content.getLineCount() == 1);
        this.assertTrue(":7b:", newText.equals("1bc"));
        this.assertTrue(":7c:", content.getLine(0).equals("1bc"));
        content.replaceTextRange(0, 0, "\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":7d:", newText.equals("\n1bc"));
        this.assertTrue(":7e:", content.getLineCount() == 2);
        this.assertTrue(":7f:", content.getLine(0).isEmpty());
        this.assertTrue(":7g:", content.getLine(1).equals("1bc"));
        content = this.getContentInstance();
        content.replaceTextRange(0, 0, "a");
        content.setText("package test;\n/* Line 1\n * Line 2\n */\npublic class SimpleClass {\n}");
        content.replaceTextRange(14, 23, "\t/*Line 1\n\t * Line 2\n\t */");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":8a:", newText.equals("package test;\n\t/*Line 1\n\t * Line 2\n\t */\npublic class SimpleClass {\n}"));
        this.assertTrue(":8b:", content.getLineCount() == 6);
        this.assertTrue(":8c:", content.getLine(0).equals("package test;"));
        this.assertTrue(":8d:", content.getLine(1).equals("\t/*Line 1"));
        this.assertTrue(":8e:", content.getLine(2).equals("\t * Line 2"));
        this.assertTrue(":8f:", content.getLine(3).equals("\t */"));
        this.assertTrue(":8g:", content.getLine(4).equals("public class SimpleClass {"));
        this.assertTrue(":8h:", content.getLine(5).equals("}"));
    }

    public void test_Text_Changed_Event() {
        StyledTextContent content = this.getContentInstance();
        content.addTextChangeListener((TextChangeListener)this);
        this.verify = 1;
        content.setText("testing");
        content.replaceTextRange(0, 0, "\n");
        this.verify = 2;
        content.setText("\n\n");
        content.replaceTextRange(0, 2, "a");
        this.verify = 3;
        content.setText("a");
        content.replaceTextRange(0, 1, "\n\n");
        this.verify = 4;
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            content.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTrue(":4:", true);
        }
        this.verify = 5;
        content.setText("Line 1\r\nLine 2");
        content.replaceTextRange(0, 0, "\r");
        this.verify = 6;
        content.setText("This\nis a test\nline 3\nline 4");
        content.replaceTextRange(21, 7, "");
        this.verify = 7;
        content.setText("This\nis a test\r");
        content.replaceTextRange(5, 9, "");
        this.verify = 8;
        content.setText("\nL1\r\nL2\r\n");
        content.replaceTextRange(7, 2, "");
        this.verify = 9;
        content.setText("L1\r\n");
        content.replaceTextRange(2, 2, "test");
        this.verify = 10;
        content.setText("L1\r\n");
        try {
            content.replaceTextRange(3, 1, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTrue(":10:", true);
        }
        this.verify = 11;
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            content.replaceTextRange(1, 2, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTrue(":11:", true);
        }
        this.verify = 12;
        content.setText("L1\r");
        content.replaceTextRange(3, 0, "\n");
        this.verify = 13;
        content.setText("L1\n");
        content.replaceTextRange(2, 0, "\r");
        this.verify = 14;
        content.setText("L1\r\n");
        try {
            content.replaceTextRange(3, 0, "test");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTrue(":14:", true);
        }
        this.verify = 15;
        content.setText("L1\r\n");
        content.replaceTextRange(2, 2, "test\n\n");
        this.verify = 16;
        content.setText("L1\r\n");
        try {
            content.replaceTextRange(3, 1, "test\r\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTrue(":16:", true);
        }
        this.verify = 17;
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            content.replaceTextRange(1, 2, "test\n\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTrue(":17:", true);
        }
        this.verify = 18;
        content.setText("L1\r");
        content.replaceTextRange(3, 0, "\ntest\r\n");
        this.verify = 19;
        content.setText("L1\n");
        content.replaceTextRange(2, 0, "test\r\r\r");
        this.verify = 20;
        content.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            content.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.assertTrue(":20:", true);
        }
        this.verify = 0;
        content.removeTextChangeListener((TextChangeListener)this);
    }

    public void test_Delimiter_Special_Cases() {
        StyledTextContent content = this.getContentInstance();
        content.setText("\nL1\r\nL2\r\n");
        content.replaceTextRange(7, 2, "");
        String newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":1:", newText.equals("\nL1\r\nL2"));
        content.setText("L1\r\n");
        content.replaceTextRange(2, 2, "test\n\n");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":2:", newText.equals("L1test\n\n"));
        content.setText("L1\n");
        content.replaceTextRange(2, 0, "test\r\r\r");
        newText = content.getTextRange(0, content.getCharCount());
        this.assertTrue(":3:", newText.equals("L1test\r\r\r\n"));
    }

    protected void setUp() {
        this.shell = new Shell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.shell.setSize(500, 300);
        this.shell.setLayout((Layout)layout);
        this.widget = new StyledText((Composite)this.shell, 2818);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.widget.setLayoutData((Object)spec);
        this.shell.open();
    }

    protected void tearDown() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.shell = null;
    }
}

