/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_CTabFolder
extends Test_org_eclipse_swt_widgets_Composite {
    protected CTabFolder ctabFolder;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.makeCleanEnvironment();
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Override
    @Test
    public void test_computeTrimIIII() {
    }

    @Override
    @Test
    public void test_getClientArea() {
    }

    @Override
    @Test
    public void test_setBackgroundLorg_eclipse_swt_graphics_Color() {
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
    }

    private void makeCleanEnvironment() {
        this.ctabFolder = new CTabFolder((Composite)this.shell, 0);
        this.setWidget((Widget)this.ctabFolder);
    }

    private void createTabFolder(List<String> events) {
        this.makeCleanEnvironment();
        int i = 0;
        while (i < 3) {
            CTabItem item = new CTabItem(this.ctabFolder, 0);
            item.setText("CTabItem &" + i);
            item.setToolTipText("CTabItem ToolTip" + i);
            Text itemText = new Text((Composite)this.ctabFolder, 2050);
            itemText.setText("\nText for CTabItem " + i + "\n\n\n");
            item.setControl((Control)itemText);
            this.hookExpectedEvents((Widget)item, this.getTestName(), events);
            this.hookExpectedEvents((Widget)itemText, this.getTestName(), events);
            ++i;
        }
        this.ctabFolder.setSelection(this.ctabFolder.getItem(0));
    }

    @Test
    public void test_consistency_KeySelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 0x1000004, 0, 0, 10, events, false);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyPrePackShell();
        this.consistencyEvent(this.ctabFolder.getSize().x / 2, 5, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_PgdwnSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.consistencyEvent(0, 262144, 0, 0x1000006, 20, events, false);
    }

    @Test
    public void test_consistency_PgupSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(2);
        this.consistencyEvent(0, 262144, 0, 0x1000005, 20, events, false);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createTabFolder(events);
        this.ctabFolder.setSelection(1);
        this.consistencyEvent(50, 5, 70, 10, 50, events);
    }

    @Test
    public void test_setHighlightEnabled() {
        Assert.assertTrue((String)"By default, highlighting should be enabled", (boolean)this.ctabFolder.getHighlightEnabled());
        this.ctabFolder.setHighlightEnabled(false);
        Assert.assertFalse((boolean)this.ctabFolder.getHighlightEnabled());
        this.ctabFolder.setHighlightEnabled(true);
        Assert.assertTrue((boolean)this.ctabFolder.getHighlightEnabled());
    }
}

