/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_Font {
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_Device$Lorg_eclipse_swt_graphics_FontData() {
        Font font;
        FontData[] data;
        boolean exceptionThrown = false;
        try {
            data = new FontData[1];
            font = new Font(null, data);
            font.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            data = null;
            font = new Font((Device)this.display, data);
            font.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            data = new FontData[]{};
            font = new Font((Device)this.display, data);
            font.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            FontData[] fontDataArray = new FontData[2];
            fontDataArray[1] = new FontData();
            data = fontDataArray;
            font = new Font((Device)this.display, data);
            font.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"null data element 0", (boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            FontData[] fontDataArray = new FontData[2];
            fontDataArray[0] = new FontData();
            data = fontDataArray;
            font = new Font((Device)this.display, data);
            font.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"null data element 1", (boolean)exceptionThrown);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_FontData() {
        Font font = new Font((Device)this.display, new FontData("", 10, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData("bad-font", 10, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 0, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 100, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 0));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 1));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 2));
        font.dispose();
        font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, 10, 3));
        font.dispose();
        try {
            font = new Font((Device)this.display, null);
            font.dispose();
            Assert.fail((String)"No exception thrown for fontData == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            font = new Font((Device)this.display, new FontData(null, 10, 0));
            font.dispose();
            Assert.fail((String)"No exception thrown for name == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            font = new Font((Device)this.display, new FontData(SwtTestUtil.testFontName, -10, 0));
            font.dispose();
            Assert.fail((String)"No exception thrown for height < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLjava_lang_StringII() {
        Font font = new Font((Device)this.display, "", 10, 0);
        font.dispose();
        font = new Font((Device)this.display, "bad-font", 10, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 0, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 100, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 1);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 2);
        font.dispose();
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 3);
        font.dispose();
        font = new Font(null, SwtTestUtil.testFontName, 10, 0);
        font.dispose();
        try {
            font = new Font((Device)this.display, null, 10, 0);
            font.dispose();
            Assert.fail((String)"No exception thrown for name == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            font = new Font((Device)this.display, SwtTestUtil.testFontName, -10, 0);
            font.dispose();
            Assert.fail((String)"No exception thrown for height < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_dispose() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Assert.assertFalse((boolean)font.isDisposed());
        font.dispose();
        Assert.assertTrue((boolean)font.isDisposed());
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Font otherFont = new Font((Device)this.display, SwtTestUtil.testFontName, 20, 0);
        try {
            Assert.assertFalse((String)"!font.equals((Object)null)", (boolean)font.equals(null));
            Assert.assertFalse((String)"!font.equals((Font)null)", (boolean)font.equals(null));
            Assert.assertTrue((String)"font.equals(font)", (boolean)font.equals((Object)font));
            Assert.assertFalse((String)"!font.equals(otherFont)", (boolean)font.equals((Object)otherFont));
        }
        finally {
            font.dispose();
            otherFont.dispose();
        }
    }

    @Test
    public void test_getFontData() {
        FontData[] fontData;
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        try {
            fontData = font.getFontData();
            Assert.assertTrue((String)"No font data", (fontData != null && fontData.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Wrong font name", (Object)SwtTestUtil.testFontName, (Object)fontData[0].getName());
            Assert.assertEquals((String)"Wrong font height", (long)10L, (long)fontData[0].getHeight());
            Assert.assertEquals((String)"Wrong font style", (long)0L, (long)fontData[0].getStyle());
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 20, 1);
        try {
            fontData = font.getFontData();
            Assert.assertTrue((String)"No font data", (fontData != null && fontData.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Wrong font name", (Object)SwtTestUtil.testFontName, (Object)fontData[0].getName());
            Assert.assertEquals((String)"Wrong font height", (long)20L, (long)fontData[0].getHeight());
            Assert.assertEquals((String)"Wrong font style", (long)1L, (long)fontData[0].getStyle());
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 30, 2);
        try {
            fontData = font.getFontData();
            Assert.assertTrue((String)"No font data", (fontData != null && fontData.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Wrong font height", (long)30L, (long)fontData[0].getHeight());
            Assert.assertEquals((String)"Wrong font style", (long)2L, (long)fontData[0].getStyle());
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, SwtTestUtil.testFontName, 40, 3);
        try {
            fontData = font.getFontData();
            font.dispose();
            Assert.assertTrue((String)"No font data", (fontData != null && fontData.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Wrong font height", (long)40L, (long)fontData[0].getHeight());
            Assert.assertEquals((String)"Wrong font style", (long)3L, (long)fontData[0].getStyle());
        }
        finally {
            font.dispose();
        }
        font = new Font((Device)this.display, "bad-font", 10, 0);
        try {
            fontData = font.getFontData();
            Assert.assertTrue((String)"No font data", (fontData != null && fontData.length > 0 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Wrong font height", (long)10L, (long)fontData[0].getHeight());
            Assert.assertEquals((String)"Wrong font style", (long)0L, (long)fontData[0].getStyle());
        }
        finally {
            font.dispose();
        }
    }

    @Test
    public void test_hashCode() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Assert.assertEquals((Object)font, (Object)font);
        Assert.assertEquals((long)font.hashCode(), (long)font.hashCode());
        Font boldFont = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 1);
        Assert.assertFalse((font.hashCode() == boldFont.hashCode() ? 1 : 0) != 0);
        boldFont.dispose();
        font.dispose();
    }

    @Test
    public void test_isDisposed() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        try {
            Assert.assertFalse((String)"Font should not be disposed", (boolean)font.isDisposed());
        }
        finally {
            font.dispose();
            Assert.assertTrue((String)"Font should be disposed", (boolean)font.isDisposed());
        }
    }

    @Test
    public void test_toString() {
        Font font = new Font((Device)this.display, SwtTestUtil.testFontName, 10, 0);
        Assert.assertNotNull((Object)font.toString());
        font.dispose();
        Assert.assertNotNull((Object)font.toString());
    }
}

