/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_TextLayout {
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_getLevel() {
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "abc55\u05e9\u05e066";
        layout.setText(text);
        Assert.assertEquals((long)0L, (long)layout.getLevel(0));
        Assert.assertEquals((long)0L, (long)layout.getLevel(2));
        Assert.assertEquals((long)1L, (long)layout.getLevel(5));
        Assert.assertEquals((long)1L, (long)layout.getLevel(6));
        Assert.assertEquals((long)2L, (long)layout.getLevel(7));
        Assert.assertEquals((long)0L, (long)layout.getLevel(9));
        try {
            layout.getLevel(-1);
            Assert.fail((String)"invalid range expection expected");
        }
        catch (Exception exception) {}
        try {
            layout.getLevel(text.length() + 1);
            Assert.fail((String)"invalid range expection expected");
        }
        catch (Exception exception) {}
        layout.dispose();
    }

    @Test
    public void test_getSegments() {
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setText("AB");
        String[] messages = new String[]{"no segments", "segments", "segments (duplicate at 0)", "segments (duplicate at 1)", "segments (duplicate at 2)"};
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 1;
        nArray2[3] = 2;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 2;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 2;
        nArrayArray[4] = nArray4;
        int[][] segments = nArrayArray;
        int i = 0;
        while (i < segments.length) {
            String m = messages[i];
            layout.setSegments(segments[i]);
            Assert.assertEquals((String)m, (long)1L, (long)layout.getNextOffset(0, 2));
            Assert.assertEquals((String)m, (long)2L, (long)layout.getNextOffset(1, 2));
            Assert.assertEquals((String)m, (long)2L, (long)layout.getNextOffset(2, 2));
            Assert.assertEquals((String)m, (long)1L, (long)layout.getPreviousOffset(2, 2));
            Assert.assertEquals((String)m, (long)0L, (long)layout.getPreviousOffset(1, 2));
            Assert.assertEquals((String)m, (long)0L, (long)layout.getPreviousOffset(0, 2));
            ++i;
        }
        layout.setText("Line");
        layout.setAscent(20);
        layout.setDescent(6);
        int[] nArray5 = new int[2];
        nArray5[1] = layout.getText().length();
        layout.setSegments(nArray5);
        layout.getBounds();
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("word word word");
        int[] nArray6 = new int[3];
        nArray6[1] = 5;
        nArray6[2] = 10;
        layout.setSegments(nArray6);
        int offset = 0;
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)5L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)10L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)14L, (long)offset);
        layout.setWidth(layout.getBounds().width / 2);
        layout.setAscent(20);
        layout.setDescent(6);
        offset = 0;
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)5L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)10L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)14L, (long)offset);
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("\nAB");
        int[] nArray7 = new int[3];
        nArray7[1] = 1;
        nArray7[2] = 3;
        layout.setSegments(nArray7);
        int[] nArray8 = new int[3];
        nArray8[1] = 1;
        nArray8[2] = 3;
        int[] expected = nArray8;
        int[] offsets = layout.getLineOffsets();
        int i2 = 0;
        while (i2 < offsets.length) {
            Assert.assertEquals((String)(" i = " + i2), (long)expected[i2], (long)offsets[i2]);
            ++i2;
        }
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("MNMNMN");
        int[] nArray9 = new int[3];
        nArray9[1] = 1;
        nArray9[2] = 6;
        layout.setSegments(nArray9);
        layout.getBounds();
        Assert.assertEquals((long)(layout.getText().length() - 1), (long)layout.getOffset(layout.getBounds().width, 0, null));
        layout.setAscent(9);
        Assert.assertEquals((long)(layout.getText().length() - 1), (long)layout.getOffset(layout.getBounds().width, 0, null));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("Abcdef\nGhij\nKl");
        Rectangle bounds1 = layout.getBounds(0, 5);
        int[] trailing = new int[1];
        offset = layout.getOffset(bounds1.width, bounds1.height + 2, trailing);
        Assert.assertEquals((long)10L, (long)offset);
        Assert.assertEquals((long)1L, (long)trailing[0]);
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("AbcdefGhijKl");
        layout.setSegments(new int[]{6, 10});
        layout.setSegmentsChars(new char[]{'\n', '\n'});
        bounds1 = layout.getBounds(0, 5);
        trailing = new int[1];
        offset = layout.getOffset(bounds1.width, bounds1.height + 2, trailing);
        Assert.assertEquals((long)9L, (long)offset);
        Assert.assertEquals((long)1L, (long)trailing[0]);
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        boolean doit = false;
        if (doit) {
            int length = layout.getText().length();
            layout.setSegments(new int[]{length});
            trailing = new int[1];
            int width = layout.getBounds().width + 20;
            Assert.assertEquals((String)"hit test to the left", (long)0L, (long)layout.getOffset(0, 0, trailing));
            Assert.assertEquals((String)"hit test to the left (trailing)", (long)0L, (long)trailing[0]);
            Assert.assertEquals((String)"hit test to the right", (long)(length - 1), (long)layout.getOffset(width, 0, trailing));
            Assert.assertEquals((String)"hit test to the right (trailing)", (long)1L, (long)trailing[0]);
            layout.setSegmentsChars(new char[]{'*'});
            Assert.assertEquals((String)"hit test to the left", (long)0L, (long)layout.getOffset(0, 0, trailing));
            Assert.assertEquals((String)"hit test to the left (trailing)", (long)0L, (long)trailing[0]);
            Assert.assertEquals((String)"hit test to the right", (long)(length - 1), (long)layout.getOffset(width, 0, trailing));
            Assert.assertEquals((String)"hit test to the right (trailing)", (long)1L, (long)trailing[0]);
        }
        layout.dispose();
    }

    @Test
    public void test_getSegmentsChars() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getSegmentsChars(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout).");
            }
            return;
        }
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "ab\u05d0\u05d1.\u05d2cd";
        int textLength = text.length();
        layout.setText(text);
        String[] messages = new String[]{"no segments", "Embedding RTL dir test", "Embedding LTR dir test", "LRO test", "RLO test", "Traditional segments", "Traditional segments invalid"};
        int[][] nArrayArray = new int[7][];
        int[] nArray = new int[8];
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 8;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[8];
        nArray2[2] = 4;
        nArray2[3] = 4;
        nArray2[4] = 5;
        nArray2[5] = 5;
        nArray2[6] = 8;
        nArray2[7] = 8;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = textLength;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = textLength;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[1] = 4;
        nArray5[2] = 8;
        nArrayArray[5] = nArray5;
        nArrayArray[6] = new int[]{1};
        int[][] segments = nArrayArray;
        char[][] cArrayArray = new char[7][];
        cArrayArray[1] = new char[]{'\u202a', '\u202b', '\u202c', '\u200e', '\u200e', '\u202b', '\u202c', '\u202c'};
        cArrayArray[2] = new char[]{'\u202b', '\u202a', '\u202c', '\u200f', '\u200f', '\u202a', '\u202c', '\u202c'};
        cArrayArray[3] = new char[]{'\u202d', '\u202c'};
        cArrayArray[4] = new char[]{'\u202e', '\u202c'};
        char[][] chars = cArrayArray;
        int[][] nArrayArray2 = new int[7][];
        int[] nArray6 = new int[8];
        nArray6[2] = 1;
        nArray6[3] = 1;
        nArray6[4] = 1;
        nArray6[5] = 1;
        nArrayArray2[0] = nArray6;
        nArrayArray2[1] = new int[]{4, 4, 3, 3, 2, 3, 4, 4};
        nArrayArray2[2] = new int[]{2, 2, 3, 3, 1, 3, 2, 2};
        nArrayArray2[3] = new int[]{2, 2, 2, 2, 2, 2, 2, 2};
        nArrayArray2[4] = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray7 = new int[8];
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[5] = 1;
        nArrayArray2[5] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 1;
        nArray8[5] = 1;
        nArrayArray2[6] = nArray8;
        int[][] levels = nArrayArray2;
        int[] nArray9 = new int[2];
        nArray9[1] = textLength;
        int[] offsets = nArray9;
        int i = 0;
        while (i < segments.length) {
            layout.setSegments(segments[i]);
            layout.setSegmentsChars(chars[i]);
            Assert.assertArrayEquals((String)("Test line offsets: group: " + i), (int[])offsets, (int[])layout.getLineOffsets());
            int j = 0;
            while (j < textLength) {
                Assert.assertEquals((String)(String.valueOf(messages[i]) + ": group: " + i + ", index: " + j), (long)levels[i][j], (long)layout.getLevel(j));
                ++j;
            }
            ++i;
        }
        layout.dispose();
    }

    @Test
    public void test_getLineOffsets() {
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "0123456\n890123\n";
        layout.setText(text);
        int[] offsets = layout.getLineOffsets();
        int[] nArray = new int[4];
        nArray[1] = 8;
        nArray[2] = 15;
        nArray[3] = 15;
        int[] expected = nArray;
        int i = 0;
        while (i < offsets.length) {
            Assert.assertEquals((long)expected[i], (long)offsets[i]);
            ++i;
        }
        layout.setText("");
        offsets = layout.getLineOffsets();
        expected = new int[2];
        i = 0;
        while (i < offsets.length) {
            Assert.assertEquals((long)expected[i], (long)offsets[i]);
            ++i;
        }
        layout.setText("\n");
        offsets = layout.getLineOffsets();
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 1;
        expected = nArray2;
        i = 0;
        while (i < offsets.length) {
            Assert.assertEquals((long)expected[i], (long)offsets[i]);
            ++i;
        }
        layout.setText("WMWM");
        int width = layout.getBounds().width;
        layout.setWidth(width / 4 + 1);
        offsets = layout.getLineOffsets();
        int[] nArray3 = new int[5];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArray3[4] = 4;
        expected = nArray3;
        int i2 = 0;
        while (i2 < offsets.length) {
            Assert.assertEquals((long)expected[i2], (long)offsets[i2]);
            ++i2;
        }
        layout.setWidth(width / 2 + 1);
        offsets = layout.getLineOffsets();
        int[] nArray4 = new int[3];
        nArray4[1] = 2;
        nArray4[2] = 4;
        expected = nArray4;
        i2 = 0;
        while (i2 < offsets.length) {
            Assert.assertEquals((long)expected[i2], (long)offsets[i2]);
            ++i2;
        }
        layout.dispose();
    }

    @Test
    public void test_getLineIndex() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getLineIndex(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout).");
            }
            return;
        }
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "0123456\n890123\n";
        layout.setText(text);
        Assert.assertEquals((long)0L, (long)layout.getLineIndex(0));
        Assert.assertEquals((long)0L, (long)layout.getLineIndex(5));
        Assert.assertEquals((long)0L, (long)layout.getLineIndex(7));
        Assert.assertEquals((long)1L, (long)layout.getLineIndex(8));
        Assert.assertEquals((long)1L, (long)layout.getLineIndex(12));
        Assert.assertEquals((long)1L, (long)layout.getLineIndex(14));
        Assert.assertEquals((long)2L, (long)layout.getLineIndex(15));
        try {
            layout.getLineIndex(-1);
            Assert.fail((String)"invalid range expection expected");
        }
        catch (Exception exception) {}
        try {
            layout.getLineIndex(text.length() + 1);
            Assert.fail((String)"invalid range expection expected");
        }
        catch (Exception exception) {}
        layout.dispose();
    }

    @Test
    public void test_getLineBounds() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getLineBonds(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout).");
            }
            return;
        }
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "0123456\n890123\n";
        layout.setText(text);
        Rectangle rect0 = layout.getLineBounds(0);
        Rectangle rect1 = layout.getLineBounds(1);
        Rectangle rect2 = layout.getLineBounds(2);
        Assert.assertTrue((rect0.width > rect1.width ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)rect2.width);
        Assert.assertEquals((long)0L, (long)rect0.x);
        Assert.assertEquals((long)0L, (long)rect1.x);
        Assert.assertEquals((long)0L, (long)rect2.x);
        Rectangle bounds = layout.getBounds();
        Assert.assertEquals((long)bounds.width, (long)rect0.width);
        layout.setWidth(bounds.width);
        layout.setAlignment(0x1000000);
        Assert.assertEquals((Object)bounds, (Object)layout.getBounds());
        layout.setWidth(bounds.width + 100);
        Rectangle newRect1 = layout.getLineBounds(0);
        Assert.assertEquals((long)50L, (long)newRect1.x);
        layout.setAlignment(131072);
        newRect1 = layout.getLineBounds(0);
        Assert.assertEquals((long)100L, (long)newRect1.x);
        Assert.assertEquals((long)bounds.height, (long)(rect0.height + rect1.height + rect2.height));
        try {
            layout.getLineBounds(-1);
            Assert.fail((String)"invalid range expection expected");
        }
        catch (Exception exception) {}
        try {
            layout.getLineBounds(3);
            Assert.fail((String)"invalid range expection expected");
        }
        catch (Exception exception) {}
        layout.dispose();
    }

    @Test
    public void test_setStyle() {
        TextStyle s1 = new TextStyle(null, null, null);
        TextStyle s2 = new TextStyle(null, null, null);
        TextStyle s3 = new TextStyle(null, null, null);
        TextStyle s4 = new TextStyle(null, null, null);
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 2, 3);
        Assert.assertEquals(null, (Object)layout.getStyle(0));
        Assert.assertEquals(null, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(3));
        Assert.assertEquals(null, (Object)layout.getStyle(4));
        Assert.assertEquals(null, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 1);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(s3, 4, 5);
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 1);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(s3, 4, 5);
        layout.setStyle(s4, 1, 2);
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 1);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(s3, 4, 5);
        layout.setStyle(s4, 3, 4);
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 1);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(s3, 4, 5);
        layout.setStyle(s4, 1, 4);
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 0);
        layout.setStyle(s2, 1, 4);
        layout.setStyle(s3, 5, 5);
        layout.setStyle(s4, 2, 3);
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 1);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(s3, 4, 5);
        layout.setStyle(s4, 0, 3);
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 0);
        layout.setStyle(s2, 1, 4);
        layout.setStyle(s3, 5, 5);
        layout.setStyle(s4, 2, 4);
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 0);
        layout.setStyle(s2, 1, 4);
        layout.setStyle(s3, 5, 5);
        layout.setStyle(s4, 1, 3);
        Assert.assertEquals((Object)s1, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s3, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 1);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(s3, 4, 5);
        layout.setStyle(null, 0, 5);
        Assert.assertEquals(null, (Object)layout.getStyle(0));
        Assert.assertEquals(null, (Object)layout.getStyle(1));
        Assert.assertEquals(null, (Object)layout.getStyle(2));
        Assert.assertEquals(null, (Object)layout.getStyle(3));
        Assert.assertEquals(null, (Object)layout.getStyle(4));
        Assert.assertEquals(null, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 0, 1);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(s3, 4, 5);
        layout.setStyle(s4, 0, 5);
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(0));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(2));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(3));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(4));
        Assert.assertEquals((Object)s4, (Object)layout.getStyle(5));
        layout.dispose();
        layout = new TextLayout((Device)this.display);
        layout.setText("aabbcc");
        layout.setStyle(s1, 2, 2);
        layout.setStyle(s2, 2, 3);
        layout.setStyle(null, 3, 3);
        Assert.assertEquals(null, (Object)layout.getStyle(0));
        Assert.assertEquals(null, (Object)layout.getStyle(1));
        Assert.assertEquals((Object)s2, (Object)layout.getStyle(2));
        Assert.assertEquals(null, (Object)layout.getStyle(3));
        Assert.assertEquals(null, (Object)layout.getStyle(4));
        Assert.assertEquals(null, (Object)layout.getStyle(5));
        layout.dispose();
    }

    @Test
    public void test_getAlignment() {
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setAlignment(16384);
        Assert.assertEquals((long)16384L, (long)layout.getAlignment());
        layout.setAlignment(0x1000000);
        Assert.assertEquals((long)0x1000000L, (long)layout.getAlignment());
        layout.setAlignment(131072);
        Assert.assertEquals((long)131072L, (long)layout.getAlignment());
        layout.setAlignment(8);
        Assert.assertEquals((long)131072L, (long)layout.getAlignment());
        layout.setAlignment(0x1000008);
        Assert.assertEquals((long)0x1000000L, (long)layout.getAlignment());
        layout.setAlignment(16924672);
        Assert.assertEquals((long)16384L, (long)layout.getAlignment());
        layout.dispose();
    }

    @Test
    public void test_getOrientation() {
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setOrientation(0x2000000);
        Assert.assertEquals((long)0x2000000L, (long)layout.getOrientation());
        layout.setOrientation(0x4000000);
        Assert.assertEquals((long)0x4000000L, (long)layout.getOrientation());
        layout.setOrientation(8);
        Assert.assertEquals((long)0x4000000L, (long)layout.getOrientation());
        layout.setOrientation(0x2000008);
        Assert.assertEquals((long)0x2000000L, (long)layout.getOrientation());
        layout.setOrientation(0x6000000);
        Assert.assertEquals((long)0x2000000L, (long)layout.getOrientation());
        layout.dispose();
    }

    @Test
    public void test_getText() {
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "Test";
        layout.setText(text);
        Assert.assertEquals((Object)text, (Object)layout.getText());
        layout.dispose();
    }

    @Test
    public void test_getLocation() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getLocation(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout).");
            }
            return;
        }
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "AB\u05e9\u05e0";
        layout.setText(text);
        Assert.assertEquals((long)0L, (long)layout.getLocation((int)0, (boolean)false).x);
        Assert.assertEquals((long)layout.getLocation((int)0, (boolean)true).x, (long)layout.getLocation((int)1, (boolean)false).x);
        Assert.assertEquals((long)layout.getLocation((int)2, (boolean)false).x, (long)layout.getLineBounds((int)0).width);
        Assert.assertEquals((long)layout.getLocation((int)2, (boolean)true).x, (long)layout.getLocation((int)3, (boolean)false).x);
        Assert.assertEquals((long)layout.getLocation((int)3, (boolean)true).x, (long)layout.getLocation((int)1, (boolean)true).x);
        Assert.assertEquals((long)layout.getLocation((int)4, (boolean)false).x, (long)layout.getLineBounds((int)0).width);
        Assert.assertEquals((long)layout.getLocation((int)4, (boolean)true).x, (long)layout.getLineBounds((int)0).width);
        layout.dispose();
    }

    @Test
    public void test_getNextOffset() {
        if (SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getNextOffset(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout).");
            }
            return;
        }
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "word word word";
        layout.setText(text);
        int offset = 0;
        offset = layout.getNextOffset(offset, 8);
        Assert.assertEquals((long)4L, (long)offset);
        offset = layout.getNextOffset(offset, 8);
        Assert.assertEquals((long)9L, (long)offset);
        offset = layout.getNextOffset(offset, 8);
        Assert.assertEquals((long)14L, (long)offset);
        offset = layout.getPreviousOffset(offset, 8);
        Assert.assertEquals((long)9L, (long)offset);
        offset = layout.getPreviousOffset(offset, 8);
        Assert.assertEquals((long)4L, (long)offset);
        offset = layout.getPreviousOffset(offset, 8);
        Assert.assertEquals((long)0L, (long)offset);
        Assert.assertEquals((long)4L, (long)layout.getNextOffset(2, 8));
        Assert.assertEquals((long)4L, (long)layout.getNextOffset(3, 8));
        Assert.assertEquals((long)9L, (long)layout.getNextOffset(8, 8));
        Assert.assertEquals((long)14L, (long)layout.getNextOffset(10, 8));
        Assert.assertEquals((long)14L, (long)layout.getNextOffset(13, 8));
        Assert.assertEquals((long)14L, (long)layout.getNextOffset(14, 8));
        Assert.assertEquals((long)0L, (long)layout.getPreviousOffset(0, 8));
        Assert.assertEquals((long)0L, (long)layout.getPreviousOffset(4, 8));
        Assert.assertEquals((long)4L, (long)layout.getPreviousOffset(5, 8));
        Assert.assertEquals((long)9L, (long)layout.getPreviousOffset(10, 8));
        Assert.assertEquals((long)9L, (long)layout.getPreviousOffset(11, 8));
        offset = 0;
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)5L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)10L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)14L, (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)10L, (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)5L, (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)0L, (long)offset);
        Assert.assertEquals((long)5L, (long)layout.getNextOffset(2, 16));
        Assert.assertEquals((long)5L, (long)layout.getNextOffset(4, 16));
        Assert.assertEquals((long)10L, (long)layout.getNextOffset(9, 16));
        Assert.assertEquals((long)14L, (long)layout.getNextOffset(10, 16));
        Assert.assertEquals((long)14L, (long)layout.getNextOffset(13, 16));
        Assert.assertEquals((long)14L, (long)layout.getNextOffset(14, 16));
        Assert.assertEquals((long)0L, (long)layout.getPreviousOffset(0, 16));
        Assert.assertEquals((long)0L, (long)layout.getPreviousOffset(3, 16));
        Assert.assertEquals((long)0L, (long)layout.getPreviousOffset(4, 16));
        Assert.assertEquals((long)0L, (long)layout.getPreviousOffset(5, 16));
        Assert.assertEquals((long)5L, (long)layout.getPreviousOffset(6, 16));
        text = "AB \u05e9\u05e0 CD\nHello";
        layout.setText(text);
        offset = 0;
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)3L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)6L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)8L, (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)6L, (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)3L, (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)0L, (long)offset);
        offset = 7;
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)8L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)9L, (long)offset);
        offset = layout.getNextOffset(offset, 16);
        Assert.assertEquals((long)text.length(), (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)9L, (long)offset);
        offset = layout.getPreviousOffset(offset, 16);
        Assert.assertEquals((long)8L, (long)offset);
        offset = layout.getNextOffset(offset, 2);
        Assert.assertEquals((long)9L, (long)offset);
        offset = layout.getNextOffset(offset, 2);
        Assert.assertEquals((long)10L, (long)offset);
        offset = layout.getPreviousOffset(offset, 2);
        Assert.assertEquals((long)9L, (long)offset);
        offset = layout.getPreviousOffset(offset, 2);
        Assert.assertEquals((long)8L, (long)offset);
        offset = layout.getPreviousOffset(offset, 2);
        Assert.assertEquals((long)7L, (long)offset);
        int i = 0;
        while (i < text.length()) {
            Assert.assertEquals((long)(i + 1), (long)layout.getNextOffset(i, 2));
            ++i;
        }
        i = text.length();
        while (i > 0) {
            Assert.assertEquals((long)(i - 1), (long)layout.getPreviousOffset(i, 2));
            --i;
        }
        layout.dispose();
    }

    @Test
    public void test_getNextOffset2() {
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getNextOffset2(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout)");
            }
            return;
        }
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setText("A\u0e19\u0e49\u0e33B");
        String[] messages = new String[]{"no segments", "segments", "segments (duplicate at 0)", "segments (duplicate at 1)", "segments (duplicate at 2)", "segments (duplicate at 3)", "segments (duplicate at 4)", "segments (duplicate at 5)"};
        int[][] segments = new int[1][];
        int i = 0;
        while (i < segments.length) {
            String m = messages[i];
            layout.setSegments(segments[i]);
            Assert.assertEquals((String)m, (long)1L, (long)layout.getNextOffset(0, 2));
            Assert.assertEquals((String)m, (long)4L, (long)layout.getNextOffset(1, 2));
            Assert.assertEquals((String)m, (long)5L, (long)layout.getNextOffset(4, 2));
            Assert.assertEquals((String)m, (long)4L, (long)layout.getPreviousOffset(5, 2));
            Assert.assertEquals((String)m, (long)1L, (long)layout.getPreviousOffset(4, 2));
            Assert.assertEquals((String)m, (long)0L, (long)layout.getPreviousOffset(1, 2));
            ++i;
        }
        layout.dispose();
    }

    @Test
    public void test_getLineSpacing() {
        TextLayout layout = new TextLayout((Device)this.display);
        layout.setSpacing(10);
        Assert.assertEquals((long)10L, (long)layout.getSpacing());
        layout.setSpacing(Short.MAX_VALUE);
        Assert.assertEquals((long)32767L, (long)layout.getSpacing());
        layout.setSpacing(50);
        Assert.assertEquals((long)50L, (long)layout.getSpacing());
        try {
            layout.setSpacing(-1);
            Assert.fail((String)"invalid range expection expected");
        }
        catch (Exception exception) {}
        Assert.assertEquals((long)50L, (long)layout.getSpacing());
        layout.setSpacing(0);
        Assert.assertEquals((long)0L, (long)layout.getSpacing());
        layout.dispose();
    }

    @Test
    public void test_getOffset() {
        boolean isCocoa = SwtTestUtil.isCocoa;
        if (isCocoa && SwtTestUtil.verbose) {
            System.out.println("Partially excluded test_getOffset(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout).");
        }
        TextLayout layout = new TextLayout((Device)this.display);
        String text = "AB \u05e9\u05e0 CD\nHello";
        layout.setText(text);
        int[] trailing = new int[1];
        Assert.assertEquals((long)0L, (long)layout.getOffset(0, 0, trailing));
        Assert.assertEquals((long)0L, (long)trailing[0]);
        Point point = layout.getLocation(0, true);
        Assert.assertEquals((long)1L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)0L, (long)trailing[0]);
        point = layout.getLocation(1, false);
        Assert.assertEquals((long)0L, (long)layout.getOffset(point.x - 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(2, true);
        Assert.assertEquals((long)4L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(4, true);
        Assert.assertEquals((long)2L, (long)layout.getOffset(point.x - 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(4, false);
        Assert.assertEquals((long)3L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        Rectangle bounds = layout.getBounds();
        layout.setWidth(bounds.width + 100);
        layout.setAlignment(0x1000000);
        Assert.assertEquals((long)0L, (long)layout.getOffset(0, 0, trailing));
        Assert.assertEquals((long)0L, (long)trailing[0]);
        point = layout.getLocation(0, true);
        Assert.assertEquals((long)1L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)0L, (long)trailing[0]);
        point = layout.getLocation(1, false);
        Assert.assertEquals((long)0L, (long)layout.getOffset(point.x - 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(2, true);
        Assert.assertEquals((long)4L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(4, true);
        Assert.assertEquals((long)2L, (long)layout.getOffset(point.x - 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(4, false);
        Assert.assertEquals((long)3L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        layout.setAlignment(131072);
        Assert.assertEquals((long)0L, (long)layout.getOffset(0, 0, trailing));
        Assert.assertEquals((long)0L, (long)trailing[0]);
        point = layout.getLocation(0, true);
        Assert.assertEquals((long)1L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)0L, (long)trailing[0]);
        point = layout.getLocation(1, false);
        Assert.assertEquals((long)0L, (long)layout.getOffset(point.x - 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(2, true);
        Assert.assertEquals((long)4L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        point = layout.getLocation(4, true);
        Assert.assertEquals((long)2L, (long)layout.getOffset(point.x - 1, 0, trailing));
        if (!isCocoa) {
            Assert.assertEquals((long)1L, (long)trailing[0]);
        }
        point = layout.getLocation(4, false);
        Assert.assertEquals((long)3L, (long)layout.getOffset(point.x + 1, 0, trailing));
        Assert.assertEquals((long)1L, (long)trailing[0]);
        text = "Text";
        layout.setText(text);
        int width = layout.getBounds().width;
        layout.setAlignment(16384);
        Assert.assertEquals((long)0L, (long)layout.getOffset(1, 0, null));
        Assert.assertEquals((long)(text.length() - 1), (long)layout.getOffset(width - 1, 0, null));
        layout.setWidth(width + 100);
        layout.setAlignment(0x1000000);
        Assert.assertEquals((long)0L, (long)layout.getOffset(51, 0, null));
        Assert.assertEquals((long)(text.length() - 1), (long)layout.getOffset(width - 1 + 50, 0, null));
        layout.setAlignment(131072);
        Assert.assertEquals((long)0L, (long)layout.getOffset(101, 0, null));
        Assert.assertEquals((long)(text.length() - 1), (long)layout.getOffset(width - 1 + 100, 0, null));
        layout.dispose();
    }

    @Test
    public void test_getTabs() {
        TextLayout layout = new TextLayout((Device)this.display);
        Assert.assertEquals(null, (Object)layout.getTabs());
        int[] tabs = new int[]{8, 18, 28, 38, 50, 80};
        layout.setTabs(tabs);
        int[] result = layout.getTabs();
        Assert.assertEquals((long)tabs.length, (long)result.length);
        int i = 0;
        while (i < result.length) {
            Assert.assertEquals((String)("pos: " + i), (long)tabs[i], (long)result[i]);
            ++i;
        }
        layout.setTabs(null);
        Assert.assertEquals(null, (Object)layout.getTabs());
        layout.dispose();
    }

    @Test
    public void test_getTextDirection() {
        if (!SwtTestUtil.isWindows) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getTextDirection(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_graphics_TextLayout).");
            }
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = 0x2000000;
        nArray[1] = 0x4000000;
        nArray[3] = -1;
        int[] styles = nArray;
        int n = styles.length;
        int prevDirection = 0;
        TextLayout layout = new TextLayout((Device)this.display);
        int i = 0;
        while (i < n) {
            int orientation = styles[i];
            if (orientation != -1) {
                layout.setOrientation(orientation);
                if (orientation != 0) {
                    prevDirection = orientation;
                }
            }
            int j = n - 1;
            while (j >= 0) {
                int direction = styles[j];
                if (direction != -1) {
                    layout.setTextDirection(direction);
                }
                if (direction == 0 || direction == -1) {
                    Assert.assertEquals((String)("orientation: " + orientation + ", text direction: " + direction), (long)layout.getTextDirection(), (long)prevDirection);
                } else {
                    prevDirection = direction;
                    Assert.assertEquals((String)("orientation: " + orientation + ", text direction: " + direction), (long)layout.getTextDirection(), (long)direction);
                }
                --j;
            }
            ++i;
        }
        layout.dispose();
    }
}

