/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Control;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Button
extends Test_org_eclipse_swt_widgets_Control {
    Button button;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.button = new Button((Composite)this.shell, 8);
        this.setWidget((Widget)this.button);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        new Button((Composite)this.shell, 0);
        new Button((Composite)this.shell, 8);
        new Button((Composite)this.shell, 32);
        new Button((Composite)this.shell, 2);
        new Button((Composite)this.shell, 4);
        new Button((Composite)this.shell, 40);
        try {
            new Button(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Test_org_eclipse_swt_widgets_Button.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        try {
            this.button.addSelectionListener(null);
            Assert.fail((String)"No exception thrown for addSelectionListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.button.addSelectionListener(listener);
        this.button.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        try {
            this.button.removeSelectionListener(null);
            Assert.fail((String)"No exception thrown for removeSelectionListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.listenerCalled = false;
        this.button.removeSelectionListener(listener);
        this.button.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.button.addSelectionListener(listener);
        this.button.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.button.removeSelectionListener(listener);
        this.button.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
        this.button.computeSize(0, 0);
        this.button.computeSize(0, 0, false);
        this.button.computeSize(-10, -10);
        this.button.computeSize(-10, -10, false);
        this.button.computeSize(10, 10);
        this.button.computeSize(10, 10, false);
        this.button.computeSize(10000, 10000);
        this.button.computeSize(10000, 10000, false);
    }

    @Test
    public void test_setAlignmentI() {
        this.button.setAlignment(16384);
        Assert.assertEquals((long)16384L, (long)this.button.getAlignment());
        this.button.setAlignment(131072);
        Assert.assertEquals((long)131072L, (long)this.button.getAlignment());
        this.button.setAlignment(0x1000000);
        Assert.assertEquals((long)0x1000000L, (long)this.button.getAlignment());
        this.button.setAlignment(128);
        Assert.assertTrue((128 != this.button.getAlignment() ? 1 : 0) != 0);
        Button arrowButton = new Button((Composite)this.shell, 4);
        arrowButton.setAlignment(16384);
        Assert.assertEquals((long)16384L, (long)arrowButton.getAlignment());
        arrowButton.setAlignment(131072);
        Assert.assertEquals((long)131072L, (long)arrowButton.getAlignment());
        arrowButton.setAlignment(128);
        Assert.assertEquals((long)128L, (long)arrowButton.getAlignment());
        arrowButton.setAlignment(1024);
        Assert.assertEquals((long)1024L, (long)arrowButton.getAlignment());
        arrowButton.setAlignment(0x1000000);
        Assert.assertTrue((0x1000000 != arrowButton.getAlignment() ? 1 : 0) != 0);
        arrowButton.dispose();
        int alignment = 55;
        this.button.setAlignment(alignment);
        Assert.assertTrue((alignment != this.button.getAlignment() ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_setFocus() {
        Button btn = new Button((Composite)this.shell, 4);
        btn.setFocus();
    }

    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
        Image image = this.button.getImage();
        this.button.setImage(image);
        Assert.assertEquals((Object)image, (Object)this.button.getImage());
        this.button.setImage(null);
        Assert.assertNull((Object)this.button.getImage());
        image = new Image((Device)this.shell.getDisplay(), 10, 10);
        this.button.setImage(image);
        Assert.assertEquals((Object)image, (Object)this.button.getImage());
        this.button.setImage(null);
        image.dispose();
        try {
            this.button.setImage(image);
            this.button.setImage(null);
            Assert.fail((String)"No exception thrown for disposed image");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setSelectionZ() {
        this.button = new Button((Composite)this.shell, 32);
        this.button.setSelection(true);
        Assert.assertTrue((boolean)this.button.getSelection());
        this.button.setSelection(false);
        Assert.assertTrue((!this.button.getSelection() ? 1 : 0) != 0);
        Button newButton = new Button((Composite)this.shell, 4);
        newButton.setSelection(true);
        Assert.assertTrue((!newButton.getSelection() ? 1 : 0) != 0);
        newButton.setSelection(false);
        Assert.assertTrue((!newButton.getSelection() ? 1 : 0) != 0);
        newButton.dispose();
        newButton = new Button((Composite)this.shell, 8);
        newButton.setSelection(true);
        Assert.assertTrue((!newButton.getSelection() ? 1 : 0) != 0);
        newButton.setSelection(false);
        Assert.assertTrue((!newButton.getSelection() ? 1 : 0) != 0);
        newButton.dispose();
        newButton = new Button((Composite)this.shell, 16);
        newButton.setSelection(true);
        Assert.assertTrue((boolean)newButton.getSelection());
        newButton.setSelection(false);
        Assert.assertTrue((!newButton.getSelection() ? 1 : 0) != 0);
        newButton.dispose();
        newButton = new Button((Composite)this.shell, 2);
        newButton.setSelection(true);
        Assert.assertTrue((boolean)newButton.getSelection());
        newButton.setSelection(false);
        Assert.assertTrue((!newButton.getSelection() ? 1 : 0) != 0);
        newButton.dispose();
    }

    @Test
    public void test_setTextLjava_lang_String() {
        String[] cases = new String[]{"", "some text", "ldkashdoehufweovcnhslvhregojebckreavbkuhxbiufvcyhbifuyewvbiureyd.,cmnesljliewjfchvbwoifivbeworixuieurvbiuvbohflksjeahfcliureafgyciabelitvyrwtlicuyrtliureybcliuyreuceyvbliureybct", "\n \n \b \t ", "\u0000"};
        int goodCases = 4;
        int i = 0;
        while (i < goodCases) {
            this.button.setText(cases[i]);
            Assert.assertTrue((String)("good case: " + String.valueOf(i)), (boolean)this.button.getText().equals(cases[i]));
            ++i;
        }
        try {
            this.button.setText(null);
            Assert.fail((String)"No exception thrown for text == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.button.setText("");
    }

    protected void setUp(int style) {
        super.setUp();
        this.button = new Button((Composite)this.shell, style);
        this.setWidget((Widget)this.button);
    }

    @Test
    public void test_consistency_MenuDetect() {
        this.consistencyEvent(10, 10, 3, 0, 30);
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(5, 5, 3, 0, 30);
        this.tearDown();
        this.setUp(16);
        this.consistencyEvent(5, 5, 3, 0, 30);
        this.tearDown();
        this.setUp(2);
        this.consistencyEvent(5, 5, 3, 0, 30);
        this.tearDown();
        this.setUp(4);
        this.consistencyEvent(5, 5, 3, 0, 30);
    }

    @Test
    public void test_consistency_MouseSelection() {
        this.consistencyEvent(10, 10, 1, 0, 30);
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(5, 5, 1, 0, 30);
        this.tearDown();
        this.setUp(16);
        this.button.setSelection(true);
        this.consistencyEvent(5, 5, 1, 0, 30);
        this.tearDown();
        this.setUp(2);
        this.consistencyEvent(5, 5, 1, 0, 30);
        this.tearDown();
        this.setUp(4);
        this.consistencyEvent(5, 5, 1, 0, 30);
    }

    @Test
    public void test_consistency_EnterSelection() {
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(10, 13, 0, 0, 10);
        this.tearDown();
        this.setUp(16);
        this.consistencyEvent(10, 13, 0, 0, 10);
        this.tearDown();
        this.setUp(2);
        this.consistencyEvent(10, 13, 0, 0, 10);
        this.tearDown();
        this.setUp(4);
        this.consistencyEvent(10, 13, 0, 0, 10);
    }

    @Test
    public void test_consistency_SpaceSelection() {
        this.consistencyEvent(32, 32, 0, 0, 10);
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(32, 32, 0, 0, 10);
        this.tearDown();
        this.setUp(16);
        this.button.setSelection(true);
        this.consistencyEvent(32, 32, 0, 0, 10);
        this.tearDown();
        this.setUp(2);
        this.consistencyEvent(32, 32, 0, 0, 10);
        this.tearDown();
        this.setUp(4);
        this.consistencyEvent(32, 32, 0, 0, 10);
    }

    @Test
    public void test_consistency_DragDetect() {
        this.consistencyEvent(10, 10, 20, 20, 50);
        this.tearDown();
        this.setUp(32);
        this.consistencyEvent(5, 5, 15, 15, 50);
        this.tearDown();
        this.setUp(16);
        this.consistencyEvent(5, 5, 15, 15, 50);
        this.tearDown();
        this.setUp(2);
        this.consistencyEvent(5, 5, 15, 15, 50);
        this.tearDown();
        this.setUp(4);
        this.consistencyEvent(5, 5, 15, 15, 50);
    }
}

