/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_ExpandBar
extends Test_org_eclipse_swt_widgets_Composite {
    protected ExpandBar expandBar;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.expandBar = new ExpandBar((Composite)this.shell, 0);
        this.setWidget((Widget)this.expandBar);
    }

    @Test
    public void test_addExpandListenerLorg_eclipse_swt_events_ExpandListener() {
        final boolean[] listenerCalled = new boolean[1];
        ExpandListener expandListener = new ExpandListener(){

            public void itemCollapsed(ExpandEvent e) {
                listenerCalled[0] = true;
            }

            public void itemExpanded(ExpandEvent e) {
                listenerCalled[0] = true;
            }
        };
        try {
            this.expandBar.addExpandListener(null);
            Assert.fail((String)"No exception thrown for addExpandListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.expandBar.addExpandListener(expandListener);
        this.expandBar.notifyListeners(17, new Event());
        Assert.assertTrue((String)":a:", (boolean)listenerCalled[0]);
        listenerCalled[0] = false;
        this.expandBar.notifyListeners(18, new Event());
        Assert.assertTrue((String)":b:", (boolean)listenerCalled[0]);
        try {
            this.expandBar.removeExpandListener(null);
            Assert.fail((String)"No exception thrown for removeExpandListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        listenerCalled[0] = false;
        this.expandBar.removeExpandListener(expandListener);
        this.expandBar.notifyListeners(17, new Event());
        Assert.assertFalse((boolean)listenerCalled[0]);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        try {
            new ExpandBar(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getItemCount() {
        int number = 10;
        int i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + i), (this.expandBar.getItemCount() == i ? 1 : 0) != 0);
            new ExpandItem(this.expandBar, 0);
            ++i;
        }
    }

    @Test
    public void test_getItemI() {
        int number = 5;
        ExpandItem[] items = new ExpandItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new ExpandItem(this.expandBar, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)":a:", (this.expandBar.getItem(i) == items[i] ? 1 : 0) != 0);
            ++i;
        }
        this.expandBar = new ExpandBar((Composite)this.shell, 0);
        number = 5;
        items = new ExpandItem[number];
        i = 0;
        while (i < number) {
            items[i] = new ExpandItem(this.expandBar, 0);
            ++i;
        }
        try {
            this.expandBar.getItem(number);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_getItems() {
        int number = 5;
        Object[] items = new ExpandItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new ExpandItem(this.expandBar, 0);
            ++i;
        }
        Assert.assertArrayEquals((Object[])items, (Object[])this.expandBar.getItems());
        this.expandBar.getItems()[0].dispose();
        Assert.assertArrayEquals((Object[])new ExpandItem[]{items[1], items[2], items[3], items[4]}, (Object[])this.expandBar.getItems());
        this.expandBar.getItems()[3].dispose();
        Assert.assertArrayEquals((Object[])new ExpandItem[]{items[1], items[2], items[3]}, (Object[])this.expandBar.getItems());
        this.expandBar.getItems()[1].dispose();
        Assert.assertArrayEquals((Object[])new ExpandItem[]{items[1], items[3]}, (Object[])this.expandBar.getItems());
    }

    @Test
    public void test_indexOfLorg_eclipse_swt_widgets_ExpandItem() {
        int number = 10;
        ExpandItem[] items = new ExpandItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new ExpandItem(this.expandBar, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertTrue((String)(":a:" + i), (this.expandBar.indexOf(items[i]) == i ? 1 : 0) != 0);
            ++i;
        }
        items = new ExpandItem[number];
        i = 0;
        while (i < number) {
            items[i] = new ExpandItem(this.expandBar, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            try {
                this.expandBar.indexOf(null);
                Assert.fail((String)"No exception thrown for expandItem == null");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
    }

    @Test
    public void test_setSpacingI() {
        this.expandBar.setSpacing(0);
        Assert.assertEquals((long)this.expandBar.getSpacing(), (long)0L);
        this.expandBar.setSpacing(3);
        Assert.assertEquals((long)this.expandBar.getSpacing(), (long)3L);
        this.expandBar.setSpacing(-4);
        Assert.assertEquals((long)this.expandBar.getSpacing(), (long)3L);
    }

    private void createExpandBar(List<String> events) {
        this.expandBar = new ExpandBar((Composite)this.shell, 512);
        int i = 0;
        while (i < 3) {
            ExpandItem item = new ExpandItem(this.expandBar, 0);
            item.setText("ExpandBar" + i);
            this.hookExpectedEvents((Widget)item, this.getTestName(), events);
            ++i;
        }
        this.setWidget((Widget)this.expandBar);
    }

    @Test
    public void test_consistency_MouseSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createExpandBar(events);
        this.consistencyEvent(30, 10, 1, 0, 30, events);
    }

    @Test
    public void test_consistency_EnterSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createExpandBar(events);
        this.consistencyEvent(13, 10, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_SpaceSelection() {
        ArrayList<String> events = new ArrayList<String>();
        this.createExpandBar(events);
        this.consistencyEvent(32, 32, 0, 0, 10, events);
    }

    @Test
    public void test_consistency_MenuDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createExpandBar(events);
        this.consistencyEvent(50, 15, 3, 0, 30, events);
    }

    @Test
    public void test_consistency_DragDetect() {
        ArrayList<String> events = new ArrayList<String>();
        this.createExpandBar(events);
        this.consistencyEvent(30, 20, 50, 20, 50, events);
    }
}

