/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Scrollable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_List
extends Test_org_eclipse_swt_widgets_Scrollable {
    List list;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.list = new List((Composite)this.shell, 2);
        this.setWidget((Widget)this.list);
    }

    @Override
    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        try {
            this.list = new List(null, 0);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int[] nArray = new int[6];
        nArray[1] = 4;
        nArray[2] = 2;
        nArray[3] = 514;
        nArray[4] = 258;
        nArray[5] = 770;
        int[] cases = nArray;
        int i = 0;
        while (i < cases.length) {
            this.list = new List((Composite)this.shell, cases[i]);
            ++i;
        }
    }

    @Test
    public void test_addLjava_lang_String() {
        try {
            this.list.add(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.add("");
        Assert.assertArrayEquals((String)":a:", (Object[])new String[]{""}, (Object[])this.list.getItems());
        this.list.add("some \n text");
        Assert.assertArrayEquals((String)":b:", (Object[])new String[]{"", "some \n text"}, (Object[])this.list.getItems());
        this.list.add("some text");
        Assert.assertArrayEquals((String)":c:", (Object[])new String[]{"", "some \n text", "some text"}, (Object[])this.list.getItems());
        this.setSingleList();
        try {
            this.list.add(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.add("");
        Assert.assertArrayEquals((String)":a:", (Object[])new String[]{""}, (Object[])this.list.getItems());
        this.list.add("some \n text");
        Assert.assertArrayEquals((String)":b:", (Object[])new String[]{"", "some \n text"}, (Object[])this.list.getItems());
        this.list.add("some text");
        Assert.assertArrayEquals((String)":c:", (Object[])new String[]{"", "some \n text", "some text"}, (Object[])this.list.getItems());
    }

    @Test
    public void test_addLjava_lang_StringI() {
        try {
            this.list.add("some text", 2);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.list.add("", 0);
        Assert.assertArrayEquals((String)":a:", (Object[])new String[]{""}, (Object[])this.list.getItems());
        this.list.add("some \n text", 1);
        Assert.assertArrayEquals((String)":b:", (Object[])new String[]{"", "some \n text"}, (Object[])this.list.getItems());
        this.list.add("some text", 0);
        Assert.assertArrayEquals((String)":c:", (Object[])new String[]{"some text", "", "some \n text"}, (Object[])this.list.getItems());
        try {
            this.list.add(null, 0);
            Assert.fail((String)"No exception thrown string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.list.add("string", -1);
            Assert.fail((String)"No exception thrown index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.setSingleList();
        try {
            this.list.add("some text", 2);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.list.add("", 0);
        Assert.assertArrayEquals((String)":a:", (Object[])new String[]{""}, (Object[])this.list.getItems());
        this.list.add("some \n text", 1);
        Assert.assertArrayEquals((String)":b:", (Object[])new String[]{"", "some \n text"}, (Object[])this.list.getItems());
        this.list.add("some text", 0);
        Assert.assertArrayEquals((String)":c:", (Object[])new String[]{"some text", "", "some \n text"}, (Object[])this.list.getItems());
        try {
            this.list.add(null, 0);
            Assert.fail((String)"No exception thrown string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.list.add("string", -1);
            Assert.fail((String)"No exception thrown index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        boolean exceptionThrown = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                Test_org_eclipse_swt_widgets_List.this.listenerCalled = true;
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        };
        try {
            this.list.addSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown for listener == null", (boolean)exceptionThrown);
        this.list.addSelectionListener(listener);
        this.list.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.list.removeSelectionListener(listener);
        exceptionThrown = false;
        try {
            this.list.removeSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown for listener == null", (boolean)exceptionThrown);
        this.setSingleList();
        this.listenerCalled = false;
        exceptionThrown = false;
        try {
            this.list.addSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown for listener == null", (boolean)exceptionThrown);
        this.list.addSelectionListener(listener);
        this.list.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.list.removeSelectionListener(listener);
        exceptionThrown = false;
        try {
            this.list.removeSelectionListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Expected exception not thrown for listener == null", (boolean)exceptionThrown);
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.list.addSelectionListener(listener);
        this.list.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.list.removeSelectionListener(listener);
        this.setSingleList();
        this.list.addSelectionListener(listener);
        this.list.select(0);
        Assert.assertFalse((String)":a:", (boolean)this.listenerCalled);
        this.list.removeSelectionListener(listener);
    }

    @Override
    @Test
    public void test_computeSizeIIZ() {
    }

    @Test
    public void test_deselect$I() {
        Object[] items = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems((String[])items);
        this.list.setSelection((String[])items);
        Assert.assertArrayEquals((String)":a:", (Object[])this.list.getSelection(), (Object[])items);
        try {
            this.list.deselect(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])items);
        this.list.deselect(new int[0]);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])items);
        this.list.deselect(new int[1]);
        Assert.assertEquals((Object)this.list.isSelected(0), (Object)false);
        Assert.assertTrue((boolean)this.list.isSelected(1));
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.list.deselect(nArray);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1, 3});
        this.setSingleList();
        this.list.setItems((String[])items);
        this.list.setSelection(new String[]{"item3"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"item3"});
        try {
            this.list.deselect(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"item3"});
        this.list.deselect(new int[0]);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"item3"});
        this.list.deselect(new int[]{1});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.deselect(new int[1]);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.deselect(new int[]{3});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        this.list.deselect(nArray2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
    }

    @Test
    public void test_deselectAll() {
        Object[] items = new String[]{"item0", "item1", "item2", "item3"};
        Object[] empty = new String[]{};
        this.list.setItems((String[])items);
        this.list.setSelection((String[])items);
        Assert.assertArrayEquals((Object[])items, (Object[])this.list.getSelection());
        this.list.deselectAll();
        Assert.assertArrayEquals((Object[])empty, (Object[])this.list.getSelection());
        this.setSingleList();
        this.list.setItems((String[])items);
        this.list.setSelection(new String[]{"item3"});
        Assert.assertArrayEquals((Object[])new String[]{"item3"}, (Object[])this.list.getSelection());
        this.list.deselectAll();
        Assert.assertArrayEquals((Object[])empty, (Object[])this.list.getSelection());
    }

    @Test
    public void test_deselectI() {
        int number = 5;
        String[] items = new String[number];
        int i = 0;
        while (i < number) {
            items[i] = "fred" + i;
            ++i;
        }
        this.list.setItems(items);
        Object[] items2 = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems((String[])items2);
        this.list.setSelection((String[])items2);
        Assert.assertArrayEquals((Object[])items2, (Object[])this.list.getSelection());
        this.list.deselect(5);
        Assert.assertArrayEquals((Object[])items2, (Object[])this.list.getSelection());
        this.list.deselect(1);
        Assert.assertEquals((Object)false, (Object)this.list.isSelected(1));
        this.list.deselect(1);
        Assert.assertEquals((Object)false, (Object)this.list.isSelected(1));
        this.setSingleList();
        this.list.setItems((String[])items2);
        this.list.setSelection(new String[]{"item3"});
        Assert.assertArrayEquals((Object[])new String[]{"item3"}, (Object[])this.list.getSelection());
        this.list.deselect(5);
        Assert.assertArrayEquals((Object[])new String[]{"item3"}, (Object[])this.list.getSelection());
        this.list.deselect(2);
        Assert.assertEquals((Object)false, (Object)this.list.isSelected(2));
        this.list.deselect(1);
        Assert.assertEquals((Object)false, (Object)this.list.isSelected(1));
        this.list.deselect(1);
        Assert.assertEquals((Object)false, (Object)this.list.isSelected(1));
    }

    @Test
    public void test_deselectII() {
        int number = 5;
        String[] items = new String[number];
        int i = 0;
        while (i < number) {
            items[i] = "fred" + i;
            ++i;
        }
        this.list.setItems(items);
        this.list.setSelection(items);
        int[][] cases = new int[][]{{3, 1}, {-3, -2}, {-2, -1}, {-1, -1}, {10, 1}};
        int i2 = 0;
        while (i2 < cases.length) {
            int[] nArray = new int[5];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            this.deselectII_helper(items, cases[i2][0], cases[i2][1], nArray);
            ++i2;
        }
        if (SwtTestUtil.fCheckSWTPolicy) {
            this.deselectII_helper(items, -1, 3, new int[]{4});
            this.deselectII_helper(items, -1, 30, new int[0]);
        }
        int[] nArray = new int[2];
        nArray[1] = 4;
        this.deselectII_helper(items, 1, 3, nArray);
        int[] nArray2 = new int[4];
        nArray2[1] = 2;
        nArray2[2] = 3;
        nArray2[3] = 4;
        this.deselectII_helper(items, 1, 1, nArray2);
        Object[] items2 = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems((String[])items2);
        this.list.setSelection((String[])items2);
        Assert.assertArrayEquals((String)":a:", (Object[])items2, (Object[])this.list.getSelection());
        this.list.deselect(0, 0);
        Assert.assertArrayEquals((String)":b:", (int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3});
        this.list.deselect(0, 0);
        Assert.assertArrayEquals((String)":bbb:", (int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3});
        this.list.deselect(2, 3);
        Assert.assertArrayEquals((String)":bb:", (int[])this.list.getSelectionIndices(), (int[])new int[]{1});
        this.list.setSelection((String[])items2);
        this.list.deselect(0, 2);
        Assert.assertArrayEquals((String)":dddd:", (int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.setSelection((String[])items2);
        this.list.deselect(2, 0);
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        Assert.assertArrayEquals((String)":ddddd:", (int[])this.list.getSelectionIndices(), (int[])nArray3);
        this.setSingleList();
        this.list.setItems((String[])items2);
        this.list.deselectAll();
        this.list.select(0);
        this.list.deselect(-3, -2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.deselect(-2, -1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.deselect(-1, -1);
        Assert.assertArrayEquals((String)":e:", (int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.setSelection(new String[]{"item3"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"item3"});
        this.list.deselect(1, 1);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"item3"});
        this.list.deselect(0, 0);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"item3"});
        this.list.deselect(3, 3);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"item3"});
        this.list.deselect(1, 2);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"item3"});
        this.list.setSelection(new String[]{"item3"});
        this.list.deselect(0, 2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.setSelection(new String[]{"item3"});
        this.list.deselect(1, 3);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
    }

    @Test
    public void test_getFocusIndex() {
        String[] items = new String[]{"item0", "item1", "item2"};
        this.list.setItems(items);
        this.list.setSelection(0);
        Assert.assertEquals((long)0L, (long)this.list.getFocusIndex());
        this.list.setSelection(2);
        Assert.assertEquals((long)2L, (long)this.list.getFocusIndex());
    }

    @Test
    public void test_getItemCount() {
        String[] items = new String[]{"item0", "item1", "item2", "item3"};
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.list.setItems(items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        this.list.remove(2);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.removeAll();
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.setSingleList();
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.list.setItems(items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        this.list.remove(2);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.removeAll();
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
    }

    @Test
    public void test_getItemHeight() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_getItemHeight(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_List)");
            }
            return;
        }
        FontData fontData = this.list.getFont().getFontData()[0];
        Font font = new Font((Device)this.list.getDisplay(), fontData.getName(), 8, fontData.getStyle());
        this.list.setFont(font);
        int lineHeight = this.list.getItemHeight();
        this.list.setFont(null);
        font.dispose();
        font = new Font((Device)this.list.getDisplay(), fontData.getName(), 12, fontData.getStyle());
        this.list.setFont(font);
        int newLineHeight = this.list.getItemHeight();
        Assert.assertTrue((String)":a:", (newLineHeight > lineHeight ? 1 : 0) != 0);
        this.list.setFont(null);
        font.dispose();
    }

    @Test
    public void test_getItemI() {
        String[] items = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems(items);
        try {
            this.list.getItem(5);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.list.getItem(-1);
            Assert.fail((String)"No exception thrown for index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((Object)this.list.getItem(3), (Object)"item3");
        this.setSingleList();
        this.list.setItems(items);
        try {
            this.list.getItem(5);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.list.getItem(-1);
            Assert.fail((String)"No exception thrown for index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((Object)"item3", (Object)this.list.getItem(3));
    }

    @Test
    public void test_getItems() {
        String[][] cases = new String[][]{new String[0], {""}, {"", ""}, {"text1", "text2"}};
        int i = 0;
        while (i < cases.length) {
            this.list.setItems(cases[i]);
            Assert.assertArrayEquals((String)("case: " + i), (Object[])cases[i], (Object[])this.list.getItems());
            ++i;
        }
    }

    @Test
    public void test_getSelection() {
        String[][] cases = new String[][]{new String[0], {""}, {"", ""}, {"text1", "text2"}};
        int i = 0;
        while (i < cases.length) {
            this.list.setItems(cases[i]);
            this.list.setSelection(cases[i]);
            Assert.assertArrayEquals((String)("case: " + i), (Object[])cases[i], (Object[])this.list.getSelection());
            ++i;
        }
        i = 1;
        while (i < cases.length) {
            this.list.setItems(cases[i]);
            this.list.setSelection(0);
            Assert.assertArrayEquals((String)("case: " + String.valueOf(i)), (Object[])this.list.getSelection(), (Object[])new String[]{cases[i][0]});
            ++i;
        }
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        int[] nArray = new int[2];
        nArray[1] = 2;
        int[] sel = nArray;
        this.list.setSelection(sel);
        Assert.assertEquals((long)this.list.getSelection().length, (long)2L);
        Object[] selItems = new String[]{items[0], items[2]};
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])selItems);
        this.list.setSelection(0, 1);
        Assert.assertEquals((long)this.list.getSelection().length, (long)2L);
        selItems = new String[]{items[0], items[1]};
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])selItems);
        this.list.setSelection(1, 1);
        Assert.assertEquals((long)this.list.getSelection().length, (long)1L);
        Assert.assertEquals((Object)this.list.getSelection()[0], (Object)items[1]);
        this.list.setSelection(1, 0);
        Object[] empty = new String[]{};
        Assert.assertArrayEquals((Object[])empty, (Object[])this.list.getSelection());
        String[] bogus_items = new String[]{"bogus_text1", "bogus_text2", "bogus_text3"};
        this.list.setSelection(bogus_items);
        Assert.assertArrayEquals((Object[])empty, (Object[])this.list.getSelection());
        this.setSingleList();
        this.list.setItems(items);
        sel = new int[1];
        this.list.setSelection(sel);
        Assert.assertEquals((long)1L, (long)this.list.getSelection().length);
        Assert.assertEquals((Object)items[0], (Object)this.list.getSelection()[0]);
        this.list.setSelection(1, 1);
        Assert.assertEquals((long)1L, (long)this.list.getSelection().length);
        Assert.assertEquals((Object)items[1], (Object)this.list.getSelection()[0]);
    }

    @Test
    public void test_getSelectionCount() {
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        Assert.assertEquals((long)0L, (long)this.list.getSelectionCount());
        this.list.setSelection(items);
        Assert.assertEquals((long)3L, (long)this.list.getSelectionCount());
        this.list.deselectAll();
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown for selection == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)this.list.getSelectionCount(), (long)0L);
        this.setSingleList();
        this.list.setItems(items);
        this.list.setSelection(new String[]{"text2"});
        Assert.assertEquals((long)1L, (long)this.list.getSelectionCount());
    }

    @Test
    public void test_getSelectionIndex() {
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        this.list.setSelection(items);
        Assert.assertEquals((long)0L, (long)this.list.getSelectionIndex());
        this.setSingleList();
        this.list.setItems(items);
        this.list.setSelection(items);
        Assert.assertEquals((long)-1L, (long)this.list.getSelectionIndex());
        this.list.setSelection(new String[]{"text1"});
        Assert.assertEquals((long)0L, (long)this.list.getSelectionIndex());
        this.list.setSelection(new String[]{"text2"});
        Assert.assertEquals((long)1L, (long)this.list.getSelectionIndex());
        this.list.setSelection(new String[]{"text3"});
        Assert.assertEquals((long)2L, (long)this.list.getSelectionIndex());
        this.list.setSelection(items);
        Assert.assertEquals((long)-1L, (long)this.list.getSelectionIndex());
    }

    @Test
    public void test_getSelectionIndices() {
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(items);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] sel = nArray;
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        sel = new int[1];
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        sel = new int[]{1};
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        sel = new int[]{2};
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        sel = new int[]{3};
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.list.getSelectionIndices());
        int[] nArray2 = new int[5];
        nArray2[0] = -1;
        nArray2[2] = 1;
        nArray2[3] = 2;
        nArray2[4] = 3;
        sel = nArray2;
        this.list.setSelection(sel);
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = 2;
        Assert.assertArrayEquals((int[])nArray3, (int[])this.list.getSelectionIndices());
        sel = new int[]{1, 1, 2, 2};
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])this.list.getSelectionIndices());
        this.setSingleList();
        this.list.setItems(items);
        sel = new int[1];
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        sel = new int[]{1};
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        sel = new int[]{2};
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])sel, (int[])this.list.getSelectionIndices());
        sel = new int[]{3};
        this.list.setSelection(sel);
        Assert.assertArrayEquals((int[])new int[0], (int[])this.list.getSelectionIndices());
    }

    @Test
    public void test_getTopIndex() {
        String[] items = new String[10];
        int i = 0;
        while (i < 10) {
            items[i] = "text" + String.valueOf(i);
            ++i;
        }
        this.list.setItems(items);
        Assert.assertEquals((long)0L, (long)this.list.getTopIndex());
        this.list.setTopIndex(5);
        Assert.assertEquals((long)5L, (long)this.list.getTopIndex());
        this.setSingleList();
        this.list.setItems(items);
        Assert.assertEquals((long)0L, (long)this.list.getTopIndex());
    }

    @Test
    public void test_indexOfLjava_lang_String() {
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.indexOf("text3"), (long)2L);
        Assert.assertEquals((long)this.list.indexOf("text4"), (long)-1L);
        try {
            this.list.indexOf(null);
            Assert.fail((String)"No exception thrown for item == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String[] items2 = new String[]{"text1", "text2", "text2"};
        this.list.setItems(items2);
        Assert.assertEquals((long)this.list.indexOf("text2"), (long)1L);
        this.setSingleList();
        this.list.setItems(items);
        Assert.assertEquals((long)-1L, (long)this.list.indexOf("text3", 4));
        Assert.assertEquals((long)2L, (long)this.list.indexOf("text3"));
        Assert.assertEquals((long)-1L, (long)this.list.indexOf("text4"));
        try {
            this.list.indexOf(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)1L, (long)this.list.indexOf("text2"));
    }

    @Test
    public void test_indexOfLjava_lang_StringI() {
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        Assert.assertEquals((long)-1L, (long)this.list.indexOf("text3", 4));
        Assert.assertEquals((long)2L, (long)this.list.indexOf("text3", 2));
        Assert.assertEquals((long)1L, (long)this.list.indexOf("text2", 0));
        Assert.assertEquals((long)1L, (long)this.list.indexOf("text2", 1));
        Assert.assertEquals((long)-1L, (long)this.list.indexOf("text2", 2));
        String[] items2 = new String[]{"text1", "text2", "text2"};
        this.list.setItems(items2);
        Assert.assertEquals((long)this.list.indexOf("text2", 2), (long)2L);
        try {
            this.list.indexOf(null, 0);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.setSingleList();
        this.list.setItems(items2);
        Assert.assertEquals((long)1L, (long)this.list.indexOf("text2", 0));
        Assert.assertEquals((long)1L, (long)this.list.indexOf("text2", 1));
        Assert.assertEquals((long)2L, (long)this.list.indexOf("text2", 2));
        try {
            this.list.indexOf(null, 0);
            Assert.fail((String)"No exception thrown for string == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_isSelectedI() {
        String[] items = new String[]{"text1", "text2", "text2"};
        this.list.setItems(items);
        this.list.setSelection(items);
        Assert.assertTrue((boolean)this.list.isSelected(0));
        Assert.assertTrue((boolean)this.list.isSelected(1));
        Assert.assertTrue((boolean)this.list.isSelected(2));
        Assert.assertEquals((Object)false, (Object)this.list.isSelected(3));
        this.setSingleList();
        this.list.setItems(items);
        this.list.setSelection(items);
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertEquals((Object)false, (Object)this.list.isSelected(0));
            Assert.assertTrue((boolean)this.list.isSelected(1));
            Assert.assertEquals((Object)false, (Object)this.list.isSelected(2));
            Assert.assertEquals((Object)false, (Object)this.list.isSelected(3));
        }
    }

    @Test
    public void test_remove$I() {
        try {
            this.list.remove(null);
            Assert.fail((String)"No exception thrown for indices == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Object[] items = new String[]{"text0", "text1", "text2", "text3"};
        this.list.setItems((String[])items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        this.list.setItems((String[])items);
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 1;
        this.list.remove(nArray);
        Assert.assertEquals((long)this.list.getItemCount(), (long)2L);
        this.list.setItems((String[])items);
        try {
            this.list.remove(new int[]{4, 1});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((String)":a:", (Object[])this.list.getItems(), (Object[])items);
        try {
            this.list.remove(new int[]{3, 1, -1});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((String)":a:", (Object[])this.list.getItems(), (Object[])items);
        this.list.setItems((String[])items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        try {
            this.list.remove(new int[]{-1, -1});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((String)":b:", (Object[])this.list.getItems(), (Object[])items);
        try {
            this.list.remove(new int[]{-2, -1});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((String)":c:", (Object[])this.list.getItems(), (Object[])items);
        this.list.setItems((String[])items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        this.list.remove(new int[]{1, 1, 1});
        Assert.assertArrayEquals((String)":d:", (Object[])this.list.getItems(), (Object[])new String[]{"text0", "text2", "text3"});
        this.list.setItems((String[])items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        this.list.remove(new int[]{1, 3});
        Assert.assertArrayEquals((String)":e:", (Object[])this.list.getItems(), (Object[])new String[]{"text0", "text2"});
        this.setSingleList();
        try {
            int[] indices = null;
            this.list.remove(indices);
            Assert.fail((String)"No exception thrown for indices == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setItems((String[])items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        this.list.remove(new int[]{1, 3});
        Assert.assertArrayEquals((String)":f:", (Object[])this.list.getItems(), (Object[])new String[]{"text0", "text2"});
        this.list.setItems((String[])items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        this.list.remove(new int[]{3, 1});
        Assert.assertArrayEquals((String)":g:", (Object[])this.list.getItems(), (Object[])new String[]{"text0", "text2"});
        this.list.setItems((String[])items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        try {
            this.list.remove(new int[]{4, 1});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((String)":h:", (Object[])this.list.getItems(), (Object[])items);
        try {
            this.list.remove(new int[]{3, 1, -1});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((String)":h:", (Object[])this.list.getItems(), (Object[])items);
        this.list.setItems((String[])items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        try {
            this.list.remove(new int[]{-1, -1});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertArrayEquals((String)":i:", (Object[])items, (Object[])this.list.getItems());
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        this.list.remove(new int[]{1, 1, 1});
        Assert.assertArrayEquals((String)":j:", (Object[])new String[]{"text0", "text2", "text3"}, (Object[])this.list.getItems());
    }

    @Test
    public void test_removeAll() {
        String[] items = new String[]{"text1", "text2", "text3", "test2"};
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        this.list.removeAll();
        Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
        this.list.removeAll();
        Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
        this.setSingleList();
        this.list.setItems(items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        this.list.removeAll();
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.setSingleList();
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.list.removeAll();
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
    }

    @Test
    public void test_removeI() {
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        try {
            this.list.remove(3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        try {
            this.list.remove(-1);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        this.list.remove(1);
        Assert.assertEquals((long)this.list.getItemCount(), (long)2L);
        Assert.assertEquals((Object)this.list.getItem(1), (Object)"text3");
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        try {
            this.list.remove(3, 4);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        try {
            this.list.remove(3, 3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        this.list.remove(0);
        Assert.assertEquals((long)this.list.getItemCount(), (long)2L);
        this.list.remove(0);
        Assert.assertEquals((long)this.list.getItemCount(), (long)1L);
        Assert.assertEquals((Object)this.list.getItem(0), (Object)"text3");
        this.list.remove(0);
        Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
        this.list.setItems(items);
        this.list.remove(1, 2);
        Assert.assertEquals((long)this.list.getItemCount(), (long)1L);
        Assert.assertEquals((Object)this.list.getItem(0), (Object)"text1");
        this.setSingleList();
        this.list.setItems(items);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(-1);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.remove(1);
        Assert.assertEquals((long)2L, (long)this.list.getItemCount());
        Assert.assertTrue((boolean)this.list.getItem(1).equals("text3"));
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        this.list.remove(0);
        Assert.assertEquals((long)this.list.getItemCount(), (long)2L);
        this.list.remove(0);
        Assert.assertEquals((long)this.list.getItemCount(), (long)1L);
        Assert.assertEquals((Object)this.list.getItem(0), (Object)"text3");
        this.list.remove(0);
        Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
    }

    @Test
    public void test_removeII() {
        String[] items = new String[]{"text1", "text2", "text3"};
        this.list.setItems(items);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(3, 4);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(3, 3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.remove(0, 0);
        Assert.assertEquals((long)2L, (long)this.list.getItemCount());
        Assert.assertEquals((Object)"text3", (Object)this.list.getItem(1));
        this.list.setItems(items);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(-1, 1);
            Assert.fail((String)"No exception thrown for start index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(3, 4);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.remove(0, 2);
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.list.setItems(items);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(3, 3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.remove(2, 0);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.setSingleList();
        this.list.setItems(items);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(3, 4);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(3, 3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(-1, 1);
            Assert.fail((String)"No exception thrown for start index < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.remove(1, 2);
        Assert.assertEquals((long)1L, (long)this.list.getItemCount());
        Assert.assertEquals((Object)"text1", (Object)this.list.getItem(0));
        this.list.setItems(items);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        try {
            this.list.remove(2, 10);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        Assert.assertEquals((Object)"text2", (Object)this.list.getItem(1));
        this.list.remove(2, 0);
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
    }

    @Test
    public void test_removeLjava_lang_String() {
        String[] items = new String[]{"text1", "text2", "text3", "test2"};
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        try {
            this.list.remove(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        try {
            this.list.remove("items989");
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.getItemCount(), (long)4L);
        this.list.remove("text3");
        Assert.assertEquals((long)this.list.getItemCount(), (long)3L);
        this.list.remove("text2");
        Assert.assertEquals((long)this.list.getItemCount(), (long)2L);
        this.setSingleList();
        this.list.setItems(items);
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        try {
            this.list.remove(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        try {
            this.list.remove("items989");
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        Assert.assertEquals((long)4L, (long)this.list.getItemCount());
        this.list.remove("text3");
        Assert.assertEquals((long)3L, (long)this.list.getItemCount());
        this.list.remove("text2");
        Assert.assertEquals((long)2L, (long)this.list.getItemCount());
    }

    @Test
    public void test_select$I() {
        try {
            this.list.select(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String[] items = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems(items);
        int[] nArray = new int[2];
        nArray[1] = 2;
        this.list.select(nArray);
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])nArray2);
        this.list.select(new int[]{1, 3});
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])nArray3);
        this.list.select(new int[]{1, 3});
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])nArray4);
        this.list.select(new int[]{1});
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 3;
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])nArray5);
        this.list.add("item4");
        int[] nArray6 = new int[5];
        nArray6[0] = -1;
        nArray6[2] = 1;
        nArray6[3] = 2;
        nArray6[4] = 3;
        this.list.select(nArray6);
        int[] nArray7 = new int[4];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArray7[3] = 3;
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])nArray7);
        this.list.deselectAll();
        this.list.select(new int[]{1, 2, 3});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3});
        int[] ind = new int[32];
        int i = 0;
        while (i < ind.length) {
            ind[i] = i;
            ++i;
        }
        this.list.select(ind);
        int[] nArray8 = new int[5];
        nArray8[1] = 1;
        nArray8[2] = 2;
        nArray8[3] = 3;
        nArray8[4] = 4;
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])nArray8);
        this.list.setSelection(new int[0]);
        this.list.select(new int[]{1});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1});
        this.list.setSelection(new int[0]);
        this.list.select(new int[]{-1});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.deselectAll();
        items = this.list.getItems();
        int[] nArray9 = new int[4];
        nArray9[1] = 1;
        nArray9[2] = 2;
        nArray9[3] = 3;
        this.select$I_helper(0, 3, nArray9);
        int[] nArray10 = new int[4];
        nArray10[1] = 1;
        nArray10[2] = 2;
        nArray10[3] = 3;
        this.select$I_helper(-1, 3, nArray10);
        int[] nArray11 = new int[5];
        nArray11[1] = 1;
        nArray11[2] = 2;
        nArray11[3] = 3;
        nArray11[4] = 4;
        this.select$I_helper(-1, 30, nArray11);
        this.setSingleList();
        this.list.setItems(items);
        try {
            this.list.select(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.select(new int[]{-1});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(new int[1]);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.select(new int[]{1});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1});
        this.list.select(new int[]{2});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        this.list.select(new int[]{3});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.select(new int[]{4});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{4});
        this.list.select(new int[]{5});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{4});
        this.list.deselectAll();
        int[] nArray12 = new int[4];
        nArray12[1] = 1;
        nArray12[2] = 2;
        nArray12[3] = 3;
        this.list.select(nArray12);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] nArray13 = new int[5];
        nArray13[0] = -1;
        nArray13[2] = 1;
        nArray13[3] = 2;
        nArray13[4] = 3;
        this.list.select(nArray13);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] selection = new int[32];
        int i2 = 0;
        while (i2 < selection.length) {
            selection[i2] = i2;
            ++i2;
        }
        this.list.select(selection);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(new int[]{1, 1, 1});
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
    }

    @Test
    public void test_selectAll() {
        String[] items = new String[]{"text1", "text2", "text3", "test2"};
        this.list.setItems(items);
        Assert.assertEquals((long)this.list.getSelectionCount(), (long)0L);
        this.list.selectAll();
        Assert.assertEquals((long)this.list.getSelectionCount(), (long)4L);
        this.setSingleList();
        this.list.setItems(items);
        Assert.assertEquals((long)0L, (long)this.list.getSelectionCount());
        this.list.selectAll();
        Assert.assertEquals((long)0L, (long)this.list.getSelectionCount());
    }

    @Test
    public void test_selectI() {
        String[] items = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems(items);
        this.list.select(2);
        Assert.assertArrayEquals((String)"select(2):", (int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        this.list.select(1);
        Assert.assertArrayEquals((String)"select(1):", (int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2});
        this.list.select(3);
        Assert.assertArrayEquals((String)"select(3):", (int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3});
        this.list.select(5);
        Assert.assertArrayEquals((String)"select(5):", (int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3});
        this.list.deselectAll();
        this.list.select(0);
        Assert.assertArrayEquals((String)"select(0):", (int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.deselectAll();
        this.list.select(-1);
        Assert.assertArrayEquals((String)"select(-1):", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.deselectAll();
        this.list.select(-2);
        Assert.assertArrayEquals((String)"select(-2):", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.deselectAll();
        this.list.select(4);
        Assert.assertArrayEquals((String)"select(4):", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.setSingleList();
        this.list.setItems(items);
        this.list.select(2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        this.list.select(1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1});
        this.list.select(3);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.select(5);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.deselectAll();
        this.list.select(0);
        Assert.assertArrayEquals((String)"select(0):", (int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.deselectAll();
        this.list.select(-1);
        Assert.assertArrayEquals((String)"select(-1):", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.deselectAll();
        this.list.select(-2);
        Assert.assertArrayEquals((String)"select(-2):", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.deselectAll();
        this.list.select(4);
        Assert.assertArrayEquals((String)"select(4):", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
    }

    @Test
    public void test_selectII() {
        this.list.select(0, 0);
        Assert.assertArrayEquals((String)"empty list", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(0, 1);
        Assert.assertArrayEquals((String)"empty list", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(-1, 0);
        Assert.assertArrayEquals((String)"empty list", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int number = 5;
        String[] items = new String[number];
        int[] empty = new int[]{};
        int i = 0;
        while (i < number) {
            items[i] = "item" + i;
            ++i;
        }
        this.selectII_helper(items, 10, 1, empty);
        this.selectII_helper(items, 3, 1, empty);
        this.selectII_helper(items, -1, -1, empty);
        this.selectII_helper(items, 5, 5, empty);
        this.selectII_helper(items, 4, 5, new int[]{4});
        this.selectII_helper(items, -1, 0, new int[1]);
        this.selectII_helper(items, 2, 4, new int[]{2, 3, 4});
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.selectII_helper(items, 0, 3, nArray);
        this.selectII_helper(items, 1, 1, new int[]{1});
        int[] nArray2 = new int[5];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        this.selectII_helper(items, -1, 30, nArray2);
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        this.selectII_helper(items, -1, 3, nArray3);
        this.list.select(0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.select(-10, -9);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.deselectAll();
        this.list.select(1000, 2000);
        Assert.assertEquals((long)this.list.getSelectionCount(), (long)0L);
        this.list.deselectAll();
        this.list.select(1, 2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2});
        this.list.select(1, 3);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3});
        this.list.select(2, 2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3});
        this.list.select(3, 5);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3, 4});
        this.setSingleList();
        this.list.select(0, 0);
        Assert.assertArrayEquals((String)"empty list", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(0, 1);
        Assert.assertArrayEquals((String)"empty list", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(-1, 0);
        Assert.assertArrayEquals((String)"empty list", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setItems(items);
        this.list.select(0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.select(-10, -9);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.deselectAll();
        Assert.assertEquals((long)0L, (long)this.list.getSelectionCount());
        this.list.select(1000, 2000);
        Assert.assertEquals((long)0L, (long)this.list.getSelectionCount());
        this.list.deselectAll();
        Assert.assertEquals((long)0L, (long)this.list.getSelectionCount());
        this.list.select(0, 0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.select(1, 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1});
        this.list.select(2, 2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        this.list.select(3, 3);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{3});
        this.list.select(4, 4);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{4});
        this.list.select(5, 5);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{4});
        this.list.deselectAll();
        this.list.select(5, 5);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(1, 2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(1, 3);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.select(3, 5);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.selectII_helper(items, 0, 0, new int[1]);
        this.selectII_helper(items, 1, 1, new int[]{1});
        this.selectII_helper(items, 2, 2, new int[]{2});
        this.selectII_helper(items, 3, 3, new int[]{3});
        this.selectII_helper(items, 4, 4, new int[]{4});
        this.selectII_helper(items, 5, 5, new int[0]);
        this.selectII_helper(items, 10, 1, new int[0]);
        this.selectII_helper(items, 3, 1, new int[0]);
        this.selectII_helper(items, -1, -1, new int[0]);
    }

    @Override
    @Test
    public void test_setFontLorg_eclipse_swt_graphics_Font() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setFontLorg_eclipse_swt_graphics_Font(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_List)");
            }
            return;
        }
        FontData fontData = this.list.getFont().getFontData()[0];
        Font font = new Font((Device)this.list.getDisplay(), fontData.getName(), 8, fontData.getStyle());
        this.list.setFont(font);
        int lineHeight = this.list.getItemHeight();
        this.list.setFont(null);
        font.dispose();
        font = new Font((Device)this.list.getDisplay(), fontData.getName(), 12, fontData.getStyle());
        this.list.setFont(font);
        Assert.assertEquals((Object)font, (Object)this.list.getFont());
        Assert.assertTrue((String)("itemHeight=" + this.list.getItemHeight() + ", lineHeight=" + lineHeight), (this.list.getItemHeight() > lineHeight ? 1 : 0) != 0);
        this.list.setFont(null);
        font.dispose();
    }

    @Test
    public void test_setItemILjava_lang_String() {
        String[] items = new String[]{"item0", "item1", "item2", "item3"};
        Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
        int[] nArray = new int[3];
        nArray[0] = -10;
        nArray[2] = 10;
        int[] cases = nArray;
        int i = 0;
        while (i < cases.length) {
            try {
                this.list.setItem(cases[i], null);
                Assert.fail((String)"No exception thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
        Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
        i = 0;
        while (i < cases.length) {
            try {
                this.list.setItem(cases[i], "");
                Assert.fail((String)"No exception thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
        Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
        int[] nArray2 = new int[3];
        nArray2[0] = 10;
        nArray2[1] = 15;
        int[] cases2 = nArray2;
        int i2 = 0;
        while (i2 < cases2.length) {
            try {
                this.list.setItem(cases2[i2], "fred");
                Assert.fail((String)"No exception thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            Assert.assertEquals((long)this.list.getItemCount(), (long)0L);
            ++i2;
        }
        this.list.setItems(items);
        this.list.setItem(1, "new1");
        Assert.assertArrayEquals((Object[])new String[]{"item0", "new1", "item2", "item3"}, (Object[])this.list.getItems());
        this.setSingleList();
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        i2 = 0;
        while (i2 < cases.length) {
            try {
                this.list.setItem(cases[i2], null);
                Assert.fail((String)"No exception thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i2;
        }
        this.setSingleList();
        i2 = 0;
        while (i2 < cases.length) {
            try {
                this.list.setItem(cases[i2], "");
                Assert.fail((String)"No exception thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i2;
        }
        Assert.assertEquals((long)0L, (long)this.list.getItemCount());
        this.setSingleList();
        i2 = 0;
        while (i2 < cases2.length) {
            try {
                this.list.setItem(cases2[i2], "fred");
                Assert.fail((String)"No exception thrown");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            Assert.assertEquals((long)0L, (long)this.list.getItemCount());
            ++i2;
        }
        this.list.setItems(items);
        this.list.setItem(1, "new1");
        Assert.assertArrayEquals((Object[])new String[]{"item0", "new1", "item2", "item3"}, (Object[])this.list.getItems());
    }

    @Test
    public void test_setItems$Ljava_lang_String() {
        try {
            this.list.setItems(null);
            Assert.fail((String)"No exception thrown for items == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        String[][] itemArr = new String[][]{new String[0], {""}, {"sdasd"}, {"sdasd", "323434"}};
        int i = 0;
        while (i < itemArr.length) {
            this.list.setItems(itemArr[i]);
            Assert.assertArrayEquals((Object[])itemArr[i], (Object[])this.list.getItems());
            ++i;
        }
        try {
            this.list.setItems(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.setSingleList();
        i = 0;
        while (i < itemArr.length) {
            this.list.setItems(itemArr[i]);
            Assert.assertArrayEquals((String)("case:" + i), (Object[])itemArr[i], (Object[])this.list.getItems());
            ++i;
        }
        try {
            this.list.setItems(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setSelection$I() {
        int number = 8;
        int i = 0;
        while (i < number) {
            this.list.add("fred" + i);
            ++i;
        }
        this.list.setSelection(new int[0]);
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [0])", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown for MULTI: setSelection((int[]) null)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new int[]{2});
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {2})", (int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        Assert.assertEquals((String)"MULTI: setSelection(new int [] {2}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)2L);
        this.list.setSelection(new int[]{number});
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {number})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(new int[]{3, 1, 5, 2});
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {3, 1, 5, 2})", (int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2, 3, 5});
        int[] nArray = new int[2];
        nArray[0] = 1;
        this.list.setSelection(nArray);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {1, 0})", (int[])this.list.getSelectionIndices(), (int[])nArray2);
        this.list.setSelection(new int[]{-1, number});
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {-1, number})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(new int[]{number - 1, number});
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {number - 1, number})", (int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        Assert.assertEquals((String)"MULTI: setSelection(new int [] {number - 1, number}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)(number - 1));
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        this.list.setSelection(nArray3);
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {-1, 0})", (int[])this.list.getSelectionIndices(), (int[])new int[1]);
        int[] nArray4 = new int[5];
        nArray4[1] = 1;
        nArray4[2] = 2;
        nArray4[3] = 3;
        nArray4[4] = 5;
        this.list.setSelection(nArray4);
        int[] nArray5 = new int[5];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 3;
        nArray5[4] = 5;
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {0, 1, 2, 3, 5})", (int[])this.list.getSelectionIndices(), (int[])nArray5);
        int[] indices = new int[number];
        int i2 = 0;
        while (i2 < number) {
            indices[i2] = i2;
            ++i2;
        }
        this.list.setSelection(indices);
        Assert.assertArrayEquals((String)"MULTI: setSelection(indices)", (int[])indices, (int[])this.list.getSelectionIndices());
        this.list.setSelection(new int[]{number, number});
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {number, number})", (int[])new int[0], (int[])this.list.getSelectionIndices());
        this.list.setSelection(new int[]{number - 1, number - 1});
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {number - 1, number - 1})", (int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        Assert.assertEquals((String)"MULTI: setSelection(new int [] {number - 1, number - 1}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)(number - 1));
        int[] nArray6 = new int[3];
        nArray6[1] = number;
        nArray6[2] = 1;
        this.list.setSelection(nArray6);
        int[] nArray7 = new int[2];
        nArray7[1] = 1;
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {0, number, 1})", (int[])this.list.getSelectionIndices(), (int[])nArray7);
        int[] nArray8 = new int[3];
        nArray8[0] = number - 1;
        nArray8[2] = number - 2;
        this.list.setSelection(nArray8);
        int[] nArray9 = new int[3];
        nArray9[1] = number - 2;
        nArray9[2] = number - 1;
        Assert.assertArrayEquals((String)"MULTI: setSelection(new int [] {number - 1, 0, number - 2})", (int[])this.list.getSelectionIndices(), (int[])nArray9);
        this.list.removeAll();
        this.list.setSelection(new int[0]);
        Assert.assertArrayEquals((String)"EMPTY MULTI: setSelection(new int [0])", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY MULTI: setSelection(new int [0]) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown for EMPTY MULTI: setSelection((int[]) null)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new int[1]);
        Assert.assertArrayEquals((String)"EMPTY MULTI: setSelection(new int [] {0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY MULTI: setSelection(new int [] {0}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(new int[]{-1});
        Assert.assertArrayEquals((String)"EMPTY MULTI: setSelection(new int [] {-1})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY MULTI: setSelection(new int [] {-1}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(new int[2]);
        Assert.assertArrayEquals((String)"EMPTY MULTI: setSelection(new int [] {0, 0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY MULTI: setSelection(new int [] {0, 0}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        int[] nArray10 = new int[2];
        nArray10[0] = -1;
        this.list.setSelection(nArray10);
        Assert.assertArrayEquals((String)"EMPTY MULTI: setSelection(new int [] {-1, 0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY MULTI: setSelection(new int [] {-1, 0}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        int[] nArray11 = new int[2];
        nArray11[1] = -1;
        this.list.setSelection(nArray11);
        Assert.assertArrayEquals((String)"EMPTY MULTI: setSelection(new int [] {0, -1})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY MULTI: setSelection(new int [] {0, -1}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        this.setSingleList();
        i2 = 0;
        while (i2 < number) {
            this.list.add("fred" + i2);
            ++i2;
        }
        this.list.setSelection(new int[0]);
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [0])", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown for SINGLE: setSelection((int[]) null)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new int[]{2});
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {2})", (int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        Assert.assertEquals((String)"SINGLE: setSelection(new int [] {2}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)2L);
        this.list.setSelection(new int[]{number});
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {number})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] nArray12 = new int[2];
        nArray12[0] = 1;
        this.list.setSelection(nArray12);
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {1, 0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] nArray13 = new int[5];
        nArray13[1] = 1;
        nArray13[2] = 2;
        nArray13[3] = 3;
        nArray13[4] = 5;
        this.list.setSelection(nArray13);
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {0, 1, 2, 3, 5})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(new int[]{-1, number});
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {-1, number})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(new int[]{number - 1, number});
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {number - 1, number})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] nArray14 = new int[2];
        nArray14[0] = -1;
        this.list.setSelection(nArray14);
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {-1, 0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        indices = new int[number];
        i2 = 0;
        while (i2 < number) {
            indices[i2] = i2;
            ++i2;
        }
        this.list.setSelection(indices);
        Assert.assertArrayEquals((String)"SINGLE: setSelection(indices)", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(new int[]{number, number});
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {number, number})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(new int[]{number - 1, number - 1});
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {number - 1, number - 1})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] nArray15 = new int[3];
        nArray15[1] = number;
        nArray15[2] = 1;
        this.list.setSelection(nArray15);
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {0, number, 1})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int[] nArray16 = new int[3];
        nArray16[0] = number - 1;
        nArray16[2] = number - 2;
        this.list.setSelection(nArray16);
        Assert.assertArrayEquals((String)"SINGLE: setSelection(new int [] {number - 1, 0, number - 2})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.removeAll();
        this.list.setSelection(new int[0]);
        Assert.assertArrayEquals((String)"EMPTY SINGLE: setSelection(new int [0])", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY SINGLE: setSelection(new int [0]) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown for EMPTY SINGLE: setSelection((int[]) null)");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new int[1]);
        Assert.assertArrayEquals((String)"EMPTY SINGLE: setSelection(new int [] {0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY SINGLE: setSelection(new int [] {0}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(new int[]{-1});
        Assert.assertArrayEquals((String)"EMPTY SINGLE: setSelection(new int [] {-1})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY SINGLE: setSelection(new int [] {-1}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(new int[2]);
        Assert.assertArrayEquals((String)"EMPTY SINGLE: setSelection(new int [] {0, 0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY SINGLE: setSelection(new int [] {0, 0}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        int[] nArray17 = new int[2];
        nArray17[0] = -1;
        this.list.setSelection(nArray17);
        Assert.assertArrayEquals((String)"EMPTY SINGLE: setSelection(new int [] {-1, 0})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY SINGLE: setSelection(new int [] {-1, 0}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
        int[] nArray18 = new int[2];
        nArray18[1] = -1;
        this.list.setSelection(nArray18);
        Assert.assertArrayEquals((String)"EMPTY SINGLE: setSelection(new int [] {0, -1})", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((String)"EMPTY SINGLE: setSelection(new int [] {0, -1}) getFocusIndex()", (long)this.list.getFocusIndex(), (long)-1L);
    }

    @Test
    public void test_setSelection$Ljava_lang_String() {
        int number = 8;
        int i = 0;
        while (i < number) {
            this.list.add("fred " + i);
            ++i;
        }
        this.list.setSelection(new String[0]);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        if (SwtTestUtil.fCheckSWTPolicy) {
            Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        }
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new String[]{"fred 2"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred 2"});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)2L);
        this.list.setSelection(new String[]{"fred " + number});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred 1", "fred 0"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred 0", "fred 1"});
        this.list.setSelection(new String[]{"fred -1", "fred " + number});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred " + (number - 1), "fred " + number});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred " + (number - 1)});
        this.list.setSelection(new String[]{"fred -1", "fred 0"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred 0"});
        Object[] items = new String[number];
        int i2 = 0;
        while (i2 < number) {
            items[i2] = "fred " + i2;
            ++i2;
        }
        this.list.setSelection((String[])items);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])items);
        this.list.setSelection(new String[]{"fred " + number, "fred " + number});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred " + (number - 1), "fred " + (number - 1)});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred " + (number - 1)});
        this.list.setSelection(new String[]{"fred 0", "fred " + number, "fred 1"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred 0", "fred 1"});
        this.list.removeAll();
        this.list.setSelection(new String[0]);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new String[]{"fred 0"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(new String[]{"fred 0", "fred 0"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.setSingleList();
        i2 = 0;
        while (i2 < number) {
            this.list.add("fred " + i2);
            ++i2;
        }
        this.list.setSelection(new String[0]);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new String[]{"fred 2"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred 2"});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)2L);
        this.list.setSelection(new String[]{"fred " + number});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred 1", "fred 0"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred -1", "fred " + number});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred " + (number - 1)});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[]{"fred " + (number - 1)});
        items = new String[number];
        i2 = 0;
        while (i2 < number) {
            items[i2] = "fred " + i2;
            ++i2;
        }
        this.list.setSelection((String[])items);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred " + number, "fred " + number});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred " + (number - 1), "fred " + (number - 1)});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.setSelection(new String[]{"fred 0", "fred " + number, "fred 1"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        this.list.removeAll();
        this.list.setSelection(new String[0]);
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        try {
            this.list.setSelection(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.list.setSelection(new String[]{"fred 0"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(new String[]{"fred 0", "fred 0"});
        Assert.assertArrayEquals((Object[])this.list.getSelection(), (Object[])new String[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
    }

    @Test
    public void test_setSelectionI() {
        int number = 8;
        int i = 0;
        while (i < number) {
            this.list.add("fred" + i);
            ++i;
        }
        this.list.setSelection(2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)2L);
        this.list.setSelection(-5);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)0L);
        this.list.setSelection(number);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number - 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        this.list.setSelection(-1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.removeAll();
        this.list.setSelection(-2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(-1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.setSingleList();
        i = 0;
        while (i < number) {
            this.list.add("fred" + i);
            ++i;
        }
        this.list.setSelection(2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{2});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)2L);
        this.list.setSelection(-5);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)0L);
        this.list.setSelection(number);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number - 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)(number - 1));
        this.list.setSelection(-1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.removeAll();
        this.list.setSelection(0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(-1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(-2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
    }

    @Test
    public void test_setSelectionII() {
        int number = 8;
        String[] items = new String[number];
        int i = 0;
        while (i < number) {
            items[i] = "fred" + i;
            ++i;
        }
        this.list.setItems(items);
        this.list.setSelection(1, 2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1, 2});
        this.list.setSelection(-3, -2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(0, 1);
        int[] nArray = new int[2];
        nArray[1] = 1;
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])nArray);
        this.list.setSelection(-2, -1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number - 2, number - 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{number - 2, number - 1});
        this.list.setSelection(number - 1, number);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        this.list.setSelection(-1, 0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        this.list.setSelection(number, number + 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(0, 0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)0L);
        this.list.setSelection(2, 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number - 1, number - 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)(number - 1));
        this.list.setSelection(-1, -1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.removeAll();
        this.list.setSelection(-2, -1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(-1, 0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(0, 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(1, 0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.list.setSelection(0, -1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)-1L);
        this.setSingleList();
        this.list.setItems(items);
        this.list.setSelection(0, 0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[1]);
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)0L);
        this.list.setSelection(1, 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{1});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)1L);
        this.list.setSelection(4, 4);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{4});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)4L);
        this.list.setSelection(number - 1, number - 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)(number - 1));
        this.list.setSelection(number, number);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(-3, -2);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(0, 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(-2, -1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number - 2, number - 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number - 1, number);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(-1, 0);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number, number + 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(2, 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
        this.list.setSelection(number - 1, number - 1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[]{number - 1});
        Assert.assertEquals((long)this.list.getFocusIndex(), (long)(number - 1));
        this.list.setSelection(-1, -1);
        Assert.assertArrayEquals((int[])this.list.getSelectionIndices(), (int[])new int[0]);
    }

    @Test
    public void test_setTopIndexI() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setTopIndexI(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_List)");
            }
            return;
        }
        this.list.setTopIndex(3);
        Assert.assertEquals((String)"MULTI: setTopIndex(3) in empty list", (long)0L, (long)this.list.getTopIndex());
        String[] items = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems(items);
        int i = 0;
        while (i < items.length) {
            this.list.setTopIndex(i);
            Assert.assertEquals((String)("MULTI: setTopIndex(i=" + i + ")"), (long)i, (long)this.list.getTopIndex());
            ++i;
        }
        this.setSingleList();
        this.list.setTopIndex(3);
        Assert.assertEquals((String)"SINGLE: setTopIndex(3) in empty list", (long)0L, (long)this.list.getTopIndex());
        this.list.setItems(items);
        i = 0;
        while (i < items.length) {
            this.list.setTopIndex(i);
            Assert.assertEquals((String)("SINGLE: setTopIndex(i=" + i + ")"), (long)i, (long)this.list.getTopIndex());
            ++i;
        }
    }

    @Test
    public void test_showSelection() {
        String[] items = new String[]{"item0", "item1", "item2", "item3"};
        this.list.setItems(items);
        this.list.setSelection(items);
        this.list.showSelection();
        this.setSingleList();
        this.list.setItems(items);
        this.list.setSelection(items);
        this.list.showSelection();
    }

    protected void deselectII_helper(String[] items, int start, int end, int[] expectedIndices) {
        this.list.setItems(items);
        this.list.setSelection(items);
        this.list.deselect(start, end);
        Assert.assertArrayEquals((String)(":(" + start + ", " + end + "):"), (int[])expectedIndices, (int[])this.list.getSelectionIndices());
        this.list.setSelection(items);
        if ((this.list.getStyle() & 2) != 0) {
            Assert.assertArrayEquals((String)"setSelection(items):", (Object[])items, (Object[])this.list.getSelection());
        }
        int i = start;
        while (i <= end) {
            this.list.deselect(i);
            ++i;
        }
        Assert.assertArrayEquals((String)(":(" + start + ", " + end + "):"), (int[])expectedIndices, (int[])this.list.getSelectionIndices());
        this.list.deselectAll();
    }

    protected List setSingleList() {
        this.list.dispose();
        this.list = new List((Composite)this.shell, 4);
        this.setWidget((Widget)this.list);
        return this.list;
    }

    protected void selectII_helper(String[] items, int start, int end, int[] expectedIndices) {
        this.list.setItems(items);
        this.list.select(start, end);
        Assert.assertArrayEquals((String)(":(" + start + ", " + end + "):"), (int[])expectedIndices, (int[])this.list.getSelectionIndices());
        this.list.deselectAll();
        Assert.assertArrayEquals((String)"deselectAll:", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        int i = start;
        while (i <= end) {
            this.list.select(i);
            ++i;
        }
        Assert.assertArrayEquals((String)(":(" + start + ", " + end + "):"), (int[])expectedIndices, (int[])this.list.getSelectionIndices());
        this.list.deselectAll();
    }

    protected void select$I_helper(int start, int end, int[] expectedIndices) {
        int[] selection = new int[end - start + 1];
        int i = 0;
        while (i < selection.length) {
            selection[i] = i + start;
            ++i;
        }
        this.list.select(selection);
        Assert.assertArrayEquals((String)(":(" + start + ", " + end + "):"), (int[])expectedIndices, (int[])this.list.getSelectionIndices());
        this.list.deselectAll();
        Assert.assertArrayEquals((String)"deselectAll:", (int[])this.list.getSelectionIndices(), (int[])new int[0]);
        i = start;
        while (i <= end) {
            this.list.select(i);
            ++i;
        }
        Assert.assertArrayEquals((String)(":(" + start + ", " + end + "):"), (int[])expectedIndices, (int[])this.list.getSelectionIndices());
        this.list.deselectAll();
    }

    private void add() {
        this.list.add("this");
        this.list.add("is");
        this.list.add("SWT");
    }

    @Test
    public void test_consistency_MouseSelection() {
        this.add();
        this.consistencyEvent(27, 10, 1, 0, 30);
    }

    @Test
    public void test_consistency_KeySelection() {
        this.add();
        this.consistencyEvent(0, 0x1000002, 0, 0, 10);
    }

    @Test
    public void test_consistency_SpaceSelection() {
        this.add();
        this.consistencyEvent(32, 32, 0, 0, 10);
    }

    @Test
    public void test_consistency_DoubleClick() {
        this.add();
        this.consistencyEvent(27, 10, 1, 0, 40);
    }

    @Test
    public void test_consistency_MenuDetect() {
        this.add();
        this.consistencyEvent(27, 5, 3, 0, 30);
    }

    @Test
    public void test_consistency_DragDetect() {
        this.add();
        this.consistencyEvent(20, 5, 30, 10, 50);
    }
}

