/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Item;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_TreeColumn
extends Test_org_eclipse_swt_widgets_Item {
    protected TreeColumn treeColumn;
    protected Tree tree;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.tree = new Tree((Composite)this.shell, 4);
        this.treeColumn = new TreeColumn(this.tree, 0);
        this.setWidget((Widget)this.treeColumn);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TreeI() {
        try {
            new TreeColumn(null, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_TreeII() {
        try {
            new TreeColumn(null, 0, 0);
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new TreeColumn(this.tree, 0, -1);
            Assert.fail((String)"No exception thrown for index == -1");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new TreeColumn(this.tree, 0, 2);
            Assert.fail((String)"No exception thrown for illegal index argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        try {
            this.treeColumn.addSelectionListener(null);
            Assert.fail((String)"No exception thrown for selectionListener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_addSelectionListenerWidgetSelectedAdapterLorg_eclipse_swt_events_SelectionListener() {
        this.listenerCalled = false;
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.listenerCalled = true;
        });
        this.treeColumn.addSelectionListener(listener);
        this.treeColumn.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.treeColumn.removeSelectionListener(listener);
        this.treeColumn.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_getWidth() {
        int testWidth = 42;
        this.treeColumn.setWidth(0);
        Assert.assertTrue((String)(":a: width=" + this.treeColumn.getWidth() + " should be=" + 0), (this.treeColumn.getWidth() == 0 ? 1 : 0) != 0);
        this.treeColumn.setWidth(testWidth);
        Assert.assertTrue((String)(":b: width=" + this.treeColumn.getWidth() + " should be=" + testWidth), (this.treeColumn.getWidth() == testWidth ? 1 : 0) != 0);
        this.treeColumn.setWidth(testWidth);
        Assert.assertTrue((String)(":c: width=" + this.treeColumn.getWidth() + " should be=" + testWidth), (this.treeColumn.getWidth() == testWidth ? 1 : 0) != 0);
    }

    @Test
    public void test_removeSelectionListenerLorg_eclipse_swt_events_SelectionListener() {
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        };
        this.treeColumn.removeSelectionListener((SelectionListener)listener);
        this.treeColumn.addSelectionListener((SelectionListener)listener);
        this.treeColumn.removeSelectionListener((SelectionListener)listener);
        try {
            this.treeColumn.removeSelectionListener(null);
            Assert.fail((String)"No exception thrown for selectionListener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_setAlignmentI() {
        Assert.assertTrue((String)":a:", (this.treeColumn.getAlignment() == 16384 ? 1 : 0) != 0);
        this.treeColumn.setAlignment(-1);
        Assert.assertTrue((String)":b:", (this.treeColumn.getAlignment() == 16384 ? 1 : 0) != 0);
        this.treeColumn.setAlignment(131072);
        Assert.assertTrue((String)":c: Should not be allowed to set alignment of the first column", (this.treeColumn.getAlignment() == 16384 ? 1 : 0) != 0);
        TreeColumn column2 = new TreeColumn(this.tree, 0);
        column2.setAlignment(131072);
        Assert.assertTrue((String)":d:", (column2.getAlignment() == 131072 ? 1 : 0) != 0);
        column2.setAlignment(0x1000000);
        Assert.assertTrue((String)":e:", (column2.getAlignment() == 0x1000000 ? 1 : 0) != 0);
        column2.setAlignment(16384);
        Assert.assertTrue((String)":f:", (column2.getAlignment() == 16384 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void test_setImageLorg_eclipse_swt_graphics_Image() {
    }

    @Test
    public void test_setResizableZ() {
        Assert.assertTrue((String)":a:", (boolean)this.treeColumn.getResizable());
        this.treeColumn.setResizable(false);
        Assert.assertFalse((String)":b:", (boolean)this.treeColumn.getResizable());
        this.treeColumn.setResizable(false);
        Assert.assertFalse((String)":c:", (boolean)this.treeColumn.getResizable());
        this.treeColumn.setResizable(true);
        Assert.assertTrue((String)":d:", (boolean)this.treeColumn.getResizable());
    }

    @Override
    @Test
    public void test_setTextLjava_lang_String() {
        Assert.assertEquals((String)":a:", (Object)this.treeColumn.getText(), (Object)"");
        this.treeColumn.setText("text");
        Assert.assertEquals((String)":b:", (Object)this.treeColumn.getText(), (Object)"text");
        try {
            this.treeColumn.setText(null);
            Assert.fail((String)"No exception thrown for column header == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

