/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Browser2_location_and_progress_advanced {
    public static boolean verbose = false;
    public static boolean passed = false;
    public static boolean locationChanging = false;
    public static boolean locationChanged = false;
    public static boolean progressCompleted = false;
    public static String file1 = "<HTML><HEAD><META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-8859-1\"><TITLE>Test with 2 frames</TITLE></HEAD><BODY>some simple test case here</BODY></HTML>";

    public static boolean test1(String html) {
        if (verbose) {
            System.out.println("setText - args: " + html + " Expected Event Sequence: Location.changing > Location.changed > Progress.completed");
        }
        passed = false;
        progressCompleted = false;
        locationChanged = false;
        locationChanging = false;
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 0);
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (verbose) {
                    System.out.println("changing " + event.location);
                }
                passed = !locationChanged && !progressCompleted;
                locationChanging = true;
                if (!passed) {
                    shell.close();
                }
            }

            public void changed(LocationEvent event) {
                if (verbose) {
                    System.out.println("changed " + event.location);
                }
                passed = locationChanging && !locationChanged && !progressCompleted;
                locationChanged = true;
                if (!passed) {
                    shell.close();
                }
            }
        });
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                if (verbose) {
                    System.out.println("completed");
                }
                passed = locationChanging && locationChanged && !progressCompleted;
                progressCompleted = true;
                if (!passed) {
                    shell.close();
                }
                if (passed) {
                    new Thread(){

                        @Override
                        public void run() {
                            if (verbose) {
                                System.out.println("timer start");
                            }
                            try {
                                1.sleep(2000L);
                            }
                            catch (Exception exception) {}
                            if (!display.isDisposed()) {
                                display.asyncExec(() -> {
                                    if (verbose) {
                                        System.out.println("timer asyncexec shell.close");
                                    }
                                    if (!shell.isDisposed()) {
                                        shell.close();
                                    }
                                });
                            }
                            if (verbose) {
                                System.out.println("timer over");
                            }
                        }
                    }.start();
                }
            }
        });
        shell.open();
        browser.setText(html);
        boolean timeout = Browser2_location_and_progress_advanced.runLoopTimer(display, shell, 600);
        if (timeout) {
            passed = false;
        }
        display.dispose();
        return passed;
    }

    public static boolean test2(String html) {
        if (verbose) {
            System.out.println("setText URL Loading Filtering - args: " + html + " Expected Event Sequence: Location.changing cancel true > no Location.changed, no Progress.completed");
        }
        progressCompleted = false;
        locationChanged = false;
        locationChanging = false;
        passed = false;
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final Browser browser = new Browser((Composite)shell, 0);
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (verbose) {
                    System.out.println("changing " + event.location);
                }
                passed = !locationChanged && !progressCompleted;
                locationChanging = true;
                if (!passed) {
                    shell.close();
                    return;
                }
                event.doit = false;
                new Thread(){

                    @Override
                    public void run() {
                        if (verbose) {
                            System.out.println("timer start");
                        }
                        try {
                            1.sleep(2000L);
                        }
                        catch (Exception exception) {}
                        if (!display.isDisposed()) {
                            display.asyncExec(() -> {
                                if (verbose) {
                                    System.out.println("timer asyncexec shell.close");
                                }
                                if (!shell.isDisposed()) {
                                    shell.close();
                                }
                            });
                        }
                        if (verbose) {
                            System.out.println("timer over");
                        }
                    }
                }.start();
            }

            public void changed(LocationEvent event) {
                boolean bl = passed = event.location.length() == 0;
                if (verbose) {
                    System.out.println("changed " + event.location + " " + passed);
                }
                locationChanged = !passed;
            }
        });
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                String location = browser.getUrl();
                boolean bl = passed = location.length() == 0;
                if (verbose) {
                    System.out.println("completed " + passed);
                }
                progressCompleted = true;
            }
        });
        shell.open();
        browser.setText(html);
        boolean timeout = Browser2_location_and_progress_advanced.runLoopTimer(display, shell, 600);
        if (timeout) {
            passed = false;
        }
        display.dispose();
        return passed;
    }

    static boolean runLoopTimer(final Display display, final Shell shell, final int seconds) {
        final boolean[] timeout = new boolean[1];
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < seconds) {
                        Thread.sleep(1000L);
                        if (display.isDisposed() || shell.isDisposed()) {
                            return;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                timeout[0] = true;
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!shell.isDisposed()) {
                            shell.redraw();
                        }
                    });
                }
            }
        }.start();
        while (!timeout[0] && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return timeout[0];
    }

    public static boolean test() {
        boolean result;
        int fail = 0;
        String[] html = new String[]{file1};
        int i = 0;
        while (i < html.length) {
            result = Browser2_location_and_progress_advanced.test1(html[i]);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i;
        }
        i = 0;
        while (i < html.length) {
            result = Browser2_location_and_progress_advanced.test2(html[i]);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i;
        }
        return fail == 0;
    }

    public static void main(String[] argv) {
        System.out.println("\r\nTests Finished. SUCCESS: " + Browser2_location_and_progress_advanced.test());
    }
}

