/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Browser6_title_change_listener {
    public static boolean verbose = false;
    public static boolean passed = false;
    public static boolean isMozilla = false;

    public static boolean test1(String url) {
        if (verbose) {
            System.out.println("URL Loading, verify get title event - args: " + url + " Expected Event Sequence: Title.changed");
        }
        passed = false;
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 0);
        browser.addTitleListener(event -> {
            Browser browser1 = (Browser)event.widget;
            String url1 = browser1.getUrl();
            if (verbose) {
                System.out.println("Title changed <" + event.title + "> for location <" + url1 + ">");
            }
            passed = true;
            Runnable runnable = () -> shell.close();
            if (isMozilla) {
                display.asyncExec(runnable);
            } else {
                runnable.run();
            }
        });
        shell.open();
        browser.setUrl(url);
        boolean timeout = Browser6_title_change_listener.runLoopTimer(display, shell, 600);
        if (timeout) {
            passed = false;
        }
        display.dispose();
        return passed;
    }

    public static boolean test2(String url, String expectedTitle) {
        if (verbose) {
            System.out.println("URL Loading, verify get title event - args: " + url + " Expected Event Sequence: Title.changed");
        }
        passed = false;
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 0);
        browser.addTitleListener(event -> {
            Browser browser1 = (Browser)event.widget;
            String url1 = browser1.getUrl();
            if (verbose) {
                System.out.println("Title changed <" + event.title + "> for location <" + url1 + ">");
            }
            if (event.title.equals(expectedTitle)) {
                passed = true;
                Runnable runnable = () -> shell.close();
                if (isMozilla) {
                    display.asyncExec(runnable);
                } else {
                    runnable.run();
                }
            }
        });
        shell.open();
        browser.setUrl(url);
        boolean timeout = Browser6_title_change_listener.runLoopTimer(display, shell, 600);
        if (timeout) {
            passed = false;
        }
        display.dispose();
        return passed;
    }

    static boolean runLoopTimer(final Display display, final Shell shell, final int seconds) {
        final boolean[] timeout = new boolean[1];
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < seconds) {
                        Thread.sleep(1000L);
                        if (display.isDisposed() || shell.isDisposed()) {
                            return;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                timeout[0] = true;
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!shell.isDisposed()) {
                            shell.redraw();
                        }
                    });
                }
            }
        }.start();
        while (!timeout[0] && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return timeout[0];
    }

    public static boolean test() {
        int fail = 0;
        String[] urls = new String[]{"http://www.google.com"};
        int i = 0;
        while (i < urls.length) {
            boolean result = Browser6_title_change_listener.test1(urls[i]);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i;
        }
        String pluginPath = System.getProperty("PLUGIN_PATH");
        if (verbose) {
            System.out.println("PLUGIN_PATH <" + pluginPath + ">");
        }
        String url = pluginPath == null ? Browser6_title_change_listener.class.getClassLoader().getResource("browser6.html").toString() : String.valueOf(pluginPath) + "/data/browser6.html";
        urls = new String[]{url};
        String[] titles = new String[]{"This is a test title that must be carefully checked when that page is loaded"};
        int i2 = 0;
        while (i2 < urls.length) {
            boolean result = Browser6_title_change_listener.test2(urls[i2], titles[i2]);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i2;
        }
        return fail == 0;
    }

    public static void main(String[] argv) {
        System.out.println("\r\nTests Finished. SUCCESS: " + Browser6_title_change_listener.test());
    }
}

