/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.browser;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Browser8_execute_fromMemory {
    public static boolean verbose = false;
    static String[] html = new String[]{"<html><title>Snippet</title><body><p id='myid'>Best Friends</p><p id='myid2'>Cat and Dog</p></body></html>"};
    static String[] script = new String[]{"var newNode = document.createElement('P'); \r\nvar text = document.createTextNode('At least when I am around');\r\nnewNode.appendChild(text);\r\ndocument.getElementById('myid').appendChild(newNode);\r\n\r\ndocument.bgColor='yellow';"};

    public static boolean test(final int index) {
        if (verbose) {
            System.out.println("Javascript - verify execute() works on HTML rendered from memory with getText - script index " + index);
        }
        final AtomicBoolean passed = new AtomicBoolean();
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final Browser browser = new Browser((Composite)shell, 0);
        final AtomicBoolean finished = new AtomicBoolean();
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                if (verbose) {
                    Browser8_execute_fromMemory.runLoopTimer(display, shell, 1000);
                }
                passed.set(browser.execute(script[index]));
                if (verbose) {
                    Browser8_execute_fromMemory.runLoopTimer(display, shell, 1000);
                }
                finished.set(true);
            }
        });
        shell.open();
        browser.setText(html[index]);
        int i = 0;
        while (i < 5 && !passed.get() && !finished.get()) {
            Browser8_execute_fromMemory.runLoopTimer(display, shell, 2);
            if (!display.isDisposed()) {
                display.readAndDispatch();
            }
            ++i;
        }
        display.dispose();
        return passed.get();
    }

    static boolean runLoopTimer(final Display display, final Shell shell, final int seconds) {
        final boolean[] timeout = new boolean[1];
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < seconds) {
                        Thread.sleep(seconds * 1000);
                        if (display.isDisposed() || shell.isDisposed()) {
                            return;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                timeout[0] = true;
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!shell.isDisposed()) {
                            shell.redraw();
                        }
                    });
                }
            }
        }.start();
        while (!timeout[0] && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return timeout[0];
    }

    public static boolean test() {
        int fail = 0;
        String pluginPath = System.getProperty("PLUGIN_PATH");
        if (verbose) {
            System.out.println("PLUGIN_PATH <" + pluginPath + ">");
        }
        String url = pluginPath == null ? Browser8_execute_fromMemory.class.getClassLoader().getResource("browser7.html").toString() : String.valueOf(pluginPath) + "/data/browser7.html";
        String[] urls = new String[]{url};
        int i = 0;
        while (i < urls.length) {
            boolean result = Browser8_execute_fromMemory.test(i);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i;
        }
        return fail == 0;
    }

    public static void main(String[] argv) {
        System.out.println("\r\nTests Finished. SUCCESS: " + Browser8_execute_fromMemory.test());
    }
}

