/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Composite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class Test_org_eclipse_swt_browser_Browser
extends Test_org_eclipse_swt_widgets_Composite {
    boolean debug_show_browser = false;
    int debug_show_browser_timeout_seconds = 2;
    boolean debug_print_test_names = true;
    boolean debug_verbose_output = false;
    int secondsToWaitTillFail = Math.max(5, this.debug_show_browser_timeout_seconds);
    @Rule
    public TestName name = new TestName();
    Browser browser;
    boolean isWebkit1 = false;
    boolean isWebkit2 = false;
    ProgressListener callCustomFunctionUponLoad = new ProgressListener(){

        public void changed(ProgressEvent event) {
        }

        public void completed(ProgressEvent event) {
            Test_org_eclipse_swt_browser_Browser.this.browser.execute("callCustomFunction()");
        }
    };

    @Override
    @Before
    public void setUp() {
        super.setUp();
        if (SwtTestUtil.isRunningOnEclipseOrgHudsonGTK || this.debug_print_test_names) {
            System.out.println("Running Test_org_eclipse_swt_browser_Browser#" + this.name.getMethodName());
        }
        this.shell.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this.shell, 0);
        String shellTitle = this.name.getMethodName();
        if (SwtTestUtil.isGTK && this.browser.getBrowserType().equals("webkit")) {
            String webkitGtkVersionStr = System.getProperty("org.eclipse.swt.internal.webkitgtk.version");
            shellTitle = String.valueOf(shellTitle) + " Webkit version: " + webkitGtkVersionStr;
            String[] webkitGtkVersionStrParts = webkitGtkVersionStr.split("\\.");
            int[] webkitGtkVersionInts = new int[3];
            int i = 0;
            while (i < 3) {
                webkitGtkVersionInts[i] = Integer.parseInt(webkitGtkVersionStrParts[i]);
                ++i;
            }
            if (webkitGtkVersionInts[0] == 1 || webkitGtkVersionInts[0] == 2 && webkitGtkVersionInts[1] <= 4) {
                this.isWebkit1 = true;
            } else if (webkitGtkVersionInts[0] == 2 && webkitGtkVersionInts[1] > 4) {
                this.isWebkit2 = true;
            }
        }
        this.shell.setText(shellTitle);
        this.setWidget((Widget)this.browser);
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void test_ConstructorLorg_eclipse_swt_widgets_CompositeI() {
        Browser browser = new Browser((Composite)this.shell, 0);
        browser.dispose();
        browser = new Browser((Composite)this.shell, 2048);
        browser.dispose();
        browser = new Browser(null, 0);
    }

    @Override
    @Test
    public void test_getChildren() {
        if (SwtTestUtil.isWindows) {
            int childCount = this.composite.getChildren().length;
            String msg = "Browser on Win32 is a special case, the first child is an OleFrame (ActiveX control). Actual child count is: " + childCount;
            Assert.assertTrue((String)msg, (childCount == 1 ? 1 : 0) != 0);
        } else {
            super.test_getChildren();
        }
    }

    @Test
    public void test_CloseWindowListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addCloseWindowListener(event -> {});
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_CloseWindowListener_addWithNullArg() {
        this.browser.addCloseWindowListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_CloseWindowListener_removeWithNullArg() {
        this.browser.removeCloseWindowListener(null);
    }

    @Test
    public void test_CloseWindowListener_addAndRemove() {
        CloseWindowListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addCloseWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeCloseWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_LocationListener_adapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        LocationAdapter adapter = new LocationAdapter(){};
        browser.addLocationListener((LocationListener)adapter);
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_LocationListener_addWithNullArg() {
        this.browser.addLocationListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_LocationListener_removeWithNullArg() {
        this.browser.removeLocationListener(null);
    }

    @Test
    public void test_LocationListener_addAndRemove() {
        LocationListener listener = new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addLocationListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeLocationListener(listener);
            ++i;
        }
    }

    @Test
    public void test_LocationListener_changing() {
        final AtomicBoolean changingFired = new AtomicBoolean(false);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                changingFired.set(true);
            }
        });
        this.shell.open();
        this.browser.setText("Hello world");
        boolean passed = this.waitForPassCondition(() -> changingFired.get());
        Assert.assertTrue((String)"LocationListener.changing() event was never fixed", (boolean)passed);
    }

    @Test
    public void test_LocationListener_changed() {
        final AtomicBoolean changedFired = new AtomicBoolean(false);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changed(LocationEvent event) {
                changedFired.set(true);
            }
        });
        this.shell.open();
        this.browser.setText("Hello world");
        boolean passed = this.waitForPassCondition(() -> changedFired.get());
        Assert.assertTrue((String)"LocationListener.changing() event was never fixed", (boolean)passed);
    }

    @Test
    public void test_LocationListener_changingAndOnlyThenChanged() {
        final AtomicBoolean changingFired = new AtomicBoolean(false);
        final AtomicBoolean changedFired = new AtomicBoolean(false);
        final AtomicBoolean changedFiredTooEarly = new AtomicBoolean(false);
        final AtomicBoolean finished = new AtomicBoolean(false);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                changingFired.set(true);
            }

            public void changed(LocationEvent event) {
                if (!changingFired.get()) {
                    changedFiredTooEarly.set(true);
                }
                changedFired.set(true);
                finished.set(true);
            }
        });
        this.shell.open();
        this.browser.setText("Hello world");
        this.waitForPassCondition(() -> finished.get());
        if (finished.get() && changingFired.get() && changedFired.get() && !changedFiredTooEarly.get()) {
            return;
        }
        if (!finished.get()) {
            Assert.fail((String)"Test timed out. 'changed()' never fired");
        } else if (changedFiredTooEarly.get()) {
            Assert.fail((String)"changed() was fired before changing(). Wrong signal order");
        } else if (!changingFired.get()) {
            Assert.fail((String)"changing() was never fired");
        } else {
            Assert.fail((String)("LocationListener test failed. changing():" + changingFired.get() + "  changed():" + changedFired.get() + " changedFiredTooEarly:" + changedFiredTooEarly.get()));
        }
    }

    @Test
    public void test_OpenWindowListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addOpenWindowListener(event -> {});
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_OpenWindowListener_addWithNulArg() {
        this.browser.addOpenWindowListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_OpenWindowListener_removeWithNullArg() {
        this.browser.removeOpenWindowListener(null);
    }

    @Test
    public void test_OpenWindowListener_addAndRemove() {
        OpenWindowListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addOpenWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeOpenWindowListener(listener);
            ++i;
        }
    }

    @Test
    public void test_ProgressListener_newProgressAdapter() {
        new ProgressAdapter(){};
    }

    @Test
    public void test_ProgressListener_newProgressAdapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addProgressListener((ProgressListener)new ProgressAdapter(){});
        shell.close();
    }

    @Test
    public void test_ProgressListener_newListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
            }
        });
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ProgressListener_addWithNullArg() {
        this.browser.addProgressListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_ProgressListener_removeWithNullArg() {
        this.browser.removeProgressListener(null);
    }

    @Test
    public void test_ProgressListener_addAndRemove() {
        ProgressListener listener = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addProgressListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeProgressListener(listener);
            ++i;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_StatusTextListener_addWithNull() {
        this.browser.addStatusTextListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_StatusTextListener_removeWithNullArg() {
        this.browser.removeStatusTextListener(null);
    }

    @Test
    public void test_StatusTextListener_addAndRemove() {
        StatusTextListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addStatusTextListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeStatusTextListener(listener);
            ++i;
        }
    }

    @Test
    public void test_StatusTextListener_hoverMouseOverLink() {
        AtomicBoolean statusChanged = new AtomicBoolean(false);
        final int size = 500;
        final Browser browser = new Browser((Composite)this.shell, 0);
        StringBuilder longhtml = new StringBuilder();
        int i = 0;
        while (i < 200) {
            longhtml.append("text text text text text text text text text text text text text text text text text text text text text text text text<br>");
            ++i;
        }
        browser.setText("<a href='http://localhost'>" + longhtml + "</a>");
        this.shell.setLocation(0, 0);
        this.shell.setSize(size, size);
        browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                Display display = event.display;
                Point cachedLocation = display.getCursorLocation();
                display.setCursorLocation(20, 10);
                browser.getBounds();
                int i = 0;
                while (i < size) {
                    display.setCursorLocation(i, i);
                    Test_org_eclipse_swt_browser_Browser.this.waitForMilliseconds(Test_org_eclipse_swt_browser_Browser.this.debug_show_browser ? 3 : 1);
                    i += 5;
                }
                display.setCursorLocation(cachedLocation);
            }

            public void changed(ProgressEvent event) {
            }
        });
        browser.addStatusTextListener(event -> statusChanged.set(true));
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> statusChanged.get());
        String msg = "Mouse movent over text was suppose to trigger StatusTextListener. But it didn't";
        Assert.assertTrue((String)msg, (boolean)passed);
    }

    @Test
    public void test_TitleListener_addListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addTitleListener(event -> {});
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TitleListener_addwithNull() {
        this.browser.addTitleListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TitleListener_removeWithNullArg() {
        this.browser.removeTitleListener(null);
    }

    @Test
    public void test_TitleListener_addAndRemove() {
        TitleListener listener = event -> {};
        int i = 0;
        while (i < 100) {
            this.browser.addTitleListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeTitleListener(listener);
            ++i;
        }
    }

    @Test
    public void test_VisibilityWindowListener_newAdapter() {
        new VisibilityWindowAdapter(){};
    }

    @Test
    public void test_VisibilityWindowListener_newAdapter_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(){});
        shell.close();
    }

    @Test
    public void test_VisibilityWindowListener_newListener_closeShell() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
            }

            public void show(WindowEvent event) {
            }
        });
        shell.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_VisibilityWindowListener_addWithNull() {
        this.browser.addVisibilityWindowListener(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_VisibilityWindowListener_removeWithNullArg() {
        this.browser.removeVisibilityWindowListener(null);
    }

    @Test
    public void test_VisibilityWindowListener_addAndRemove() {
        VisibilityWindowListener listener = new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
            }

            public void show(WindowEvent event) {
            }
        };
        int i = 0;
        while (i < 100) {
            this.browser.addVisibilityWindowListener(listener);
            ++i;
        }
        i = 0;
        while (i < 100) {
            this.browser.removeVisibilityWindowListener(listener);
            ++i;
        }
    }

    @Override
    @Test
    public void test_isVisible() {
        super.test_isVisible();
    }

    @Test
    public void test_back() {
        int i = 0;
        while (i < 2) {
            this.browser.back();
            ++i;
        }
        boolean result = this.browser.back();
        Assert.assertFalse((boolean)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_setTextNull() {
        this.browser.setText(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_setUrlWithNullArg() {
        this.browser.setUrl(null);
    }

    @Test
    public void test_setJavascriptEnabled() {
        final AtomicInteger pageLoadCount = new AtomicInteger(0);
        final AtomicBoolean testFinished = new AtomicBoolean(false);
        final AtomicBoolean testPassed = new AtomicBoolean(false);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                pageLoadCount.incrementAndGet();
                if (pageLoadCount.get() == 1) {
                    Test_org_eclipse_swt_browser_Browser.this.browser.setJavascriptEnabled(false);
                    Test_org_eclipse_swt_browser_Browser.this.browser.setText("Second page with javascript dissabled");
                } else if (pageLoadCount.get() == 2) {
                    Boolean expectedNull = null;
                    try {
                        expectedNull = (Boolean)Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return true");
                    }
                    catch (Exception exception) {
                        Assert.fail((String)"1) if javascript is dissabled, browser.evaluate() should return null. But an Exception was thrown");
                    }
                    Assert.assertNull((String)("2) Javascript should not have executed. But not-null was returned:" + expectedNull), (Object)expectedNull);
                    testPassed.set(true);
                    testFinished.set(true);
                }
            }
        });
        this.shell.open();
        this.browser.setText("First page with javascript enabled. This should not be visiable as a second page should load");
        this.waitForPassCondition(testFinished::get);
        Assert.assertTrue((String)"3) Javascript was executed on the second page. But it shouldn't have", (boolean)testPassed.get());
    }

    @Test
    public void test_setJavascriptEnabled_multipleInstances() {
        final AtomicInteger pageLoadCount = new AtomicInteger(1);
        final AtomicInteger pageLoadCountSecondInstance = new AtomicInteger(1);
        final AtomicBoolean instanceOneFinishedCorrectly = new AtomicBoolean(false);
        final AtomicBoolean instanceTwoFinishedCorrectly = new AtomicBoolean(false);
        final Browser browserSecondInsance = new Browser((Composite)this.shell, 0);
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                if (pageLoadCount.get() == 1) {
                    Test_org_eclipse_swt_browser_Browser.this.browser.setJavascriptEnabled(false);
                    pageLoadCount.set(2);
                    Test_org_eclipse_swt_browser_Browser.this.browser.setText("First instance, second page (with javascript turned off)");
                    pageLoadCountSecondInstance.set(2);
                    browserSecondInsance.setText("Second instance, second page (javascript execution not changed)");
                } else if (pageLoadCount.get() == 2) {
                    pageLoadCount.set(3);
                    Boolean shouldBeNull = (Boolean)Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return true");
                    Assert.assertNull((String)"1) Evaluate execution should be null, but 'true was returned'", (Object)shouldBeNull);
                    instanceOneFinishedCorrectly.set(true);
                }
            }
        });
        browserSecondInsance.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                if (pageLoadCountSecondInstance.get() == 2) {
                    pageLoadCountSecondInstance.set(3);
                    Boolean shouldBeTrue = (Boolean)browserSecondInsance.evaluate("return true");
                    Assert.assertTrue((String)("2) Javascript should be executable in second instance (as javascript was not turned off), but it was not. Expected:'someStr', Actual:" + shouldBeTrue), (boolean)shouldBeTrue);
                    instanceTwoFinishedCorrectly.set(true);
                }
            }
        });
        this.browser.setText("First Instance, first page");
        browserSecondInsance.setText("Second instance, first page");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> {
            if (instanceOneFinishedCorrectly.get() && instanceTwoFinishedCorrectly.get()) {
                return true;
            }
            return false;
        });
        String message = "3) Test timed out. Debug Info:\nInstanceOneFinishedCorrectly: " + instanceOneFinishedCorrectly.get() + "\n" + "InstanceTwoFinishedCorrectly: " + instanceTwoFinishedCorrectly.get() + "\n" + "Instance 1 & 2 page counts: " + pageLoadCount.get() + " & " + pageLoadCountSecondInstance.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_LocationListener_evaluateInCallback() {
        Assume.assumeTrue((this.isWebkit2 || SwtTestUtil.isCocoa || SwtTestUtil.isWindows ? 1 : 0) != 0);
        final AtomicBoolean changingFinished = new AtomicBoolean(false);
        final AtomicBoolean changedFinished = new AtomicBoolean(false);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("SWTchanging = true");
                changingFinished.set(true);
            }

            public void changed(LocationEvent event) {
                Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("SWTchanged = true");
                changedFinished.set(true);
            }
        });
        this.browser.setText("<body>Hello <b>World</b></body>");
        if (SwtTestUtil.isWindows) {
            this.waitForPassCondition(changingFinished::get);
        } else {
            this.waitForPassCondition(() -> changingFinished.get() && changedFinished.get());
        }
        Boolean changed = false;
        try {
            changed = (Boolean)this.browser.evaluate("return SWTchanged");
        }
        catch (SWTException sWTException) {}
        Boolean changing = false;
        try {
            changing = (Boolean)this.browser.evaluate("return SWTchanging");
        }
        catch (SWTException sWTException) {}
        String errMsg = "\n  changing:  fired:" + changingFinished.get() + "    evaluated:" + changing + "\n  changed:   fired:" + changedFinished.get() + "    evaluated:" + changed;
        boolean passed = false;
        if (this.isWebkit2) {
            passed = changingFinished.get() && changedFinished.get() && changed != false && changing != false;
        } else if (this.isWebkit1) {
            passed = changingFinished.get() && changedFinished.get() && changed != false;
        } else if (SwtTestUtil.isCocoa) {
            passed = changingFinished.get() && changedFinished.get() && changed != false;
        } else if (SwtTestUtil.isWindows) {
            passed = changingFinished.get();
        }
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_OpenWindowListener_evaluateInCallback() {
        Assume.assumeTrue((!this.isWebkit1 ? 1 : 0) != 0);
        AtomicBoolean eventFired = new AtomicBoolean(false);
        this.browser.addOpenWindowListener(event -> {
            this.browser.evaluate("SWTopenListener = true");
            eventFired.set(true);
            event.required = true;
        });
        this.shell.open();
        this.browser.evaluate("window.open()");
        boolean fired = this.waitForPassCondition(() -> eventFired.get());
        boolean evaluated = false;
        try {
            evaluated = (Boolean)this.browser.evaluate("return SWTopenListener");
        }
        catch (SWTException sWTException) {}
        boolean passed = fired && evaluated;
        String errMsg = "Event fired:" + fired + "   evaluated:" + evaluated;
        Assert.assertTrue((String)errMsg, (boolean)passed);
    }

    @Test
    public void test_forward() {
        int i = 0;
        while (i < 2) {
            this.browser.forward();
            ++i;
        }
        boolean result = this.browser.forward();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_getUrl() {
        String string = this.browser.getUrl();
        Assert.assertNotNull((Object)string);
    }

    @Test
    public void test_isBackEnabled() {
        Assert.assertEquals((Object)this.browser.isBackEnabled(), (Object)this.browser.back());
        int i = 0;
        while (i < 2) {
            this.browser.back();
            ++i;
        }
        boolean result = this.browser.isBackEnabled();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_isForwardEnabled() {
        Assert.assertEquals((Object)this.browser.isForwardEnabled(), (Object)this.browser.forward());
        int i = 0;
        while (i < 10) {
            this.browser.forward();
            ++i;
        }
        boolean result = this.browser.isForwardEnabled();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void test_refresh() {
        int i = 0;
        while (i < 2) {
            this.browser.refresh();
            ++i;
        }
    }

    @Test
    public void test_setTextLjava_lang_String() {
        String html = "<HTML><HEAD><TITLE>HTML example 2</TITLE></HEAD><BODY><H1>HTML example 2</H1>";
        int i = 0;
        while (i < 1000) {
            html = String.valueOf(html) + "<P>That is a test line with the number " + i + "</P>";
            ++i;
        }
        html = String.valueOf(html) + "</BODY></HTML>";
        boolean result = this.browser.setText(html);
        Assert.assertTrue((boolean)result);
        this.waitForMilliseconds(2000);
    }

    @Test
    public void test_setUrl() {
        assert (this.browser.setUrl("http://www.eclipse.org/swt"));
        this.waitForMilliseconds(2000);
    }

    @Test
    public void test_stop() {
        this.browser.setUrl("http://www.eclipse.org/swt");
        this.waitForMilliseconds(1000);
        this.browser.stop();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_execute_withNullArg() {
        this.browser.execute(null);
    }

    @Test
    public void test_execute_and_closeListener() {
        AtomicBoolean hasClosed = new AtomicBoolean(false);
        this.browser.setText("You should not see this page, it should have been closed by javascript");
        this.browser.addCloseWindowListener(e -> hasClosed.set(true));
        this.browser.execute("window.close()");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> hasClosed.get());
        if (passed) {
            this.disposedIntentionally = true;
        }
        String message = "Either browser.execute() did not work (if you still see the html page) or closeListener Was not triggered if browser looks disposed, but test still fails.";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_string() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (SwtTestUtil.isRunningOnEclipseOrgHudsonGTK && this.isWebkit1 ? 1 : 0) != 0);
        final AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                String evalResult = (String)Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return document.getElementById('myid').childNodes[0].nodeValue;");
                returnValue.set(evalResult);
                if (Test_org_eclipse_swt_browser_Browser.this.debug_verbose_output) {
                    System.out.println("Node value: " + evalResult);
                }
            }
        });
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "HelloWorld".equals(returnValue.get()));
        Assert.assertTrue((String)"Evaluation did not return a value. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_number_normal() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        Double testNum = 123.0;
        boolean passed = this.evaluate_number_helper(testNum);
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)passed);
    }

    @Test
    public void test_evaluate_number_negative() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        Double testNum = -123.0;
        boolean passed = this.evaluate_number_helper(testNum);
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)passed);
    }

    @Test
    public void test_evaluate_number_big() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        Double testNum = 1.0E10;
        boolean passed = this.evaluate_number_helper(testNum);
        Assert.assertTrue((String)("Failed to evaluate number: " + testNum.toString()), (boolean)passed);
    }

    boolean evaluate_number_helper(final Double testNum) {
        final AtomicReference returnValue = new AtomicReference();
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                Double evalResult = (Double)Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return " + testNum.toString());
                returnValue.set(evalResult);
                if (Test_org_eclipse_swt_browser_Browser.this.debug_verbose_output) {
                    System.out.println("Node value: " + evalResult);
                }
            }
        });
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> testNum.equals(returnValue.get()));
        return passed;
    }

    @Test
    public void test_evaluate_boolean() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                Boolean evalResult = (Boolean)Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return true");
                atomicBoolean.set(evalResult);
                if (Test_org_eclipse_swt_browser_Browser.this.debug_verbose_output) {
                    System.out.println("Node value: " + evalResult);
                }
            }
        });
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> atomicBoolean.get());
        Assert.assertTrue((String)"Evaluation did not return a boolean. Or test timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_null() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        final AtomicReference<Boolean> returnValue = new AtomicReference<Boolean>(new Boolean(true));
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                Object evalResult = Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return null");
                returnValue.set(evalResult);
                if (Test_org_eclipse_swt_browser_Browser.this.debug_verbose_output) {
                    System.out.println("Node value: " + evalResult);
                }
            }
        });
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnValue.get() == null);
        Assert.assertTrue((String)"Evaluate did not return a null. Timed out.", (boolean)passed);
    }

    @Test
    public void test_evaluate_invalid_return_value() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        if (SwtTestUtil.isWindows) {
            return;
        }
        final AtomicInteger exception = new AtomicInteger(-1);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                try {
                    Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return new Date()");
                }
                catch (SWTException e) {
                    exception.set(e.code);
                }
            }
        });
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        AtomicBoolean wrongExceptionCode = new AtomicBoolean(false);
        boolean passed = this.waitForPassCondition(() -> {
            if (exception.get() != -1) {
                if (exception.get() == 51) {
                    return true;
                }
                if (exception.get() == 50) {
                    wrongExceptionCode.set(true);
                    return true;
                }
            }
            return false;
        });
        if (wrongExceptionCode.get()) {
            System.err.println("SWT Warning: test_evaluate_invalid_return_value threw wrong exception code. Expected ERROR_INVALID_RETURN_VALUE but got ERROR_FAILED_EVALUATE");
        }
        String message = exception.get() == -1 ? "Exception was not thrown. Test timed out" : "Exception thrown, but wrong code: " + exception.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_evaluation_failed_exception() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        final AtomicInteger exception = new AtomicInteger(-1);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                try {
                    Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return runSomeUndefinedFunctionInJavaScriptWhichCausesUndefinedError()");
                }
                catch (SWTException e) {
                    exception.set(e.code);
                }
            }
        });
        this.browser.setText("<html><body>HelloWorld</body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (exception.get() != -1) {
                if (exception.get() == 50) {
                    return true;
                }
                additionalErrorInfo.set("Invalid exception thrown: " + exception.get());
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not throw an error. Test timed out" : "Javascript threw an error, but not the right one." + additionalErrorInfo.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_numbers() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        final AtomicIntegerArray atomicIntArray = new AtomicIntegerArray(3);
        atomicIntArray.set(0, -1);
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                Object[] evalResult = (Object[])Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return new Array(1,2,3)");
                atomicIntArray.set(0, ((Double)evalResult[0]).intValue());
                atomicIntArray.set(1, ((Double)evalResult[1]).intValue());
                atomicIntArray.set(2, ((Double)evalResult[2]).intValue());
                if (Test_org_eclipse_swt_browser_Browser.this.debug_verbose_output) {
                    System.out.println("Node value: " + evalResult);
                }
            }
        });
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (atomicIntArray.get(0) != -1) {
                if (atomicIntArray.get(0) == 1 && atomicIntArray.get(1) == 2 && atomicIntArray.get(2) == 3) {
                    return true;
                }
                additionalErrorInfo.set("Resulting numbers in the array are not as expected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not call java" : "Javasscript called java, but passed wrong values: " + additionalErrorInfo.get();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_strings() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        final AtomicReferenceArray<String> atomicStringArray = new AtomicReferenceArray<String>(3);
        atomicStringArray.set(0, "executing");
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                Object[] evalResult = (Object[])Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return new Array(\"str1\", \"str2\", \"str3\")");
                atomicStringArray.set(0, (String)evalResult[0]);
                atomicStringArray.set(1, (String)evalResult[1]);
                atomicStringArray.set(2, (String)evalResult[2]);
                if (Test_org_eclipse_swt_browser_Browser.this.debug_verbose_output) {
                    System.out.println("Node value: " + evalResult);
                }
            }
        });
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (!"executing".equals(atomicStringArray.get(0))) {
                if (((String)atomicStringArray.get(0)).equals("str1") && ((String)atomicStringArray.get(1)).equals("str2") && ((String)atomicStringArray.get(2)).equals("str3")) {
                    return true;
                }
                additionalErrorInfo.set("Resulting strings in array are not as expected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Expected an array of strings, but did not receive array or got the wrong result." : "Received a callback from javascript, but: " + additionalErrorInfo.get() + " : " + atomicStringArray.toString();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_evaluate_array_mixedTypes() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        final AtomicReferenceArray<String> atomicArray = new AtomicReferenceArray<String>(3);
        atomicArray.set(0, "executing");
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                Object[] evalResult = (Object[])Test_org_eclipse_swt_browser_Browser.this.browser.evaluate("return new Array(\"str1\", 2, true)");
                atomicArray.set(2, evalResult[2]);
                atomicArray.set(1, evalResult[1]);
                atomicArray.set(0, evalResult[0]);
                if (Test_org_eclipse_swt_browser_Browser.this.debug_verbose_output) {
                    System.out.println("Node value: " + evalResult);
                }
            }
        });
        this.browser.setText("<html><body><p id='myid'>HelloWorld</p></body></html>");
        this.shell.open();
        AtomicReference<String> additionalErrorInfo = new AtomicReference<String>("");
        boolean passed = this.waitForPassCondition(() -> {
            if (!"executing".equals(atomicArray.get(0))) {
                if (atomicArray.get(0).equals("str1") && (Double)atomicArray.get(1) == 2.0 && ((Boolean)atomicArray.get(2)).booleanValue()) {
                    return true;
                }
                additionalErrorInfo.set("Resulting String are not as exected");
            }
            return false;
        });
        String message = "".equals(additionalErrorInfo.get()) ? "Javascript did not call java" : "Javascript called java but passed wrong values: " + atomicArray.toString();
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava()\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicBoolean atomicBoolean) {
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                this.val$javaCallbackExecuted.set(true);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", javaCallbackExecuted);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> javaCallbackExecuted.get());
        String message = "Java failed to get a callback from javascript. Test timed out";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_integer() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (SwtTestUtil.isRunningOnEclipseOrgHudsonGTK && this.isWebkit1 ? 1 : 0) != 0);
        AtomicInteger returnInt = new AtomicInteger(0);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava(5)\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$returnInt;

            JavascriptCallback(Browser browser, String name, AtomicInteger atomicInteger) {
                this.val$returnInt = atomicInteger;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Double returnedDouble = (Double)arguments[0];
                this.val$returnInt.set(returnedDouble.intValue());
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", returnInt);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnInt.get() == 5);
        String message = "Javascript should have passed an integer to java. But this did not happen";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_boolean() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava(true)\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicBoolean atomicBoolean) {
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Boolean returnBool = (Boolean)arguments[0];
                this.val$javaCallbackExecuted.set(returnBool);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", javaCallbackExecuted);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> javaCallbackExecuted.get());
        String message = "Javascript did not pass a boolean back to java";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_String() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReference returnValue = new AtomicReference();
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava('hellojava')\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicReference val$returnValue;

            JavascriptCallback(Browser browser, String name, AtomicReference atomicReference) {
                this.val$returnValue = atomicReference;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                String returnString = (String)arguments[0];
                this.val$returnValue.set(returnString);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", returnValue);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> "hellojava".equals(returnValue.get()));
        String message = "Javascript was suppose to call java with a String. But it seems java did not receive the call or wrong value was passed";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_multipleValues() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicReferenceArray<String> atomicArray = new AtomicReferenceArray<String>(3);
        atomicArray.set(0, "executing");
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n\t\tjsCallbackToJava('hellojava', 5, true)\n}</script>\n</head>\n<body> I'm going to make a callback to java </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicReferenceArray val$atomicArray;

            JavascriptCallback(Browser browser, String name, AtomicReferenceArray atomicReferenceArray) {
                this.val$atomicArray = atomicReferenceArray;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                this.val$atomicArray.set(1, arguments[1]);
                this.val$atomicArray.set(2, arguments[2]);
                this.val$atomicArray.set(0, arguments[0]);
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", atomicArray);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> {
            if (atomicArray.get(0).equals("hellojava") && (Double)atomicArray.get(1) == 5.0 && ((Boolean)atomicArray.get(2)).booleanValue()) {
                return true;
            }
            return false;
        });
        String msg = "Values not set. Test timed out. Array should be [\"hellojava\", 5, true], but is: " + atomicArray.toString();
        Assert.assertTrue((String)msg, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_with_javaReturningInt() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        Assume.assumeFalse((String)"Skipping test_BrowserFunction_callback_with_javaReturningInt. Java's callback to Javascript doesn't support return yet", (boolean)this.isWebkit2);
        AtomicInteger returnInt = new AtomicInteger(0);
        String htmlWithScript = "<html><head>\n<script language=\"JavaScript\">\nfunction callCustomFunction() {\n     document.body.style.backgroundColor = 'red'\n     var retVal = jsCallbackToJava()\n\t\tdocument.write(retVal)\n     jsSuccess(retVal)\n}</script>\n</head>\n<body> If you see this, javascript did not receive anything from Java. This page should just be '42' </body>\n</html>\n";
        this.browser.setText(htmlWithScript);
        class JavascriptCallback
        extends BrowserFunction {
            JavascriptCallback(Browser browser, String name) {
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                return 42;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava");
        class JavascriptCallback_javascriptReceivedJavaInt
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$returnInt;

            JavascriptCallback_javascriptReceivedJavaInt(Browser browser, String name, AtomicInteger atomicInteger) {
                this.val$returnInt = atomicInteger;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                Double returnVal = (Double)arguments[0];
                this.val$returnInt.set(returnVal.intValue());
                return null;
            }
        }
        new JavascriptCallback_javascriptReceivedJavaInt(this.browser, "jsSuccess", returnInt);
        this.browser.addProgressListener(this.callCustomFunctionUponLoad);
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> returnInt.get() == 42);
        String message = "Java should have returned something back to javascript. But something went wrong";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    @Test
    public void test_BrowserFunction_callback_afterPageReload() {
        Assume.assumeFalse((String)this.webkit1SkipMsg(), (boolean)this.isWebkit1);
        AtomicBoolean javaCallbackExecuted = new AtomicBoolean(false);
        AtomicInteger callCount = new AtomicInteger(0);
        this.browser.setText("1st (initial) page load");
        class JavascriptCallback
        extends BrowserFunction {
            private final /* synthetic */ AtomicInteger val$callCount;
            private final /* synthetic */ AtomicBoolean val$javaCallbackExecuted;

            JavascriptCallback(Browser browser, String name, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean) {
                this.val$callCount = atomicInteger;
                this.val$javaCallbackExecuted = atomicBoolean;
                super(browser, name);
            }

            public Object function(Object[] arguments) {
                if (this.val$callCount.get() == 0) {
                    this.val$callCount.set(1);
                    Test_org_eclipse_swt_browser_Browser.this.browser.setText("2nd page load");
                } else {
                    this.val$javaCallbackExecuted.set(true);
                }
                return null;
            }
        }
        new JavascriptCallback(this.browser, "jsCallbackToJava", callCount, javaCallbackExecuted);
        this.browser.execute("jsCallbackToJava()");
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                Test_org_eclipse_swt_browser_Browser.this.browser.execute("jsCallbackToJava()");
            }

            public void changed(ProgressEvent event) {
            }
        });
        this.shell.open();
        boolean passed = this.waitForPassCondition(() -> javaCallbackExecuted.get());
        String message = "A javascript callback should work after a page has been reloaded. But something went wrong";
        Assert.assertTrue((String)message, (boolean)passed);
    }

    private boolean waitForPassCondition(Supplier<Boolean> passTest) {
        return this.waitForPassCondition(passTest, 1000 * this.secondsToWaitTillFail);
    }

    private boolean waitForPassCondition(Supplier<Boolean> passTest, int millisecondsToWait) {
        AtomicBoolean passed = new AtomicBoolean(false);
        Instant timeOut = Instant.now().plusMillis(millisecondsToWait);
        Instant debug_showBrowserTimeout = Instant.now().plusSeconds(this.debug_show_browser_timeout_seconds);
        Display display = this.shell.getDisplay();
        new Thread(() -> {
            while (Instant.now().isBefore(timeOut)) {
                if (((Boolean)passTest.get()).booleanValue()) {
                    passed.set(true);
                    break;
                }
                try {
                    Thread.sleep(2L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (this.debug_show_browser && Instant.now().isBefore(debug_showBrowserTimeout)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            display.wake();
        }).start();
        while (Instant.now().isBefore(timeOut)) {
            if (passed.get() && (!this.debug_show_browser || Instant.now().isAfter(debug_showBrowserTimeout))) break;
            if (this.shell.isDisposed() || display.readAndDispatch()) continue;
            display.sleep();
        }
        return passed.get();
    }

    void waitForMilliseconds(int milliseconds) {
        this.waitForPassCondition(() -> false, milliseconds);
    }

    private String webkit1SkipMsg() {
        return "Test_org_eclipse_swt_browser. Bug 509411. Skipping test on Webkit1 due to sporadic crash: " + this.name.getMethodName();
    }
}

