/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_custom_TextChangeListener {
    Shell shell;
    StyledText styledText;
    int verify = -1;

    @Before
    public void setUp() {
        this.shell = new Shell();
        this.styledText = new StyledText((Composite)this.shell, 0);
    }

    @Test
    public void test_textChangedLorg_eclipse_swt_custom_TextChangedEvent() {
        StyledTextContent content = this.styledText.getContent();
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(TextChangedEvent event) {
                switch (Test_org_eclipse_swt_custom_TextChangeListener.this.verify) {
                    case 1: {
                        Assert.assertTrue((String)":1:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("\ntesting"));
                        break;
                    }
                    case 2: {
                        Assert.assertTrue((String)":2:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("a"));
                        break;
                    }
                    case 3: {
                        Assert.assertTrue((String)":3:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("\n\n"));
                        break;
                    }
                    case 4: {
                        Assert.assertTrue((String)":4:", (boolean)false);
                        break;
                    }
                    case 5: {
                        Assert.assertTrue((String)":5:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("\rLine 1\r\nLine 2"));
                        break;
                    }
                    case 6: {
                        Assert.assertTrue((String)":6:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("This\nis a test\nline 3"));
                        break;
                    }
                    case 7: {
                        Assert.assertTrue((String)":7:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("This\n\r"));
                        break;
                    }
                    case 8: {
                        Assert.assertTrue((String)":8:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("\nL1\r\nL2"));
                        break;
                    }
                    case 9: {
                        Assert.assertTrue((String)":9:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("L1test"));
                        break;
                    }
                    case 10: {
                        Assert.assertTrue((String)":10:", (boolean)false);
                        break;
                    }
                    case 11: {
                        Assert.assertTrue((String)":11:", (boolean)false);
                        break;
                    }
                    case 12: {
                        Assert.assertTrue((String)":12:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("L1\r\n"));
                        break;
                    }
                    case 13: {
                        Assert.assertTrue((String)":13:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("L1\r\n"));
                        break;
                    }
                    case 14: {
                        Assert.assertTrue((String)":14:", (boolean)false);
                        break;
                    }
                    case 15: {
                        Assert.assertTrue((String)":15:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("L1test\n\n"));
                        break;
                    }
                    case 16: {
                        Assert.assertTrue((String)":16:", (boolean)false);
                        break;
                    }
                    case 17: {
                        Assert.assertTrue((String)":17:", (boolean)false);
                        break;
                    }
                    case 18: {
                        Assert.assertTrue((String)":18:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("L1\r\ntest\r\n"));
                        break;
                    }
                    case 19: {
                        Assert.assertTrue((String)":19:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("L1test\r\r\r\n"));
                        break;
                    }
                    case 20: {
                        Assert.assertTrue((String)":20:", (boolean)false);
                    }
                }
            }

            public void textChanging(TextChangingEvent event) {
            }

            public void textSet(TextChangedEvent event) {
            }
        };
        content.addTextChangeListener(listener);
        boolean exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("testing");
        this.verify = 1;
        this.styledText.replaceTextRange(0, 0, "\n");
        this.verify = 0;
        this.styledText.setText("\n\n");
        this.verify = 2;
        this.styledText.replaceTextRange(0, 2, "a");
        this.verify = 0;
        this.styledText.setText("a");
        this.verify = 3;
        this.styledText.replaceTextRange(0, 1, "\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 4;
        try {
            this.styledText.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":4: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("Line 1\r\nLine 2");
        this.verify = 5;
        this.styledText.replaceTextRange(0, 0, "\r");
        this.verify = 0;
        this.styledText.setText("This\nis a test\nline 3\nline 4");
        this.verify = 6;
        this.styledText.replaceTextRange(21, 7, "");
        this.verify = 0;
        this.styledText.setText("This\nis a test\r");
        this.verify = 7;
        this.styledText.replaceTextRange(5, 9, "");
        this.verify = 0;
        this.styledText.setText("\nL1\r\nL2\r\n");
        this.verify = 8;
        this.styledText.replaceTextRange(7, 2, "");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 9;
        this.styledText.replaceTextRange(2, 2, "test");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 10;
        try {
            this.styledText.replaceTextRange(3, 1, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":10: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 11;
        try {
            this.styledText.replaceTextRange(1, 2, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":11: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 12;
        this.styledText.replaceTextRange(3, 0, "\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 13;
        this.styledText.replaceTextRange(2, 0, "\r");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 14;
        try {
            this.styledText.replaceTextRange(3, 0, "test");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":14: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 15;
        this.styledText.replaceTextRange(2, 2, "test\n\n");
        this.verify = 0;
        this.styledText.setText("L1\r\n");
        this.verify = 16;
        try {
            this.styledText.replaceTextRange(3, 1, "test\r\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":16: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 17;
        try {
            this.styledText.replaceTextRange(1, 2, "test\n\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":17: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 0;
        this.styledText.setText("L1\r");
        this.verify = 18;
        this.styledText.replaceTextRange(3, 0, "\ntest\r\n");
        this.verify = 0;
        this.styledText.setText("L1\n");
        this.verify = 19;
        this.styledText.replaceTextRange(2, 0, "test\r\r\r");
        this.verify = 0;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        this.verify = 20;
        try {
            this.styledText.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":20: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        content.removeTextChangeListener(listener);
    }

    @Test
    public void test_textChangingLorg_eclipse_swt_custom_TextChangingEvent() {
        StyledTextContent content = this.styledText.getContent();
        TextChangeListener listener = new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
                switch (Test_org_eclipse_swt_custom_TextChangeListener.this.verify) {
                    case 1: {
                        Assert.assertTrue((String)":1a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":1b:", (event.newLineCount == 1 ? 1 : 0) != 0);
                        break;
                    }
                    case 2: {
                        Assert.assertTrue((String)":2a:", (event.replaceLineCount == 2 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":2b:", (event.newLineCount == 0 ? 1 : 0) != 0);
                        break;
                    }
                    case 3: {
                        Assert.assertTrue((String)":3a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":3b:", (event.newLineCount == 2 ? 1 : 0) != 0);
                        break;
                    }
                    case 4: {
                        Assert.assertTrue((String)":4:", (boolean)false);
                        break;
                    }
                    case 5: {
                        Assert.assertTrue((String)":5a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":5b:", (event.newLineCount == 1 ? 1 : 0) != 0);
                        break;
                    }
                    case 6: {
                        Assert.assertTrue((String)":6a:", (event.replaceLineCount == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":6b:", (event.newLineCount == 0 ? 1 : 0) != 0);
                        break;
                    }
                    case 7: {
                        Assert.assertTrue((String)":7a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":7b:", (event.newLineCount == 0 ? 1 : 0) != 0);
                        break;
                    }
                    case 8: {
                        Assert.assertTrue((String)":8a:", (event.replaceLineCount == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":8b:", (event.newLineCount == 0 ? 1 : 0) != 0);
                        break;
                    }
                    case 9: {
                        Assert.assertTrue((String)":9a:", (event.replaceLineCount == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":9b:", (event.newLineCount == 0 ? 1 : 0) != 0);
                        break;
                    }
                    case 10: {
                        Assert.assertTrue((String)":10:", (boolean)false);
                        break;
                    }
                    case 11: {
                        Assert.assertTrue((String)":11:", (boolean)false);
                        break;
                    }
                    case 12: {
                        Assert.assertTrue((String)":12a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":12b:", (event.newLineCount == 1 ? 1 : 0) != 0);
                        break;
                    }
                    case 13: {
                        Assert.assertTrue((String)":13a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":13b:", (event.newLineCount == 1 ? 1 : 0) != 0);
                        break;
                    }
                    case 14: {
                        Assert.assertTrue((String)":14:", (boolean)false);
                        break;
                    }
                    case 15: {
                        Assert.assertTrue((String)":15a:", (event.replaceLineCount == 1 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":15b:", (event.newLineCount == 2 ? 1 : 0) != 0);
                        break;
                    }
                    case 16: {
                        Assert.assertTrue((String)":16:", (boolean)false);
                        break;
                    }
                    case 17: {
                        Assert.assertTrue((String)":17:", (boolean)false);
                        break;
                    }
                    case 18: {
                        Assert.assertTrue((String)":18a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":18b:", (event.newLineCount == 2 ? 1 : 0) != 0);
                        break;
                    }
                    case 19: {
                        Assert.assertTrue((String)":19a:", (event.replaceLineCount == 0 ? 1 : 0) != 0);
                        Assert.assertTrue((String)":19b:", (event.newLineCount == 3 ? 1 : 0) != 0);
                        break;
                    }
                    case 20: {
                        Assert.assertTrue((String)":20:", (boolean)false);
                    }
                }
            }

            public void textChanged(TextChangedEvent event) {
            }

            public void textSet(TextChangedEvent event) {
            }
        };
        content.addTextChangeListener(listener);
        boolean exceptionHandled = false;
        this.verify = 1;
        this.styledText.setText("testing");
        this.styledText.replaceTextRange(0, 0, "\n");
        this.verify = 2;
        this.styledText.setText("\n\n");
        this.styledText.replaceTextRange(0, 2, "a");
        this.verify = 3;
        this.styledText.setText("a");
        this.styledText.replaceTextRange(0, 1, "\n\n");
        this.verify = 4;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            this.styledText.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":4: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 5;
        this.styledText.setText("Line 1\r\nLine 2");
        this.styledText.replaceTextRange(0, 0, "\r");
        this.verify = 6;
        this.styledText.setText("This\nis a test\nline 3\nline 4");
        this.styledText.replaceTextRange(21, 7, "");
        this.verify = 7;
        this.styledText.setText("This\nis a test\r");
        this.styledText.replaceTextRange(5, 9, "");
        this.verify = 8;
        this.styledText.setText("\nL1\r\nL2\r\n");
        this.styledText.replaceTextRange(7, 2, "");
        this.verify = 9;
        this.styledText.setText("L1\r\n");
        this.styledText.replaceTextRange(2, 2, "test");
        this.verify = 10;
        this.styledText.setText("L1\r\n");
        try {
            this.styledText.replaceTextRange(3, 1, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":10: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 11;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            this.styledText.replaceTextRange(1, 2, "");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":11: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 12;
        this.styledText.setText("L1\r");
        this.styledText.replaceTextRange(3, 0, "\n");
        this.verify = 13;
        this.styledText.setText("L1\n");
        this.styledText.replaceTextRange(2, 0, "\r");
        this.verify = 14;
        this.styledText.setText("L1\r\n");
        try {
            this.styledText.replaceTextRange(3, 0, "test");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":14: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 15;
        this.styledText.setText("L1\r\n");
        this.styledText.replaceTextRange(2, 2, "test\n\n");
        this.verify = 16;
        this.styledText.setText("L1\r\n");
        try {
            this.styledText.replaceTextRange(3, 1, "test\r\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":16: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 17;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            this.styledText.replaceTextRange(1, 2, "test\n\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":17: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        this.verify = 18;
        this.styledText.setText("L1\r");
        this.styledText.replaceTextRange(3, 0, "\ntest\r\n");
        this.verify = 19;
        this.styledText.setText("L1\n");
        this.styledText.replaceTextRange(2, 0, "test\r\r\r");
        this.verify = 20;
        this.styledText.setText("L1\r\nL2\r\nL3\r\nL4\r\n");
        try {
            this.styledText.replaceTextRange(3, 1, "test\n");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionHandled = true;
        }
        Assert.assertTrue((String)":20: exception not thrown", (boolean)exceptionHandled);
        exceptionHandled = false;
        content.removeTextChangeListener(listener);
    }

    @Test
    public void test_textSetLorg_eclipse_swt_custom_TextChangedEvent() {
        StyledTextContent content = this.styledText.getContent();
        TextChangeListener listener = new TextChangeListener(){

            public void textChanging(TextChangingEvent event) {
            }

            public void textChanged(TextChangedEvent event) {
            }

            public void textSet(TextChangedEvent event) {
                switch (Test_org_eclipse_swt_custom_TextChangeListener.this.verify) {
                    case 1: {
                        Assert.assertTrue((String)":1:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("testing"));
                        break;
                    }
                    case 2: {
                        Assert.assertTrue((String)":2:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("\n\n"));
                        break;
                    }
                    case 3: {
                        Assert.assertTrue((String)":3:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().equals("a"));
                        break;
                    }
                    case 4: {
                        Assert.assertTrue((String)":4:", (boolean)Test_org_eclipse_swt_custom_TextChangeListener.this.styledText.getText().isEmpty());
                    }
                }
            }
        };
        content.addTextChangeListener(listener);
        this.verify = 1;
        this.styledText.setText("testing");
        this.verify = 2;
        this.styledText.setText("\n\n");
        this.verify = 3;
        this.styledText.setText("a");
        this.verify = 4;
        try {
            this.styledText.setText(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((String)":4:", (boolean)true);
        }
        content.removeTextChangeListener(listener);
    }
}

