/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_graphics_Color {
    Display display;

    @Before
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceIII() {
        Color color = new Color((Device)this.display, 0, 0, 0);
        color.dispose();
        color = new Color((Device)this.display, 0, 0, 0, 0);
        color.dispose();
        color = new Color((Device)this.display, 255, 255, 255);
        color.dispose();
        color = new Color((Device)this.display, 255, 255, 255, 0);
        color.dispose();
        color = new Color((Device)this.display, 20, 20, 20);
        color.dispose();
        color = new Color((Device)this.display, 20, 20, 20, 0);
        color.dispose();
        color = new Color((Device)this.display, 102, 255, 0);
        color.dispose();
        color = new Color((Device)this.display, 102, 255, 0, 0);
        color.dispose();
        color = new Color(null, 0, 0, 0);
        color.dispose();
        color = new Color(null, 0, 0, 0, 0);
        color.dispose();
        try {
            color = new Color((Device)this.display, -10, -10, -10);
            color.dispose();
            Assert.fail((String)"No exception thrown for rgb < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, 0, 0, 0, -10);
            color.dispose();
            Assert.fail((String)"No exception thrown for rgba < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, 1000, 2000, 3000);
            color.dispose();
            Assert.fail((String)"No exception thrown for rgb > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, 1000, 2000, 3000, 4000);
            color.dispose();
            Assert.fail((String)"No exception thrown for rgba > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, 10, 10, 256);
            color.dispose();
            Assert.fail((String)"No exception thrown for blue > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, 10, 10, 10, 256);
            color.dispose();
            Assert.fail((String)"No exception thrown for alpha > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_RGB() {
        Color color = new Color((Device)this.display, new RGB(0, 0, 0));
        color.dispose();
        color = new Color((Device)this.display, new RGB(0, 0, 0), 0);
        color.dispose();
        color = new Color((Device)this.display, new RGB(255, 255, 255));
        color.dispose();
        color = new Color((Device)this.display, new RGB(255, 255, 255), 0);
        color.dispose();
        color = new Color((Device)this.display, new RGB(10, 10, 10));
        color.dispose();
        color = new Color((Device)this.display, new RGB(10, 10, 10), 0);
        color.dispose();
        color = new Color((Device)this.display, new RGB(102, 255, 0));
        color.dispose();
        color = new Color((Device)this.display, new RGB(102, 255, 0), 0);
        color.dispose();
        color = new Color(null, new RGB(0, 0, 0));
        color.dispose();
        color = new Color(null, new RGB(0, 0, 0), 0);
        color.dispose();
        try {
            color = new Color((Device)this.display, new RGB(-10, -10, -10));
            color.dispose();
            Assert.fail((String)"No exception thrown for rgb < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGB(0, 0, 0), -10);
            color.dispose();
            Assert.fail((String)"No exception thrown for rgba < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGB(1000, 2000, 3000));
            color.dispose();
            Assert.fail((String)"No exception thrown for rgb > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGB(1000, 2000, 3000), 4000);
            color.dispose();
            Assert.fail((String)"No exception thrown for rgba > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGB(10, 10, 256));
            color.dispose();
            Assert.fail((String)"No exception thrown for blue > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGB(10, 10, 10), 256);
            color.dispose();
            Assert.fail((String)"No exception thrown for alpha > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, null, 0);
            color.dispose();
            Assert.fail((String)"No exception thrown for rgb == null with alpha");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceLorg_eclipse_swt_graphics_RGBA() {
        Color color = new Color((Device)this.display, new RGBA(0, 0, 0, 255));
        color.dispose();
        color = new Color((Device)this.display, new RGBA(0, 0, 0, 0));
        color.dispose();
        color = new Color((Device)this.display, new RGBA(255, 255, 255, 255));
        color.dispose();
        color = new Color((Device)this.display, new RGBA(255, 255, 255, 0));
        color.dispose();
        color = new Color((Device)this.display, new RGBA(10, 10, 10, 10));
        color.dispose();
        color = new Color((Device)this.display, new RGBA(10, 10, 10, 0));
        color.dispose();
        color = new Color((Device)this.display, new RGBA(102, 255, 0, 255));
        color.dispose();
        color = new Color((Device)this.display, new RGBA(102, 255, 0, 0));
        color.dispose();
        color = new Color(null, new RGBA(0, 0, 0, 255));
        color.dispose();
        color = new Color(null, new RGBA(0, 0, 0, 0));
        color.dispose();
        try {
            color = new Color((Device)this.display, new RGBA(-10, -10, -10, -10));
            color.dispose();
            Assert.fail((String)"No exception thrown for rgba < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGBA(0, 0, 0, -10));
            color.dispose();
            Assert.fail((String)"No exception thrown for alpha < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGBA(1000, 2000, 3000, 4000));
            color.dispose();
            Assert.fail((String)"No exception thrown for rgba > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGBA(10, 10, 256, 10));
            color.dispose();
            Assert.fail((String)"No exception thrown for blue > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            color = new Color((Device)this.display, new RGBA(10, 10, 10, 256));
            color.dispose();
            Assert.fail((String)"No exception thrown for alpha > 255");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Test
    public void test_equalsLjava_lang_Object() {
        Color color = new Color((Device)this.display, 1, 2, 3);
        Color sameColor = new Color((Device)this.display, 1, 2, 3);
        Color sameColor2 = new Color((Device)this.display, new RGB(1, 2, 3));
        Color otherColor = new Color((Device)this.display, 5, 6, 7);
        try {
            Assert.assertTrue((String)"!color.equals((Object)null)", (!color.equals(null) ? 1 : 0) != 0);
            Assert.assertTrue((String)"!color.equals((Color)null)", (!color.equals(null) ? 1 : 0) != 0);
            Assert.assertTrue((String)"color.equals(color)", (boolean)color.equals((Object)color));
            Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColor));
            Assert.assertTrue((String)"color.equals(sameColor2)", (boolean)color.equals((Object)sameColor2));
            Assert.assertTrue((String)"!color.equals(otherColor)", (!color.equals((Object)otherColor) ? 1 : 0) != 0);
        }
        finally {
            color.dispose();
            sameColor.dispose();
            sameColor2.dispose();
            otherColor.dispose();
        }
        color = new Color((Device)this.display, 1, 2, 3, 0);
        sameColor = new Color((Device)this.display, 1, 2, 3, 0);
        sameColor2 = new Color((Device)this.display, new RGB(1, 2, 3), 0);
        otherColor = new Color((Device)this.display, 5, 6, 7, 0);
        try {
            Assert.assertTrue((String)"!color.equals((Object)null)", (!color.equals(null) ? 1 : 0) != 0);
            Assert.assertTrue((String)"!color.equals((Color)null)", (!color.equals(null) ? 1 : 0) != 0);
            Assert.assertTrue((String)"color.equals(color)", (boolean)color.equals((Object)color));
            Assert.assertTrue((String)"color.equals(sameColor)", (boolean)color.equals((Object)sameColor));
            Assert.assertTrue((String)"color.equals(sameColor2)", (boolean)color.equals((Object)sameColor2));
            Assert.assertTrue((String)"!color.equals(otherColor)", (!color.equals((Object)otherColor) ? 1 : 0) != 0);
        }
        finally {
            color.dispose();
            sameColor.dispose();
            sameColor2.dispose();
            otherColor.dispose();
        }
    }

    @Test
    public void test_getBlue() {
        Color color = new Color((Device)this.display, 0, 0, 255);
        try {
            Assert.assertEquals((String)"color.getBlue()", (long)color.getBlue(), (long)255L);
        }
        finally {
            color.dispose();
        }
    }

    @Test
    public void test_getGreen() {
        Color color = new Color((Device)this.display, 0, 255, 0);
        try {
            Assert.assertEquals((String)"color.getGreen()", (long)color.getGreen(), (long)255L);
        }
        finally {
            color.dispose();
        }
    }

    @Test
    public void test_getRGB() {
        Color color = new Color((Device)this.display, 255, 255, 255);
        Assert.assertNotNull((Object)color.getRGB());
        Assert.assertEquals((Object)new RGB(255, 255, 255), (Object)color.getRGB());
        color.dispose();
    }

    @Test
    public void test_getRed() {
        Color color = new Color((Device)this.display, 255, 0, 0);
        try {
            Assert.assertEquals((String)"color.getRed()", (long)color.getRed(), (long)255L);
        }
        finally {
            color.dispose();
        }
    }

    @Test
    public void test_getAlpha() {
        Color color = new Color((Device)this.display, 255, 0, 0, 0);
        try {
            Assert.assertEquals((String)"color.getAlpha()", (long)color.getAlpha(), (long)0L);
        }
        finally {
            color.dispose();
        }
    }

    @Test
    public void test_hashCode() {
        Color color = new Color((Device)this.display, 12, 34, 56, 0);
        Color otherColor = new Color((Device)this.display, 12, 34, 56, 0);
        if (color.equals((Object)otherColor)) {
            Assert.assertEquals((String)"Hash codes of equal objects should be equal", (long)color.hashCode(), (long)otherColor.hashCode());
        }
        color.dispose();
        otherColor.dispose();
    }

    @Test
    public void test_isDisposed() {
        Color color = new Color((Device)this.display, 34, 67, 98, 0);
        try {
            Assert.assertTrue((String)"Color should not be disposed", (!color.isDisposed() ? 1 : 0) != 0);
        }
        finally {
            color.dispose();
            Assert.assertTrue((String)"Color should be disposed", (boolean)color.isDisposed());
        }
    }

    @Test
    public void test_toString() {
        Color color = new Color((Device)this.display, 0, 0, 255, 255);
        try {
            Assert.assertNotNull((Object)color.toString());
            Assert.assertTrue((color.toString().length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"Color {0, 0, 255, 255}", (Object)color.toString());
        }
        finally {
            color.dispose();
        }
    }
}

