/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.lang.invoke.LambdaMetafactory;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.test.Screenshots;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class Test_org_eclipse_swt_widgets_Display {
    private static boolean isRunningOnEclipseOrgHudson = "hudsonbuild".equalsIgnoreCase(System.getProperty("user.name")) || "genie.platform".equalsIgnoreCase(System.getProperty("user.name"));
    private static final boolean BUG_492569 = SwtTestUtil.isWindows && isRunningOnEclipseOrgHudson;
    @Rule
    public TestName testName = new TestName();
    boolean disposeExecRan;

    @Test
    public void test_Constructor() {
        Display disp = new Display();
        System.out.println("org.eclipse.swt.internal.DPIUtil.getDeviceZoom(): " + DPIUtil.getDeviceZoom());
        disp.dispose();
        if (SwtTestUtil.isGTK) {
            System.out.println("org.eclipse.swt.internal.gtk.version=" + System.getProperty("org.eclipse.swt.internal.gtk.version"));
        }
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_graphics_DeviceData() {
        Display disp = new Display(null);
        disp.dispose();
        disp = new Display(new DeviceData());
        disp.dispose();
    }

    @Test
    public void test_addFilterILorg_eclipse_swt_widgets_Listener() {
        boolean[] callbackReceived = new boolean[2];
        Listener listener = e -> {
            if (e.type == 21) {
                blArray[0] = true;
            } else if (e.type == 12) {
                blArray[1] = true;
            }
        };
        try (Display display = new Display();){
            try {
                display.addFilter(12, null);
                Assert.fail((String)"No exception thrown for addFilter with null argument");
            }
            catch (IllegalArgumentException e2) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for addFilter with null argument", 4, e2);
            }
            display.addFilter(21, listener);
        }
        Assert.assertTrue((boolean)callbackReceived[0]);
        Assert.assertFalse((boolean)callbackReceived[1]);
    }

    @Test
    public void test_addListenerILorg_eclipse_swt_widgets_Listener() {
        boolean[] callbackReceived = new boolean[2];
        Listener listener = e -> {
            if (e.type == 21) {
                blArray[0] = true;
            } else if (e.type == 12) {
                blArray[1] = true;
            }
        };
        try (Display display = new Display();){
            try {
                display.addListener(21, null);
                Assert.fail((String)"No exception thrown for addListener with null argument");
            }
            catch (IllegalArgumentException e2) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for addListener with null argument", 4, e2);
            }
            display.addListener(12, listener);
        }
        Assert.assertFalse((String)":a:", (boolean)callbackReceived[0]);
        Assert.assertTrue((String)":b:", (boolean)callbackReceived[1]);
        display = new Display();
        try {
            display.addListener(21, listener);
        }
        finally {
            display.close();
        }
        Assert.assertTrue((String)":c:", (boolean)callbackReceived[0]);
    }

    @Test
    public void test_asyncExecLjava_lang_Runnable() {
        Display display = new Display();
        try {
            display.asyncExec(() -> display.beep());
        }
        finally {
            display.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void test_asyncExecLjava_lang_Runnable_dispose() {
        display = new Display();
        try {
            this.disposeExecRan = false;
            display.asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(org.eclipse.swt.widgets.Display ), ()V)((Test_org_eclipse_swt_widgets_Display)this, (Display)display));
            if (true) ** GOTO lbl17
        }
        catch (Throwable var2_2) {
            ** while (!this.disposeExecRan)
        }
lbl-1000:
        // 1 sources

        {
            if (display.readAndDispatch()) continue;
            display.sleep();
            continue;
        }
lbl12:
        // 1 sources

        throw var2_2;
        do {
            if (display.readAndDispatch()) continue;
            display.sleep();
lbl17:
            // 3 sources

        } while (!this.disposeExecRan);
    }

    @Test
    public void test_beep() {
        Display display = new Display();
        try {
            display.beep();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_close() {
        Display display = new Display();
        display.close();
        Assert.assertTrue((boolean)display.isDisposed());
    }

    @Test
    public void test_disposeExecLjava_lang_Runnable() {
        Display testDisplay = new Display();
        this.disposeExecRan = false;
        testDisplay.disposeExec(() -> {
            boolean bl = this.disposeExecRan = true;
        });
        Assert.assertEquals((String)"Display should not be disposed", (Object)false, (Object)testDisplay.isDisposed());
        testDisplay.dispose();
        Assert.assertTrue((String)"Display should be disposed", (boolean)testDisplay.isDisposed());
        Assert.assertTrue((String)"DisposeExec Runnable did not run", (boolean)this.disposeExecRan);
    }

    @Test
    public void test_findDisplayLjava_lang_Thread() {
        Assert.assertNull((Object)Display.findDisplay((Thread)new Thread()));
        Display display = new Display();
        try {
            Assert.assertEquals((Object)display, (Object)Display.findDisplay((Thread)Thread.currentThread()));
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getActiveShell() {
        Display display = new Display();
        try {
            Shell shell = new Shell(display);
            shell.setText("test_getActiveShell");
            shell.open();
            Test_org_eclipse_swt_widgets_Display.drainEventQueue(display, 150);
            Assert.assertSame((Object)shell, (Object)display.getActiveShell());
            shell.dispose();
        }
        finally {
            display.dispose();
        }
    }

    private static void drainEventQueue(Display display, int millis) {
        if (millis == 0) {
            while (!display.isDisposed() && display.readAndDispatch()) {
            }
            return;
        }
        long end = System.currentTimeMillis() + (long)millis;
        while (!display.isDisposed() && System.currentTimeMillis() < end) {
            if (display.readAndDispatch()) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void test_getBounds() {
        Display display = new Display();
        try {
            Rectangle rect = display.getBounds();
            Assert.assertNotNull((Object)rect);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getClientArea() {
        Display display = new Display();
        try {
            Rectangle rect = display.getClientArea();
            Assert.assertNotNull((Object)rect);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getCurrent() {
        Display display = new Display();
        try {
            Assert.assertTrue((display.getThread() == Thread.currentThread() ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getCursorControl() {
        Display display = new Display();
        try {
            display.getCursorControl();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getCursorLocation() {
        Display display = new Display();
        try {
            Point pt = display.getCursorLocation();
            Assert.assertNotNull((Object)pt);
            Assert.assertTrue((pt.x >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((pt.y >= 0 ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getDefault() {
        Display display = new Display();
        try {
            Assert.assertNotNull((Object)Display.getDefault());
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getDismissalAlignment() {
        Display display = new Display();
        try {
            int alignment = display.getDismissalAlignment();
            Assert.assertTrue((String)"getDismissalAlignment should return SWT.LEFT or SWT.RIGHT", (alignment == 16384 || alignment == 131072 ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getDoubleClickTime() {
        Display display = new Display();
        try {
            int time = display.getDoubleClickTime();
            Assert.assertTrue((time > 0 ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getFocusControl() {
        Display display = new Display();
        try {
            display.getFocusControl();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getIconDepth() {
        Display display = new Display();
        try {
            int depth = display.getIconDepth();
            Assert.assertTrue((depth > 0 ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getMonitors() {
        Display display = new Display();
        Monitor[] monitors = display.getMonitors();
        Assert.assertNotNull((Object)monitors);
        Assert.assertTrue((String)"at least one monitor should be returned", (monitors.length >= 1 ? 1 : 0) != 0);
        int i = 0;
        while (i < monitors.length) {
            Assert.assertNotNull((String)("monitor at index " + i + " should not be null"), (Object)monitors[i]);
            ++i;
        }
        display.dispose();
    }

    @Test
    public void test_getPrimaryMonitor() {
        Display display = new Display();
        Monitor monitor = display.getPrimaryMonitor();
        Assert.assertNotNull((Object)monitor);
        display.dispose();
    }

    @Test
    public void test_getShells() {
        Display display = new Display();
        try {
            Shell shell1 = new Shell(display);
            Shell shell2 = new Shell(display);
            Assert.assertTrue((display.getShells().length == 2 ? 1 : 0) != 0);
            shell1.dispose();
            shell2.dispose();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getSyncThread() {
        Display display = new Display();
        try {
            boolean[] threadRan = new boolean[1];
            Thread nonUIThread = new Thread(() -> {
                Assert.assertNull((Object)display.getSyncThread());
                Thread invokingThread = Thread.currentThread();
                display.syncExec(() -> Assert.assertEquals((Object)invokingThread, (Object)display.getSyncThread()));
                boolean[] asyncExecRan = new boolean[1];
                display.asyncExec(() -> {
                    Assert.assertNull((Object)display.getSyncThread());
                    blArray[0] = true;
                });
                try {
                    while (!asyncExecRan[0]) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {}
                blArray[0] = true;
                display.wake();
            });
            nonUIThread.start();
            while (!threadRan[0]) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getSystemColorI() {
        Display display = new Display();
        try {
            int[] colorIds = new int[]{17, 18, 19, 20, 22, 23, 21, 24, 25, 26, 27};
            int i = 0;
            while (i < colorIds.length) {
                Assert.assertNotNull((Object)display.getSystemColor(colorIds[i]));
                ++i;
            }
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getSystemFont() {
        Display display = new Display();
        try {
            Font font = display.getSystemFont();
            Assert.assertNotNull((Object)font);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getThread() {
        Display display = new Display();
        try {
            Assert.assertTrue((display.getThread() == Thread.currentThread() ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_mapLorg_eclipse_swt_widgets_ControlLorg_eclipse_swt_widgets_ControlII() {
        Display display = new Display();
        try {
            Shell shell = new Shell(display, 8);
            Button button1 = new Button((Composite)shell, 8);
            button1.setBounds(0, 0, 100, 100);
            Button button2 = new Button((Composite)shell, 8);
            button2.setBounds(200, 100, 100, 100);
            shell.setBounds(0, 0, 400, 400);
            shell.open();
            Point shellOffset = shell.getLocation();
            Point result = display.map((Control)button1, (Control)button2, 0, 0);
            Assert.assertEquals((Object)new Point(-200, -100), (Object)result);
            result = display.map((Control)button1, (Control)button2, -10, -20);
            Assert.assertEquals((Object)new Point(-210, -120), (Object)result);
            result = display.map((Control)button1, (Control)button2, 30, 40);
            Assert.assertEquals((Object)new Point(-170, -60), (Object)result);
            result = display.map((Control)button2, (Control)button1, 0, 0);
            Assert.assertEquals((Object)new Point(200, 100), (Object)result);
            result = display.map((Control)button2, (Control)button1, -5, -15);
            Assert.assertEquals((Object)new Point(195, 85), (Object)result);
            result = display.map((Control)button2, (Control)button1, 25, 35);
            Assert.assertEquals((Object)new Point(225, 135), (Object)result);
            result = display.map(null, (Control)button2, 0, 0);
            Assert.assertEquals((Object)new Point(-200 - shellOffset.x, -100 - shellOffset.y), (Object)result);
            result = display.map(null, (Control)button2, -2, -4);
            Assert.assertEquals((Object)new Point(-202 - shellOffset.x, -104 - shellOffset.y), (Object)result);
            result = display.map(null, (Control)button2, 6, 8);
            Assert.assertEquals((Object)new Point(-194 - shellOffset.x, -92 - shellOffset.y), (Object)result);
            result = display.map((Control)button2, null, 0, 0);
            Assert.assertEquals((Object)new Point(shellOffset.x + 200, shellOffset.y + 100), (Object)result);
            result = display.map((Control)button2, null, -3, -6);
            Assert.assertEquals((Object)new Point(shellOffset.x + 197, shellOffset.y + 94), (Object)result);
            result = display.map((Control)button2, null, 9, 12);
            Assert.assertEquals((Object)new Point(shellOffset.x + 209, shellOffset.y + 112), (Object)result);
            Shell shellMapTest1 = new Shell(display, 8);
            Button buttonTest1 = new Button((Composite)shellMapTest1, 8);
            buttonTest1.setBounds(0, 0, 100, 100);
            shellMapTest1.setBounds(200, 200, 400, 400);
            shellMapTest1.open();
            Shell overlayShell1 = new Shell(shellMapTest1, 8);
            overlayShell1.setBounds(shellMapTest1.getBounds());
            Rectangle r = buttonTest1.getBounds();
            result = display.map((Control)buttonTest1, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShell1, result);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            Shell shellMapTest2 = new Shell(display, 8);
            Button buttonTest2 = new Button((Composite)shellMapTest2, 8);
            buttonTest2.setBounds(0, 0, 100, 100);
            shellMapTest2.setBounds(200, 200, 400, 400);
            shellMapTest2.open();
            Shell overlayShell2 = new Shell(display, 8);
            overlayShell2.setBounds(shellMapTest2.getBounds());
            r = buttonTest2.getBounds();
            result = display.map((Control)buttonTest2, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShell2, result.x, result.y);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            Shell shellMapTestRtoL1 = new Shell(display, 8);
            shellMapTestRtoL1.setOrientation(0x4000000);
            Button buttonTestRtoL1 = new Button((Composite)shellMapTestRtoL1, 8);
            buttonTestRtoL1.setBounds(0, 0, 100, 100);
            shellMapTestRtoL1.setBounds(200, 200, 400, 400);
            shellMapTestRtoL1.open();
            Shell overlayShellRtoL1 = new Shell(shellMapTestRtoL1, 8);
            overlayShellRtoL1.setOrientation(0x4000000);
            overlayShellRtoL1.setBounds(shellMapTestRtoL1.getBounds());
            r = buttonTestRtoL1.getBounds();
            result = display.map((Control)buttonTestRtoL1, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShellRtoL1, result);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            Shell shellMapTestRtoL2 = new Shell(display, 8);
            shellMapTestRtoL2.setOrientation(0x4000000);
            Button buttonTestRtoL2 = new Button((Composite)shellMapTestRtoL2, 8);
            buttonTestRtoL2.setBounds(0, 0, 100, 100);
            shellMapTestRtoL2.setBounds(200, 200, 400, 400);
            shellMapTestRtoL2.open();
            Shell overlayShellRtoL2 = new Shell(display, 8);
            overlayShellRtoL2.setOrientation(0x4000000);
            overlayShellRtoL2.setBounds(shellMapTestRtoL2.getBounds());
            r = buttonTestRtoL2.getBounds();
            result = display.map((Control)buttonTestRtoL2, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShellRtoL2, result.x, result.y);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            button1.dispose();
            buttonTest1.dispose();
            buttonTest2.dispose();
            shellMapTest1.dispose();
            shellMapTest2.dispose();
            overlayShell1.dispose();
            overlayShell2.dispose();
            buttonTestRtoL1.dispose();
            buttonTestRtoL2.dispose();
            shellMapTestRtoL1.dispose();
            shellMapTestRtoL2.dispose();
            overlayShellRtoL1.dispose();
            overlayShellRtoL2.dispose();
            try {
                result = display.map((Control)button1, (Control)button2, 0, 0);
                Assert.fail((String)"No exception thrown for map from control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map from control being disposed", 5, e);
            }
            try {
                result = display.map((Control)button2, (Control)button1, 0, 0);
                Assert.fail((String)"No exception thrown for map to control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map to control being disposed", 5, e);
            }
            shell.dispose();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_mapLorg_eclipse_swt_widgets_ControlLorg_eclipse_swt_widgets_ControlIIII() {
        Display display = new Display();
        try {
            Shell shell = new Shell(display, 8);
            Button button1 = new Button((Composite)shell, 8);
            button1.setBounds(0, 0, 100, 100);
            Button button2 = new Button((Composite)shell, 8);
            button2.setBounds(200, 100, 100, 100);
            shell.setBounds(0, 0, 400, 400);
            shell.open();
            Point shellOffset = shell.getLocation();
            Rectangle result = display.map((Control)button1, (Control)button2, 0, 0, 100, 100);
            Assert.assertEquals((Object)new Rectangle(-200, -100, 100, 100), (Object)result);
            result = display.map((Control)button1, (Control)button2, -10, -20, 130, 140);
            Assert.assertEquals((Object)new Rectangle(-210, -120, 130, 140), (Object)result);
            result = display.map((Control)button1, (Control)button2, 50, 60, 170, 180);
            Assert.assertEquals((Object)new Rectangle(-150, -40, 170, 180), (Object)result);
            result = display.map((Control)button2, (Control)button1, 0, 0, 100, 100);
            Assert.assertEquals((Object)new Rectangle(200, 100, 100, 100), (Object)result);
            result = display.map((Control)button2, (Control)button1, -5, -15, 125, 135);
            Assert.assertEquals((Object)new Rectangle(195, 85, 125, 135), (Object)result);
            result = display.map((Control)button2, (Control)button1, 45, 55, 165, 175);
            Assert.assertEquals((Object)new Rectangle(245, 155, 165, 175), (Object)result);
            result = display.map(null, (Control)button2, 0, 0, 100, 100);
            Assert.assertEquals((Object)new Rectangle(-200 - shellOffset.x, -100 - shellOffset.y, 100, 100), (Object)result);
            result = display.map(null, (Control)button2, -2, -4, 106, 108);
            Assert.assertEquals((Object)new Rectangle(-202 - shellOffset.x, -104 - shellOffset.y, 106, 108), (Object)result);
            result = display.map(null, (Control)button2, 10, 12, 114, 116);
            Assert.assertEquals((Object)new Rectangle(-190 - shellOffset.x, -88 - shellOffset.y, 114, 116), (Object)result);
            result = display.map((Control)button2, null, 0, 0, 100, 100);
            Assert.assertEquals((Object)new Rectangle(shellOffset.x + 200, shellOffset.y + 100, 100, 100), (Object)result);
            result = display.map((Control)button2, null, -3, -6, 109, 112);
            Assert.assertEquals((Object)new Rectangle(shellOffset.x + 197, shellOffset.y + 94, 109, 112), (Object)result);
            result = display.map((Control)button2, null, 15, 18, 121, 124);
            Assert.assertEquals((Object)new Rectangle(shellOffset.x + 215, shellOffset.y + 118, 121, 124), (Object)result);
            Shell shellMapTest1 = new Shell(display, 8);
            Button buttonTest1 = new Button((Composite)shellMapTest1, 8);
            buttonTest1.setBounds(0, 0, 100, 100);
            shellMapTest1.setBounds(200, 200, 400, 400);
            shellMapTest1.open();
            Shell overlayShell1 = new Shell(shellMapTest1, 8);
            overlayShell1.setBounds(shellMapTest1.getBounds());
            Rectangle r = buttonTest1.getBounds();
            result = display.map((Control)buttonTest1, null, r);
            result = display.map(null, (Control)overlayShell1, result);
            Assert.assertEquals((Object)r, (Object)result);
            Shell shellMapTest2 = new Shell(display, 8);
            Button buttonTest2 = new Button((Composite)shellMapTest2, 8);
            buttonTest2.setBounds(0, 0, 100, 100);
            shellMapTest2.setBounds(200, 200, 400, 400);
            shellMapTest2.open();
            Shell overlayShell2 = new Shell(display, 8);
            overlayShell2.setBounds(shellMapTest2.getBounds());
            r = buttonTest2.getBounds();
            result = display.map((Control)buttonTest2, null, r);
            result = display.map(null, (Control)overlayShell2, result);
            Assert.assertEquals((Object)r, (Object)result);
            Shell shellMapTestRtoL1 = new Shell(display, 8);
            shellMapTestRtoL1.setOrientation(0x4000000);
            Button buttonTestRtoL1 = new Button((Composite)shellMapTestRtoL1, 8);
            buttonTestRtoL1.setBounds(0, 0, 100, 100);
            shellMapTestRtoL1.setBounds(200, 200, 400, 400);
            shellMapTestRtoL1.open();
            Shell overlayShellRtoL1 = new Shell(shellMapTestRtoL1, 8);
            overlayShellRtoL1.setOrientation(0x4000000);
            overlayShellRtoL1.setBounds(shellMapTestRtoL1.getBounds());
            r = buttonTest1.getBounds();
            result = display.map((Control)buttonTestRtoL1, null, r);
            result = display.map(null, (Control)overlayShellRtoL1, result);
            Assert.assertEquals((Object)r, (Object)result);
            Shell shellMapTestRtoL2 = new Shell(display, 8);
            shellMapTestRtoL2.setOrientation(0x4000000);
            Button buttonTestRtoL2 = new Button((Composite)shellMapTestRtoL2, 8);
            buttonTestRtoL2.setBounds(0, 0, 100, 100);
            shellMapTestRtoL2.setBounds(200, 200, 400, 400);
            shellMapTestRtoL2.open();
            Shell overlayShellRtoL2 = new Shell(display, 8);
            overlayShellRtoL2.setOrientation(0x4000000);
            overlayShellRtoL2.setBounds(shellMapTestRtoL2.getBounds());
            r = buttonTestRtoL2.getBounds();
            result = display.map((Control)buttonTestRtoL2, null, r);
            result = display.map(null, (Control)overlayShellRtoL2, result);
            Assert.assertEquals((Object)r, (Object)result);
            button1.dispose();
            buttonTest1.dispose();
            buttonTest2.dispose();
            shellMapTest1.dispose();
            shellMapTest2.dispose();
            overlayShell1.dispose();
            overlayShell2.dispose();
            buttonTestRtoL1.dispose();
            buttonTestRtoL2.dispose();
            shellMapTestRtoL1.dispose();
            shellMapTestRtoL2.dispose();
            overlayShellRtoL1.dispose();
            overlayShellRtoL2.dispose();
            try {
                result = display.map((Control)button1, (Control)button2, 0, 0, 100, 100);
                Assert.fail((String)"No exception thrown for map from control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map from control being disposed", 5, e);
            }
            try {
                result = display.map((Control)button2, (Control)button1, 0, 0, 100, 100);
                Assert.fail((String)"No exception thrown for map to control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map to control being disposed", 5, e);
            }
            shell.dispose();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_mapLorg_eclipse_swt_widgets_ControlLorg_eclipse_swt_widgets_ControlLorg_eclipse_swt_graphics_Point() {
        Display display = new Display();
        try {
            Shell shell = new Shell(display, 8);
            Button button1 = new Button((Composite)shell, 8);
            button1.setBounds(0, 0, 100, 100);
            Button button2 = new Button((Composite)shell, 8);
            button2.setBounds(200, 100, 100, 100);
            shell.setBounds(0, 0, 400, 400);
            shell.open();
            Point point = new Point(0, 0);
            Point shellOffset = shell.getLocation();
            Point result = display.map((Control)button1, (Control)button2, point);
            Assert.assertEquals((Object)new Point(-200, -100), (Object)result);
            result = display.map((Control)button1, (Control)button2, new Point(-10, -20));
            Assert.assertEquals((Object)new Point(-210, -120), (Object)result);
            result = display.map((Control)button1, (Control)button2, new Point(30, 40));
            Assert.assertEquals((Object)new Point(-170, -60), (Object)result);
            result = display.map((Control)button2, (Control)button1, point);
            Assert.assertEquals((Object)new Point(200, 100), (Object)result);
            result = display.map((Control)button2, (Control)button1, new Point(-5, -15));
            Assert.assertEquals((Object)new Point(195, 85), (Object)result);
            result = display.map((Control)button2, (Control)button1, new Point(25, 35));
            Assert.assertEquals((Object)new Point(225, 135), (Object)result);
            result = display.map(null, (Control)button2, point);
            Assert.assertEquals((Object)new Point(-200 - shellOffset.x, -100 - shellOffset.y), (Object)result);
            result = display.map(null, (Control)button2, new Point(-2, -4));
            Assert.assertEquals((Object)new Point(-202 - shellOffset.x, -104 - shellOffset.y), (Object)result);
            result = display.map(null, (Control)button2, new Point(6, 8));
            Assert.assertEquals((Object)new Point(-194 - shellOffset.x, -92 - shellOffset.y), (Object)result);
            result = display.map((Control)button2, null, point);
            Assert.assertEquals((Object)new Point(shellOffset.x + 200, shellOffset.y + 100), (Object)result);
            result = display.map((Control)button2, null, new Point(-3, -6));
            Assert.assertEquals((Object)new Point(shellOffset.x + 197, shellOffset.y + 94), (Object)result);
            result = display.map((Control)button2, null, new Point(9, 12));
            Assert.assertEquals((Object)new Point(shellOffset.x + 209, shellOffset.y + 112), (Object)result);
            Shell shellMapTest1 = new Shell(display, 8);
            Button buttonTest1 = new Button((Composite)shellMapTest1, 8);
            buttonTest1.setBounds(0, 0, 100, 100);
            shellMapTest1.setBounds(200, 200, 400, 400);
            shellMapTest1.open();
            Shell overlayShell1 = new Shell(shellMapTest1, 8);
            overlayShell1.setBounds(shellMapTest1.getBounds());
            Rectangle r = buttonTest1.getBounds();
            result = display.map((Control)buttonTest1, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShell1, result);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            Shell shellMapTest2 = new Shell(display, 8);
            Button buttonTest2 = new Button((Composite)shellMapTest2, 8);
            buttonTest2.setBounds(0, 0, 100, 100);
            shellMapTest2.setBounds(200, 200, 400, 400);
            shellMapTest2.open();
            Shell overlayShell2 = new Shell(display, 8);
            overlayShell2.setBounds(shellMapTest2.getBounds());
            r = buttonTest2.getBounds();
            result = display.map((Control)buttonTest2, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShell2, result.x, result.y);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            Shell shellMapTestRtoL1 = new Shell(display, 8);
            shellMapTestRtoL1.setOrientation(0x4000000);
            Button buttonTestRtoL1 = new Button((Composite)shellMapTestRtoL1, 8);
            buttonTestRtoL1.setBounds(0, 0, 100, 100);
            shellMapTestRtoL1.setBounds(200, 200, 400, 400);
            shellMapTestRtoL1.open();
            Shell overlayShellRtoL1 = new Shell(shellMapTestRtoL1, 8);
            overlayShellRtoL1.setOrientation(0x4000000);
            overlayShellRtoL1.setBounds(shellMapTestRtoL1.getBounds());
            r = buttonTestRtoL1.getBounds();
            result = display.map((Control)buttonTestRtoL1, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShellRtoL1, result);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            Shell shellMapTestRtoL2 = new Shell(display, 8);
            shellMapTestRtoL2.setOrientation(0x4000000);
            Button buttonTestRtoL2 = new Button((Composite)shellMapTestRtoL2, 8);
            buttonTestRtoL2.setBounds(0, 0, 100, 100);
            shellMapTestRtoL2.setBounds(200, 200, 400, 400);
            shellMapTestRtoL2.open();
            Shell overlayShellRtoL2 = new Shell(display, 8);
            overlayShellRtoL2.setOrientation(0x4000000);
            overlayShellRtoL2.setBounds(shellMapTestRtoL2.getBounds());
            r = buttonTestRtoL2.getBounds();
            result = display.map((Control)buttonTestRtoL2, null, new Point(r.x, r.y));
            result = display.map(null, (Control)overlayShellRtoL2, result.x, result.y);
            Assert.assertEquals((Object)new Point(r.x, r.y), (Object)result);
            button1.dispose();
            buttonTest1.dispose();
            buttonTest2.dispose();
            shellMapTest1.dispose();
            shellMapTest2.dispose();
            overlayShell1.dispose();
            overlayShell2.dispose();
            buttonTestRtoL1.dispose();
            buttonTestRtoL2.dispose();
            shellMapTestRtoL1.dispose();
            shellMapTestRtoL2.dispose();
            overlayShellRtoL1.dispose();
            overlayShellRtoL2.dispose();
            try {
                result = display.map((Control)button1, (Control)button2, point);
                Assert.fail((String)"No exception thrown for map from control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map from control being disposed", 5, e);
            }
            try {
                result = display.map((Control)button2, (Control)button1, point);
                Assert.fail((String)"No exception thrown for map to control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map to control being disposed", 5, e);
            }
            try {
                result = display.map((Control)button2, (Control)button1, null);
                Assert.fail((String)"No exception thrown for null point");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for point being null", 4, e);
            }
            shell.dispose();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_mapLorg_eclipse_swt_widgets_ControlLorg_eclipse_swt_widgets_ControlLorg_eclipse_swt_graphics_Rectangle() {
        Display display = new Display();
        try {
            Shell shell = new Shell(display, 8);
            Button button1 = new Button((Composite)shell, 8);
            button1.setBounds(0, 0, 100, 100);
            Button button2 = new Button((Composite)shell, 8);
            button2.setBounds(200, 100, 100, 100);
            shell.setBounds(0, 0, 400, 400);
            shell.open();
            Rectangle rect = new Rectangle(0, 0, 100, 100);
            Point shellOffset = shell.getLocation();
            Rectangle result = display.map((Control)button1, (Control)button2, rect);
            Assert.assertEquals((Object)new Rectangle(-200, -100, 100, 100), (Object)result);
            result = display.map((Control)button1, (Control)button2, new Rectangle(-10, -20, 130, 140));
            Assert.assertEquals((Object)new Rectangle(-210, -120, 130, 140), (Object)result);
            result = display.map((Control)button1, (Control)button2, new Rectangle(50, 60, 170, 180));
            Assert.assertEquals((Object)new Rectangle(-150, -40, 170, 180), (Object)result);
            result = display.map((Control)button2, (Control)button1, rect);
            Assert.assertEquals((Object)new Rectangle(200, 100, 100, 100), (Object)result);
            result = display.map((Control)button2, (Control)button1, new Rectangle(-5, -15, 125, 135));
            Assert.assertEquals((Object)new Rectangle(195, 85, 125, 135), (Object)result);
            result = display.map((Control)button2, (Control)button1, new Rectangle(45, 55, 165, 175));
            Assert.assertEquals((Object)new Rectangle(245, 155, 165, 175), (Object)result);
            result = display.map(null, (Control)button2, rect);
            Assert.assertEquals((Object)new Rectangle(-200 - shellOffset.x, -100 - shellOffset.y, 100, 100), (Object)result);
            result = display.map(null, (Control)button2, new Rectangle(-2, -4, 106, 108));
            Assert.assertEquals((Object)new Rectangle(-202 - shellOffset.x, -104 - shellOffset.y, 106, 108), (Object)result);
            result = display.map(null, (Control)button2, new Rectangle(10, 12, 114, 116));
            Assert.assertEquals((Object)new Rectangle(-190 - shellOffset.x, -88 - shellOffset.y, 114, 116), (Object)result);
            result = display.map((Control)button2, null, rect);
            Assert.assertEquals((Object)new Rectangle(shellOffset.x + 200, shellOffset.y + 100, 100, 100), (Object)result);
            result = display.map((Control)button2, null, new Rectangle(-3, -6, 109, 112));
            Assert.assertEquals((Object)new Rectangle(shellOffset.x + 197, shellOffset.y + 94, 109, 112), (Object)result);
            result = display.map((Control)button2, null, new Rectangle(15, 18, 121, 124));
            Assert.assertEquals((Object)new Rectangle(shellOffset.x + 215, shellOffset.y + 118, 121, 124), (Object)result);
            Shell shellMapTest1 = new Shell(display, 8);
            Button buttonTest1 = new Button((Composite)shellMapTest1, 8);
            buttonTest1.setBounds(0, 0, 100, 100);
            shellMapTest1.setBounds(200, 200, 400, 400);
            shellMapTest1.open();
            Shell overlayShell1 = new Shell(shellMapTest1, 8);
            overlayShell1.setBounds(shellMapTest1.getBounds());
            Rectangle r = buttonTest1.getBounds();
            result = display.map((Control)buttonTest1, null, r);
            result = display.map(null, (Control)overlayShell1, result);
            Assert.assertEquals((Object)r, (Object)result);
            Shell shellMapTest2 = new Shell(display, 8);
            Button buttonTest2 = new Button((Composite)shellMapTest2, 8);
            buttonTest2.setBounds(0, 0, 100, 100);
            shellMapTest2.setBounds(200, 200, 400, 400);
            shellMapTest2.open();
            Shell overlayShell2 = new Shell(display, 8);
            overlayShell2.setBounds(shellMapTest2.getBounds());
            r = buttonTest2.getBounds();
            result = display.map((Control)buttonTest2, null, r);
            result = display.map(null, (Control)overlayShell2, result);
            Assert.assertEquals((Object)r, (Object)result);
            Shell shellMapTestRtoL1 = new Shell(display, 8);
            shellMapTestRtoL1.setOrientation(0x4000000);
            Button buttonTestRtoL1 = new Button((Composite)shellMapTestRtoL1, 8);
            buttonTestRtoL1.setBounds(0, 0, 100, 100);
            shellMapTestRtoL1.setBounds(200, 200, 400, 400);
            shellMapTestRtoL1.open();
            Shell overlayShellRtoL1 = new Shell(shellMapTestRtoL1, 8);
            overlayShellRtoL1.setOrientation(0x4000000);
            overlayShellRtoL1.setBounds(shellMapTestRtoL1.getBounds());
            r = buttonTestRtoL1.getBounds();
            result = display.map((Control)buttonTestRtoL1, null, r);
            result = display.map(null, (Control)overlayShellRtoL1, result);
            Assert.assertEquals((Object)r, (Object)result);
            Shell shellMapTestRtoL2 = new Shell(display, 8);
            shellMapTestRtoL2.setOrientation(0x4000000);
            Button buttonTestRtoL2 = new Button((Composite)shellMapTestRtoL2, 8);
            buttonTestRtoL2.setBounds(0, 0, 100, 100);
            shellMapTestRtoL2.setBounds(200, 200, 400, 400);
            shellMapTestRtoL2.open();
            Shell overlayShellRtoL2 = new Shell(display, 8);
            overlayShellRtoL2.setOrientation(0x4000000);
            overlayShellRtoL2.setBounds(shellMapTestRtoL2.getBounds());
            r = buttonTestRtoL2.getBounds();
            result = display.map((Control)buttonTestRtoL2, null, r);
            result = display.map(null, (Control)overlayShellRtoL2, result);
            Assert.assertEquals((Object)r, (Object)result);
            button1.dispose();
            buttonTest1.dispose();
            buttonTest2.dispose();
            shellMapTest1.dispose();
            shellMapTest2.dispose();
            overlayShell1.dispose();
            overlayShell2.dispose();
            buttonTestRtoL1.dispose();
            buttonTestRtoL2.dispose();
            shellMapTestRtoL1.dispose();
            shellMapTestRtoL2.dispose();
            overlayShellRtoL1.dispose();
            overlayShellRtoL2.dispose();
            try {
                result = display.map((Control)button1, (Control)button2, rect);
                Assert.fail((String)"No exception thrown for map from control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map from control being disposed", 5, e);
            }
            try {
                result = display.map((Control)button2, (Control)button1, rect);
                Assert.fail((String)"No exception thrown for map to control being disposed");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for map to control being disposed", 5, e);
            }
            try {
                result = display.map((Control)button2, (Control)button1, null);
                Assert.fail((String)"No exception thrown for null point");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for rectangle being null", 4, e);
            }
            shell.dispose();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_postLorg_eclipse_swt_widgets_Event() {
        if (SwtTestUtil.isGTK || SwtTestUtil.isCocoa) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_postLorg_eclipse_swt_widgets_Event(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Display)");
            }
            return;
        }
        Display display = new Display();
        try {
            try {
                display.post(null);
                Assert.fail((String)"No exception thrown for post with null argument");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for post with null argument", 4, e);
            }
            Shell shell = new Shell(display, 8);
            shell.setBounds(display.getBounds());
            shell.open();
            Event event = new Event();
            event.type = 1;
            event.keyCode = -1;
            Assert.assertTrue((String)"Display#post failed, probably because screen is not rendered (bug 407862)", (boolean)display.post(event));
            event = new Event();
            event.type = 2;
            Assert.assertTrue((boolean)display.post(event));
            event.type = 1;
            event.keyCode = 131072;
            shell.setFocus();
            Assert.assertTrue((boolean)display.post(event));
            event.type = 2;
            shell.setFocus();
            Assert.assertTrue((boolean)display.post(event));
            event = new Event();
            event.type = 5;
            Rectangle bounds = shell.getBounds();
            event.x = bounds.x + bounds.width / 2;
            event.y = bounds.y + bounds.height / 2;
            shell.setFocus();
            Assert.assertTrue((boolean)display.post(event));
            event = new Event();
            event.type = 3;
            Assert.assertFalse((boolean)display.post(event));
            event.button = 1;
            shell.setFocus();
            Assert.assertTrue((boolean)display.post(event));
            event = new Event();
            event.type = 4;
            Assert.assertFalse((boolean)display.post(event));
            event.button = 1;
            shell.setFocus();
            Assert.assertTrue((boolean)display.post(event));
            event = new Event();
            event.type = 8;
            Assert.assertFalse((boolean)display.post(event));
            Test_org_eclipse_swt_widgets_Display.drainEventQueue(display, 500);
            shell.dispose();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_readAndDispatch() {
    }

    @Test
    public void test_removeFilterILorg_eclipse_swt_widgets_Listener() {
        boolean[] callbackReceived = new boolean[2];
        Listener listener = e -> {
            if (e.type == 21) {
                blArray[0] = true;
            } else if (e.type == 12) {
                blArray[1] = true;
            }
        };
        try (Display display = new Display();){
            try {
                display.removeFilter(12, null);
                Assert.fail((String)"No exception thrown for removeFilter with null argument");
            }
            catch (IllegalArgumentException e2) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for removeFilter with null argument", 4, e2);
            }
            display.addFilter(21, listener);
            display.removeFilter(21, listener);
        }
        Assert.assertFalse((boolean)callbackReceived[0]);
        Assert.assertFalse((boolean)callbackReceived[1]);
    }

    @Test
    public void test_removeListenerILorg_eclipse_swt_widgets_Listener() {
        boolean[] callbackReceived = new boolean[2];
        Listener listener = e -> {
            if (e.type == 21) {
                blArray[0] = true;
            } else if (e.type == 12) {
                blArray[1] = true;
            }
        };
        try (Display display = new Display();){
            try {
                display.removeListener(21, null);
                Assert.fail((String)"No exception thrown for removeListener with null argument");
            }
            catch (IllegalArgumentException e2) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for removeListener with null argument", 4, e2);
            }
            display.addListener(12, listener);
            display.removeListener(12, listener);
        }
        Assert.assertFalse((boolean)callbackReceived[0]);
        Assert.assertFalse((boolean)callbackReceived[1]);
    }

    @Test
    public void test_setAppNameLjava_lang_String() {
        Display.setAppName((String)"My Application Name");
    }

    @Test
    public void test_setCursorLocationII() {
        Display display = new Display();
        try {
            Point location = new Point(100, 100);
            display.setCursorLocation(location.x, location.y);
            Test_org_eclipse_swt_widgets_Display.drainEventQueue(display, 150);
            Screenshots.takeScreenshot(this.getClass(), (String)this.testName.getMethodName());
            Point actual = display.getCursorLocation();
            if (!BUG_492569) {
                Assert.assertEquals((Object)location, (Object)actual);
            } else {
                System.out.println(String.valueOf(this.getClass().getName()) + "#" + this.testName.getMethodName() + ": actual == " + actual);
            }
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_setCursorLocationLorg_eclipse_swt_graphics_Point() {
        Display display = new Display();
        try {
            Point location = new Point(100, 50);
            display.setCursorLocation(location);
            try {
                display.setCursorLocation(null);
                Assert.fail((String)"No exception thrown for null argument");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for setCursorLocation with null argument", 4, e);
            }
            Test_org_eclipse_swt_widgets_Display.drainEventQueue(display, 150);
            Screenshots.takeScreenshot(this.getClass(), (String)this.testName.getMethodName());
            Point actual = display.getCursorLocation();
            if (!BUG_492569) {
                Assert.assertEquals((Object)location, (Object)actual);
            } else {
                System.out.println(String.valueOf(this.getClass().getName()) + "#" + this.testName.getMethodName() + ": actual == " + actual);
            }
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_setDataLjava_lang_Object() {
        Display display = new Display();
        try {
            display.setData((Object)10);
            Integer i = (Integer)display.getData();
            Assert.assertNotNull((Object)i);
            Assert.assertTrue((boolean)i.equals(10));
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_setDataLjava_lang_StringLjava_lang_Object() {
        Display display = new Display();
        try {
            display.setData("Integer", (Object)10);
            display.setData("String", (Object)"xyz");
            Integer i = (Integer)display.getData("Integer");
            Assert.assertNotNull((Object)i);
            Assert.assertTrue((boolean)i.equals(10));
            String s = (String)display.getData("String");
            Assert.assertNotNull((Object)s);
            Assert.assertTrue((boolean)s.equals("xyz"));
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_setSynchronizerLorg_eclipse_swt_widgets_Synchronizer() {
        Display display = new Display();
        boolean[] asyncExec0Ran = new boolean[1];
        boolean[] asyncExec1Ran = new boolean[1];
        try {
            try {
                display.setSynchronizer(null);
                Assert.fail((String)"No exception thrown for post with null argument");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for set synchronizer with null argument", 4, e);
            }
            class MySynchronizer
            extends Synchronizer {
                boolean invoked;

                MySynchronizer(Display d) {
                    super(d);
                    this.invoked = false;
                }

                protected void asyncExec(Runnable runnable) {
                    this.invoked = true;
                    super.asyncExec(runnable);
                }
            }
            MySynchronizer mySynchronizer = new MySynchronizer(display);
            display.asyncExec(() -> {
                boolean bl = blArray[0] = true;
            });
            display.setSynchronizer((Synchronizer)mySynchronizer);
            display.asyncExec(() -> {
                boolean bl = blArray[0] = true;
            });
            Assert.assertFalse((boolean)asyncExec0Ran[0]);
            Assert.assertFalse((boolean)asyncExec1Ran[0]);
            while (display.readAndDispatch()) {
            }
            Assert.assertTrue((boolean)mySynchronizer.invoked);
            Assert.assertTrue((boolean)asyncExec0Ran[0]);
            Assert.assertTrue((boolean)asyncExec1Ran[0]);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_sleep() {
        final Display display = new Display();
        try {
            while (display.readAndDispatch()) {
            }
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    display.wake();
                }
            };
            thread.start();
            boolean eventQueued = display.sleep();
            while (display.readAndDispatch()) {
            }
            thread = new Thread(){

                @Override
                public void run() {
                    try {
                        2.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    display.syncExec(() -> {
                        Shell s = new Shell(display);
                        s.open();
                        s.dispose();
                    });
                }
            };
            thread.start();
            eventQueued = display.sleep();
            Assert.assertTrue((boolean)eventQueued);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_syncExecLjava_lang_Runnable() {
        Display display = new Display();
        try {
            display.syncExec(() -> display.beep());
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_syncExecLjava_lang_Runnable_dispose() {
        Display display = new Display();
        try {
            display.syncExec(() -> display.dispose());
        }
        finally {
            Assert.assertTrue((boolean)display.isDisposed());
        }
    }

    @Test
    public void test_timerExecILjava_lang_Runnable() {
        Display display = new Display();
        try {
            boolean[] timerExecRan = new boolean[1];
            boolean[] threadRan = new boolean[1];
            try {
                display.timerExec(0, null);
                Assert.fail((String)"No exception thrown for timerExec with null runnable");
            }
            catch (IllegalArgumentException e) {
                SwtTestUtil.assertSWTProblem("Incorrect exception thrown for timerExec with null runnable", 4, e);
            }
            display.timerExec(-100, () -> {
                boolean bl = blArray[0] = true;
            });
            long startTime = System.currentTimeMillis();
            display.timerExec(3000, () -> {
                long endTime = System.currentTimeMillis();
                if (endTime < startTime + 3000L) {
                    System.out.println("Display.timerExec ran early " + (startTime + 3000L - endTime));
                }
                blArray[0] = true;
            });
            while (!threadRan[0]) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            Assert.assertFalse((String)"< 0 ms timer did execute", (boolean)timerExecRan[0]);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_update() {
        Display display = new Display();
        try {
            display.update();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_wake() {
    }

    @Test
    public void test_getDPI() {
        Display display = new Display();
        try {
            Point p = display.getDPI();
            Assert.assertTrue((String)"horizontal DPI not greater than zero", (p.x > 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"vertical DPI not greater than zero", (p.y > 0 ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getDepth() {
        Display display = new Display();
        try {
            int d = display.getDepth();
            Assert.assertTrue((String)"depth not greater than zero", (d > 0 ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getFontListLjava_lang_StringZ() {
        Display display = new Display();
        try {
            FontData[] scalable = display.getFontList(null, true);
            FontData[] non_scalable = display.getFontList(null, false);
            Assert.assertTrue((String)"no fonts detected", (scalable.length + non_scalable.length > 0 ? 1 : 0) != 0);
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_getWarnings() {
        Display display = new Display();
        try {
            display.getWarnings();
        }
        finally {
            display.dispose();
        }
    }

    @Test
    public void test_isDisposed() {
        Display disp = new Display();
        Assert.assertFalse((boolean)disp.isDisposed());
        disp.dispose();
        Assert.assertTrue((boolean)disp.isDisposed());
    }

    @Test
    public void test_setWarningsZ() {
        Display display = new Display();
        try {
            display.setWarnings(true);
            display.setWarnings(false);
        }
        finally {
            display.dispose();
        }
    }

    private /* synthetic */ void lambda$3(Display display) {
        display.dispose();
        this.disposeExecRan = true;
    }
}

