/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.tests.junit.SwtTestUtil;
import org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Widget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_org_eclipse_swt_widgets_Menu
extends Test_org_eclipse_swt_widgets_Widget {
    Menu menu;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.menu = new Menu((Control)this.shell);
        this.setWidget((Widget)this.menu);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_Control() {
        Composite comp = new Composite((Composite)this.shell, 0);
        new Menu((Control)comp);
        comp.dispose();
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_DecorationsI() {
        Menu newMenu;
        Decorations nullShell = null;
        try {
            newMenu = new Menu(nullShell, 0);
            newMenu.dispose();
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        newMenu = new Menu((Decorations)this.shell, 0);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_Menu() {
        new Menu(this.menu);
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_MenuItem() {
        Menu newMenu;
        MenuItem mItem = null;
        try {
            newMenu = new Menu(mItem);
            newMenu.dispose();
            Assert.fail((String)"No exception thrown for parent == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        mItem = new MenuItem(this.menu, 0);
        newMenu = new Menu(mItem);
    }

    @Test
    public void test_addHelpListenerLorg_eclipse_swt_events_HelpListener() {
        this.listenerCalled = false;
        HelpListener listener = e -> {
            boolean bl = this.listenerCalled = true;
        };
        try {
            this.menu.addHelpListener(null);
            Assert.fail((String)"No exception thrown for addHelpListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.menu.addHelpListener(listener);
        this.menu.notifyListeners(28, new Event());
        Assert.assertTrue((boolean)this.listenerCalled);
        try {
            this.menu.removeHelpListener(null);
            Assert.fail((String)"No exception thrown for removeHelpListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.listenerCalled = false;
        this.menu.removeHelpListener(listener);
        this.menu.notifyListeners(28, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_addMenuListenerLorg_eclipse_swt_events_MenuListener() {
        this.listenerCalled = false;
        MenuListener menuListener = new MenuListener(){

            public void menuShown(MenuEvent e) {
                Test_org_eclipse_swt_widgets_Menu.this.listenerCalled = true;
            }

            public void menuHidden(MenuEvent e) {
                Test_org_eclipse_swt_widgets_Menu.this.listenerCalled = true;
            }
        };
        try {
            this.menu.addMenuListener(null);
            Assert.fail((String)"No exception thrown for addMenuListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.menu.addMenuListener(menuListener);
        this.menu.notifyListeners(22, new Event());
        Assert.assertTrue((String)":a:", (boolean)this.listenerCalled);
        this.listenerCalled = false;
        this.menu.notifyListeners(23, new Event());
        Assert.assertTrue((String)":b:", (boolean)this.listenerCalled);
        try {
            this.menu.removeMenuListener(null);
            Assert.fail((String)"No exception thrown for removeMenuListener with null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.listenerCalled = false;
        this.menu.removeMenuListener(menuListener);
        this.menu.notifyListeners(22, new Event());
        Assert.assertFalse((boolean)this.listenerCalled);
    }

    @Test
    public void test_getItemCount() {
        int number = 10;
        int i = 0;
        while (i < number) {
            Assert.assertEquals((long)this.menu.getItemCount(), (long)i);
            new MenuItem(this.menu, 0);
            ++i;
        }
    }

    @Test
    public void test_getItemI() {
        MenuItem mItem0 = new MenuItem(this.menu, 0);
        MenuItem mItem1 = new MenuItem(this.menu, 0);
        Assert.assertEquals((Object)this.menu.getItem(0), (Object)mItem0);
        Assert.assertEquals((Object)this.menu.getItem(1), (Object)mItem1);
    }

    @Test
    public void test_getItems() {
        int number = 5;
        Object[] items = new MenuItem[number];
        int i = 0;
        while (i < number) {
            items[i] = new MenuItem(this.menu, 0);
            ++i;
        }
        Assert.assertArrayEquals((String)":a:", (Object[])items, (Object[])this.menu.getItems());
        this.menu.getItems()[0].dispose();
        Assert.assertArrayEquals((String)":b:", (Object[])new MenuItem[]{items[1], items[2], items[3], items[4]}, (Object[])this.menu.getItems());
        this.menu.getItems()[3].dispose();
        Assert.assertArrayEquals((String)":c:", (Object[])new MenuItem[]{items[1], items[2], items[3]}, (Object[])this.menu.getItems());
        this.menu.getItems()[1].dispose();
        Assert.assertArrayEquals((String)":d:", (Object[])new MenuItem[]{items[1], items[3]}, (Object[])this.menu.getItems());
    }

    @Test
    public void test_getParent() {
        Assert.assertEquals((Object)this.menu.getParent(), (Object)this.shell);
    }

    @Test
    public void test_getParentItem() {
        MenuItem mItem = new MenuItem(this.menu, 64);
        Menu newMenu = new Menu((Decorations)this.shell, 4);
        Assert.assertNull((Object)newMenu.getParentItem());
        mItem.setMenu(newMenu);
        Assert.assertEquals((Object)newMenu.getParentItem(), (Object)mItem);
    }

    @Test
    public void test_getParentMenu() {
        MenuItem mItem = new MenuItem(this.menu, 64);
        Menu newMenu = new Menu((Decorations)this.shell, 4);
        Assert.assertNull((Object)newMenu.getParentMenu());
        mItem.setMenu(newMenu);
        Assert.assertEquals((Object)newMenu.getParentMenu(), (Object)this.menu);
    }

    @Test
    public void test_getShell() {
        Assert.assertEquals((Object)this.menu.getShell(), (Object)this.shell);
    }

    @Test
    public void test_indexOfLorg_eclipse_swt_widgets_MenuItem() {
        int number = 10;
        MenuItem[] mis = new MenuItem[number];
        int i = 0;
        while (i < number) {
            mis[i] = new MenuItem(this.menu, 0);
            ++i;
        }
        i = 0;
        while (i < number) {
            Assert.assertEquals((long)this.menu.indexOf(mis[i]), (long)i);
            if (i > 1) {
                Assert.assertTrue((this.menu.indexOf(mis[i - 1]) != i ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    @Test
    public void test_setDefaultItemLorg_eclipse_swt_widgets_MenuItem() {
        if (SwtTestUtil.isGTK) {
            if (SwtTestUtil.verbose) {
                System.out.println("Excluded test_setDefaultItemLorg_eclipse_swt_widgets_MenuItem(org.eclipse.swt.tests.junit.Test_org_eclipse_swt_widgets_Menu)");
            }
            return;
        }
        MenuItem mItem0 = new MenuItem(this.menu, 0);
        MenuItem mItem1 = new MenuItem(this.menu, 0);
        this.menu.setDefaultItem(mItem0);
        Assert.assertEquals((Object)this.menu.getDefaultItem(), (Object)mItem0);
        Assert.assertTrue((String)"After setDefaultItem(mItem0):", (this.menu.getDefaultItem() != mItem1 ? 1 : 0) != 0);
        this.menu.setDefaultItem(mItem1);
        Assert.assertEquals((Object)this.menu.getDefaultItem(), (Object)mItem1);
        Assert.assertTrue((String)"After setDefaultItem(mItem1):", (this.menu.getDefaultItem() != mItem0 ? 1 : 0) != 0);
    }

    @Test
    public void test_setEnabledZ() {
        this.menu.setEnabled(true);
        Assert.assertTrue((boolean)this.menu.getEnabled());
        this.menu.setEnabled(false);
        Assert.assertFalse((boolean)this.menu.getEnabled());
    }

    @Test
    public void test_setLocationII() {
        this.menu.setLocation(0, 0);
    }

    @Test
    public void test_setLocationLorg_eclipse_swt_graphics_Point() {
        this.menu.setLocation(new Point(0, 0));
        try {
            this.menu.setLocation(null);
            Assert.fail((String)"No exception thrown for null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

