/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit;

import java.util.List;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.tests.junit.ConsistencyUtility;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class Test_org_eclipse_swt_widgets_Widget {
    boolean listenerCalled;
    boolean disposedIntentionally;
    @Rule
    public TestName name = new TestName();
    public Shell shell;
    private Widget widget;

    @Before
    public void setUp() {
        this.shell = new Shell();
    }

    @After
    public void tearDown() {
        if (this.widget != null) {
            Assert.assertEquals((Object)this.disposedIntentionally, (Object)this.widget.isDisposed());
        }
        if (!this.disposedIntentionally) {
            Assert.assertEquals((Object)false, (Object)this.shell.isDisposed());
        }
        this.shell.dispose();
        if (this.widget != null) {
            Assert.assertTrue((boolean)this.widget.isDisposed());
        }
        Assert.assertTrue((boolean)this.shell.isDisposed());
    }

    @Test
    public void test_ConstructorLorg_eclipse_swt_widgets_WidgetI() {
    }

    @Test
    public void test_addDisposeListenerLorg_eclipse_swt_events_DisposeListener() {
        DisposeListener listener = e -> {};
        this.widget.addDisposeListener(listener);
        this.widget.removeDisposeListener(listener);
    }

    @Test
    public void test_addListenerILorg_eclipse_swt_widgets_Listener() {
        try {
            this.widget.addListener(12, null);
            Assert.fail((String)"No exception thrown for listener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Listener listener = e -> {};
        this.widget.addListener(12, listener);
        this.widget.removeListener(12, listener);
    }

    @Test
    public void test_getDisplay() {
        Assert.assertEquals((Object)this.widget.getDisplay(), (Object)this.widget.getDisplay());
    }

    @Test
    public void test_isDisposed() {
        Assert.assertEquals((Object)false, (Object)this.widget.isDisposed());
    }

    @Test
    public void test_notifyListenersILorg_eclipse_swt_widgets_Event() {
        this.widget.notifyListeners(0, null);
        Event event = new Event();
        GC gc = null;
        if (this.widget instanceof Control) {
            gc = event.gc = new GC((Drawable)((Control)this.widget));
        }
        this.widget.notifyListeners(9, event);
        if (gc != null) {
            gc.dispose();
        }
    }

    @Test
    public void test_removeListenerILorg_eclipse_swt_widgets_Listener() {
        try {
            this.widget.removeListener(9, null);
            Assert.fail((String)"No exception thrown for listener == null");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.widget.removeListener(9, e -> {});
        Listener listener = e -> {};
        this.widget.addListener(9, listener);
        this.widget.removeListener(9, listener);
    }

    @Test
    public void test_setDataLjava_lang_Object() {
        this.widget.setData((Object)this.widget);
        Assert.assertEquals((Object)this.widget, (Object)this.widget.getData());
        this.widget.setData(null);
        Assert.assertNull((Object)this.widget.getData());
    }

    @Test
    public void test_setDataLjava_lang_StringLjava_lang_Object() {
        this.widget.setData("the widget", (Object)this.widget);
        Assert.assertEquals((Object)this.widget, (Object)this.widget.getData("the widget"));
        this.widget.setData("the widget", null);
        Assert.assertNull((Object)this.widget.getData("the widget"));
    }

    @Test
    public void test_toString() {
        Assert.assertNotNull((Object)this.widget.toString());
        Assert.assertTrue((this.widget.toString().length() > 0 ? 1 : 0) != 0);
    }

    protected void setWidget(Widget w) {
        this.widget = w;
    }

    protected void hookListeners(Widget w, int[] types, Listener listener) {
        int i = 0;
        while (i < types.length) {
            w.addListener(types[i], listener);
            ++i;
        }
    }

    protected String[] hookExpectedEvents(String type, List<String> events) {
        return this.hookExpectedEvents(this.widget, type, events);
    }

    protected String[] hookExpectedEvents(Widget w, String type, List<String> events) {
        String[] expectedEvents = ConsistencyUtility.eventOrdering.get(type);
        this.hookExpectedEvents(w, expectedEvents, events);
        return expectedEvents;
    }

    protected void hookExpectedEvents(Widget w, String[] types, List<String> events) {
        this.hookListeners(w, ConsistencyUtility.convertEventNames(types), e -> {
            String temp = ConsistencyUtility.eventNames[e.type];
            if (e.type == 31) {
                temp = String.valueOf(temp) + ":" + ConsistencyUtility.getTraversalType(e.detail);
            } else if (e.type == 13) {
                temp = String.valueOf(temp) + ":" + ConsistencyUtility.getSelectionType(e.detail);
            }
            events.add(temp);
            System.out.println(String.valueOf(temp) + e.widget);
        });
    }

    protected String getTestName() {
        String test = this.name.getMethodName();
        int index = test.lastIndexOf(95);
        if (index != -1) {
            test = test.substring(index + 1, test.length());
        }
        String clss = this.getClassName();
        if ((!test.equals("MenuDetect") || clss.equals("Table") || clss.equals("TableTree") || test.startsWith("Chevron")) && (!test.equals("DragDetect") || clss.equals("Tree") || clss.equals("TableTree") || test.startsWith("Chevron")) && (!test.equals("DoubleClick") || clss.equals("List")) && (!test.equals("KeySelection") || clss.equals("Slider") || clss.equals("Combo") || clss.equals("CCombo") || clss.equals("CTabFolder")) && (!test.equals("EnterSelection") || clss.equals("Button") || clss.equals("ToolBar") || clss.equals("CCombo") || clss.equals("ExpandBar"))) {
            test = String.valueOf(clss) + test;
        }
        return test;
    }

    protected String getClassName() {
        String clazz = this.getClass().getName();
        int index = clazz.lastIndexOf(95);
        if (index != -1) {
            clazz = clazz.substring(index + 1, clazz.length());
        }
        return clazz;
    }
}

