/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.Screenshots;

public class Browser3_window_open_visibility_listeners {
    public static boolean verbose = false;
    public static boolean passed = false;
    public static boolean openWindow;
    public static boolean locationChanging;
    public static boolean locationChanged;
    public static boolean visibilityShow;
    public static boolean progressCompleted;

    public static boolean test1(String url) {
        if (verbose) {
            System.out.println("javascript window.open - args: " + url + " Expected Event Sequence: Browser1:OpenWindow.open > { Browser2:Location.changing, Browser2:Visibility.show, Browser2:Location.changed } > Browser2:Progress.completed");
        }
        passed = false;
        progressCompleted = false;
        locationChanged = false;
        locationChanging = false;
        final Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Browser browser1 = new Browser((Composite)shell, 0);
        final Shell shell2 = new Shell(display);
        shell2.setLayout((Layout)new FillLayout());
        Browser browser2 = new Browser((Composite)shell2, 0);
        browser1.addOpenWindowListener(event -> {
            Browser src;
            if (verbose) {
                System.out.println("Browser1:OpenWindow.open");
            }
            openWindow = true;
            if (verbose) {
                Screenshots.takeScreenshot(Browser3_window_open_visibility_listeners.class, (String)"openWindow");
            }
            if ((src = (Browser)event.widget) != browser1) {
                if (verbose) {
                    System.out.println("Failure - expected " + browser1 + ", got " + src);
                }
                passed = false;
                shell.close();
                return;
            }
            if (event.browser != null) {
                if (verbose) {
                    System.out.println("Failure - expected null, got " + event.browser);
                }
                passed = false;
                shell.close();
                return;
            }
            event.browser = browser2;
        });
        browser2.addLocationListener(new LocationListener(){
            private int changed = 1;

            public void changed(LocationEvent event) {
                if (verbose) {
                    System.out.println("Browser2:Location.changed to " + event.location);
                }
                if (verbose) {
                    Screenshots.takeScreenshot(Browser3_window_open_visibility_listeners.class, (String)("changed" + this.changed++));
                }
                if (!openWindow || !locationChanging) {
                    if (verbose) {
                        System.out.println("Failure - LocationEvent.changing received at wrong time");
                    }
                    passed = false;
                    shell.close();
                    return;
                }
                locationChanged = true;
            }

            public void changing(LocationEvent event) {
                if (verbose) {
                    System.out.println("Browser2:Location.changing to " + event.location);
                }
                if (!openWindow) {
                    if (verbose) {
                        System.out.println("Failure - LocationEvent.changing received at wrong time");
                    }
                    passed = false;
                    shell.close();
                    return;
                }
                locationChanging = true;
            }
        });
        browser2.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                if (verbose) {
                    System.out.println("Browser2:Visibility.hide");
                }
                if (verbose) {
                    System.out.println("Failure - did not expect VisibilityEvent.hide");
                }
                passed = false;
                shell.close();
            }

            public void show(WindowEvent event) {
                if (verbose) {
                    System.out.println("Browser2:Visibility.show");
                }
                if (verbose) {
                    Screenshots.takeScreenshot(Browser3_window_open_visibility_listeners.class, (String)"show");
                }
                if (!openWindow) {
                    if (verbose) {
                        System.out.println("Failure - VisibilityEvent.show received at wrong time");
                    }
                    passed = false;
                    shell.close();
                    return;
                }
                shell2.open();
            }
        });
        browser2.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                if (verbose) {
                    System.out.println("Browser2:Progress.completed");
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (verbose) {
                            System.out.println("timer start");
                        }
                        try {
                            1.sleep(2000L);
                        }
                        catch (Exception exception) {}
                        passed = true;
                        if (verbose) {
                            Screenshots.takeScreenshot(Browser3_window_open_visibility_listeners.class, (String)"completed");
                        }
                        if (!display.isDisposed()) {
                            display.asyncExec(() -> {
                                if (verbose) {
                                    System.out.println("timer asyncexec shell.close");
                                }
                                if (!shell.isDisposed()) {
                                    shell.close();
                                }
                            });
                        }
                        if (verbose) {
                            System.out.println("timer over");
                        }
                    }
                }.start();
            }
        });
        shell.open();
        browser1.setUrl(url);
        boolean timeout = Browser3_window_open_visibility_listeners.runLoopTimer(display, shell, 600);
        if (timeout) {
            if (verbose) {
                System.out.println("timed out");
            }
            passed = false;
        }
        if (verbose) {
            Screenshots.takeScreenshot(Browser3_window_open_visibility_listeners.class, (String)"end");
        }
        display.dispose();
        return passed;
    }

    static boolean runLoopTimer(final Display display, final Shell shell, final int seconds) {
        final boolean[] timeout = new boolean[1];
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < seconds) {
                        Thread.sleep(1000L);
                        if (display.isDisposed() || shell.isDisposed()) {
                            return;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                timeout[0] = true;
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!shell.isDisposed()) {
                            shell.redraw();
                        }
                    });
                }
            }
        }.start();
        while (!timeout[0] && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return timeout[0];
    }

    public static boolean test() {
        int fail = 0;
        String pluginPath = System.getProperty("PLUGIN_PATH");
        if (verbose) {
            System.out.println("PLUGIN_PATH <" + pluginPath + ">");
        }
        String url = pluginPath == null ? Browser3_window_open_visibility_listeners.class.getClassLoader().getResource("browser3.html").toString() : String.valueOf(pluginPath) + "/data/browser3.html";
        String[] urls = new String[]{url};
        int i = 0;
        while (i < urls.length) {
            boolean result = Browser3_window_open_visibility_listeners.test1(urls[i]);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i;
        }
        return fail == 0;
    }

    public static void main(String[] argv) {
        System.out.println("\r\nTests Finished. SUCCESS: " + Browser3_window_open_visibility_listeners.test());
    }
}

