/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.Screenshots;

public class Browser5_sizing_and_bounds {
    public static boolean verbose = false;
    public static boolean passed = false;
    static Point[][] regressionBounds;
    static int index;
    static int cntPassed;
    static int cntClosed;

    static {
        Point[][] pointArrayArray = new Point[4][];
        pointArrayArray[0] = new Point[]{new Point(100, 200), new Point(300, 100)};
        Point[] pointArray = new Point[2];
        pointArray[0] = new Point(100, 200);
        pointArrayArray[1] = pointArray;
        Point[] pointArray2 = new Point[2];
        pointArray2[1] = new Point(300, 100);
        pointArrayArray[2] = pointArray2;
        pointArrayArray[3] = new Point[2];
        regressionBounds = pointArrayArray;
        index = 0;
        cntPassed = 0;
        cntClosed = 0;
    }

    public static boolean test1(String url) {
        if (verbose) {
            System.out.println("javascript window.open with location and size parameters - args: " + url + "\n  Expected Event Sequence: Visibility.show");
        }
        passed = false;
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 0);
        browser.addOpenWindowListener(event -> {
            if (verbose) {
                System.out.println("OpenWindow " + index);
            }
            Shell newShell = new Shell(display);
            newShell.setLayout((Layout)new FillLayout());
            Browser browser1 = new Browser((Composite)newShell, 0);
            browser1.setData("index", (Object)index);
            browser1.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent event) {
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public void show(WindowEvent event) {
                    int index;
                    block15: {
                        boolean checkSize;
                        Point size;
                        Point location;
                        Browser browser;
                        block16: {
                            browser = (Browser)event.widget;
                            Shell parent = browser.getShell();
                            location = event.location;
                            size = event.size;
                            if (location != null) {
                                parent.setLocation(location);
                            }
                            if (size != null) {
                                parent.setSize(size);
                            }
                            index = (Integer)browser.getData("index");
                            parent.setText("SWT Browser shell " + index);
                            parent.open();
                            if (index >= 0) break block16;
                            if (location != null || size != null) {
                                if (verbose) {
                                    System.out.println("Failure - Browser " + index + " is receiving multiple show events");
                                }
                                if (verbose) {
                                    Screenshots.takeScreenshot(Browser5_sizing_and_bounds.class, (String)"show.noindex");
                                }
                                passed = false;
                                shell.close();
                                break block15;
                            } else if (verbose) {
                                System.out.println("Unnecessary (but harmless) visibility.show event Browser " + index);
                            }
                            break block15;
                        }
                        if (verbose) {
                            System.out.println("Visibility.show browser " + index + " location " + location + " size " + size);
                        }
                        browser.setData("index", (Object)(-100 - index));
                        Point expectedLocation = regressionBounds[index][0];
                        Point expectedSize = regressionBounds[index][1];
                        if (verbose) {
                            System.out.println("Expected location " + expectedLocation + " size " + expectedSize);
                        }
                        boolean checkLocation = location == null && expectedLocation == null || location != null && location.equals((Object)expectedLocation) || location != null && expectedLocation == null;
                        boolean bl = checkSize = size == null && expectedSize == null || size != null && size.equals((Object)expectedSize) || size != null && expectedSize == null || size != null && size.x >= expectedSize.x && size.y >= expectedSize.y;
                        if (!checkSize || !checkLocation) {
                            if (verbose) {
                                System.out.println("\tFailure ");
                            }
                            if (verbose) {
                                Screenshots.takeScreenshot(Browser5_sizing_and_bounds.class, (String)("show.failure." + index));
                            }
                            if (location != null && expectedLocation != null && expectedLocation.x - location.x < 20 && expectedLocation.y - location.y < 20) {
                                ++cntPassed;
                                break block15;
                            } else {
                                passed = false;
                                shell.close();
                                return;
                            }
                        }
                        ++cntPassed;
                    }
                    if (verbose) {
                        Screenshots.takeScreenshot(Browser5_sizing_and_bounds.class, (String)("show.end." + index));
                    }
                }
            });
            browser1.addCloseWindowListener(event1 -> {
                ++cntClosed;
                if (verbose) {
                    System.out.println("Close");
                }
                if (verbose) {
                    Screenshots.takeScreenshot(Browser5_sizing_and_bounds.class, (String)("close " + cntClosed));
                }
                Browser browser2 = (Browser)event1.widget;
                browser2.getShell().close();
                if (cntPassed == regressionBounds.length) {
                    passed = true;
                }
                if (cntClosed == regressionBounds.length) {
                    shell.close();
                    return;
                }
            });
            event.browser = browser1;
            ++index;
        });
        shell.open();
        browser.setUrl(url);
        boolean timeout = Browser5_sizing_and_bounds.runLoopTimer(display, shell, 600);
        if (timeout) {
            passed = false;
        }
        display.dispose();
        return passed;
    }

    static boolean runLoopTimer(final Display display, final Shell shell, final int seconds) {
        final boolean[] timeout = new boolean[1];
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < seconds) {
                        Thread.sleep(1000L);
                        if (display.isDisposed() || shell.isDisposed()) {
                            return;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                timeout[0] = true;
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!shell.isDisposed()) {
                            shell.redraw();
                        }
                    });
                }
            }
        }.start();
        while (!timeout[0] && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return timeout[0];
    }

    public static boolean test() {
        int fail = 0;
        String pluginPath = System.getProperty("PLUGIN_PATH");
        if (verbose) {
            System.out.println("PLUGIN_PATH <" + pluginPath + ">");
        }
        String url = pluginPath == null ? Browser5_sizing_and_bounds.class.getClassLoader().getResource("browser5.html").toString() : String.valueOf(pluginPath) + "/data/browser5.html";
        String[] urls = new String[]{url};
        int i = 0;
        while (i < urls.length) {
            boolean result = Browser5_sizing_and_bounds.test1(urls[i]);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i;
        }
        return fail == 0;
    }

    public static void main(String[] argv) {
        System.out.println("\r\nTests Finished. SUCCESS: " + Browser5_sizing_and_bounds.test());
    }
}

