/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tests.junit.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Browser7_child_browsers {
    public static boolean verbose = false;
    public static boolean passed = false;
    static int cntOpen = 0;
    static int cntShow = 0;

    public static boolean test(String url) {
        if (verbose) {
            System.out.println("window.open, verify get Window.open and Window.show events - args: " + url + " Expected Event Sequence: Window.open, Window.show multiple times");
        }
        passed = false;
        cntOpen = 0;
        cntShow = 0;
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Browser browser = new Browser((Composite)shell, 0);
        Browser7_child_browsers.initialize(display, browser);
        shell.open();
        browser.setUrl(url);
        int i = 0;
        while (i < 5 && cntOpen != 4 && cntShow < 4) {
            Browser7_child_browsers.runLoopTimer(display, shell, 2);
            if (!display.isDisposed()) {
                display.readAndDispatch();
            }
            ++i;
        }
        if (verbose) {
            System.out.println("Window opened: " + cntOpen + " Window shown: " + cntShow);
        }
        passed = cntOpen == 4 && cntShow >= 4;
        display.dispose();
        return passed;
    }

    static void initialize(Display display, Browser browser) {
        browser.addOpenWindowListener(event -> {
            if (verbose) {
                System.out.println("VisibilityWindowListener.open");
            }
            Shell shell = new Shell(display);
            shell.setText("New Window");
            shell.setLayout((Layout)new FillLayout());
            Browser browser1 = new Browser((Composite)shell, 0);
            Browser7_child_browsers.initialize(display, browser1);
            event.browser = browser1;
            ++cntOpen;
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                if (verbose) {
                    System.out.println("VisibilityWindowListener.show location=" + event.location + " size=" + event.size + " addressBar=" + event.addressBar + " menuBar=" + event.menuBar + " statusBar=" + event.statusBar + " toolBar=" + event.toolBar);
                }
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                ++cntShow;
                shell.open();
            }
        });
        browser.addCloseWindowListener(event -> {
            Browser browser1 = (Browser)event.widget;
            Shell shell = browser1.getShell();
            shell.close();
        });
    }

    static boolean runLoopTimer(final Display display, final Shell shell, final int seconds) {
        final boolean[] timeout = new boolean[1];
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < seconds) {
                        Thread.sleep(1000L);
                        if (display.isDisposed() || shell.isDisposed()) {
                            return;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {}
                timeout[0] = true;
                if (!display.isDisposed()) {
                    display.asyncExec(() -> {
                        if (!shell.isDisposed()) {
                            shell.redraw();
                        }
                    });
                }
            }
        }.start();
        while (!timeout[0] && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return timeout[0];
    }

    public static boolean test() {
        int fail = 0;
        String pluginPath = System.getProperty("PLUGIN_PATH");
        if (verbose) {
            System.out.println("PLUGIN_PATH <" + pluginPath + ">");
        }
        String url = pluginPath == null ? Browser7_child_browsers.class.getClassLoader().getResource("browser7.html").toString() : String.valueOf(pluginPath) + "/data/browser7.html";
        String[] urls = new String[]{url};
        int i = 0;
        while (i < urls.length) {
            boolean result = Browser7_child_browsers.test(urls[i]);
            if (verbose) {
                System.out.print(result ? "." : "E");
            }
            if (!result) {
                ++fail;
            }
            ++i;
        }
        return fail == 0;
    }

    public static void main(String[] argv) {
        System.out.println("\r\nTests Finished. SUCCESS: " + Browser7_child_browsers.test());
    }
}

