/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.builders;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.swt.tools.Activator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Check64CompilationParticipant
extends CompilationParticipant {
    HashSet<String> sources;
    static final char[] INT_LONG = "int /*long*/".toCharArray();
    static final char[] INT_LONG_ARRAY = "int[] /*long[]*/".toCharArray();
    static final char[] FLOAT_DOUBLE = "float /*double*/".toCharArray();
    static final char[] FLOAT_DOUBLE_ARRAY = "float[] /*double[]*/".toCharArray();
    static final char[] LONG_INT = "long /*int*/".toCharArray();
    static final char[] LONG_INT_ARRAY = "long[] /*int[]*/".toCharArray();
    static final char[] DOUBLE_FLOAT = "double /*float*/".toCharArray();
    static final char[] DOUBLE_FLOAT_ARRAY = "double[] /*float[]*/".toCharArray();
    static final String buildDir = "/.build64/";
    static final String pluginDir = "/org.eclipse.swt/";
    static final String plugin = "org.eclipse.swt";
    static final String SOURCE_ID = "JNI";
    static final String CHECK_64_ENABLED = "org.eclipse.swt.toolsCHECK_64_ENABLED";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String loadFile(String file) {
        if (file == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                FileReader fr = new FileReader(file);
                try {
                    String string;
                    block19: {
                        BufferedReader br = new BufferedReader(fr);
                        try {
                            StringBuffer str = new StringBuffer();
                            char[] buffer = new char[1024];
                            while (true) {
                                int read;
                                if ((read = br.read(buffer)) == -1) {
                                    fr.close();
                                    string = str.toString();
                                    return string;
                                }
                                str.append(buffer, 0, read);
                            }
                        }
                        finally {
                            if (br == null) break block19;
                            br.close();
                        }
                    }
                    if (fr != null) {
                        fr.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("File not found:" + file, e);
        }
    }

    void build(IJavaProject project, String root) throws CoreException {
        try {
            StringBuffer sourcePath = new StringBuffer();
            StringBuffer cp = new StringBuffer();
            IClasspathEntry[] entries = project.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                String path = entry.getPath().toPortableString();
                if (entry.getEntryKind() == 3) {
                    if (path.startsWith(pluginDir)) {
                        if (sourcePath.length() > 0) {
                            sourcePath.append(File.pathSeparatorChar);
                        }
                        String dir = String.valueOf(root) + path.substring(pluginDir.length());
                        sourcePath.append(dir);
                    }
                } else {
                    if (cp.length() > 0) {
                        cp.append(File.pathSeparator);
                    }
                    cp.append(path);
                }
                ++i;
            }
            String bin = String.valueOf(root) + "/bin";
            if (cp.length() > 0) {
                cp.append(File.pathSeparator);
            }
            cp.append(bin);
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList("-nowarn", "-1.8", "-d", bin, "-cp", cp.toString(), "-log", String.valueOf(root) + "/log.xml", "-sourcepath", sourcePath.toString()));
            args.addAll(this.sources);
            Throwable throwable = null;
            Object var9_12 = null;
            try (PrintWriter writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(String.valueOf(root) + "/out.txt")));){
                BatchCompiler.compile((String[])args.toArray(new String[args.size()]), (PrintWriter)writer, (PrintWriter)writer, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            project.getProject().findMember((IPath)new Path(buildDir)).refreshLocal(2, null);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools", "Problem building 64-bit code", (Throwable)e));
        }
    }

    void create(IContainer file) throws CoreException {
        if (file.exists()) {
            return;
        }
        switch (file.getType()) {
            case 2: {
                this.create(file.getParent());
                ((IFolder)file).create(true, true, null);
            }
        }
    }

    IResource getResourceWithoutErrors(IProject proj, String path, boolean deleteJNI) throws CoreException {
        String projPath;
        if ((path = path.replaceAll(buildDir, "/")).startsWith(projPath = proj.getLocation().toPortableString())) {
            path = path.substring(projPath.length());
        }
        IResource resource = proj.findMember((IPath)new Path(path));
        boolean hasProblems = false;
        IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
        int m = 0;
        while (m < markers.length) {
            IMarker marker = markers[m];
            if (SOURCE_ID.equals(marker.getAttribute("sourceId"))) {
                if (deleteJNI) {
                    marker.delete();
                }
            } else {
                Object severity = marker.getAttribute("severity");
                hasProblems |= severity != null && (Integer)severity == 2;
            }
            ++m;
        }
        return hasProblems ? null : resource;
    }

    void createProblem(IResource resource, String message, int start, int end) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.jdt.core.problem");
        int severity = 2;
        marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd", "sourceId"}, new Object[]{"[32/64] " + message, severity, start, end, SOURCE_ID});
    }

    void createProblems(IJavaProject project, String root) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(String.valueOf(root) + "/log.xml"));){
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(is));
                ((InputStream)is).close();
                IProject proj = project.getProject();
                NodeList sources = doc.getDocumentElement().getElementsByTagName("sources");
                int i = 0;
                while (i < sources.getLength()) {
                    NodeList src = ((Element)sources.item(i)).getElementsByTagName("source");
                    int j = 0;
                    while (j < src.getLength()) {
                        Element source = (Element)src.item(j);
                        String path = source.getAttribute("path").replace('\\', '/');
                        IResource resource = this.getResourceWithoutErrors(proj, path, true);
                        if (resource != null) {
                            NodeList problems = source.getElementsByTagName("problems");
                            int k = 0;
                            while (k < problems.getLength()) {
                                NodeList problem = ((Element)problems.item(k)).getElementsByTagName("problem");
                                int l = 0;
                                while (l < problem.getLength()) {
                                    Element node = (Element)problem.item(l);
                                    if (resource != null) {
                                        int start = Integer.parseInt(node.getAttribute("charStart"));
                                        int end = Integer.parseInt(node.getAttribute("charEnd"));
                                        String message = ((Element)node.getElementsByTagName("message").item(0)).getAttribute("value");
                                        this.createProblem(resource, message, start, end);
                                    }
                                    ++l;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.swt.tools", "Problem creating 64-bit problems", (Throwable)e));
        }
    }

    String resolvePath(String sourcePath, String simpleName) {
        String basePath = sourcePath.substring(0, sourcePath.lastIndexOf("/"));
        File file = new File(String.valueOf(basePath) + "/" + simpleName + ".java");
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    TypeDeclaration loadType(HashMap<String, TypeDeclaration> cache, String path) {
        if (path == null) {
            return null;
        }
        TypeDeclaration value = cache.get(path);
        if (value != null) {
            return value;
        }
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(Check64CompilationParticipant.loadFile(path).toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        TypeDeclaration type = (TypeDeclaration)unit.types().get(0);
        cache.put(path, type);
        return type;
    }

    boolean is64Type(String type) {
        return type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double") || type.equals("int[]") || type.equals("long[]") || type.equals("float[]") || type.equals("double[]");
    }

    void createBadOverwrittenMethodProblems(IJavaProject project, String root) throws CoreException {
        if (this.sources == null) {
            return;
        }
        IProject proj = project.getProject();
        HashMap<String, TypeDeclaration> cache = new HashMap<String, TypeDeclaration>();
        for (String path : this.sources) {
            TypeDeclaration stype;
            Type supertype;
            IResource resource = this.getResourceWithoutErrors(proj, path, false);
            if (resource == null) continue;
            TypeDeclaration type = this.loadType(cache, path);
            MethodDeclaration[] methods = type.getMethods();
            ArrayList<TypeDeclaration> superclasses = new ArrayList<TypeDeclaration>();
            TypeDeclaration temp = type;
            while ((supertype = temp.getSuperclassType()) != null && (stype = this.loadType(cache, this.resolvePath(path, supertype.toString()))) != null) {
                superclasses.add(stype);
                temp = stype;
            }
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                for (TypeDeclaration supertype2 : superclasses) {
                    MethodDeclaration[] supermethods = supertype2.getMethods();
                    int j = 0;
                    while (j < supermethods.length) {
                        MethodDeclaration supermethod = supermethods[j];
                        if (method.getName().getIdentifier().equals(supermethod.getName().getIdentifier()) && method.parameters().size() == supermethod.parameters().size()) {
                            List mParams = method.parameters();
                            List sParams = supermethod.parameters();
                            int k = 0;
                            while (k < sParams.size()) {
                                SingleVariableDeclaration p1 = (SingleVariableDeclaration)mParams.get(k);
                                SingleVariableDeclaration p2 = (SingleVariableDeclaration)sParams.get(k);
                                String r1 = p1.getType().toString();
                                String r2 = p2.getType().toString();
                                if (this.is64Type(r1) && this.is64Type(r2) && !r1.equals(r2) && p1.getName().getIdentifier().equals(p2.getName().getIdentifier())) {
                                    String message = "\"" + p1.getName().getIdentifier() + "\" parameter type does not match super declaration";
                                    this.createProblem(resource, message, p1.getStartPosition(), p1.getStartPosition() + p1.toString().length());
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    boolean replace(char[] source, char[] src, char[] dest) {
        boolean changed = false;
        int start = 0;
        while (start < source.length) {
            int index = CharOperation.indexOf((char[])src, (char[])source, (boolean)true, (int)start);
            if (index == -1) break;
            changed |= true;
            System.arraycopy(dest, 0, source, index, dest.length);
            start = index + 1;
        }
        return changed;
    }

    boolean replace(char[] source) {
        boolean changed = false;
        changed |= this.replace(source, LONG_INT, INT_LONG);
        changed |= this.replace(source, LONG_INT_ARRAY, INT_LONG_ARRAY);
        changed |= this.replace(source, DOUBLE_FLOAT, FLOAT_DOUBLE);
        if (!(changed |= this.replace(source, DOUBLE_FLOAT_ARRAY, FLOAT_DOUBLE_ARRAY))) {
            changed |= this.replace(source, INT_LONG, LONG_INT);
            changed |= this.replace(source, INT_LONG_ARRAY, LONG_INT_ARRAY);
            changed |= this.replace(source, FLOAT_DOUBLE, DOUBLE_FLOAT);
            changed |= this.replace(source, FLOAT_DOUBLE_ARRAY, DOUBLE_FLOAT_ARRAY);
        }
        return changed;
    }

    public static boolean getEnabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean(CHECK_64_ENABLED);
    }

    public static void setEnabled(boolean enabled) {
        Activator.getDefault().getPreferenceStore().setValue(CHECK_64_ENABLED, enabled);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean is64bit(IJavaProject project) {
        try {
            IClasspathEntry[] entries = project.getResolvedClasspath(true);
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return false;
                }
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 3) {
                    String path = entry.getPath().toPortableString();
                    if (path.equals("/org.eclipse.swt/Eclipse SWT PI/win32")) return true;
                    if (path.equals("/org.eclipse.swt/Eclipse SWT PI/cocoa")) return true;
                    if (path.equals("/org.eclipse.swt/Eclipse SWT PI/gtk")) {
                        return true;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public void buildFinished(IJavaProject project) {
        try {
            if (this.sources == null) {
                return;
            }
            if (!Check64CompilationParticipant.getEnabled() || !this.is64bit(project)) {
                return;
            }
            String root = String.valueOf(project.getProject().getLocation().toPortableString()) + buildDir;
            this.build(project, root);
            this.createProblems(project, root);
            this.createBadOverwrittenMethodProblems(project, root);
            this.sources = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        if (this.sources == null) {
            this.sources = new HashSet();
        }
        int i = 0;
        while (i < files.length) {
            BuildContext context = files[i];
            IFile file = context.getFile();
            IProject project = file.getProject();
            Path path = new Path(buildDir + file.getProjectRelativePath().toPortableString());
            IFile newFile = project.getFile((IPath)path);
            this.sources.add(newFile.getLocation().toPortableString());
            try {
                if (newFile.exists()) {
                    newFile.delete(true, null);
                }
                this.create(newFile.getParent());
                char[] source = context.getContents();
                this.replace(source);
                newFile.create((InputStream)new ByteArrayInputStream(new String(source).getBytes()), true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void cleanStarting(IJavaProject project) {
        if (!this.isActive(project)) {
            return;
        }
        this.sources = null;
        IResource resource = project.getProject().findMember((IPath)new Path(buildDir));
        if (resource != null) {
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isActive(IJavaProject project) {
        if (project.getProject().getName().equals(plugin)) {
            return true;
        }
        return super.isActive(project);
    }
}

