/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIItem;

public abstract class AbstractItem
implements JNIItem {
    HashMap<String, Object> params;

    static String[] split(String str, String separator) {
        return JNIGenerator.split(str, separator);
    }

    void checkParams() {
        if (this.params != null) {
            return;
        }
        this.parse(this.getMetaData());
    }

    public String flatten() {
        this.checkParams();
        StringBuffer buffer = new StringBuffer();
        Set<String> set = this.params.keySet();
        Object[] keys = set.toArray(new String[set.size()]);
        Arrays.sort(keys);
        int j = 0;
        while (j < keys.length) {
            Object key = keys[j];
            Object value = this.params.get(key);
            String valueStr = "";
            if (value instanceof String) {
                valueStr = (String)value;
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                StringBuffer valueBuffer = new StringBuffer();
                int i = 0;
                while (i < values.length) {
                    if (i != 0) {
                        valueBuffer.append(" ");
                    }
                    valueBuffer.append(values[i]);
                    ++i;
                }
                valueStr = valueBuffer.toString();
            } else {
                valueStr = value.toString();
            }
            if (valueStr.length() > 0) {
                if (buffer.length() != 0) {
                    buffer.append(",");
                }
                buffer.append((String)key);
                buffer.append("=");
                String quote = "";
                if (valueStr.indexOf(44) != -1) {
                    quote = valueStr.indexOf(34) != -1 ? "'" : "\"";
                }
                buffer.append(quote);
                buffer.append(valueStr);
                buffer.append(quote);
            }
            ++j;
        }
        return buffer.toString();
    }

    @Override
    public String[] getFlags() {
        Object flags = this.getParam("flags");
        if (flags == null) {
            return new String[0];
        }
        if (flags instanceof String[]) {
            return (String[])flags;
        }
        String[] result = AbstractItem.split((String)flags, " ");
        this.setParam("flags", result);
        return result;
    }

    @Override
    public boolean getFlag(String flag) {
        String[] flags = this.getFlags();
        int i = 0;
        while (i < flags.length) {
            if (flags[i].equals(flag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract String getMetaData();

    @Override
    public Object getParam(String key) {
        this.checkParams();
        Object value = this.params.get(key);
        return value == null ? "" : value;
    }

    @Override
    public boolean getGenerate() {
        return !this.getFlag("no_gen");
    }

    @Override
    public void setFlags(String[] flags) {
        this.setParam("flags", flags);
    }

    public void parse(String str) {
        this.params = new HashMap();
        int length = str.length();
        if (length == 0) {
            return;
        }
        int index = 0;
        while (index < length) {
            int equals = str.indexOf(61, index);
            if (equals == -1) {
                System.out.println("Error: " + str + " index=" + index + " length=" + length);
                break;
            }
            String key = str.substring(index, equals).trim();
            ++equals;
            while (equals < length && Character.isWhitespace(str.charAt(equals))) {
                ++equals;
            }
            char c = str.charAt(equals);
            char ending = ',';
            switch (c) {
                case '\"': 
                case '\'': {
                    ending = c;
                }
            }
            int end = ++equals;
            while (end < length && str.charAt(end) != ending) {
                ++end;
            }
            String value = str.substring(equals, end).trim();
            this.setParam(key, value);
            if (ending != ',') {
                while (end < length && str.charAt(end) != ',') {
                    ++end;
                }
            }
            index = end + 1;
        }
    }

    @Override
    public void setFlag(String flag, boolean value) {
        String[] flags = this.getFlags();
        HashSet<String> set = new HashSet<String>(Arrays.asList(flags));
        if (value) {
            set.add(flag);
        } else {
            set.remove(flag);
        }
        this.setFlags(set.toArray(new String[set.size()]));
    }

    @Override
    public void setGenerate(boolean value) {
        this.setFlag("no_gen", !value);
    }

    public abstract void setMetaData(String var1);

    @Override
    public void setParam(String key, Object value) {
        this.checkParams();
        this.params.put(key, value);
        this.setMetaData(this.flatten());
    }
}

