/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.tests.core.RepositoryProviderBic;
import org.eclipse.team.tests.core.RepositoryProviderNaish;
import org.eclipse.team.tests.core.RepositoryProviderWithLinking;
import org.eclipse.team.tests.core.TeamTest;
import org.junit.Assert;

public class RepositoryProviderTests
extends TeamTest {
    public RepositoryProviderTests() {
    }

    public RepositoryProviderTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(RepositoryProviderTests.class);
        return new TestSetup((Test)suite);
    }

    public void testProvidersRegistered() throws CoreException, TeamException {
        ArrayList<String> repoProviderIds = new ArrayList<String>(Arrays.asList(RepositoryProvider.getAllProviderTypeIds()));
        RepositoryProviderTests.assertEquals((boolean)true, (boolean)repoProviderIds.contains("org.eclipse.team.tests.core.bic-provider"));
        RepositoryProviderTests.assertEquals((boolean)true, (boolean)repoProviderIds.contains("org.eclipse.team.tests.core.naish-provider"));
        RepositoryProviderTests.assertEquals((boolean)false, (boolean)repoProviderIds.contains("org.eclipse.team.tests.core.other"));
    }

    public void testGetProviderGeneric() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testGetProviderGeneric1");
        IProject project2 = this.getUniqueTestProject("testGetProviderGeneric2");
        boolean good = false;
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.other");
        }
        catch (TeamException teamException) {
            good = true;
        }
        Assert.assertTrue((boolean)good);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.naish-provider");
        RepositoryProvider.map((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider");
        RepositoryProvider provider1 = RepositoryProvider.getProvider((IProject)project);
        RepositoryProvider provider2 = RepositoryProvider.getProvider((IProject)project2);
        Assert.assertTrue((provider1 != null && provider1.getID().equals("org.eclipse.team.tests.core.naish-provider") ? 1 : 0) != 0);
        Assert.assertTrue((provider2 != null && provider2.getID().equals("org.eclipse.team.tests.core.naish-provider") ? 1 : 0) != 0);
        Assert.assertTrue((provider1.getProject().equals((Object)project) && provider2.getProject().equals((Object)project2) ? 1 : 0) != 0);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        provider1 = RepositoryProvider.getProvider((IProject)project);
        Assert.assertTrue((provider1 != null && provider1.getID().equals("org.eclipse.team.tests.core.bic-provider") ? 1 : 0) != 0);
        IProject closedProject = this.getUniqueTestProject("testGetProviderGenericClosed");
        IProject nonExistantProject = ResourcesPlugin.getWorkspace().getRoot().getProject("nonExistant");
        closedProject.close(null);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)closedProject) == null ? 1 : 0) != 0);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)nonExistantProject) == null ? 1 : 0) != 0);
        RepositoryProvider.unmap((IProject)project);
        RepositoryProvider.unmap((IProject)project2);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)project) == null ? 1 : 0) != 0);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)project2) == null ? 1 : 0) != 0);
    }

    public void testGetProviderById() throws CoreException, TeamException {
        IProject project1 = this.getUniqueTestProject("testGetProviderById_1");
        IProject project2 = this.getUniqueTestProject("testGetProviderById_2");
        RepositoryProvider.map((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProvider.map((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider");
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider") != null ? 1 : 0) != 0);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider") != null ? 1 : 0) != 0);
        IProject closedProject = this.getUniqueTestProject("testGetProviderGenericClosed");
        IProject nonExistantProject = ResourcesPlugin.getWorkspace().getRoot().getProject("nonExistant");
        closedProject.close(null);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)closedProject, (String)"id") == null ? 1 : 0) != 0);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)nonExistantProject, (String)"id") == null ? 1 : 0) != 0);
        RepositoryProvider.unmap((IProject)project1);
        RepositoryProvider.unmap((IProject)project2);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider") == null ? 1 : 0) != 0);
        Assert.assertTrue((RepositoryProvider.getProvider((IProject)project2, (String)"org.eclipse.team.tests.core.naish-provider") == null ? 1 : 0) != 0);
    }

    public void testFileModificationValidator() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testFileModificationValidator");
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProviderBic bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        Assert.assertTrue((bicProvider != null ? 1 : 0) != 0);
        final boolean[] called = new boolean[1];
        bicProvider.setModificationValidator((IFileModificationValidator)new FileModificationValidator(){

            public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
                return null;
            }

            public IStatus validateSave(IFile file) {
                called[0] = true;
                return RepositoryProviderTests.this.getTeamTestStatus(0);
            }
        });
        IFile file = project.getFile("test.txt");
        file.create((InputStream)new ByteArrayInputStream("test".getBytes()), true, null);
        file.setContents((InputStream)new ByteArrayInputStream("test2".getBytes()), true, false, null);
        Assert.assertTrue((boolean)called[0]);
        called[0] = false;
        bicProvider.setModificationValidator((IFileModificationValidator)new FileModificationValidator(){

            public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
                return null;
            }

            public IStatus validateSave(IFile file) {
                called[0] = true;
                return RepositoryProviderTests.this.getTeamTestStatus(4);
            }
        });
        try {
            file.setContents((InputStream)new ByteArrayInputStream("test3".getBytes()), true, false, null);
            RepositoryProviderTests.fail((String)"validate hook should veto this setContents");
        }
        catch (CoreException coreException) {
            Assert.assertTrue((boolean)called[0]);
        }
        bicProvider.setModificationValidator(null);
        file.setContents((InputStream)new ByteArrayInputStream("test4".getBytes()), true, false, null);
    }

    public void testMoveDeleteHook() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testMoveDeleteHook");
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProviderBic bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.tests.core.bic-provider");
        Assert.assertTrue((bicProvider != null ? 1 : 0) != 0);
        final boolean[] called = new boolean[6];
        IMoveDeleteHook hook = new IMoveDeleteHook(){

            public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
                called[0] = true;
                return false;
            }

            public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
                called[1] = true;
                return false;
            }

            public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
                called[2] = true;
                return false;
            }

            public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
                called[3] = true;
                return false;
            }

            public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
                called[4] = true;
                return false;
            }

            public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
                called[5] = true;
                return false;
            }
        };
        bicProvider.setMoveDeleteHook(hook);
        IResource[] resources = this.buildResources((IContainer)project, new String[]{"deleteFile.txt", "moveFile.txt", "deletedFolder/", "moveFolder/"});
        this.ensureExistsInWorkspace(resources, true);
        resources[0].delete(false, null);
        resources[1].move(resources[1].getFullPath().removeLastSegments(1).append("movedFile_NEW"), false, null);
        resources[2].delete(false, null);
        resources[3].move(resources[3].getFullPath().removeLastSegments(1).append("movedFolder"), false, null);
        IProjectDescription desc = project.getDescription();
        desc.setName("movedProject");
        project.move(desc, false, null);
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject("movedProject");
        bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)newProject);
        bicProvider.setMoveDeleteHook(hook);
        newProject.delete(true, null);
        int i = 0;
        while (i < called.length) {
            Assert.assertTrue((boolean)called[i]);
            ++i;
        }
    }

    public void testMoveDeleteHookBetweenProjects() throws CoreException, TeamException {
        IProject projectA = this.getUniqueTestProject("testMoveDeleteHookBetweenProjects_A");
        IProject projectB = this.getUniqueTestProject("testMoveDeleteHookBetweenProjects_B");
        IProject projectC = this.getUniqueTestProject("testMoveDeleteHookBetweenProjects_C");
        RepositoryProvider.map((IProject)projectA, (String)"org.eclipse.team.tests.core.bic-provider");
        final RepositoryProviderBic bicProvider = (RepositoryProviderBic)RepositoryProvider.getProvider((IProject)projectA, (String)"org.eclipse.team.tests.core.bic-provider");
        RepositoryProvider.map((IProject)projectB, (String)"org.eclipse.team.tests.core.naish-provider");
        RepositoryProviderNaish naishProvider = (RepositoryProviderNaish)RepositoryProvider.getProvider((IProject)projectB, (String)"org.eclipse.team.tests.core.naish-provider");
        Assert.assertTrue((bicProvider != null && naishProvider != null ? 1 : 0) != 0);
        final boolean[] calledProjectA = new boolean[2];
        bicProvider.setMoveDeleteHook(new IMoveDeleteHook(){

            public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
                Assert.assertTrue((boolean)bicProvider.getProject().equals((Object)source.getProject()));
                calledProjectA[0] = true;
                return false;
            }

            public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
                Assert.assertTrue((boolean)bicProvider.getProject().equals((Object)source.getProject()));
                calledProjectA[1] = true;
                return false;
            }

            public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
                return false;
            }
        });
        final boolean[] calledProjectB = new boolean[2];
        naishProvider.setMoveDeleteHook(new IMoveDeleteHook(){

            public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
                return false;
            }

            public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
                Assert.assertTrue((boolean)bicProvider.getProject().equals((Object)destination.getProject()));
                calledProjectB[0] = true;
                return false;
            }

            public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
                Assert.assertTrue((boolean)bicProvider.getProject().equals((Object)destination.getProject()));
                calledProjectB[1] = true;
                return false;
            }

            public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
                return false;
            }
        });
        IResource[] resources = this.buildResources((IContainer)projectA, new String[]{"moveFile.txt", "moveFolder/"});
        this.ensureExistsInWorkspace(resources, true);
        resources[0].move(projectB.getFullPath().append("moveFile_new.txt"), false, null);
        resources[1].move(projectB.getFullPath().append("movedFolder"), false, null);
        int i = 0;
        while (i < calledProjectA.length) {
            Assert.assertTrue((calledProjectA[i] && !calledProjectB[i] ? 1 : 0) != 0);
            ++i;
        }
        calledProjectA[0] = false;
        calledProjectA[1] = false;
        calledProjectB[0] = false;
        calledProjectB[1] = false;
        resources = this.buildResources((IContainer)projectA, new String[]{"anotherMovedFiled.txt", "anotherMovedFolder/"});
        this.ensureExistsInWorkspace(resources, true);
        resources[0].move(projectC.getFullPath().append("moveFileOther_new.txt"), false, null);
        resources[1].move(projectC.getFullPath().append("movedFolderOther"), false, null);
        i = 0;
        while (i < calledProjectA.length) {
            Assert.assertTrue((calledProjectA[i] && !calledProjectB[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testMapSuccess() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testLinkSuccess");
        this.buildResources((IContainer)project, new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"}, true);
        IFolder folder = project.getFolder("link");
        folder.createLink(this.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        RepositoryProvider.unmap((IProject)project);
        folder.delete(false, null);
        folder = project.getFolder("link");
        folder.createLink(this.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        RepositoryProvider.unmap((IProject)project);
        folder.delete(false, null);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(this.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
    }

    public void testLinkSuccess() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testLinkSuccess");
        this.buildResources((IContainer)project, new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"}, true);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        IFolder folder = project.getFolder("link");
        folder.createLink(this.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        folder.delete(false, null);
        folder = project.getFolder("link");
        folder.createLink(this.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(true);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(this.getRandomLocation(), 16, null);
    }

    public void testMapFailure() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testMapFailure");
        this.buildResources((IContainer)project, new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"}, true);
        IFolder folder = project.getFolder("link");
        folder.createLink(this.getRandomLocation(), 16, null);
        RepositoryProviderWithLinking.setCanHandleLinking(false);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        boolean fail = true;
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() != 378) {
                throw e;
            }
            fail = false;
        }
        if (fail) {
            RepositoryProviderTests.fail((String)"Link should be disallowed");
        }
        folder.delete(false, null);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(this.getRandomLocation(), 16, null);
        fail = true;
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() != 378) {
                throw e;
            }
            fail = false;
        }
        if (fail) {
            RepositoryProviderTests.fail((String)"Link should be disallowed");
        }
        folder.delete(false, null);
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        folder = project.getFolder("folder1/folder2");
        folder.createLink(this.getRandomLocation(), 16, null);
        fail = true;
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() != 378) {
                throw e;
            }
            fail = false;
        }
        if (fail) {
            RepositoryProviderTests.fail((String)"Link should be disallowed");
        }
    }

    public void testLinkFailure() throws CoreException, TeamException {
        IProject project = this.getUniqueTestProject("testLinkFailure");
        this.buildResources((IContainer)project, new String[]{"changed.txt", "deleted.txt", "folder1/", "folder1/a.txt"}, true);
        RepositoryProviderWithLinking.setCanHandleLinking(false);
        RepositoryProviderWithLinking.setCanHandleLinkedURI(false);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.team.tests.core.linking");
        IFolder folder = project.getFolder("link");
        boolean fail = true;
        try {
            folder.createLink(this.getRandomLocation(), 16, null);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 378) {
                throw e;
            }
            fail = false;
        }
        if (fail) {
            RepositoryProviderTests.fail((String)"Link should be disallowed");
        }
        folder = project.getFolder("folder1/folder2");
        fail = true;
        try {
            folder.createLink(this.getRandomLocation(), 16, null);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 378) {
                throw e;
            }
            fail = false;
        }
        if (fail) {
            RepositoryProviderTests.fail((String)"Link should be disallowed");
        }
        RepositoryProviderWithLinking.setCanHandleLinking(true);
        folder = project.getFolder("folder1/folder2");
        fail = true;
        try {
            folder.createLink(this.getRandomLocation(), 16, null);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() != 378) {
                throw e;
            }
            fail = false;
        }
        if (fail) {
            RepositoryProviderTests.fail((String)"Link should be disallowed");
        }
    }

    public void testIsShared() throws CoreException, TeamException {
        IProject project1 = this.getUniqueTestProject("testGetProviderById_1");
        RepositoryProvider.map((IProject)project1, (String)"org.eclipse.team.tests.core.bic-provider");
        Assert.assertTrue((boolean)RepositoryProvider.isShared((IProject)project1));
        project1.close(null);
        Assert.assertTrue((!RepositoryProvider.isShared((IProject)project1) ? 1 : 0) != 0);
        project1.open(null);
        Assert.assertTrue((boolean)RepositoryProvider.isShared((IProject)project1));
        RepositoryProvider.unmap((IProject)project1);
        Assert.assertTrue((!RepositoryProvider.isShared((IProject)project1) ? 1 : 0) != 0);
    }
}

