/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.team.internal.core.streams.CRLFtoLFInputStream;
import org.eclipse.team.internal.core.streams.LFtoCRLFInputStream;

public class StreamTests
extends TestCase {
    public StreamTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(StreamTests.class);
    }

    public void testCRLFtoLFInputStream() throws IOException {
        this.testCRLFtoLFTranslation("", "");
        this.testCRLFtoLFTranslation("a", "a");
        this.testCRLFtoLFTranslation("abc", "abc");
        this.testCRLFtoLFTranslation("\n", "\n");
        this.testCRLFtoLFTranslation("\r", "\r");
        this.testCRLFtoLFTranslation("\r\n", "\n");
        this.testCRLFtoLFTranslation("x\r\r\n\rx", "x\r\n\rx");
        this.testCRLFtoLFTranslation("The \r\n quick brown \n fox \r\n\n\r\r\n jumped \n\n over \r\n the \n lazy dog.\r\n", "The \n quick brown \n fox \n\n\r\n jumped \n\n over \n the \n lazy dog.\n");
    }

    private void testCRLFtoLFTranslation(String pre, String post) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(pre.getBytes());
        CRLFtoLFInputStream in = new CRLFtoLFInputStream((InputStream)bin);
        ByteArrayInputStream inExpected = new ByteArrayInputStream(post.getBytes());
        this.assertStreamEquals(inExpected, (InputStream)in);
    }

    public void testLFtoCRLFInputStream() throws IOException {
        this.testLFtoCRLFTranslation("", "");
        this.testLFtoCRLFTranslation("a", "a");
        this.testLFtoCRLFTranslation("abc", "abc");
        this.testLFtoCRLFTranslation("\n", "\r\n");
        this.testLFtoCRLFTranslation("\r", "\r");
        this.testLFtoCRLFTranslation("\r\n", "\r\r\n");
        this.testLFtoCRLFTranslation("x\r\r\n\rx", "x\r\r\r\n\rx");
        this.testLFtoCRLFTranslation("The \r\n quick brown \n fox \r\n\n\r\r\n jumped \n\n over \r\n the \n lazy dog.\r\n", "The \r\r\n quick brown \r\n fox \r\r\n\r\n\r\r\r\n jumped \r\n\r\n over \r\r\n the \r\n lazy dog.\r\r\n");
    }

    private void testLFtoCRLFTranslation(String pre, String post) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(pre.getBytes());
        LFtoCRLFInputStream in = new LFtoCRLFInputStream((InputStream)bin);
        ByteArrayInputStream inExpected = new ByteArrayInputStream(post.getBytes());
        this.assertStreamEquals(inExpected, (InputStream)in);
    }

    private void assertStreamEquals(InputStream in1, InputStream in2) throws IOException {
        try {
            int byte1;
            do {
                byte1 = in1.read();
                int byte2 = in2.read();
                StreamTests.assertEquals((String)"Streams not equal", (int)byte1, (int)byte2);
            } while (byte1 != -1);
        }
        finally {
            in1.close();
            in2.close();
        }
    }
}

