/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.core.mapping;

import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.tests.core.TeamTest;
import org.eclipse.team.tests.core.mapping.ScopeTestSubscriber;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ScopeTests
extends TeamTest {
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IWorkingSet workingSet;
    private SubscriberScopeManager manager;

    public static Test suite() {
        return ScopeTests.suite(ScopeTests.class);
    }

    public ScopeTests() {
    }

    public ScopeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project1 = this.createProject("p1", new String[]{"file.txt"});
        this.project2 = this.createProject("p2", new String[]{"file.txt"});
        this.project3 = this.createProject("p3", new String[]{"file.txt"});
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        this.workingSet = manager.createWorkingSet("TestWS", (IAdaptable[])new IProject[]{this.project1});
        manager.addWorkingSet(this.workingSet);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.manager.dispose();
        this.project1.delete(true, null);
        this.project2.delete(true, null);
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        manager.removeWorkingSet(this.workingSet);
    }

    private void assertProperContainment(ISynchronizationScopeManager sm) throws OperationCanceledException, InterruptedException {
        this.waitForManager(sm);
        this.testProjectContainment(sm, this.project1);
        this.testProjectContainment(sm, this.project2);
        this.testProjectContainment(sm, this.project3);
    }

    private void waitForManager(ISynchronizationScopeManager sm) throws OperationCanceledException, InterruptedException {
        Job.getJobManager().join((Object)sm, null);
    }

    private void testProjectContainment(ISynchronizationScopeManager sm, IProject project) {
        if (this.isInWorkingSet(project) && !this.isInScope(sm, project)) {
            ScopeTests.fail((String)(String.valueOf(project.getName()) + " is in the working set but not in the scope"));
        }
        if (!this.isInWorkingSet(project) && this.isInScope(sm, project)) {
            ScopeTests.fail((String)(String.valueOf(project.getName()) + " is in scope but not in the working set"));
        }
    }

    private boolean isInScope(ISynchronizationScopeManager sm, IProject project) {
        return sm.getScope().contains((IResource)project);
    }

    private boolean isInWorkingSet(IProject project) {
        IAdaptable[] elements = this.workingSet.getElements();
        int i = 0;
        while (i < elements.length) {
            IAdaptable adaptable = elements[i];
            if (adaptable.equals(project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ISynchronizationScopeManager createScopeManager() throws CoreException, OperationCanceledException, InterruptedException {
        ScopeTestSubscriber subscriber = new ScopeTestSubscriber();
        this.manager = new SubscriberScopeManager(subscriber.getName(), new ResourceMapping[]{Utils.getResourceMapping((Object)this.workingSet)}, (Subscriber)subscriber, true);
        this.manager.initialize((IProgressMonitor)new NullProgressMonitor());
        this.waitForManager((ISynchronizationScopeManager)this.manager);
        return this.manager;
    }

    public void testScopeExpansion() throws CoreException, OperationCanceledException, InterruptedException {
        ISynchronizationScopeManager sm = this.createScopeManager();
        this.assertProperContainment(sm);
        this.workingSet.setElements((IAdaptable[])new IProject[]{this.project1, this.project2});
        this.assertProperContainment(sm);
    }
}

