/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ui.synchronize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.mapping.ResourceModelContentProvider;
import org.eclipse.team.tests.core.TeamTest;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ResourceContentTests
extends TeamTest {
    private ResourceModelContentProvider provider;

    public static Test suite() {
        return ResourceContentTests.suite(ResourceContentTests.class);
    }

    public ResourceContentTests() {
    }

    public ResourceContentTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.initializeProvider(null, null, null);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.cleanupProvider();
        super.tearDown();
    }

    private void initializeProvider(ISynchronizationScope scope, ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
        this.cleanupProvider();
        this.provider = new TestableResourceModelContentProvider(scope, context, configuration);
    }

    private void cleanupProvider() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        this.provider = null;
    }

    private void assertContentMatches(IProject project, String[] leaves) {
        this.assertContentsMatch(this.asResources(project, leaves));
    }

    private void assertContentsMatch(IResource[] resources) {
        Set paths = this.getPaths(ResourcesPlugin.getWorkspace().getRoot());
        HashSet<IResource> resourceSet = new HashSet<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            resourceSet.add(resource);
            ++i;
        }
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            TreePath path = (TreePath)iterator.next();
            Object o = path.getLastSegment();
            if (!resourceSet.remove(o)) continue;
            iterator.remove();
        }
        if (!resourceSet.isEmpty()) {
            ResourceContentTests.fail((String)("Tree entries were missing for " + this.toString(resourceSet)));
        }
        if (!paths.isEmpty()) {
            ResourceContentTests.fail((String)("Tree entries were found for " + this.toString(paths)));
        }
    }

    private Set getPaths(Object root) {
        HashSet result = new HashSet();
        Object[] elements = this.provider.getElements(root);
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            TreePath path = new TreePath(new Object[]{object});
            Set childPaths = this.getPaths(this.provider, path);
            result.addAll(childPaths);
            ++i;
        }
        return result;
    }

    private Set getPaths(ResourceModelContentProvider provider, TreePath path) {
        Object[] children = provider.getChildren(path);
        HashSet<TreePath> result = new HashSet<TreePath>();
        if (children.length == 0) {
            result.add(path);
        }
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            TreePath childPath = path.createChildPath(object);
            Set childPaths = this.getPaths(provider, childPath);
            result.addAll(childPaths);
            ++i;
        }
        return result;
    }

    private String toString(Set set) {
        StringBuffer buffer = new StringBuffer();
        boolean addComma = false;
        for (Object resource : set) {
            buffer.append(this.toString(resource));
            if (addComma) {
                buffer.append(", ");
            }
            addComma = true;
        }
        return buffer.toString();
    }

    private String toString(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getFullPath().toString();
        }
        if (object instanceof TreePath) {
            return this.toString(((TreePath)object).getLastSegment());
        }
        return object.toString();
    }

    private IResource[] asResources(IProject project, String[] resourcePaths) {
        ArrayList<Object> resources = new ArrayList<Object>();
        int i = 0;
        while (i < resourcePaths.length) {
            String path = resourcePaths[i];
            if (path.endsWith("/")) {
                resources.add(project.getFolder(path));
            } else {
                resources.add(project.getFile(path));
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public void testFileContent() throws CoreException {
        String[] files = new String[]{"file.txt", "file2.txt", "folder1/file3.txt", "folder1/folder2/file4.txt"};
        IProject project = this.createProject(files);
        files = new String[]{".project", "file.txt", "file2.txt", "folder1/file3.txt", "folder1/folder2/file4.txt"};
        this.assertContentMatches(project, files);
    }

    public void testFileChange() throws CoreException {
    }

    public static class TestableResourceModelContentProvider
    extends ResourceModelContentProvider {
        private final ISynchronizationScope scope;
        private final ISynchronizationContext context;
        private final ISynchronizePageConfiguration configuration;

        public TestableResourceModelContentProvider(ISynchronizationScope scope, ISynchronizationContext context, ISynchronizePageConfiguration configuration) {
            this.scope = scope;
            this.context = context;
            this.configuration = configuration;
        }

        public ISynchronizePageConfiguration getConfiguration() {
            return this.configuration;
        }

        public ISynchronizationContext getContext() {
            return this.context;
        }

        public ISynchronizationScope getScope() {
            return this.scope;
        }
    }
}

