/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IUserAuthenticator;
import org.eclipse.team.internal.ccvs.core.connection.CVSCommunicationException;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.tests.ccvs.core.CVSTestLogListener;
import org.eclipse.team.tests.ccvs.core.TestsUserAuthenticator;

public class CVSTestSetup
extends TestSetup {
    public static final String REPOSITORY_LOCATION;
    public static final boolean INITIALIZE_REPO;
    public static final boolean DEBUG;
    public static final boolean LOCAL_REPO;
    public static final String RSH;
    public static final int WAIT_FACTOR;
    public static final int COMPRESSION_LEVEL;
    public static final boolean FAIL_IF_EXCEPTION_LOGGED;
    public static final boolean RECORD_PROTOCOL_TRAFFIC;
    public static final boolean ENSURE_SEQUENTIAL_ACCESS;
    public static final boolean FAIL_ON_BAD_DIFF;
    public static final int TIMEOUT = 600;
    public static CVSRepositoryLocation repository;
    public static CVSTestLogListener logListener;

    static {
        CVSTestSetup.loadProperties();
        REPOSITORY_LOCATION = System.getProperty("eclipse.cvs.repository");
        INITIALIZE_REPO = Boolean.valueOf(System.getProperty("eclipse.cvs.initrepo", "false"));
        DEBUG = Boolean.valueOf(System.getProperty("eclipse.cvs.debug", "false"));
        RSH = System.getProperty("eclipse.cvs.rsh", "rsh");
        LOCAL_REPO = Boolean.valueOf(System.getProperty("eclipse.cvs.localRepo", "false"));
        WAIT_FACTOR = Integer.parseInt(System.getProperty("eclipse.cvs.waitFactor", "1"));
        COMPRESSION_LEVEL = Integer.parseInt(System.getProperty("eclipse.cvs.compressionLevel", "0"));
        FAIL_IF_EXCEPTION_LOGGED = Boolean.valueOf(System.getProperty("eclipse.cvs.failLog", "true"));
        RECORD_PROTOCOL_TRAFFIC = Boolean.valueOf(System.getProperty("eclipse.cvs.recordProtocolTraffic", "false"));
        ENSURE_SEQUENTIAL_ACCESS = Boolean.valueOf(System.getProperty("eclipse.cvs.sequentialAccess", "false"));
        FAIL_ON_BAD_DIFF = Boolean.valueOf(System.getProperty("eclipse.cvs.failOnBadDiff", "false"));
    }

    public static void loadProperties() {
        String propertiesFile = System.getProperty("eclipse.cvs.properties");
        if (propertiesFile == null) {
            return;
        }
        File file = new File(propertiesFile);
        if (file.isDirectory()) {
            file = new File(file, "repository.properties");
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                int sep = line.indexOf("=");
                String property = line.substring(0, sep).trim();
                String value = line.substring(sep + 1).trim();
                System.setProperty("eclipse.cvs." + property, value);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not read repository properties file: " + file.getAbsolutePath());
        }
    }

    public CVSTestSetup(Test test) {
        super(test);
    }

    public static void executeRemoteCommand(ICVSRepositoryLocation repository, String commandLine) {
        int returnCode;
        if (!LOCAL_REPO) {
            commandLine = String.valueOf(RSH) + " " + repository.getHost() + " -l " + repository.getUsername() + " " + commandLine;
        }
        if ((returnCode = CVSTestSetup.executeCommand(commandLine, null, null)) != -1 && returnCode != 0) {
            System.err.println("Remote command returned " + returnCode + ": " + commandLine);
        }
    }

    public static int executeCommand(String commandLine, String[] environment, File workingDirectory) {
        PrintStream debugStream = DEBUG ? System.out : null;
        try {
            if (debugStream != null) {
                debugStream.println();
                CVSTestSetup.printPrefixedLine(debugStream, "CMD> ", commandLine);
                if (workingDirectory != null) {
                    CVSTestSetup.printPrefixedLine(debugStream, "DIR> ", workingDirectory.toString());
                }
            }
            Process cvsProcess = Runtime.getRuntime().exec(commandLine, environment, workingDirectory);
            CVSTestSetup.startBackgroundPipeThread(cvsProcess.getErrorStream(), debugStream, "ERR> ");
            CVSTestSetup.startBackgroundPipeThread(cvsProcess.getInputStream(), debugStream, "MSG> ");
            int returnCode = cvsProcess.waitFor();
            if (debugStream != null) {
                debugStream.println("RESULT> " + returnCode);
            }
            return returnCode;
        }
        catch (IOException e) {
            CVSTestSetup.printPrefixedLine(System.err, "Unable to execute command: ", commandLine);
            e.printStackTrace(System.err);
        }
        catch (InterruptedException e) {
            CVSTestSetup.printPrefixedLine(System.err, "Unable to execute command: ", commandLine);
            e.printStackTrace(System.err);
        }
        return -1;
    }

    private static void startBackgroundPipeThread(final InputStream is, final PrintStream os, final String prefix) {
        new Thread(){

            @Override
            public void run() {
                BufferedReader reader = null;
                try {
                    try {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(is));
                        while ((line = reader.readLine()) != null) {
                            if (os == null) continue;
                            CVSTestSetup.printPrefixedLine(os, prefix, line);
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private static void printPrefixedLine(PrintStream os, String prefix, String line) {
        os.print(prefix);
        os.println(line.substring(0, Math.min(line.length(), 256)));
    }

    private static void initializeRepository(CVSRepositoryLocation repository) {
        String repoRoot = repository.getRootDirectory();
        CVSTestSetup.executeRemoteCommand((ICVSRepositoryLocation)repository, "rm -rf " + repoRoot);
        CVSTestSetup.executeRemoteCommand((ICVSRepositoryLocation)repository, "cvs -d " + repoRoot + " init");
    }

    public void setUp() throws CoreException {
        if (repository == null) {
            repository = this.setupRepository(REPOSITORY_LOCATION);
        }
        CVSProviderPlugin.getPlugin().setCompressionLevel(COMPRESSION_LEVEL);
        CVSProviderPlugin.getPlugin().setTimeout(600);
        if (logListener == null) {
            logListener = new CVSTestLogListener();
            Platform.addLogListener((ILogListener)logListener);
        }
    }

    protected CVSRepositoryLocation setupRepository(String location) throws CVSException {
        CVSRepositoryLocation repository = (CVSRepositoryLocation)KnownRepositories.getInstance().getRepository(location);
        KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)repository, false);
        repository.setUserAuthenticator((IUserAuthenticator)new TestsUserAuthenticator());
        System.out.println("Connecting to: " + repository.getHost() + ":" + repository.getMethod().getName());
        try {
            try {
                repository.validateConnection((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CVSCommunicationException cVSCommunicationException) {
                repository.validateConnection((IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new CVSException((IStatus)new CVSStatus(4, "The connection was canceled, possibly due to an authentication failure."));
            }
        }
        catch (CVSException e) {
            System.out.println("Unable to connect to remote repository: " + repository.toString());
            System.out.println(e.getMessage());
            throw e;
        }
        if (INITIALIZE_REPO) {
            CVSTestSetup.initializeRepository(repository);
        }
        return repository;
    }
}

