/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.tests.ccvs.core.CVSClientException;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.ICVSClient;
import org.eclipse.team.tests.ccvs.core.JUnitTestCase;
import org.junit.Assert;

public class CommandLineCVSClient
implements ICVSClient {
    public static final ICVSClient INSTANCE = new CommandLineCVSClient();
    private static final String cvsExecutable = System.getProperty("eclipse.cvs.command");

    @Override
    public void executeCommand(ICVSRepositoryLocation repositoryLocation, IContainer localRoot, String command, String[] globalOptions, String[] localOptions, String[] arguments) throws CVSException {
        CommandLineCVSClient.execute(repositoryLocation.getLocation(false), localRoot.getLocation().toFile(), command, globalOptions, localOptions, arguments);
        try {
            localRoot.refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw new CVSClientException("CoreException during refreshLocal: " + e.getMessage());
        }
    }

    public static void execute(String repositoryLocation, File localRoot, String command, String[] globalOptions, String[] localOptions, String[] arguments) throws CVSException {
        Assert.assertNotNull((Object)repositoryLocation);
        Assert.assertNotNull((Object)localRoot);
        Assert.assertNotNull((Object)command);
        Assert.assertNotNull((Object)globalOptions);
        Assert.assertNotNull((Object)localOptions);
        Assert.assertNotNull((Object)arguments);
        Assert.assertTrue((boolean)localRoot.exists());
        StringBuffer commandLineBuf = new StringBuffer(cvsExecutable);
        commandLineBuf.append(" -d \"");
        commandLineBuf.append(repositoryLocation);
        commandLineBuf.append('\"');
        CommandLineCVSClient.appendStrings(commandLineBuf, globalOptions);
        commandLineBuf.append(' ');
        commandLineBuf.append(command);
        CommandLineCVSClient.appendStrings(commandLineBuf, localOptions);
        CommandLineCVSClient.appendStrings(commandLineBuf, arguments);
        JUnitTestCase.waitMsec(1500);
        int returnCode = CVSTestSetup.executeCommand(commandLineBuf.toString(), null, localRoot);
        if (returnCode != 0) {
            throw new CVSClientException("Command line client returned non-zero code: " + returnCode);
        }
    }

    private static void appendStrings(StringBuffer commandLine, String[] strings) {
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null && string.length() != 0) {
                commandLine.append(" \"");
                commandLine.append(string);
                commandLine.append('\"');
            }
            ++i;
        }
    }
}

