/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseCVSClient;

public abstract class JUnitTestCase
extends TestCase {
    protected static final int RANDOM_CONTENT_SIZE = 10000;
    protected static final boolean NEWLINE_TEST = false;
    protected static final String PLATFORM_NEWLINE = System.getProperty("line.separator");
    protected static final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    public static final String[] EMPTY_ARGS = new String[0];

    public JUnitTestCase(String name) {
        super(name);
    }

    protected void magicDeleteRemote(String remoteName) throws CVSException {
        JUnitTestCase.magicDeleteRemote((ICVSRepositoryLocation)CVSTestSetup.repository, remoteName);
    }

    protected static void magicDeleteRemote(ICVSRepositoryLocation location, String remoteName) throws CVSException {
        CVSTestSetup.executeRemoteCommand(location, "rm -rf " + new Path(location.getRootDirectory()).append(remoteName).toString());
    }

    protected void magicSetUpRepo(String projectName, String[] createResources) throws IOException, CoreException, CVSException {
        JUnitTestCase.magicSetUpRepo((ICVSRepositoryLocation)CVSTestSetup.repository, projectName, createResources);
    }

    protected static void magicSetUpRepo(ICVSRepositoryLocation location, String projectName, String[] createResources) throws IOException, CoreException, CVSException {
        IProject projectRoot = workspaceRoot.getProject(String.valueOf(projectName) + "-setup-tmp");
        JUnitTestCase.mkdirs((IContainer)projectRoot);
        JUnitTestCase.createRandomFile((IContainer)projectRoot, createResources);
        JUnitTestCase.magicDeleteRemote(location, projectName);
        String[] lOptions = new String[]{"-m", "msg"};
        String[] args = new String[]{projectName, "a", "b"};
        EclipseCVSClient.execute(location, CVSWorkspaceRoot.getCVSFolderFor((IContainer)projectRoot), "import", EMPTY_ARGS, lOptions, args);
        projectRoot.delete(false, null);
    }

    protected static void assertEqualsArrays(Object[] obArr1, Object[] obArr2) {
        JUnitTestCase.assertEquals((String)"Called assertEqualsArrays with null on one side", (obArr1 == null ? 1 : 0) != 0, (obArr2 == null ? 1 : 0) != 0);
        if (obArr1 == null) {
            return;
        }
        int i = 0;
        while (i < Math.min(obArr1.length, obArr2.length)) {
            JUnitTestCase.assertEquals((String)("At Element " + i + " of the array"), (Object)obArr1[i], (Object)obArr2[i]);
            ++i;
        }
        if (obArr1.length > obArr2.length) {
            JUnitTestCase.assertEquals((String)"Arrays of different length", (Object)obArr1[obArr2.length], null);
            return;
        }
        if (obArr1.length < obArr2.length) {
            JUnitTestCase.assertEquals((String)"Arrays of different length", (Object)obArr2[obArr1.length], null);
            return;
        }
    }

    protected static void writeToFile(IFile file, String[] contents) throws IOException, CoreException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (PrintStream os = new PrintStream(bos);){
            int i = 0;
            while (i < contents.length) {
                os.println(contents[i]);
                ++i;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            if (file.exists()) {
                file.setContents((InputStream)bis, false, true, null);
            } else {
                JUnitTestCase.mkdirs(file.getParent());
                file.create((InputStream)bis, false, null);
            }
        }
    }

    protected static String[] readFromFile(IFile file) throws IOException, CoreException {
        if (!file.exists()) {
            return null;
        }
        ArrayList<String> fileContentStore = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()));){
            String line;
            while ((line = reader.readLine()) != null) {
                fileContentStore.add(line);
            }
        }
        return fileContentStore.toArray(new String[fileContentStore.size()]);
    }

    protected static void appendToFile(IFile file, String[] contents) throws IOException, CoreException {
        String[] newContents;
        String[] oldContents = JUnitTestCase.readFromFile(file);
        if (oldContents == null) {
            newContents = contents;
        } else {
            newContents = new String[oldContents.length + contents.length];
            System.arraycopy(oldContents, 0, newContents, 0, oldContents.length);
            System.arraycopy(contents, 0, newContents, oldContents.length, contents.length);
        }
        JUnitTestCase.writeToFile(file, newContents);
    }

    protected static void prefixToFile(IFile file, String[] contents) throws IOException, CoreException {
        String[] newContents;
        String[] oldContents = JUnitTestCase.readFromFile(file);
        if (oldContents == null) {
            newContents = contents;
        } else {
            newContents = new String[oldContents.length + contents.length];
            System.arraycopy(contents, 0, newContents, 0, contents.length);
            System.arraycopy(oldContents, 0, newContents, contents.length, oldContents.length);
        }
        JUnitTestCase.writeToFile(file, newContents);
    }

    protected static String createRandomContent() {
        StringBuffer content = new StringBuffer();
        content.append("Random file generated for test" + PLATFORM_NEWLINE);
        int contentSize = (int)Math.round(20000.0 * Math.random());
        int i = 0;
        while (i < contentSize) {
            if (Math.random() > 0.99) {
                content.append(PLATFORM_NEWLINE);
            }
            if (Math.random() > 0.99) {
                content.append("\n");
            }
            content.append((char)(33L + Math.round(60.0 * Math.random())));
            ++i;
        }
        return content.toString();
    }

    protected static void mkdirs(IContainer container) throws CoreException {
        IFolder folder;
        if (container.getType() == 4) {
            IProject project = (IProject)container;
            if (!project.exists()) {
                project.create(null);
            }
            project.open(null);
        } else if (container.getType() == 2 && !(folder = (IFolder)container).exists()) {
            JUnitTestCase.mkdirs(folder.getParent());
            folder.create(false, true, null);
        }
    }

    private static void createRandomFile(IFile file) throws IOException, CoreException {
        JUnitTestCase.mkdirs(file.getParent());
        JUnitTestCase.writeToFile(file, new String[]{JUnitTestCase.createRandomContent()});
    }

    protected static void createRandomFile(IContainer parent, String[] fileNameArray) throws IOException, CoreException {
        int i = 0;
        while (i < fileNameArray.length) {
            IFile file = parent.getFile((IPath)new Path(fileNameArray[i]));
            JUnitTestCase.createRandomFile(file);
            ++i;
        }
    }

    public static void waitMsec(int msec) {
        try {
            int wait = CVSTestSetup.WAIT_FACTOR * msec;
            long start = System.currentTimeMillis();
            Thread.sleep(wait);
            long end = System.currentTimeMillis();
            JUnitTestCase.assertTrue((String)"Error in thread class. Did not wait long enough", (end - start > (long)(wait - 100) ? 1 : 0) != 0);
        }
        catch (InterruptedException interruptedException) {
            JUnitTestCase.fail((String)"wait-problem");
        }
    }

    protected static void run(Class<? extends TestCase> test) {
        System.setProperty("eclipse.cvs.standalone", "true");
        TestRunner.run(test);
    }
}

