/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.compatible;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.team.tests.ccvs.core.JUnitTestCase;
import org.eclipse.team.tests.ccvs.core.compatible.CompatibleTestSetup;
import org.eclipse.team.tests.ccvs.core.compatible.SameResultEnv;

public class ModuleTest
extends JUnitTestCase {
    SameResultEnv env1;
    SameResultEnv env2;

    public ModuleTest(String arg) {
        super(arg);
        this.env1 = new SameResultEnv(String.valueOf(arg) + "checkout1");
        this.env2 = new SameResultEnv(String.valueOf(arg) + "checkout2");
    }

    public static void main(String[] args) {
        ModuleTest.run(ModuleTest.class);
    }

    public void setUp() throws Exception {
        this.env1.setUp();
        this.env2.setUp();
        this.env1.magicDeleteRemote("CVSROOT/modules");
        this.env1.magicDeleteRemote("CVSROOT/modules,v");
        this.env1.magicSetUpRepo("proj2", new String[]{"a.txt", "f1/b.txt", "f1/c.txt", "f2/d.txt", "f2/f3/e.txt"});
        this.env2.deleteFile("proj2");
    }

    public void tearDown() throws Exception {
        this.env1.tearDown();
        this.env2.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ModuleTest.class);
        return new CompatibleTestSetup((Test)suite);
    }

    private void setUpModuleFile(String[] change) throws Exception {
        this.env1.execute("co", EMPTY_ARGS, new String[]{"CVSROOT"});
        this.env1.writeToFile("CVSROOT/modules", change);
        this.env1.execute("add", new String[]{"-m", "m"}, new String[]{"modules"}, "CVSROOT");
        this.env1.execute("ci", new String[]{"-m", "m"}, new String[]{"CVSROOT"});
        this.env1.deleteFile("CVSROOT");
    }

    public void testSimpleModule() throws Exception {
        this.setUpModuleFile(new String[]{"mod1 proj2"});
        this.env1.execute("co", EMPTY_ARGS, new String[]{"mod1"});
        this.env1.appendToFile("mod1/a.txt", new String[]{"Append"});
        this.env1.execute("ci", new String[]{"-m", "m"}, new String[]{"mod1"});
        this.env1.execute("update", EMPTY_ARGS, new String[]{"mod1"});
    }

    public void testCompositeModule() throws Exception {
        this.setUpModuleFile(new String[]{"mod1-f1 proj2/f1", "mod1-f2 proj2/f2", "mod1f &mod1-f1 &mod1-f2"});
        this.env1.execute("co", EMPTY_ARGS, new String[]{"mod1f"});
        this.env1.appendToFile("mod1f/mod1-f1/b.txt", new String[]{"Append"});
        this.env1.execute("ci", new String[]{"-m", "m"}, new String[]{"mod1f"});
        this.env1.execute("update", EMPTY_ARGS, new String[]{"mod1f"});
    }

    public void testCompositeAliasModule() throws Exception {
        this.setUpModuleFile(new String[]{"mod1-f1 proj2/f1", "mod1t proj2/f1 b.txt", "mod1-f2 &proj2/f2 &mod1t", "mod1f -a mod1-f1 mod1-f2"});
        this.env1.execute("co", EMPTY_ARGS, new String[]{"mod1f"});
        this.env1.appendToFile("mod1-f1/b.txt", new String[]{"Append"});
        this.env1.execute("ci", new String[]{"-m", "m"}, new String[]{"mod1-f1", "mod1-f2"});
        this.env1.execute("update", EMPTY_ARGS, new String[]{"mod1-f1", "mod1-f2"});
    }
}

