/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.cvsresources;

import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;

public class ResourceSyncInfoTest
extends EclipseTest {
    public ResourceSyncInfoTest() {
    }

    public ResourceSyncInfoTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ResourceSyncInfoTest.class);
        return new CVSTestSetup((Test)suite);
    }

    public void testEntryLineParsing() {
        try {
            new ResourceSyncInfo("//////", null);
            ResourceSyncInfoTest.fail();
        }
        catch (CVSException cVSException) {}
        try {
            new ResourceSyncInfo("//1.1///", null);
            ResourceSyncInfoTest.fail();
        }
        catch (CVSException cVSException) {}
        try {
            new ResourceSyncInfo("/file.txt////", null);
            ResourceSyncInfoTest.fail();
        }
        catch (CVSException cVSException) {}
        try {
            new ResourceSyncInfo("/file.txt//////////", null);
            ResourceSyncInfoTest.fail();
        }
        catch (CVSException cVSException) {}
    }

    public void testEntryLineConstructor() throws CVSException {
        ResourceSyncInfo info = new ResourceSyncInfo("/file.java/-1.1/Mon Feb 25 21:44:02 2002/-k/", null);
        ResourceSyncInfoTest.assertTrue((boolean)info.isDeleted());
        info = new ResourceSyncInfo("/file.java/0/something/-k/", null);
        ResourceSyncInfoTest.assertTrue((boolean)info.isAdded());
        info = new ResourceSyncInfo("/file.java/1.0/Mon Feb 25 21:44:02 2002/-k/Tv1", null);
        ResourceSyncInfoTest.assertTrue((info.getTag() != null ? 1 : 0) != 0);
        Date timestamp = new Date(123000L);
        info = new ResourceSyncInfo("/file.java/1.0/Mon Feb 25 21:44:02 2002/-k/Tv1", timestamp);
        ResourceSyncInfoTest.assertTrue((boolean)info.getTimeStamp().equals(timestamp));
        info = new ResourceSyncInfo("/file.java/0/Mon Feb 25 21:44:02 2002/-k/", timestamp);
        ResourceSyncInfoTest.assertTrue((boolean)info.getTimeStamp().equals(timestamp));
        info = new ResourceSyncInfo("D/file.java////", null);
        ResourceSyncInfoTest.assertTrue((boolean)info.isDirectory());
    }

    public void testConstructor() throws CVSException {
        ResourceSyncInfo info = new ResourceSyncInfo("folder");
        ResourceSyncInfoTest.assertTrue((boolean)info.isDirectory());
        info = new ResourceSyncInfo("/file.java/-2.34/Mon Feb 25 21:44:02 2002/-k/Tv1", null);
        ResourceSyncInfoTest.assertTrue((boolean)info.isDeleted());
        ResourceSyncInfoTest.assertTrue((boolean)info.getRevision().equals("2.34"));
        info = new ResourceSyncInfo("/file.java/0/Mon Feb 25 21:44:02 2002/-k/Tv1", null);
        ResourceSyncInfoTest.assertTrue((boolean)info.isAdded());
    }

    public void testMergeTimestamps() throws CVSException {
        Date timestamp = new Date(123000L);
        Date timestamp2 = new Date(654000L);
        ResourceSyncInfo info = new ResourceSyncInfo("/file.java/1.1//-kb/", timestamp);
        ResourceSyncInfoTest.assertTrue((!info.isMerged() ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!info.isNeedsMerge(timestamp) ? 1 : 0) != 0);
        info = new ResourceSyncInfo("/file.java/1.1/+=/-kb/", timestamp);
        String entryLine = info.getEntryLine();
        ResourceSyncInfo info2 = new ResourceSyncInfo(entryLine, null);
        ResourceSyncInfoTest.assertTrue((info.isMerged() && info2.isMerged() ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((info.isNeedsMerge(timestamp) && info2.isNeedsMerge(timestamp) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!info.isNeedsMerge(timestamp2) && !info2.isNeedsMerge(timestamp2) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((info.getTimeStamp().equals(timestamp) && info2.getTimeStamp().equals(timestamp) ? 1 : 0) != 0);
        info = new ResourceSyncInfo("/file.java/1.1/+modified/-kb/", null);
        entryLine = info.getEntryLine();
        info2 = new ResourceSyncInfo(entryLine, null);
        ResourceSyncInfoTest.assertTrue((info.isMerged() && info2.isMerged() ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!info.isNeedsMerge(timestamp) && !info2.isNeedsMerge(timestamp) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!info.isNeedsMerge(timestamp2) && !info2.isNeedsMerge(timestamp2) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((info.getTimeStamp() == null && info2.getTimeStamp() == null ? 1 : 0) != 0);
    }

    public void testTimestampCompatibility() throws CVSException, CoreException {
        String entryLine1 = "/a.bin/1.1/Mon Feb  9 21:44:02 2002/-kb/";
        String entryLine2 = "/a.bin/1.1/Mon Feb 9 21:44:02 2002/-kb/";
        String entryLine3 = "/a.bin/1.1/Mon Feb 09 21:44:02 2002/-kb/";
        ResourceSyncInfo info1 = new ResourceSyncInfo(entryLine1, null);
        ResourceSyncInfo info2 = new ResourceSyncInfo(entryLine2, null);
        ResourceSyncInfo info3 = new ResourceSyncInfo(entryLine3, null);
        Date date1 = info1.getTimeStamp();
        Date date2 = info2.getTimeStamp();
        Date date3 = info3.getTimeStamp();
        ResourceSyncInfoTest.assertTrue((boolean)date1.equals(date2));
        ResourceSyncInfoTest.assertTrue((boolean)date1.equals(date3));
        ResourceSyncInfoTest.assertTrue((boolean)date2.equals(date3));
    }

    public void testRevisionComparison() {
        ResourceSyncInfoTest.assertTrue((boolean)ResourceSyncInfo.isLaterRevision((String)"1.9", (String)"1.8"));
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevision((String)"1.8", (String)"1.8") ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevision((String)"1.8", (String)"1.9") ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((boolean)ResourceSyncInfo.isLaterRevision((String)"1.8.1.2", (String)"1.8"));
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevision((String)"1.8", (String)"1.8.1.2") ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevision((String)"1.8.1.2", (String)"1.7") ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevision((String)"0", (String)"1.1") ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((boolean)ResourceSyncInfo.isLaterRevision((String)"1.1", (String)"0"));
    }

    public void testRevisionOnBranchComparison() throws CVSException {
        ResourceSyncInfo syncInfo1 = new ResourceSyncInfo("/name/1.5/dummy timestamp//", null);
        ResourceSyncInfo syncInfo2 = new ResourceSyncInfo("/name/1.4/dummy timestamp//", null);
        ResourceSyncInfo syncInfo3 = new ResourceSyncInfo("/name/1.4.1.2/dummy timestamp//Nb1", null);
        ResourceSyncInfo syncInfo4 = new ResourceSyncInfo("/name/1.4/dummy timestamp//Nb1", null);
        ResourceSyncInfo syncInfo5 = new ResourceSyncInfo("/name/1.4.1.2/dummy timestamp//Tv1", null);
        ResourceSyncInfoTest.assertTrue((boolean)ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo1.getBytes(), (byte[])syncInfo2.getBytes()));
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo2.getBytes(), (byte[])syncInfo1.getBytes()) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo1.getBytes(), (byte[])syncInfo1.getBytes()) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((boolean)ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo3.getBytes(), (byte[])syncInfo4.getBytes()));
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo4.getBytes(), (byte[])syncInfo3.getBytes()) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo4.getBytes(), (byte[])syncInfo4.getBytes()) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo5.getBytes(), (byte[])syncInfo4.getBytes()) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo4.getBytes(), (byte[])syncInfo5.getBytes()) ? 1 : 0) != 0);
        ResourceSyncInfoTest.assertTrue((!ResourceSyncInfo.isLaterRevisionOnSameBranch((byte[])syncInfo5.getBytes(), (byte[])syncInfo5.getBytes()) ? 1 : 0) != 0);
    }

    public void testRepositoryLocationFormats() throws CVSException {
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:user@host:/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:user:password@host:/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:host:/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:user@host:1234/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:user:password@host:1234/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:host:1234/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:user@host/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:user:password@host/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:host/home/path"), "/home/path");
        this.assertPathCorrect(CVSRepositoryLocation.fromString((String)":pserver:user@domain:password@host/home/path"), "/home/path");
    }

    private void assertPathCorrect(CVSRepositoryLocation location, String string) throws CVSException {
        ResourceSyncInfoTest.assertEquals((String)location.getRootDirectory(), (String)string);
        FolderSyncInfo info = new FolderSyncInfo("childPath", location.getLocation(), null, false);
        ResourceSyncInfoTest.assertEquals((String)info.getRemoteLocation(), (String)(String.valueOf(string) + '/' + "childPath"));
    }
}

