/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.mappings;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.core.variants.IResourceVariant;

public class SyncInfoSetTraveralContext
extends RemoteResourceMappingContext {
    SyncInfoTree set = new SyncInfoTree();

    public SyncInfoSetTraveralContext(SyncInfoSet set) {
        this.set.addAll(set);
    }

    protected SyncInfo getSyncInfo(IFile file) {
        return this.set.getSyncInfo((IResource)file);
    }

    public boolean contentDiffers(IFile file, IProgressMonitor monitor) {
        return this.getSyncInfo(file) != null;
    }

    public IStorage fetchRemoteContents(IFile file, IProgressMonitor monitor) throws CoreException {
        SyncInfo info = this.getSyncInfo(file);
        if (info == null) {
            return null;
        }
        IResourceVariant remote = info.getRemote();
        if (remote == null) {
            return null;
        }
        return remote.getStorage(monitor);
    }

    public IResource[] fetchMembers(IContainer container, IProgressMonitor monitor) throws CoreException {
        HashSet<IResource> members = new HashSet<IResource>();
        members.addAll(Arrays.asList(container.members(false)));
        members.addAll(Arrays.asList(this.set.members((IResource)container)));
        return members.toArray(new IResource[members.size()]);
    }

    public void refresh(ResourceTraversal[] traversals, int flags, IProgressMonitor monitor) throws CoreException {
    }

    public boolean isThreeWay() {
        Iterator iter = this.set.iterator();
        if (iter.hasNext()) {
            SyncInfo info = (SyncInfo)iter.next();
            return info.getComparator().isThreeWay();
        }
        return true;
    }

    public boolean hasRemoteChange(IResource resource, IProgressMonitor monitor) throws CoreException {
        SyncInfo info = this.set.getSyncInfo(resource);
        int direction = SyncInfo.getDirection((int)info.getKind());
        return direction == 8 || direction == 12;
    }

    public boolean hasLocalChange(IResource resource, IProgressMonitor monitor) throws CoreException {
        SyncInfo info = this.set.getSyncInfo(resource);
        int direction = SyncInfo.getDirection((int)info.getKind());
        return direction == 4 || direction == 12;
    }

    public IStorage fetchBaseContents(IFile file, IProgressMonitor monitor) throws CoreException {
        SyncInfo info = this.getSyncInfo(file);
        if (info == null) {
            return null;
        }
        IResourceVariant base = info.getBase();
        if (base == null) {
            return null;
        }
        return base.getStorage(monitor);
    }

    public IProject[] getProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }
}

