/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.tests.ccvs.core.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.operations.FetchMembersOperation;
import org.eclipse.team.tests.ccvs.core.CVSTestSetup;
import org.eclipse.team.tests.ccvs.core.EclipseTest;
import org.eclipse.ui.progress.IElementCollector;

public class ConcurrencyTests
extends EclipseTest {
    public ConcurrencyTests() {
    }

    public ConcurrencyTests(String name) {
        super(name);
    }

    public static Test suite() {
        String testName = System.getProperty("eclipse.cvs.testName");
        if (testName == null) {
            TestSuite suite = new TestSuite(ConcurrencyTests.class);
            return new CVSTestSetup((Test)suite);
        }
        return new CVSTestSetup((Test)new ConcurrencyTests(testName));
    }

    public void testBackgroundMemberFetch() throws CoreException, InvocationTargetException, InterruptedException {
        IProject project = this.createProject("testBackgroundMemberFetch", new String[]{"file1.txt", "folder1/", "folder1/a.txt", "folder2/", "folder2/a.txt", "folder2/folder3/", "folder2/folder3/b.txt", "folder2/folder3/c.txt"});
        ICVSRemoteFolder folder = (ICVSRemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        final ArrayList result = new ArrayList();
        final boolean[] done = new boolean[1];
        IElementCollector collector = new IElementCollector(){

            public void add(Object element, IProgressMonitor monitor) {
                result.add(element);
            }

            public void add(Object[] elements, IProgressMonitor monitor) {
                result.addAll(Arrays.asList(elements));
            }

            public void done() {
                done[0] = true;
            }
        };
        FetchMembersOperation operation = new FetchMembersOperation(null, folder, collector){

            public void done(IJobChangeEvent event) {
                done[0] = true;
                super.done(event);
            }
        };
        operation.run();
        int count = 0;
        while (!done[0]) {
            Thread.sleep(1000L);
            if (++count <= 5) continue;
            ConcurrencyTests.fail((String)("Fetch of memebers didn't complete in " + count + " seconds"));
        }
        ConcurrencyTests.assertTrue((result.size() == project.members().length ? 1 : 0) != 0);
        for (ICVSRemoteResource remote : result) {
            IResource local = project.findMember(remote.getName());
            ConcurrencyTests.assertNotNull((Object)local);
        }
    }
}

